/*
 * Decompiled with CFR 0.152.
 */
package local.ua;

import com.skype.Call;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import local.ua.CallHistoryEntry;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallHistoryHandler {
    private String skypeUserid;
    private Logger log = null;
    private FileWriter writer = null;
    private String curLogName = "";
    private String callLogPath = null;
    private String[] tollFreePrefixList = null;
    private int pstnMinutesToday = 0;
    private Hashtable<String, Integer> pstnQualifiedCallHash = null;
    private Hashtable<Call.Type, Hashtable<String, CallHistoryEntry>> memLog = null;
    private String lockObj = new String();

    CallHistoryHandler(String argSkypeUserid, String argCallLogPath, String argTollFreeNumberList) {
        if (argTollFreeNumberList.length() > 0) {
            this.tollFreePrefixList = argTollFreeNumberList.replaceAll(" ", "").split(",");
        }
        this.callLogPath = argCallLogPath;
        this.log = Logger.getLogger(this.getClass());
        this.skypeUserid = argSkypeUserid.toLowerCase().replaceAll("[^a-z0-9_.]", "");
    }

    public String getResetTime() {
        SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss z");
        Calendar mCal = Calendar.getInstance();
        mCal.set(11, 0);
        mCal.set(12, 0);
        mCal.set(13, 0);
        mCal.set(14, 0);
        mCal.add(14, mCal.getTimeZone().getRawOffset());
        return format.format(mCal.getTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPstnTodayCountQualified() {
        String string = this.lockObj;
        synchronized (string) {
            block4: {
                if (this.switchCallLog(null)) break block4;
                return 0;
            }
            return this.pstnQualifiedCallHash.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPstnTodayTimeQualified() {
        String string = this.lockObj;
        synchronized (string) {
            block4: {
                if (this.switchCallLog(null)) break block4;
                return 0;
            }
            return this.pstnMinutesToday;
        }
    }

    public boolean isTollFreeNumber(String callTo) {
        if (this.tollFreePrefixList == null) {
            return false;
        }
        String tmp = callTo.replaceAll(" ", "").replaceAll("^[+]", "").replaceAll("^00", "");
        int x = 0;
        while (x < this.tollFreePrefixList.length) {
            if (tmp.startsWith(this.tollFreePrefixList[x])) {
                return true;
            }
            ++x;
        }
        return false;
    }

    public boolean addCall(CallHistoryEntry entry) {
        if (entry.durationSeconds == 0L) {
            return false;
        }
        Calendar resetTime = Calendar.getInstance();
        resetTime.setTime(entry.startTime);
        resetTime.set(11, 0);
        resetTime.set(12, 0);
        resetTime.set(13, 0);
        resetTime.set(14, 0);
        resetTime.add(5, 1);
        resetTime.add(14, resetTime.getTimeZone().getRawOffset());
        Calendar callStartTime = Calendar.getInstance();
        callStartTime.setTime(entry.startTime);
        if (callStartTime.getTimeInMillis() < resetTime.getTimeInMillis() && callStartTime.getTimeInMillis() + entry.durationSeconds * 1000L >= resetTime.getTimeInMillis()) {
            CallHistoryEntry entry2 = new CallHistoryEntry(entry);
            entry.durationSeconds = (int)(resetTime.getTimeInMillis() - callStartTime.getTimeInMillis()) / 1000;
            entry.callCost = "Rollover";
            entry2.durationSeconds -= entry.durationSeconds;
            entry2.startTime = resetTime.getTime();
            this.addCallEntry(entry);
            this.addCallEntry(entry2);
            return true;
        }
        return this.addCallEntry(entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addCallEntry(CallHistoryEntry entry) {
        String string = this.lockObj;
        synchronized (string) {
            block12: {
                Hashtable<String, CallHistoryEntry> typeLog;
                block11: {
                    if (this.switchCallLog(entry.startTime)) break block11;
                    return false;
                }
                if (!this.memLog.containsKey((Object)entry.callType)) {
                    this.memLog.put(entry.callType, new Hashtable());
                }
                if ((typeLog = this.memLog.get((Object)entry.callType)).containsKey(entry.callId)) break block12;
                try {
                    this.writer.write(entry + "\r\n");
                    this.writer.flush();
                }
                catch (Exception e) {
                    this.log.error("addCall error", e);
                    return false;
                }
                typeLog.put(entry.callId, entry);
                if (entry.callType == Call.Type.OUTGOING_PSTN && this.isCallQualified(entry.callType, entry.callTo, entry.callCost)) {
                    if (!this.pstnQualifiedCallHash.containsKey(entry.callTo)) {
                        this.pstnQualifiedCallHash.put(entry.callTo, 1);
                    }
                    this.pstnMinutesToday += (int)((entry.durationSeconds + 59L) / 60L);
                }
                return true;
            }
            return false;
        }
    }

    private boolean switchCallLog(Date relevantDate) {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        Calendar mCal = Calendar.getInstance();
        if (relevantDate != null) {
            mCal.setTime(relevantDate);
        }
        mCal.add(14, -mCal.getTimeZone().getRawOffset());
        String newLogName = String.valueOf(this.callLogPath) + "callLog_" + this.skypeUserid + "_" + format.format(mCal.getTime()) + ".log";
        if (!newLogName.equals(this.curLogName) || this.writer == null) {
            this.log.debug("Call Log Switch: " + newLogName);
            try {
                if (this.writer != null) {
                    this.writer.close();
                }
                this.loadCallHistory(newLogName);
                this.writer = new FileWriter(new File(newLogName), true);
            }
            catch (Exception e) {
                this.log.error("switchCallLog error", e);
                this.curLogName = "";
                return false;
            }
            this.curLogName = newLogName;
        }
        return true;
    }

    private boolean loadCallHistory(String logFileName) {
        boolean retvar = false;
        FileReader reader = null;
        BufferedReader bufReader = null;
        this.memLog = new Hashtable();
        try {
            reader = new FileReader(new File(logFileName));
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception e) {
            this.log.error("loadCallHistory error", e);
        }
        if (reader != null) {
            bufReader = new BufferedReader(reader);
            int line = 0;
            try {
                String data;
                while ((data = bufReader.readLine()) != null) {
                    ++line;
                    CallHistoryEntry entry = null;
                    try {
                        entry = new CallHistoryEntry(data);
                    }
                    catch (Exception e) {
                        this.log.warn("Corrupt call history entry skipped at line:" + line + " - " + e.getLocalizedMessage());
                    }
                    if (entry == null) continue;
                    if (!this.memLog.containsKey((Object)entry.callType)) {
                        this.memLog.put(entry.callType, new Hashtable());
                    }
                    this.memLog.get((Object)entry.callType).put(entry.callId, entry);
                }
                bufReader.close();
                reader.close();
                retvar = true;
            }
            catch (Exception e) {
                this.log.error("loadCallHistory error", e);
            }
        }
        this.pstnQualifiedCallHash = this.hashQualifiedCalls(Call.Type.OUTGOING_PSTN);
        this.pstnMinutesToday = this.calcCallTimeQualified(Call.Type.OUTGOING_PSTN);
        return retvar;
    }

    private Hashtable<String, Integer> hashQualifiedCalls(Call.Type type) {
        Hashtable<String, CallHistoryEntry> v = this.memLog.get((Object)type);
        Hashtable<String, Integer> um = new Hashtable<String, Integer>();
        if (v != null) {
            Enumeration<CallHistoryEntry> en = v.elements();
            while (en.hasMoreElements()) {
                CallHistoryEntry entry = en.nextElement();
                if (!this.isCallQualified(entry.callType, entry.callTo, entry.callCost) || um.containsKey(entry.callTo)) continue;
                um.put(entry.callTo, 0);
            }
        }
        return um;
    }

    private int calcCallTimeQualified(Call.Type type) {
        Hashtable<String, CallHistoryEntry> v = this.memLog.get((Object)type);
        if (v == null) {
            return 0;
        }
        int totalMinutes = 0;
        Enumeration<CallHistoryEntry> en = v.elements();
        while (en.hasMoreElements()) {
            CallHistoryEntry entry = en.nextElement();
            if (!this.isCallQualified(entry.callType, entry.callTo, entry.callCost)) continue;
            totalMinutes += (int)((entry.durationSeconds + 59L) / 60L);
        }
        return totalMinutes;
    }

    private boolean isCallQualified(Call.Type type, String callTo, String callCost) {
        if (type != Call.Type.OUTGOING_PSTN) {
            return false;
        }
        if (callCost.replaceAll("[^1-9]", "").length() > 0) {
            return false;
        }
        return !this.isTollFreeNumber(callTo);
    }
}

