/*
 * Decompiled with CFR 0.152.
 */
package local.ua;

import java.net.DatagramSocket;
import local.ua.MediaLauncher;
import local.ua.SkypeRtpReceiver;
import local.ua.SkypeRtpSender;
import local.ua.sscodecs.SSCodec;
import org.apache.log4j.Logger;

public class JSkypeAudioLauncher
implements MediaLauncher {
    private Logger log = Logger.getLogger(this.getClass());
    private DatagramSocket socket = null;
    private SkypeRtpSender skypeaudio_output = null;
    private SkypeRtpReceiver skypeaudio_input = null;

    public JSkypeAudioLauncher(DatagramSocket argSocket, SSCodec sscodec, String remote_addr, int remote_port, int direction, SkypeRtpReceiver skypeAudioIn, SkypeRtpSender skypeAudioOut) {
        try {
            this.socket = argSocket;
            int dir = direction;
            if (dir >= 0) {
                this.skypeaudio_output = skypeAudioOut;
                skypeAudioOut.initRtp(sscodec, this.socket, remote_addr, remote_port);
            }
            if (dir <= 0) {
                this.skypeaudio_input = skypeAudioIn;
                skypeAudioIn.initRtp(sscodec, this.socket);
            }
        }
        catch (Exception e) {
            this.log.error("launchError", e);
        }
    }

    public boolean startMedia() {
        this.log.debug("starting skype/sip audio bridge..");
        if (this.skypeaudio_output != null) {
            this.skypeaudio_output.startMedia();
        }
        if (this.skypeaudio_input != null) {
            this.skypeaudio_input.startMedia();
        }
        return true;
    }

    public boolean stopMedia() {
        this.log.debug("halting skype/sip audio bridge..");
        if (this.skypeaudio_input != null) {
            this.skypeaudio_input.stopMedia();
            this.skypeaudio_input = null;
        }
        if (this.skypeaudio_output != null) {
            this.skypeaudio_output.stopMedia();
            this.skypeaudio_output = null;
        }
        try {
            Thread.sleep(150L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }
}

