/*
 * Decompiled with CFR 0.152.
 */
package local.ua;

import java.util.Date;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import local.ua.SMTPAuthenticator;
import org.apache.log4j.Logger;

public class MailerThread
extends Thread {
    private String msgSubject;
    private String msgBodyText;
    private String mailHost;
    private int mailPort;
    private String userName;
    private String password;
    private String recipients;
    private String fromAddress;
    private static Logger log = null;

    private MailerThread() {
    }

    MailerThread(String argmsgSubject, String argmsgBodyText, String argmailHost, int argmailPort, String arguserName, String argpassword, String argrecipients, String argfromAddress) {
        log = Logger.getLogger(this.getClass().getName());
        this.msgSubject = argmsgSubject;
        this.msgBodyText = argmsgBodyText;
        this.mailHost = argmailHost;
        this.mailPort = argmailPort;
        this.userName = arguserName;
        this.password = argpassword;
        this.recipients = argrecipients;
        this.fromAddress = argfromAddress;
        this.start();
    }

    public void run() {
        log.info("Sending Mail.");
        if (MailerThread.sendMail(this.msgSubject, this.msgBodyText, this.mailHost, this.mailPort, this.userName, this.password, this.recipients, this.fromAddress)) {
            log.info("Mail sent.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean sendMail(String msgSubject, String msgBodyText, String mailHost, int mailPort, String userName, String password, String recipients, String fromAddress) {
        boolean emailSent = false;
        int maxAttempts = 3;
        if (mailPort < 0) {
            mailPort = 25;
        }
        String[] recipientList = recipients.split(";");
        Properties props = new Properties();
        props.put("mail.smtp.host", mailHost);
        props.put("mail.smtp.port", (Object)mailPort);
        props.put("mail.transport.protocol", "smtp");
        props.put("mail.smtp.connectiontimeout", "4000");
        props.put("mail.smtp.timeout", "10000");
        Session session = null;
        if (password != null && password.length() > 0 && userName != null && userName.length() > 0) {
            SMTPAuthenticator auth = new SMTPAuthenticator(userName, password);
            props.put("mail.smtp.user", userName);
            props.put("mail.smtp.auth", "true");
            session = Session.getDefaultInstance((Properties)props, (Authenticator)auth);
        } else {
            props.put("mail.smtp.auth", "false");
            session = Session.getDefaultInstance((Properties)props);
        }
        session.setDebug(false);
        try {
            InternetAddress[] actualTo = new InternetAddress[recipientList.length];
            int x = 0;
            while (true) {
                if (x >= recipientList.length) {
                    InternetAddress from = new InternetAddress(fromAddress);
                    try {
                        MimeMessage msg = new MimeMessage(session);
                        msg.setFrom((Address)from);
                        msg.setRecipients(Message.RecipientType.TO, (Address[])actualTo);
                        msg.setSubject(msgSubject);
                        msg.setSentDate(new Date());
                        msg.setHeader("X-Mailer", "SipToSis Notifier");
                        MimeBodyPart mbpText = new MimeBodyPart();
                        mbpText.setContent((Object)msgBodyText, "text/plain");
                        MimeMultipart mp = new MimeMultipart("alternative");
                        mp.addBodyPart((BodyPart)mbpText);
                        msg.setContent((Multipart)mp);
                        int retryCnt = 0;
                        while (retryCnt < maxAttempts) {
                            if (emailSent) {
                                return emailSent;
                            }
                            ++retryCnt;
                            try {
                                log.debug("sendMail - transport.send - attempt# " + retryCnt + " start");
                                Transport.send((Message)msg);
                                emailSent = true;
                            }
                            catch (MessagingException mex) {
                                log.debug("sendMail - transport.send - attempt# " + retryCnt + " failed " + mex.getMessage());
                                if (mex.getMessage().toLowerCase().indexOf("could not connect") >= 0) {
                                    Thread.sleep(3000L);
                                    continue;
                                }
                                int errorCode = 0;
                                Matcher errorMatcher = Pattern.compile("[0-9]{3}").matcher(mex.getMessage());
                                if (errorMatcher.find(0)) {
                                    errorCode = Integer.parseInt(mex.getMessage().substring(errorMatcher.start(), errorMatcher.end()));
                                }
                                if (errorCode >= 400 && errorCode < 500) {
                                    Thread.sleep(3000L);
                                    continue;
                                }
                                log.error("sendMail - Error", mex);
                                Exception ex = null;
                                ex = mex.getNextException();
                                if (ex != null) {
                                    log.error("sendMail - Error", ex);
                                }
                                retryCnt = 9999;
                            }
                        }
                        return emailSent;
                    }
                    catch (MessagingException mex) {
                        log.error("sendMail Error", mex);
                        Exception ex = null;
                        ex = mex.getNextException();
                        if (ex == null) return emailSent;
                        ex.printStackTrace();
                        log.error("sendMail Error", ex);
                        return emailSent;
                    }
                }
                actualTo[x] = new InternetAddress(recipientList[x]);
                ++x;
            }
        }
        catch (Exception ex) {
            log.error("sendMail Error", ex);
        }
        return emailSent;
    }
}

