/*
 * Decompiled with CFR 0.152.
 */
package local.ua;

import org.zoolu.tools.Random;

public class RtpPacket {
    byte[] packet;
    int packet_len;
    private static boolean bigEndian = true;

    public byte[] getPacket() {
        return this.packet;
    }

    public int getLength() {
        return this.packet_len;
    }

    public int getHeaderLength() {
        if (this.packet_len >= 12) {
            return 12 + 4 * this.getCscrCount();
        }
        return this.packet_len;
    }

    public int getPayloadLength() {
        if (this.packet_len >= 12) {
            return this.packet_len - this.getHeaderLength();
        }
        return 0;
    }

    public void setPayloadLength(int len) {
        this.packet_len = this.getHeaderLength() + len;
    }

    public int getVersion() {
        if (this.packet_len >= 12) {
            return this.packet[0] >> 6 & 3;
        }
        return 0;
    }

    public void setVersion(int v) {
        if (this.packet_len >= 12) {
            this.packet[0] = (byte)(this.packet[0] & 0x3F | (v & 3) << 6);
        }
    }

    public boolean hasPadding() {
        if (this.packet_len >= 12) {
            return RtpPacket.getBit(this.packet[0], 5);
        }
        return false;
    }

    public void setPadding(boolean p) {
        if (this.packet_len >= 12) {
            this.packet[0] = RtpPacket.setBit(p, this.packet[0], 5);
        }
    }

    public boolean hasExtension() {
        if (this.packet_len >= 12) {
            return RtpPacket.getBit(this.packet[0], 4);
        }
        return false;
    }

    public void setExtension(boolean x) {
        if (this.packet_len >= 12) {
            this.packet[0] = RtpPacket.setBit(x, this.packet[0], 4);
        }
    }

    public int getCscrCount() {
        if (this.packet_len >= 12) {
            return this.packet[0] & 0xF;
        }
        return 0;
    }

    public boolean hasMarker() {
        if (this.packet_len >= 12) {
            return RtpPacket.getBit(this.packet[1], 7);
        }
        return false;
    }

    public void setMarker(boolean m) {
        if (this.packet_len >= 12) {
            this.packet[1] = RtpPacket.setBit(m, this.packet[1], 7);
        }
    }

    public int getPayloadType() {
        if (this.packet_len >= 12) {
            return this.packet[1] & 0x7F;
        }
        return -1;
    }

    public void setPayloadType(int pt) {
        if (this.packet_len >= 12) {
            this.packet[1] = (byte)(this.packet[1] & 0x80 | pt & 0x7F);
        }
    }

    public int getSequenceNumber() {
        if (this.packet_len >= 12) {
            return RtpPacket.getInt(this.packet, 2);
        }
        return 0;
    }

    public void setSequenceNumber(int sn) {
        if (this.packet_len >= 12) {
            RtpPacket.setInt(sn, this.packet, 2);
        }
    }

    public long getTimestamp() {
        if (this.packet_len >= 12) {
            return RtpPacket.getLong(this.packet, 4, 8);
        }
        return 0L;
    }

    public void setTimestamp(long timestamp) {
        if (this.packet_len >= 12) {
            RtpPacket.setLong(timestamp, this.packet, 4, 8);
        }
    }

    public long getSscr() {
        if (this.packet_len >= 12) {
            return RtpPacket.getLong(this.packet, 8, 12);
        }
        return 0L;
    }

    public void setSscr(long ssrc) {
        if (this.packet_len >= 12) {
            RtpPacket.setLong(ssrc, this.packet, 8, 12);
        }
    }

    public long[] getCscrList() {
        int cc = this.getCscrCount();
        long[] cscr = new long[cc];
        int i = 0;
        while (i < cc) {
            cscr[i] = RtpPacket.getLong(this.packet, 12 + 4 * i, 16 + 4 * i);
            ++i;
        }
        return cscr;
    }

    public void setCscrList(long[] cscr) {
        if (this.packet_len >= 12) {
            int cc = cscr.length;
            if (cc > 15) {
                cc = 15;
            }
            this.packet[0] = (byte)((this.packet[0] >> 4 << 4) + cc);
            cscr = new long[cc];
            int i = 0;
            while (i < cc) {
                RtpPacket.setLong(cscr[i], this.packet, 12 + 4 * i, 16 + 4 * i);
                ++i;
            }
        }
    }

    public void setPayload(byte[] payload, int len) {
        if (this.packet_len >= 12) {
            int header_len = this.getHeaderLength();
            System.arraycopy(payload, 0, this.packet, header_len, len);
            this.packet_len = header_len + len;
        }
    }

    public byte[] getPayload() {
        int header_len = this.getHeaderLength();
        int len = this.packet_len - header_len;
        byte[] payload = new byte[len];
        System.arraycopy(this.packet, header_len, payload, 0, len);
        return payload;
    }

    public RtpPacket(byte[] buffer, int packet_length) {
        this.packet = buffer;
        this.packet_len = packet_length;
        if (this.packet_len < 12) {
            this.packet_len = 12;
        }
        this.init(15);
    }

    public void init(int ptype) {
        this.init(ptype, Random.nextLong());
    }

    public void init(int ptype, long sscr) {
        this.init(ptype, Random.nextInt(), Random.nextLong(), sscr);
    }

    public void init(int ptype, int seqn, long timestamp, long sscr) {
        this.setVersion(2);
        this.setPayloadType(ptype);
        this.setSequenceNumber(seqn);
        this.setTimestamp(timestamp);
        this.setSscr(sscr);
    }

    public void setDuration(int dur) {
        RtpPacket.setInt(dur, this.packet, this.getHeaderLength() + 2);
    }

    public int getDuration() {
        return RtpPacket.getInt(this.packet, this.getHeaderLength() + 2);
    }

    private static int getLong(byte[] buffer, int byteOffset, int junk) {
        return bigEndian ? buffer[byteOffset] << 24 | (buffer[byteOffset + 1] & 0xFF) << 16 | (buffer[byteOffset + 2] & 0xFF) << 8 | buffer[byteOffset + 3] & 0xFF : buffer[byteOffset + 3] << 24 | (buffer[byteOffset + 2] & 0xFF) << 16 | (buffer[byteOffset + 1] & 0xFF) << 8 | buffer[byteOffset] & 0xFF;
    }

    private static void setLong(long sample, byte[] buffer, int byteOffset, int junk) {
        if (bigEndian) {
            buffer[byteOffset++] = (byte)(sample >> 24);
            buffer[byteOffset++] = (byte)(sample >>> 16 & 0xFFL);
            buffer[byteOffset++] = (byte)(sample >>> 8 & 0xFFL);
            buffer[byteOffset] = (byte)(sample & 0xFFL);
        } else {
            buffer[byteOffset++] = (byte)(sample & 0xFFL);
            buffer[byteOffset++] = (byte)(sample >>> 8 & 0xFFL);
            buffer[byteOffset++] = (byte)(sample >>> 16 & 0xFFL);
            buffer[byteOffset] = (byte)(sample >> 24);
        }
    }

    private static int getInt(byte[] buffer, int byteOffset) {
        return bigEndian ? buffer[byteOffset] << 8 | buffer[byteOffset + 1] & 0xFF : buffer[byteOffset + 1] << 8 | buffer[byteOffset] & 0xFF;
    }

    private static void setInt(int sample, byte[] buffer, int byteOffset) {
        if (bigEndian) {
            buffer[byteOffset++] = (byte)(sample >> 8);
            buffer[byteOffset] = (byte)(sample & 0xFF);
        } else {
            buffer[byteOffset++] = (byte)(sample & 0xFF);
            buffer[byteOffset] = (byte)(sample >> 8);
        }
    }

    private static boolean getBit(byte b, int bit) {
        return b >> bit != 0;
    }

    private static byte setBit(boolean value, byte b, int bit) {
        b = value ? (byte)(b | 1 << bit) : (byte)((b | 1 << bit) ^ 1 << bit);
        return b;
    }
}

