/*
 * Decompiled with CFR 0.152.
 */
package local.ua;

import com.skype.Call;
import com.skype.CallStatusChangedListener;
import com.skype.Chat;
import com.skype.Friend;
import com.skype.NotAttachedException;
import com.skype.Skype;
import com.skype.SkypeException;
import com.skype.connector.Connector;
import java.util.Date;
import local.ua.AuthTimer;
import local.ua.AuthTimerInterface;
import local.ua.CallHistoryEntry;
import local.ua.CallHistoryHandler;
import local.ua.CallTimer;
import local.ua.CallTimerInterface;
import local.ua.ControllerChannelInterface;
import local.ua.RegisterAgent;
import local.ua.RegisterAgentListener;
import local.ua.SipCallRingTimer;
import local.ua.SipCallRingTimerInterface;
import local.ua.SipCommandRunner;
import local.ua.SkypeCommandRunner;
import local.ua.SkypeProfile;
import local.ua.SkypeUA;
import local.ua.SkypeUserAgent;
import local.ua.UserAgent;
import local.ua.UserAgentListener;
import local.ua.UserAgentProfile;
import local.ua.util;
import org.apache.log4j.Logger;
import org.zoolu.sip.address.NameAddress;
import org.zoolu.sip.address.SipURL;
import org.zoolu.sip.message.Message;
import org.zoolu.sip.provider.SipProvider;

public class SSCallChannel
extends Thread
implements UserAgentListener,
RegisterAgentListener,
AuthTimerInterface,
CallStatusChangedListener,
SipCallRingTimerInterface,
CallTimerInterface {
    protected SkypeUserAgent ua;
    private SkypeProfile skype_profile;
    private Call currentSkypeCall = null;
    private boolean skypeAudioRedirected = false;
    private ControllerChannelInterface controller = null;
    private String authPin = "";
    private int authFailCnt = 0;
    private AuthState callAuthState = AuthState.IDLE;
    private AuthTimer authTimer = null;
    private CallTimer callTimer = null;
    private UserAgentProfile user_profile;
    private Logger log = null;
    private CallHistoryEntry callEntry = new CallHistoryEntry();
    private int hangupStatus = 403;
    private String curSipCaller = "";
    private String curSipCallee = "";
    private String curSipCallerIP = "";
    private boolean doPinCalleeDial = false;
    private SipCommandRunner sipCmdRunner = null;
    private SkypeCommandRunner skypeCmdRunner = null;
    private SipCallRingTimer sipCallRingTimer = null;
    private boolean locked = false;
    private double glbSkypeCallRate = 0.0;
    private int glbSkypeCallPrecision = 0;
    private String glbSkypeCallCurrency = "";
    private String glbSkypeCallid = null;
    private String glbPossibleRunaway = null;
    private long callStart = 0L;
    private long lastSipCallAttempt = 0L;
    private String joinSkypeUserId = null;

    public SSCallChannel(SipProvider sip_provider, UserAgentProfile user_profile, SkypeProfile skype_profile, int argRtpPort, int argSkypePort, ControllerChannelInterface argCI, int chanId) throws Exception {
        this.setName(String.valueOf(this.getClass().getName()) + ".#C" + chanId);
        this.log = Logger.getLogger(this.getName());
        this.controller = argCI;
        this.skype_profile = skype_profile;
        this.user_profile = user_profile;
        this.ua = new SkypeUserAgent(sip_provider, user_profile, this, skype_profile, argRtpPort, argSkypePort, chanId);
        this.hangupStatus = skype_profile.baseFailureResponse;
        this.start();
    }

    public void call(String target_url) {
        this.callEntry.callTo = target_url.toString();
        this.lock();
        this.ua.hangup();
        this.log.info("UAC: CALLING " + target_url.replaceAll(";.*", ""));
        if (!this.ua.user_profile.audio && !this.ua.user_profile.video) {
            this.log.info("ONLY SIGNALING, NO MEDIA");
        }
        this.ua.call(target_url);
    }

    public void listen() {
        this.logCall();
        this.curSipCaller = "";
        this.curSipCallee = "";
        this.curSipCallerIP = "";
        this.doPinCalleeDial = false;
        this.joinSkypeUserId = null;
        this.clearCallTimer();
        this.clearAuthTimer();
        this.clearSipCommandRunner();
        this.clearSkypeCommandRunner();
        this.clearSipCallRingTimer();
        this.callAuthState = AuthState.IDLE;
        this.ua.hangup(this.hangupStatus);
        if (this.currentSkypeCall != null && this.skype_profile.skypeInboundSipDestUnavailableAction.equals("ring")) {
            try {
                Call.Type ct = this.currentSkypeCall.getType();
                if (this.currentSkypeCall.getStatus() == Call.Status.RINGING && (ct == Call.Type.INCOMING_P2P || ct == Call.Type.INCOMING_PSTN)) {
                    this.log.info("Allowing Skype Client to ring.");
                    this.currentSkypeCall.removeCallStatusChangedListener(this);
                    this.currentSkypeCall = null;
                }
            }
            catch (Exception e) {
                this.log.debug("error", e);
            }
        }
        this.cancelSkypeCall();
        this.hangupStatus = this.skype_profile.baseFailureResponse;
        this.ua.listen();
        this.unLock();
        if (!this.ua.user_profile.audio && !this.ua.user_profile.video) {
            this.log.info("ONLY SIGNALING, NO MEDIA");
        }
    }

    public void run() {
        try {
            if (this.user_profile.re_invite_time > 0) {
                this.ua.reInvite(this.user_profile.contact_url, this.user_profile.re_invite_time);
            }
            if (this.user_profile.transfer_to != null && this.user_profile.transfer_time > 0) {
                this.ua.callTransfer(this.user_profile.transfer_to, this.user_profile.transfer_time);
            }
            if (this.user_profile.accept_time >= 0) {
                this.log.info("UAS: AUTO ACCEPT MODE");
            }
            this.listen();
        }
        catch (Exception e) {
            this.log.fatal("error", e);
            System.exit(SkypeUA.ExitCode.FATALERROR.code());
        }
    }

    public void onUaCallIncoming(UserAgent tua, NameAddress callee, NameAddress caller, Message invite) {
        this.lock();
        this.log.info("incoming sip call from " + caller.toString() + " callee=" + callee.toString());
        this.lastSipCallAttempt = System.currentTimeMillis();
        this.callEntry.callFrom = caller.toString();
        this.curSipCallerIP = invite.getRemoteAddress();
        this.curSipCaller = caller.toString();
        this.curSipCallee = callee.toString();
        this.handleSipCall(caller.toString(), this.curSipCallerIP, callee.toString());
    }

    public void onUaCallConfirmed(UserAgent ua) {
        if (ua.onRemoteSipHold) {
            this.log.info("Call Holding");
            return;
        }
        if (this.ua.skypeHoldingLocal && !this.ua.onRemoteSipHold) {
            this.resumeSkypeCall();
            this.log.info("Call Resuming");
            return;
        }
        this.log.info("CallConfirmed Active");
        if (this.sipCmdRunner != null) {
            this.sipCmdRunner.start();
        }
        this.startCallTime();
    }

    public void onUaCallRinging(UserAgent tua) {
        this.log.debug("onUaCallRinging");
    }

    public void onUaCallAccepted(UserAgent tua) {
        this.log.debug("onUaCallAccepted");
        if (this.joinSkypeUserId != null) {
            if (this.makeSkypeCall(this.joinSkypeUserId)) {
                this.ua.queueSipClip(this.skype_profile.dialingFile);
            } else {
                this.log.error("Skype called Failed.");
                this.ua.queueSipClip(this.skype_profile.invalidDestFile);
                this.listen();
            }
        } else if (this.skypeAnswer()) {
            this.startCallTime();
        } else {
            this.listen();
        }
    }

    public void onUaCallTrasferred(UserAgent tua) {
    }

    public void onUaCallCancelled(UserAgent tua) {
        this.log.debug("onUaCallCancelled");
        this.listen();
    }

    public void onUaCallFailed(UserAgent tua) {
        this.log.debug("onUaCallFailed");
        this.listen();
    }

    public void onUaCallClosed(UserAgent tua) {
        this.log.debug("onUaCallClosed");
        this.listen();
    }

    public void onDtmfReceived(UserAgent tua, int digit, boolean isSkype) {
        if (!isSkype) {
            if (this.callAuthState == AuthState.SIP_WAITFORPIN) {
                if (tua.getDtmfBuffer().startsWith(this.authPin)) {
                    this.authFailCnt = 0;
                    this.clearAuthTimer();
                    if (this.doPinCalleeDial) {
                        this.callAuthState = AuthState.IDLE;
                        String skypeDest = this.curSipCallee.replaceAll("(?i).*sip:<?([^@<]+)@.*", "$1");
                        if (this.directSkypeDial(skypeDest)) {
                            this.ua.queueSipClip(this.skype_profile.dialingFile);
                        }
                    } else {
                        this.callAuthState = AuthState.SIP_WAITFORDESTINATION;
                        this.log.info("Pin Authorized");
                        tua.chopDtmfBuffer(this.authPin.length());
                        this.ua.queueSipClip(this.skype_profile.destinationFile);
                        this.startAuthTimer(this.skype_profile.destinationTimeout);
                    }
                }
            } else if (this.callAuthState == AuthState.SIP_WAITFORDESTINATION) {
                if (tua.getDtmfBuffer().indexOf("#") >= 0) {
                    this.authFailCnt = 0;
                    this.clearAuthTimer();
                    this.callAuthState = AuthState.IDLE;
                    String skypeDest = this.ua.getDtmfBuffer().replaceAll("#.*$", "").trim();
                    this.ua.clearDtmfBuffer();
                    if (skypeDest.length() > 0) {
                        this.log.info("Dialing Skype Destination:" + skypeDest);
                        if (!this.makeSkypeCall(skypeDest)) {
                            this.log.info("Skype Call Failed");
                            this.callAuthState = AuthState.SIP_WAITFORDESTINATION;
                            this.ua.queueSipClip(this.skype_profile.invalidDestFile);
                            this.ua.queueSipClip(this.skype_profile.destinationFile);
                            this.startAuthTimer(this.skype_profile.destinationTimeout);
                        } else {
                            this.ua.queueSipClip(this.skype_profile.dialingFile);
                        }
                    } else {
                        this.callAuthState = AuthState.SIP_WAITFORDESTINATION;
                        this.ua.queueSipClip(this.skype_profile.destinationFile);
                        this.startAuthTimer(this.skype_profile.destinationTimeout);
                    }
                }
            } else if (this.currentSkypeCall != null && !this.ua.skypeHoldingLocal) {
                if (this.skype_profile.sendSipDtmfToSkype) {
                    try {
                        if (this.currentSkypeCall.getStatus() == Call.Status.INPROGRESS) {
                            int fixDigit = digit;
                            if (digit == 10) {
                                fixDigit = Call.DTMF.TYPE_ASTERISK.ordinal();
                            } else if (digit == 11) {
                                fixDigit = Call.DTMF.TYPE_SHARP.ordinal();
                            }
                            if (fixDigit <= 11) {
                                this.currentSkypeCall.send(Call.DTMF.values()[fixDigit]);
                                this.log.debug("DTMF:" + digit + " sent to skype");
                            }
                        }
                    }
                    catch (Exception e) {
                        this.log.error("Error sending dtmf: " + digit + " to skype: ", e);
                    }
                }
            } else if (this.callAuthState == AuthState.IDLE) {
                this.log.debug("Auth State not handled:" + (Object)((Object)this.callAuthState));
            }
        } else if (this.callAuthState == AuthState.SKYPE_WAITFORPIN) {
            if (this.ua.getSkypeDtmfBuffer().startsWith(this.authPin)) {
                this.authFailCnt = 0;
                this.clearAuthTimer();
                this.callAuthState = AuthState.SKYPE_WAITFORDESTINATION;
                this.log.info("Pin Authorized");
                this.ua.chopSkypeDtmfBuffer(this.authPin.length());
                this.ua.queueSkypeClip(this.skype_profile.skypeDestinationFile);
                this.startAuthTimer(this.skype_profile.destinationTimeout);
            }
        } else if (this.callAuthState == AuthState.SKYPE_WAITFORDESTINATION) {
            if (this.ua.getSkypeDtmfBuffer().indexOf("#") >= 0) {
                this.authFailCnt = 0;
                this.clearAuthTimer();
                this.callAuthState = AuthState.IDLE;
                String sipDest = this.ua.getSkypeDtmfBuffer().replaceAll("#.*$", "").trim();
                sipDest = this.controller.getAuthMap().sipOutFilter(sipDest);
                this.ua.clearSkypeDtmfBuffer();
                if (sipDest.length() > 0) {
                    this.log.info("Dialing Sip Destination:" + sipDest);
                    this.ua.queueSkypeClip(this.skype_profile.skypeDialingFile);
                    this.waitForSkypeClipsComplete();
                    try {
                        NameAddress tmpfrom;
                        String skypeid = this.currentSkypeCall.getPartnerId();
                        if (this.skype_profile.replaceFromWithSkypeId) {
                            SipURL tmpurl = new SipURL(this.ua.user_profile.contact_url);
                            tmpfrom = new NameAddress(skypeid, new SipURL(skypeid, tmpurl.getHost(), tmpurl.getPort()));
                        } else {
                            tmpfrom = new NameAddress(skypeid, new SipURL(this.ua.user_profile.contact_url));
                        }
                        this.ua.user_profile.from_url = tmpfrom.toString();
                    }
                    catch (Exception e) {
                        this.log.error("Error", e);
                        this.listen();
                        return;
                    }
                    this.call(sipDest);
                } else {
                    this.callAuthState = AuthState.SKYPE_WAITFORDESTINATION;
                    this.ua.queueSkypeClip(this.skype_profile.skypeDestinationFile);
                    this.startAuthTimer(this.skype_profile.destinationTimeout);
                }
            }
        } else if (this.ua.call_state != "IDLE" && !this.ua.onLocalSipHold) {
            if (this.skype_profile.sendSkypeDtmfToSip) {
                this.ua.queueSipDtmfDigits(this.ua.dtmfConvertToString(digit));
                this.log.debug("DTMF:" + digit + " sent to sip");
            }
        } else if (this.callAuthState == AuthState.IDLE) {
            this.log.debug("Auth State not handled:" + (Object)((Object)this.callAuthState));
        }
    }

    public void onAuthTimeout() {
        this.authTimer = null;
        if (this.callAuthState != AuthState.IDLE) {
            ++this.authFailCnt;
            if (this.callAuthState == AuthState.SIP_WAITFORPIN) {
                this.log.info("Pin timeout");
                if (this.ua.getDtmfBuffer().length() > 0 && this.authFailCnt < this.skype_profile.pinRetryLimit) {
                    this.ua.queueSipClip(this.skype_profile.invalidPinFile);
                    this.ua.clearDtmfBuffer();
                    this.ua.queueSipClip(this.skype_profile.pinFile);
                    this.startAuthTimer(this.skype_profile.pinTimeout);
                } else {
                    this.ua.queueSipClip(this.skype_profile.invalidPinFile);
                    this.waitForSipClipsComplete();
                    this.listen();
                }
            } else if (this.callAuthState == AuthState.SIP_WAITFORDESTINATION) {
                this.log.info("Destination timeout");
                if (this.ua.getDtmfBuffer().length() > 0 && this.authFailCnt < this.skype_profile.destRetryLimit) {
                    this.ua.queueSipClip(this.skype_profile.invalidDestFile);
                    this.ua.clearDtmfBuffer();
                    this.ua.queueSipClip(this.skype_profile.destinationFile);
                    this.startAuthTimer(this.skype_profile.destinationTimeout);
                } else {
                    this.ua.queueSipClip(this.skype_profile.invalidDestFile);
                    this.waitForSipClipsComplete();
                    this.listen();
                }
            } else if (this.callAuthState == AuthState.SKYPE_WAITFORPIN) {
                this.log.info("Pin timeout");
                if (this.ua.getSkypeDtmfBuffer().length() > 0 && this.authFailCnt < this.skype_profile.pinRetryLimit) {
                    this.ua.queueSkypeClip(this.skype_profile.skypeInvalidPinFile);
                    this.ua.clearSkypeDtmfBuffer();
                    this.ua.queueSkypeClip(this.skype_profile.skypePinFile);
                    this.startAuthTimer(this.skype_profile.pinTimeout);
                } else {
                    this.ua.queueSkypeClip(this.skype_profile.skypeInvalidPinFile);
                    this.waitForSkypeClipsComplete();
                    this.cancelSkypeCall();
                    this.unLock();
                }
            } else if (this.callAuthState == AuthState.SKYPE_WAITFORDESTINATION) {
                this.log.info("Destination timeout");
                if (this.ua.getSkypeDtmfBuffer().length() > 0 && this.authFailCnt < this.skype_profile.destRetryLimit) {
                    this.ua.queueSkypeClip(this.skype_profile.skypeInvalidDestFile);
                    this.ua.clearSkypeDtmfBuffer();
                    this.ua.queueSkypeClip(this.skype_profile.skypeDestinationFile);
                    this.startAuthTimer(this.skype_profile.destinationTimeout);
                } else {
                    this.ua.queueSkypeClip(this.skype_profile.skypeInvalidDestFile);
                    this.waitForSkypeClipsComplete();
                    this.cancelSkypeCall();
                    this.unLock();
                }
            } else {
                this.cancelSkypeCall();
                this.listen();
            }
        }
    }

    public void startSipAuthSequence(String argPin) {
        this.authPin = argPin;
        if (this.authPin.trim().length() == 0) {
            this.ua.queueSipClip(this.skype_profile.destinationFile);
        } else {
            this.ua.queueSipClip(this.skype_profile.pinFile);
        }
        this.authFailCnt = 0;
        if (this.authPin.trim().length() == 0) {
            this.callAuthState = AuthState.SIP_WAITFORDESTINATION;
            this.authTimer = new AuthTimer(this.skype_profile.destinationTimeout, this);
            this.authTimer.start();
        } else {
            this.callAuthState = AuthState.SIP_WAITFORPIN;
            this.authTimer = new AuthTimer(this.skype_profile.pinTimeout, this);
            this.authTimer.start();
        }
    }

    public void startSkypeAuthSequence(String argPin) {
        this.authPin = argPin;
        if (this.authPin.trim().length() == 0) {
            this.ua.queueSkypeClip(this.skype_profile.skypeDestinationFile);
        } else {
            this.ua.queueSkypeClip(this.skype_profile.skypePinFile);
        }
        this.authFailCnt = 0;
        if (this.authPin.trim().length() == 0) {
            this.callAuthState = AuthState.SKYPE_WAITFORDESTINATION;
            this.authTimer = new AuthTimer(this.skype_profile.destinationTimeout, this);
            this.authTimer.start();
        } else {
            this.callAuthState = AuthState.SKYPE_WAITFORPIN;
            this.authTimer = new AuthTimer(this.skype_profile.pinTimeout, this);
            this.authTimer.start();
        }
    }

    private void clearAuthTimer() {
        if (this.authTimer != null) {
            this.authTimer.stopTimer();
        }
        this.authTimer = null;
    }

    private void startAuthTimer(int timeout) {
        this.authTimer = new AuthTimer(timeout, this);
        this.authTimer.start();
    }

    public void clearSipCommandRunner() {
        if (this.sipCmdRunner != null) {
            this.sipCmdRunner.stopCommands();
        }
        this.sipCmdRunner = null;
    }

    public void clearSkypeCommandRunner() {
        if (this.skypeCmdRunner != null) {
            this.skypeCmdRunner.stopCommands();
        }
        this.skypeCmdRunner = null;
    }

    public void onUaRegistrationSuccess(RegisterAgent ra, NameAddress target, NameAddress contact, String result) {
        this.log.info("Registration success: " + result);
    }

    public void onUaRegistrationFailure(RegisterAgent ra, NameAddress target, NameAddress contact, String result) {
        this.log.info("Registration failure: " + result);
    }

    private void handleSipCall(String callerSipCID, String sipCIP, String argdestination) {
        String destination = this.controller.getAuthMap().getSkypeDest(callerSipCID, sipCIP, argdestination);
        this.log.debug("handleSipCall - authMap:" + destination);
        if (destination == null || destination.length() == 0) {
            this.log.info("handleSipCall - rejected call");
            this.listen();
            return;
        }
        if (destination.indexOf(":") < 0) {
            this.directSkypeDial(destination);
        } else {
            this.log.info("handleSipCall - Command List:" + destination);
            if (this.ua.call_state == "INCOMING_CALL") {
                this.ua.accept();
            }
            this.sipCmdRunner = new SipCommandRunner(destination, this);
        }
    }

    private boolean directSkypeDial(String destination) {
        this.log.info("Skype Dial:" + destination);
        if (!this.makeSkypeCall(destination)) {
            this.listen();
            return false;
        }
        return true;
    }

    public void statusChanged(Call.Status status) throws SkypeException {
        if (status == Call.Status.FINISHED || status == Call.Status.CANCELLED || status == Call.Status.MISSED || status == Call.Status.REFUSED || status == Call.Status.FAILED || status == Call.Status.UNPLACED || status == Call.Status.BUSY) {
            this.log.info("skypeCallStatus - Complete: " + (Object)((Object)status));
            if (this.currentSkypeCall != null) {
                this.currentSkypeCall.removeCallStatusChangedListener(this);
                this.cancelSkypeCall();
            }
            this.ua.stopMedia();
            this.hangupStatus = this.skype_profile.baseFailureResponse;
            if (status == Call.Status.REFUSED) {
                this.hangupStatus = this.skype_profile.skypeRefusedResponse;
            } else if (status == Call.Status.FAILED) {
                this.hangupStatus = this.skype_profile.skypeFailedResponse;
            } else if (status == Call.Status.UNPLACED) {
                this.hangupStatus = this.skype_profile.skypeUnPlacedResponse;
            } else if (status == Call.Status.BUSY) {
                this.hangupStatus = this.skype_profile.skypeBusyResponse;
            }
            this.listen();
        } else if (this.skype_profile.handleEarlyMedia && status == Call.Status.EARLYMEDIA) {
            try {
                this.log.info("skypeCallStatus - " + (Object)((Object)status));
                if (this.ua.call_state == "INCOMING_CALL") {
                    if (this.skype_profile.sendSkypeEarlyMediaOverSipSessionProgress) {
                        this.ua.sendEarlyMedia();
                    } else {
                        this.ua.accept();
                    }
                }
                this.redirSkypeAudio();
                this.ua.startSkypeMedia(this.skype_profile.sendSkypeEarlyMediaOverSipSessionProgress);
            }
            catch (Exception e) {
                this.log.error("skypeCallStatus: error", e);
                this.cancelSkypeCall();
                this.listen();
            }
        } else if (status == Call.Status.INPROGRESS) {
            try {
                this.callEntry.callType = this.currentSkypeCall.getType();
                if (this.ua.call_state == "OUTGOING_CALL" && (this.callEntry.callType == Call.Type.INCOMING_P2P || this.callEntry.callType == Call.Type.INCOMING_PSTN)) {
                    this.log.info("Incoming Skype Call Manually Answered.");
                    this.currentSkypeCall.removeCallStatusChangedListener(this);
                    this.currentSkypeCall = null;
                    this.listen();
                    return;
                }
                this.log.info("skypeCallStatus - " + (Object)((Object)status));
                this.getSkypeCallRate();
                if (this.ua.call_state == "INCOMING_CALL") {
                    this.ua.accept();
                }
                this.redirSkypeAudio();
                this.ua.startSkypeMedia(false);
                this.startCallTime();
                this.ua.skypeHoldingLocal = false;
                this.ua.skypeHoldingRemote = false;
            }
            catch (Exception e) {
                this.log.error("error", e);
                this.cancelSkypeCall();
                this.listen();
            }
        } else if (status == Call.Status.LOCALHOLD) {
            this.log.info("skypeCallStatus - " + (Object)((Object)status));
            this.ua.skypeHoldingLocal = true;
        } else if (status == Call.Status.REMOTEHOLD) {
            this.log.info("skypeCallStatus - " + (Object)((Object)status));
            this.ua.skypeHoldingRemote = true;
        } else if (status == Call.Status.ROUTING || status == Call.Status.RINGING) {
            this.log.info("skypeCallStatus - " + (Object)((Object)status));
            this.redirSkypeAudio();
        } else {
            this.log.info("skypeCallStatus - " + (Object)((Object)status));
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean makeSkypeCall(String dest) {
        retvar = false;
        retry = true;
        if (!this.skype_profile.skypeClientSupportsMultiCalls) {
            try {
                this.controller.holdOtherSkypeCalls(null);
            }
            catch (Exception e) {
                this.log.error("makeSkypeCall: holdOtherSkypeCalls failed. ", e);
                return false;
            }
        }
        if (!(filteredDest = this.controller.getAuthMap().skypeOutFilter(dest)).equals(dest)) {
            dest = filteredDest;
            this.log.info("Actual number dialed:" + dest);
        }
        if (dest.length() < 1) {
            this.log.error("makeSkypeCall: invalid destination");
            return false;
        }
        if (!this.isOverUsageLimit(dest)) ** GOTO lbl59
        this.hangupStatus = this.skype_profile.overUsageLimitSipResponse;
        this.log.info("Call rejected - Usage Limit Reached");
        this.listen();
        return false;
lbl-1000:
        // 1 sources

        {
            try {
                Skype.getVersion();
                if (this.skype_profile.sendSkypeIM) {
                    this.sendSkypeIM(dest);
                }
                this.setCurrentSkypeCall(Skype.call(dest));
                this.callEntry.callTo = dest;
                retvar = true;
                break;
            }
            catch (NotAttachedException e) {
                retry = this.controller.lostSkypeConnection();
                if (retry) continue;
                this.listen();
                this.log.error("Reconnect to Skype client failed.");
                this.controller.restart();
                continue;
            }
            catch (SkypeException e) {
                retry = false;
                if (e.getLocalizedMessage() == null) {
                    this.log.error("Error: makeSkypeCall: skypeDest=" + dest, e);
                    break;
                }
                if (e.getLocalizedMessage().contains("Unrecognised identity")) {
                    this.hangupStatus = this.skype_profile.skypeFailedResponse;
                    this.log.error("Error: makeSkypeCall: skypeDest=" + dest + " " + e.getLocalizedMessage());
                    break;
                }
                if (e.getLocalizedMessage().contains("Cannot call yourself")) {
                    this.log.error("Error: makeSkypeCall: skypeDest=" + dest + " " + e.getLocalizedMessage());
                    break;
                }
                if (e.getLocalizedMessage().contains("command execution failed")) {
                    this.log.error("Error: makeSkypeCall: skypeDest=" + dest + " " + e.getLocalizedMessage());
                    retry = this.controller.lostSkypeConnection();
                    if (retry) break;
                    this.listen();
                    this.log.error("Reconnect to Skype client failed.");
                    this.controller.restart();
                    break;
                }
                this.log.error("Error: makeSkypeCall: skypeDest=" + dest + " " + e.getLocalizedMessage(), e);
                break;
            }
lbl59:
            // 3 sources

            ** while (retry)
        }
lbl60:
        // 8 sources

        return retvar;
    }

    private void sendSkypeIM(String dest) {
        if (dest.startsWith("+") || dest.startsWith("00")) {
            return;
        }
        int alphalen = dest.replaceAll("[^\\p{Alpha}]", "").length();
        int numlen = dest.replaceAll("[^0-9]", "").length();
        if (alphalen > 0 || numlen < 7) {
            char firstChar;
            if (alphalen == 0) {
                dest = this.getUserFromSpeedDial(dest);
            }
            if ((firstChar = dest.toLowerCase().charAt(0)) < 'a' || firstChar > 'z') {
                return;
            }
            this.log.info("Sending Skype IM to: " + dest);
            String msg = this.skype_profile.skypeImMessage;
            msg = msg.replaceAll("\\x5bcallerid\\x5d", this.curSipCaller.replaceAll("(^\"|\" .*$)", ""));
            this.log.info("IM: " + msg);
            try {
                Chat chat = Skype.chat(dest);
                chat.send(msg);
            }
            catch (SkypeException e) {
                if (e.getLocalizedMessage() == null) {
                    this.log.error("Error: sendSkypeIM: skypeDest=" + dest, e);
                }
                this.log.error("Error: sendSkypeIM: skypeDest=" + dest + " " + e.getLocalizedMessage(), e);
            }
            try {
                Thread.sleep(this.skype_profile.sendSkypeImDelay * 1000);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private String getUserFromSpeedDial(String dest) {
        try {
            Friend[] fr = Skype.getContactList().getAllFriends();
            int s = 0;
            while (s < fr.length) {
                if (fr[s].getSpeedDial().toString().equals(dest)) {
                    dest = fr[s].getId();
                    break;
                }
                ++s;
            }
        }
        catch (SkypeException e) {
            if (e.getLocalizedMessage() == null) {
                this.log.error("Error: getUserFromSpeedDial: skypeDest=" + dest, e);
            }
            this.log.error("Error: getUserFromSpeedDial: skypeDest=" + dest + " " + e.getLocalizedMessage(), e);
        }
        return dest;
    }

    public void cancelSkypeCall() {
        block5: {
            this.skypeAudioRedirected = false;
            Call curCall = this.currentSkypeCall;
            if (curCall != null) {
                try {
                    this.glbPossibleRunaway = curCall.getId();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    curCall.cancel();
                }
                catch (Throwable e) {
                    String msg = e.getLocalizedMessage();
                    if (msg != null && msg.indexOf("Cannot hangup inactive call") >= 0) break block5;
                    this.log.debug("cancelSkypeCall:", e);
                }
            }
        }
        this.currentSkypeCall = null;
    }

    public boolean skypeAnswer() {
        Call.Status curStat;
        boolean ansStatus;
        block12: {
            ansStatus = true;
            this.log.debug("skypeAnswer");
            if (!this.skype_profile.skypeClientSupportsMultiCalls) {
                if (this.currentSkypeCall == null) {
                    this.log.debug("No skype call to answer");
                    this.cancelSkypeCall();
                    return false;
                }
                try {
                    this.controller.holdOtherSkypeCalls(this.currentSkypeCall);
                }
                catch (Exception e) {
                    this.log.error("skypeAnswer: holdOtherSkypeCalls failed. ", e);
                    this.cancelSkypeCall();
                    ansStatus = false;
                    return false;
                }
            }
            if (this.currentSkypeCall == null) {
                this.log.debug("No skype call to answer");
                this.cancelSkypeCall();
                return false;
            }
            curStat = null;
            curStat = this.currentSkypeCall.getStatus();
            if (curStat != Call.Status.INPROGRESS) break block12;
            return true;
        }
        try {
            if (curStat == Call.Status.MISSED || curStat == Call.Status.CANCELLED || curStat == Call.Status.FAILED || curStat == Call.Status.FINISHED || curStat == Call.Status.BUSY || curStat == Call.Status.REFUSED || curStat == Call.Status.UNPLACED) {
                ansStatus = false;
            } else {
                this.currentSkypeCall.answer();
                this.redirSkypeAudio();
                this.ua.startSkypeMedia(false);
                this.callEntry.callFrom = this.currentSkypeCall.getPartnerId();
            }
        }
        catch (Exception e) {
            if (this.currentSkypeCall != null) {
                this.log.error("skypeAnswer: CallStatus=" + (Object)((Object)curStat), e);
            } else {
                this.log.debug("No skype call to answer");
            }
            this.cancelSkypeCall();
            ansStatus = false;
        }
        return ansStatus;
    }

    public void waitForSkypeClipsComplete() {
        try {
            while (this.currentSkypeCall.getStatus() == Call.Status.INPROGRESS && !this.ua.getSkypeClipQueueComplete()) {
                Thread.sleep(500L);
            }
        }
        catch (Exception e) {
            this.log.error("waitForSkypeClipsComplete:", e);
        }
        try {
            Thread.sleep(500L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void waitForSipClipsComplete() {
        while (this.ua.call_state == "ONCALL" && !this.ua.getSipClipQueueComplete()) {
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            Thread.sleep(500L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isIdle() {
        return this.ua.call_state == "IDLE" && this.currentSkypeCall == null && !this.locked;
    }

    public boolean answerSkypeCall(String sipDest) {
        if (this.skypeAnswer()) {
            this.skypeCmdRunner = new SkypeCommandRunner(sipDest, this);
            this.skypeCmdRunner.start();
            return true;
        }
        return false;
    }

    public Call getCurrentSkypeCall() {
        return this.currentSkypeCall;
    }

    public void setCurrentSkypeCall(Call call) {
        this.currentSkypeCall = call;
    }

    public String getSipDest() throws SkypeException {
        return this.controller.getAuthMap().getSipDest(this.currentSkypeCall.getPartnerId());
    }

    public void lock() {
        this.locked = true;
    }

    public void unLock() {
        this.locked = false;
    }

    public void skypeCallMaked() {
        this.currentSkypeCall.addCallStatusChangedListener(this);
        this.redirSkypeAudio();
    }

    public void redirSkypeAudio() {
        if (this.currentSkypeCall != null && !this.skypeAudioRedirected) {
            try {
                String skypeCallid = this.currentSkypeCall.getId();
                Connector.getInstance().execute("ALTER CALL " + skypeCallid + " SET_OUTPUT PORT=\"" + this.ua.skypeOutPort + "\"");
                Connector.getInstance().execute("ALTER CALL " + skypeCallid + " SET_INPUT PORT=\"" + this.ua.skypeInPort + "\"");
                this.log.debug("###  redirSkypeAudio success");
                this.skypeAudioRedirected = true;
            }
            catch (Exception e) {
                this.log.debug("redirSkypeAudio: error", e);
            }
        }
    }

    public void resumeSkypeCall() {
        try {
            this.currentSkypeCall.resume();
        }
        catch (Exception e) {
            this.log.error("Error resuming skype call: ", e);
            this.listen();
        }
    }

    public void holdSkypeCall() throws Exception {
        this.currentSkypeCall.hold();
    }

    public void sendSkypeDtmfDigits(String digits) {
        int p = 0;
        while (p < digits.length()) {
            char digit = digits.charAt(p);
            int sDig = -1;
            if (digit == '*') {
                sDig = Call.DTMF.TYPE_ASTERISK.ordinal();
            } else if (digit == '#') {
                sDig = Call.DTMF.TYPE_SHARP.ordinal();
            } else if (digit >= '0' && digit <= '9') {
                sDig = digit - 48;
            }
            try {
                this.currentSkypeCall.send(Call.DTMF.values()[sDig]);
                this.log.debug("DTMF:" + digit + " sent to skype");
                Thread.sleep(800L);
            }
            catch (Exception e) {
                this.log.error("Error sending dtmf: " + digit + " to skype: ", e);
            }
            ++p;
        }
    }

    private synchronized void startCallTime() {
        if (this.callStart > 0L) {
            return;
        }
        if (this.currentSkypeCall == null) {
            return;
        }
        try {
            if (this.currentSkypeCall.getStatus() != Call.Status.INPROGRESS) {
                return;
            }
        }
        catch (SkypeException e) {
            this.log.error("startCallTime:", e);
            return;
        }
        if (this.ua.call_state != "ONCALL") {
            return;
        }
        this.callStart = System.currentTimeMillis();
        this.callEntry.startTime = new Date();
        try {
            this.callEntry.callId = Long.toString(this.currentSkypeCall.getStartTime().getTime() / 1000L);
        }
        catch (Exception e) {
            this.log.error("startCallTime error", e);
        }
        this.clearSipCommandRunner();
        this.clearSkypeCommandRunner();
        this.startCallTimer();
    }

    private void logCall() {
        if (this.callStart > 0L) {
            this.callEntry.durationSeconds = (System.currentTimeMillis() - this.callStart) / 1000L;
            this.callStart = 0L;
            long minutes = this.callEntry.durationSeconds / 60L;
            String seconds = Long.toString(this.callEntry.durationSeconds % 60L + 100L).substring(1);
            this.callEntry.callCost = this.getSkypeCallCost();
            double curBal = util.getSkypeCreditBalance();
            this.log.info((Object)((Object)this.callEntry.callType) + " From: " + this.callEntry.callFrom + " To: " + this.callEntry.callTo + " CallTime: " + minutes + ":" + seconds + " Cost: " + this.callEntry.callCost + " " + util.formatSkypeCreditBalance(curBal));
            this.controller.getCallHistoryHandler().addCall(this.callEntry);
            if (this.callEntry.callType == Call.Type.OUTGOING_PSTN) {
                this.controller.showCallHist();
            }
            this.callEntry = new CallHistoryEntry();
            this.controller.updateSkypeCreditBalance(curBal);
        }
    }

    void halt() {
        this.ua.halt();
        this.interrupt();
    }

    public long getLastSipCallTime() {
        return this.lastSipCallAttempt;
    }

    public void setPinCalleeDial() {
        this.doPinCalleeDial = true;
    }

    public boolean doSkypeSIPJoin(String skypeUserId) {
        String sipDest = this.controller.getAuthMap().getSipDest(skypeUserId);
        if (sipDest == null || sipDest.length() == 0) {
            this.log.info("doSkypeSIPJoin - rejected call - no SIP Destination");
            this.listen();
            return false;
        }
        this.joinSkypeUserId = skypeUserId;
        if (sipDest.toLowerCase().indexOf("sip:") >= 0) {
            this.callEntry.callFrom = sipDest = this.controller.getSipUserContact(sipDest);
            NameAddress tmpfrom = new NameAddress(this.ua.user_profile.contact_url);
            tmpfrom.setDisplayName(skypeUserId);
            this.ua.user_profile.from_url = tmpfrom.toString();
            this.log.info("doSkypeSIPJoin - Direct SIP Dial to:" + sipDest.replaceAll(";.*", "") + " from:" + this.ua.user_profile.from_url);
            this.call(sipDest);
            this.sipCallRingTimer = new SipCallRingTimer(20L, this);
        } else {
            this.log.info("doSkypeSIPJoin - Command List:" + sipDest);
            this.answerSkypeCall(sipDest);
        }
        return true;
    }

    public void onSipCallRingTimeout() {
        if (this.ua.call_state != "ONCALL") {
            this.log.info("SIP destination did not answer. Call Cancelled.");
            this.listen();
        }
        this.clearSipCallRingTimer();
    }

    private void clearSipCallRingTimer() {
        if (this.sipCallRingTimer != null) {
            this.sipCallRingTimer.stopTimer();
        }
        this.sipCallRingTimer = null;
    }

    private void getSkypeCallRate() {
        this.glbSkypeCallRate = 0.0;
        this.glbSkypeCallPrecision = 0;
        this.glbSkypeCallCurrency = "";
        this.glbSkypeCallid = null;
        if (this.currentSkypeCall == null) {
            return;
        }
        try {
            this.glbSkypeCallid = this.currentSkypeCall.getId();
            if (this.callEntry.callType == Call.Type.OUTGOING_PSTN) {
                this.glbSkypeCallRate = Long.parseLong(util.parseSkypeResponse("GET CALL " + this.glbSkypeCallid + " RATE", "CALL " + this.glbSkypeCallid + " RATE"));
                if (this.glbSkypeCallRate == 0.0) {
                    this.log.info("Call Rate: Free");
                } else {
                    this.glbSkypeCallPrecision = Integer.parseInt(util.parseSkypeResponse("GET CALL " + this.glbSkypeCallid + " RATE_PRECISION", "CALL " + this.glbSkypeCallid + " RATE_PRECISION"));
                    if (this.glbSkypeCallPrecision == 0) {
                        this.glbSkypeCallPrecision = 1;
                    }
                    this.glbSkypeCallRate /= Math.pow(10.0, this.glbSkypeCallPrecision);
                    this.glbSkypeCallCurrency = util.parseSkypeResponse("GET CALL " + this.glbSkypeCallid + " RATE_CURRENCY", "CALL " + this.glbSkypeCallid + " RATE_CURRENCY");
                    this.log.info("Call Rate: " + util.formatAmount(this.glbSkypeCallRate, this.glbSkypeCallPrecision) + " " + this.glbSkypeCallCurrency);
                }
            }
        }
        catch (Throwable e) {
            this.log.debug("getSkypeCallRate", e);
        }
    }

    private String getSkypeCallCost() {
        if (this.glbSkypeCallid == null) {
            return "";
        }
        try {
            if (this.callEntry.callType == Call.Type.OUTGOING_PSTN) {
                this.callEntry.durationSeconds = Integer.parseInt(util.parseSkypeResponse("GET CALL " + this.glbSkypeCallid + " DURATION", "CALL " + this.glbSkypeCallid + " DURATION"));
                if (this.glbSkypeCallRate > 0.0) {
                    long durMin = (this.callEntry.durationSeconds + 59L) / 60L;
                    double callCost = (double)durMin * this.glbSkypeCallRate + this.skype_profile.connectionFee;
                    return String.valueOf(util.formatAmount(callCost, 2)) + " " + this.glbSkypeCallCurrency;
                }
                return "FREE";
            }
        }
        catch (Throwable e) {
            this.log.debug("appendSkypeCallCost:", e);
        }
        return "FREE";
    }

    public void onCallTimeoutWarning() {
        this.log.info("Call Time Limit Warning.");
        if (this.skype_profile.overLimitWarningFile.length() > 0) {
            this.ua.queueSipClip(this.skype_profile.overLimitWarningFile);
            this.ua.queueSkypeClip(this.skype_profile.overLimitWarningFile);
        }
    }

    public void onCallTimeout() {
        this.log.info("Call Time Limit reached - call Terminated.");
        this.listen();
    }

    private void clearCallTimer() {
        if (this.callTimer != null) {
            this.callTimer.stopTimer();
        }
        this.callTimer = null;
    }

    private void startCallTimer() {
        int cutOff = this.calcMaxCallTime();
        if (cutOff > 0) {
            this.log.info("This call is limited to: " + cutOff + " minutes");
            this.callTimer = new CallTimer(cutOff, this.skype_profile.warnMinutesBeforeCutoff, this);
            this.callTimer.start();
        } else {
            this.callTimer = null;
        }
    }

    private int calcMaxCallTime() {
        int cutOff = this.skype_profile.maxCallTimeLimitMinutes;
        if (this.callEntry.callType == Call.Type.OUTGOING_PSTN) {
            if (this.skype_profile.MaxPstnCallTimeLimitMinutes > 0 && (this.skype_profile.MaxPstnCallTimeLimitMinutes < cutOff || cutOff == 0)) {
                cutOff = this.skype_profile.MaxPstnCallTimeLimitMinutes;
            }
            if (this.skype_profile.dailyPstnLimitMinutes > 0) {
                int pstnRemaining = this.skype_profile.dailyPstnLimitMinutes - this.controller.getCallHistoryHandler().getPstnTodayTimeQualified();
                if (pstnRemaining <= 0) {
                    this.log.error("remaining time lte 0???");
                }
                if (pstnRemaining < cutOff || cutOff == 0) {
                    cutOff = pstnRemaining;
                }
            }
        }
        return cutOff;
    }

    private boolean isOverUsageLimit(String filteredDest) {
        String tmp = filteredDest.replaceAll(" ", "").replaceAll("^[+]", "").replaceAll("^00", "");
        if (tmp.length() < 1) {
            return false;
        }
        if (Character.isDigit(tmp.charAt(0))) {
            int pstnRemaining;
            CallHistoryHandler chh = this.controller.getCallHistoryHandler();
            if (chh.isTollFreeNumber(tmp)) {
                return false;
            }
            if (this.skype_profile.dailyPstnUniqueNumberLimit > 0 && chh.getPstnTodayCountQualified() >= this.skype_profile.dailyPstnUniqueNumberLimit) {
                return true;
            }
            if (this.skype_profile.dailyPstnLimitMinutes > 0 && ((pstnRemaining = this.skype_profile.dailyPstnLimitMinutes - chh.getPstnTodayTimeQualified()) <= 0 || pstnRemaining < this.skype_profile.refuseNewPstnCallsWhenRemainingMinutesUnder)) {
                return true;
            }
        }
        return false;
    }

    public String getPossibleRunawaySkypeCallid() {
        return this.glbPossibleRunaway;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum AuthState {
        IDLE,
        SIP_WAITFORPIN,
        SIP_WAITFORDESTINATION,
        SKYPE_WAITFORPIN,
        SKYPE_WAITFORDESTINATION;

    }
}

