/*
 * Decompiled with CFR 0.152.
 */
package local.ua;

import java.io.File;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import local.media.PipedInputStreamSizable;
import local.ua.SSInBandDtmfInterface;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class SSInBandDtmfDetector
extends Thread {
    private Logger log = null;
    private float SAMPLING_RATE = 16000.0f;
    private int BYTESPERDATASAMPLE = 2;
    private int GOERTZEL_N;
    private int NUM_FREQS;
    private int STREAM_BYTES;
    private int HIT_THRESHHOLD;
    private int NOHIT_THRESHHOLD;
    private int HIT_THRESHHOLDms;
    private int NOHIT_THRESHHOLDms;
    private float[] curValues;
    private int activeDetect;
    private long activeHitCnt;
    private long silenceHitCnt;
    private States detectState;
    private float[] freqCoeffValueArray;
    private float Q0;
    private float[] Q1;
    private float[] Q2;
    private boolean running = true;
    private PipedInputStream dataIs = new PipedInputStreamSizable(65536);
    private SSInBandDtmfInterface dtmfInt = null;
    private float curSample;
    private int activeDTMF;
    private static int[][] dtmf_row_col_map;
    private int detectRow;
    private int detectCol;
    private int peak_count;
    private int max_index;
    private double maxval;
    private double tFactor;
    private int iloop;

    static {
        int[][] nArrayArray = new int[4][];
        nArrayArray[0] = new int[]{1, 2, 3, 12};
        nArrayArray[1] = new int[]{4, 5, 6, 13};
        nArrayArray[2] = new int[]{7, 8, 9, 14};
        int[] nArray = new int[4];
        nArray[0] = 10;
        nArray[2] = 11;
        nArray[3] = 15;
        nArrayArray[3] = nArray;
        dtmf_row_col_map = nArrayArray;
    }

    public SSInBandDtmfDetector(SSInBandDtmfInterface argUa, int argSampleRate, int argBytesPerSample, int argHitThresholdms, int argSilenceThresholdms) {
        this.setName(String.valueOf(this.getClass().getName()) + ".T" + this.getName().replaceAll("Thread-", ""));
        this.log = Logger.getLogger(this.getName());
        this.dtmfInt = argUa;
        this.SAMPLING_RATE = argSampleRate;
        this.BYTESPERDATASAMPLE = argBytesPerSample;
        this.HIT_THRESHHOLDms = argHitThresholdms;
        this.NOHIT_THRESHHOLDms = argSilenceThresholdms;
        this.init();
        this.start();
    }

    private void init() {
        double msPerRound = 5.5;
        int gMagic = (int)(msPerRound * (double)this.BYTESPERDATASAMPLE * 8.0);
        this.GOERTZEL_N = Math.round(this.SAMPLING_RATE / (float)gMagic);
        this.STREAM_BYTES = this.GOERTZEL_N * this.BYTESPERDATASAMPLE;
        this.HIT_THRESHHOLD = (int)((double)this.HIT_THRESHHOLDms / msPerRound);
        this.NOHIT_THRESHHOLD = (int)((double)this.NOHIT_THRESHHOLDms / msPerRound);
        if (this.NOHIT_THRESHHOLD < 1) {
            this.NOHIT_THRESHHOLD = 1;
        }
        float[] frequencyArray = new float[]{697.0f, 770.0f, 852.0f, 941.0f, 1209.0f, 1336.0f, 1477.0f, 1633.0f};
        this.NUM_FREQS = frequencyArray.length;
        this.freqCoeffValueArray = new float[this.NUM_FREQS];
        this.Q1 = new float[this.NUM_FREQS];
        this.Q2 = new float[this.NUM_FREQS];
        this.curValues = new float[this.NUM_FREQS];
        int n = 0;
        while (n < this.NUM_FREQS) {
            this.freqCoeffValueArray[n] = (float)(2.0 * Math.cos(Math.PI * 2 * (double)frequencyArray[n] / (double)this.SAMPLING_RATE));
            ++n;
        }
        this.silenceHitCnt = 1L;
        this.detectState = States.SILENCE;
        this.activeDetect = -1;
    }

    public void stopDetecter() {
        this.running = false;
    }

    public PipedInputStream getPipedInputStream() {
        return this.dataIs;
    }

    public void run() {
        byte[] data = new byte[this.STREAM_BYTES];
        while (!Thread.interrupted() && this.running) {
            try {
                if (this.dataIs.available() >= this.STREAM_BYTES) {
                    int si;
                    this.dataIs.read(data, 0, this.STREAM_BYTES);
                    if (this.BYTESPERDATASAMPLE == 2) {
                        si = 0;
                        while (si < this.STREAM_BYTES) {
                            this.curSample = data[si + 1] << 8 | data[si] & 0xFF;
                            int qi = 0;
                            while (qi < this.NUM_FREQS) {
                                this.Q0 = this.freqCoeffValueArray[qi] * this.Q1[qi] - this.Q2[qi] + this.curSample;
                                this.Q2[qi] = this.Q1[qi];
                                this.Q1[qi] = this.Q0;
                                ++qi;
                            }
                            si += 2;
                        }
                    } else {
                        si = 0;
                        while (si < this.STREAM_BYTES) {
                            this.curSample = data[si];
                            int qi = 0;
                            while (qi < this.NUM_FREQS) {
                                this.Q0 = this.freqCoeffValueArray[qi] * this.Q1[qi] - this.Q2[qi] + this.curSample;
                                this.Q2[qi] = this.Q1[qi];
                                this.Q1[qi] = this.Q0;
                                ++qi;
                            }
                            ++si;
                        }
                    }
                    si = 0;
                    while (si < this.NUM_FREQS) {
                        this.curValues[si] = this.Q1[si] * this.Q1[si] + this.Q2[si] * this.Q2[si] - this.freqCoeffValueArray[si] * this.Q1[si] * this.Q2[si];
                        this.Q1[si] = 0.0f;
                        this.Q2[si] = 0.0f;
                        ++si;
                    }
                    this.activeDTMF = this.doDTMFDetection();
                    if (this.activeDTMF < 0) {
                        if (this.detectState != States.SILENCE) {
                            if (this.activeDetect >= 0 && this.activeHitCnt >= (long)this.HIT_THRESHHOLD && this.silenceHitCnt >= (long)this.NOHIT_THRESHHOLD) {
                                if (this.dtmfInt != null) {
                                    this.dtmfInt.gotDtmfDigit(this.activeDetect);
                                } else {
                                    this.log.warn(" got:" + this.activeDetect);
                                }
                                this.activeDetect = -1;
                            }
                            this.silenceHitCnt = 1L;
                            this.detectState = States.SILENCE;
                            continue;
                        }
                        ++this.silenceHitCnt;
                        continue;
                    }
                    if (this.detectState != States.ACTIVE) {
                        if (this.silenceHitCnt >= (long)this.NOHIT_THRESHHOLD) {
                            this.activeHitCnt = 1L;
                            this.detectState = States.ACTIVE;
                            this.activeDetect = this.activeDTMF;
                            continue;
                        }
                        this.detectState = States.FALSEHIT;
                        this.activeDetect = -1;
                        continue;
                    }
                    if (this.activeDTMF != this.activeDetect) {
                        this.detectState = States.FALSEHIT;
                        this.activeDetect = -1;
                        continue;
                    }
                    ++this.activeHitCnt;
                    continue;
                }
                try {
                    SSInBandDtmfDetector.sleep(10L);
                }
                catch (Exception si) {}
            }
            catch (IOException ioe) {
                try {
                    SSInBandDtmfDetector.sleep(10L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private int doDTMFDetection() {
        this.detectRow = 0;
        this.maxval = 0.0;
        this.iloop = 0;
        while (this.iloop < 4) {
            if ((double)this.curValues[this.iloop] > this.maxval) {
                this.maxval = this.curValues[this.iloop];
                this.detectRow = this.iloop;
            }
            ++this.iloop;
        }
        if ((double)this.curValues[this.detectRow] < 400000.0) {
            return -1;
        }
        this.detectCol = 4;
        this.maxval = 0.0;
        this.iloop = 4;
        while (this.iloop < 8) {
            if ((double)this.curValues[this.iloop] > this.maxval) {
                this.maxval = this.curValues[this.iloop];
                this.detectCol = this.iloop;
            }
            ++this.iloop;
        }
        if ((double)this.curValues[this.detectCol] < 400000.0) {
            return -1;
        }
        if (this.curValues[this.detectCol] > this.curValues[this.detectRow]) {
            this.max_index = this.detectCol;
            if ((double)this.curValues[this.detectRow] < (double)this.curValues[this.detectCol] * 0.398) {
                return -1;
            }
        } else {
            this.max_index = this.detectRow;
            if ((double)this.curValues[this.detectCol] < (double)this.curValues[this.detectRow] * 0.158) {
                return -1;
            }
        }
        this.tFactor = (double)this.curValues[this.max_index] > 1.0E9 ? (double)this.curValues[this.max_index] * 0.158 : (double)this.curValues[this.max_index] * 0.01;
        this.peak_count = 0;
        this.iloop = 0;
        while (this.iloop < 8) {
            if ((double)this.curValues[this.iloop] > this.tFactor) {
                ++this.peak_count;
            }
            ++this.iloop;
        }
        if (this.peak_count > 2) {
            return -1;
        }
        return dtmf_row_col_map[this.detectRow][this.detectCol - 4];
    }

    public static void main(String[] args) throws Exception {
        String clipFile = "testingclips/skypetest.wav";
        int ReadSize = 5000;
        AudioInputStream audStream = null;
        try {
            AudioFormat af = AudioSystem.getAudioFileFormat(new File(clipFile)).getFormat();
            SSInBandDtmfDetector detector = new SSInBandDtmfDetector(null, (int)af.getSampleRate(), af.getSampleSizeInBits() / 8, 20, 6);
            PipedOutputStream dtmfDectorStream = new PipedOutputStream(detector.getPipedInputStream());
            PropertyConfigurator.configure("log.properties");
            System.out.println("clipFormat=" + af.toString());
            byte[] data = new byte[ReadSize];
            audStream = AudioSystem.getAudioInputStream(new File(clipFile));
            System.out.println("File:" + clipFile + "Opened");
            while (audStream.available() >= ReadSize) {
                audStream.read(data, 0, ReadSize);
                dtmfDectorStream.write(data, 0, ReadSize);
                try {
                    SSInBandDtmfDetector.sleep(1L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            dtmfDectorStream.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Error - Msg:" + e.getLocalizedMessage());
        }
        System.exit(0);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum States {
        SILENCE,
        ACTIVE,
        FALSEHIT;

    }
}

