/*
 * Decompiled with CFR 0.152.
 */
package local.ua;

import java.util.Vector;
import local.ua.QueueCmd;
import local.ua.SSCallChannel;
import org.apache.log4j.Logger;

public class SipCommandRunner
extends Thread {
    private Vector<QueueCmd> queueList = new Vector();
    private SSCallChannel skypeua = null;
    private boolean stop = false;
    private Logger log = null;

    SipCommandRunner(String cmdData, SSCallChannel argUa) {
        this.setName(String.valueOf(this.getClass().getName()) + ".T" + this.getName().replaceAll("Thread-", ""));
        this.log = Logger.getLogger(this.getName());
        this.skypeua = argUa;
        String[] cmdList = cmdData.split(";");
        int c = 0;
        while (c < cmdList.length) {
            String[] curCmd = cmdList[c].split(":");
            if (curCmd.length == 2) {
                this.queueList.add(new QueueCmd(curCmd[0].toLowerCase(), curCmd[1]));
            } else if (curCmd.length == 1) {
                this.queueList.add(new QueueCmd(curCmd[0].toLowerCase(), ""));
            } else {
                this.log.error("Invalid command sequence:" + cmdData);
                this.queueList.clear();
                this.skypeua.listen();
                break;
            }
            ++c;
        }
    }

    public void run() {
        while (this.queueList.size() > 0 && !this.stop) {
            QueueCmd thisCmd = this.queueList.get(0);
            this.queueList.remove(0);
            this.log.info(String.valueOf(thisCmd.attrib) + ":" + thisCmd.value);
            if (thisCmd.attrib.equals("pause")) {
                try {
                    SipCommandRunner.sleep(Long.parseLong(thisCmd.value) * 1000L);
                }
                catch (Exception e) {
                    this.log.error("error", e);
                }
                continue;
            }
            if (thisCmd.attrib.equals("dtmf")) {
                this.skypeua.ua.queueSipDtmfDigits(thisCmd.value);
                continue;
            }
            if (thisCmd.attrib.equals("pin")) {
                this.skypeua.startSipAuthSequence(thisCmd.value);
                continue;
            }
            if (thisCmd.attrib.equals("calleeid")) {
                this.skypeua.setPinCalleeDial();
                continue;
            }
            if (thisCmd.attrib.equals("play")) {
                this.skypeua.ua.queueSipClip(thisCmd.value);
                this.skypeua.waitForSipClipsComplete();
                if (this.queueList.size() != 0) continue;
                this.skypeua.ua.hangup();
                continue;
            }
            this.log.error("Unknown command:" + thisCmd.attrib + ":" + thisCmd.value);
        }
        if (!this.stop) {
            this.skypeua.clearSipCommandRunner();
        }
    }

    public void stopCommands() {
        this.stop = true;
    }
}

