/*
 * Decompiled with CFR 0.152.
 */
package local.ua;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.PipedOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import local.ua.SSInBandDtmfDetector;
import local.ua.SSInBandDtmfInterface;
import local.ua.SkypeUserAgent;
import org.apache.log4j.Logger;

public class SkypeAudioReceiverServer
extends Thread
implements SSInBandDtmfInterface {
    private boolean stopnow = false;
    private Logger log = null;
    private boolean sipSending = false;
    private PipedOutputStream skypeOutputStream = new PipedOutputStream();
    private SkypeUserAgent ua = null;
    private boolean haltNow = false;
    private ServerSocket listener;
    private long neededSkypeBytes = 0L;
    private int skypeSleepIntervalMs = 0;
    private static final int SkypeBytesPerMs = 32;
    private boolean inbandDtmfActive = false;

    public SkypeAudioReceiverServer(SkypeUserAgent argUa) throws Exception {
        this.setName(String.valueOf(this.getClass().getName()) + ".T" + this.getName().replaceAll("Thread-", ""));
        this.log = Logger.getLogger(this.getName());
        this.ua = argUa;
    }

    public PipedOutputStream getPipedOutputStream() {
        return this.skypeOutputStream;
    }

    public void stopMedia() {
        this.stopnow = true;
    }

    public void gotDtmfDigit(int digit) {
        this.ua.gotSkypeDtmfDigit(digit);
    }

    public void setSipSending(boolean state, long argNeededSkypeBytes) {
        this.sipSending = state;
        this.neededSkypeBytes = argNeededSkypeBytes;
        this.skypeSleepIntervalMs = (int)(this.neededSkypeBytes / 32L / 2L) + 1;
        if (!this.ua.skype_profile.inbandFullTimeDtmfDetection && state) {
            this.inbandDtmfActive = false;
        }
    }

    public void halt() {
        this.haltNow = true;
        try {
            this.listener.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void interrupt() {
        this.stopnow = true;
        super.interrupt();
    }

    public void run() {
        block3: {
            try {
                this.listener = new ServerSocket(this.ua.skypeOutPort);
                while (!this.haltNow) {
                    this.inbandDtmfActive = this.ua.skype_profile.enableSkypeDtmfDetector;
                    this.neededSkypeBytes = 320L;
                    this.skypeSleepIntervalMs = (int)(this.neededSkypeBytes / 32L / 2L) + 1;
                    Socket server = this.listener.accept();
                    this.handleConnection(server);
                    server.close();
                }
            }
            catch (IOException ioe) {
                if (this.haltNow) break block3;
                this.log.error("IOException: ", ioe);
            }
        }
    }

    public void handleConnection(Socket server) {
        if (this.ua.skype_profile.audioPriorityIncrease > 0) {
            try {
                this.setPriority(5 + this.ua.skype_profile.audioPriorityIncrease);
            }
            catch (Exception e) {
                this.log.warn("setPriority Error. ", e);
            }
        }
        this.stopnow = false;
        try {
            server.setSoLinger(false, 500);
            server.setKeepAlive(false);
            server.setSoTimeout(80);
        }
        catch (IOException e) {
            this.log.fatal("socket error", e);
            this.ua.hangup();
            this.stopnow = true;
        }
        if (this.ua.skype_profile.TcpRxBufferSize > 0) {
            try {
                server.setReceiveBufferSize(this.ua.skype_profile.TcpRxBufferSize);
                int tstRx = server.getReceiveBufferSize();
                if (tstRx != this.ua.skype_profile.TcpRxBufferSize) {
                    this.log.warn("error setting TCPReceiveBufferSize");
                }
            }
            catch (SocketException e) {
                this.log.warn("error setting TCPReceiveBufferSize", e);
            }
        }
        int BUFFER_SIZE = 8192;
        int numRead = 0;
        long skypePacketCnt = 0L;
        long ioErrorCnt = 0L;
        long underRuns = 0L;
        int noDataCount = 0;
        byte[] inpcm = new byte[BUFFER_SIZE];
        BufferedInputStream sockin = null;
        SSInBandDtmfDetector dtmfDetecter = null;
        PipedOutputStream skypeDtmfDectorStream = null;
        try {
            sockin = new BufferedInputStream(server.getInputStream(), BUFFER_SIZE);
            if (this.ua.skype_profile.enableSkypeDtmfDetector) {
                dtmfDetecter = new SSInBandDtmfDetector(this, 16000, 2, this.ua.skype_profile.SkypeDtmfDetectorHitThreshold, this.ua.skype_profile.SkypeDtmfDetectorSilenceThreshold);
                skypeDtmfDectorStream = new PipedOutputStream(dtmfDetecter.getPipedInputStream());
            }
        }
        catch (IOException e) {
            this.log.fatal("error", e);
            this.ua.hangup();
            this.stopnow = true;
        }
        this.log.debug("+++ skypeAudioReceiver Connected on port:" + this.ua.skypeOutPort);
        while (!this.stopnow) {
            int availBytes;
            try {
                availBytes = sockin.available();
            }
            catch (Exception e) {
                if (!this.stopnow) {
                    ++ioErrorCnt;
                }
                availBytes = -999;
            }
            if ((long)availBytes >= this.neededSkypeBytes) {
                if (availBytes > BUFFER_SIZE) {
                    availBytes = BUFFER_SIZE;
                }
                noDataCount = 0;
                try {
                    numRead = sockin.read(inpcm, 0, availBytes);
                }
                catch (Exception e) {
                    if (!this.stopnow) {
                        ++ioErrorCnt;
                    }
                    numRead = -999;
                }
                ++skypePacketCnt;
                if (this.sipSending) {
                    try {
                        this.skypeOutputStream.write(inpcm, 0, numRead);
                    }
                    catch (IOException e) {
                        this.log.error("pipe write error");
                    }
                    if (this.ua.skype_profile.jitterLevel == 0) {
                        this.ua.skypeRtpSender.skypeSentData();
                    }
                }
                try {
                    if (this.inbandDtmfActive) {
                        skypeDtmfDectorStream.write(inpcm, 0, numRead);
                    }
                }
                catch (IOException e) {
                    this.log.error("dtmf pipe write error");
                }
            } else if (availBytes != -999 && !this.stopnow && this.sipSending && ++noDataCount > 5) {
                ++underRuns;
            }
            try {
                SkypeAudioReceiverServer.sleep(this.skypeSleepIntervalMs);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            sockin.close();
            if (this.ua.skype_profile.enableSkypeDtmfDetector) {
                skypeDtmfDectorStream.close();
            }
        }
        catch (IOException e) {
            this.log.error("dtmf pipe write error");
        }
        if (this.ua.skype_profile.audioPriorityIncrease > 0) {
            try {
                this.setPriority(5);
            }
            catch (Exception e) {
                this.log.warn("resetPriority Error. ", e);
            }
        }
        this.setSipSending(false, this.neededSkypeBytes);
        String stats = "SkypeAudioReceiver stats - packets:" + skypePacketCnt;
        if (ioErrorCnt > 0L) {
            stats = String.valueOf(stats) + " timeOuts:" + ioErrorCnt;
        }
        if (underRuns > 0L) {
            stats = String.valueOf(stats) + " underRuns=" + underRuns;
        }
        this.log.info(stats);
    }
}

