/*
 * Decompiled with CFR 0.152.
 */
package local.ua;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PipedInputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import local.ua.PipedInputStreamPCM;
import local.ua.SkypeUserAgent;
import org.apache.log4j.Logger;

public class SkypeAudioSenderServer
extends Thread {
    private Vector<String> skypeClipQueue = new Vector();
    private AudioInputStream skypeClipStream = null;
    private boolean stopnow = false;
    private Logger log = null;
    private static final int PIPEBUFFER_SIZE = 65536;
    private static final int maxBehindBytes = 60536;
    private SkypeUserAgent ua = null;
    private boolean haltNow = false;
    private boolean sipSentData = false;
    private boolean sipConnected = false;
    private ServerSocket listener;
    private static final int pcmBytesPerMs = 32;
    private PipedInputStreamPCM sipInputStream = new PipedInputStreamPCM(65536);

    public SkypeAudioSenderServer(SkypeUserAgent argUa) throws Exception {
        this.setName(String.valueOf(this.getClass().getName()) + ".T" + this.getName().replaceAll("Thread-", ""));
        this.log = Logger.getLogger(this.getName());
        this.ua = argUa;
    }

    public PipedInputStream getPipedInPutStream() {
        return this.sipInputStream;
    }

    public void queueSkypeClip(String argClipFile) {
        this.log.debug("Play Clip:" + argClipFile);
        this.skypeClipQueue.add(argClipFile);
    }

    public void stopSkypeClips() {
        this.skypeClipQueue.removeAllElements();
        if (this.skypeClipStream != null) {
            try {
                this.skypeClipStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.skypeClipStream = null;
        }
    }

    public boolean areClipsComplete() {
        return this.skypeClipQueue.size() == 0 && this.skypeClipStream == null;
    }

    public void stopMedia() {
        this.stopnow = true;
    }

    public void halt() {
        this.haltNow = true;
        try {
            this.listener.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setSipConnected() {
        this.sipConnected = true;
    }

    public synchronized void sipSentData() {
        this.sipSentData = true;
        this.notify();
    }

    public void interrupt() {
        this.stopnow = true;
        super.interrupt();
    }

    public void run() {
        block3: {
            try {
                this.listener = new ServerSocket(this.ua.skypeInPort);
                while (!this.haltNow) {
                    Socket skypeSocket = this.listener.accept();
                    this.handleConnection(skypeSocket);
                    skypeSocket.close();
                }
            }
            catch (IOException ioe) {
                if (this.haltNow) break block3;
                this.log.error("error", ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleConnection(Socket skypeSocket) {
        if (this.ua.skype_profile.audioPriorityIncrease > 0) {
            try {
                this.setPriority(5 + this.ua.skype_profile.audioPriorityIncrease);
            }
            catch (Exception e) {
                this.log.warn("setPriority Error. ", e);
            }
        }
        this.stopnow = false;
        byte[] buffer = new byte[65536];
        int availBytes = 0;
        int numRead = 0;
        long pcmBufferBytesReceived = 0L;
        long pcmPacketCounter = 0L;
        int bufferCeiling = 0;
        long choppedCnt = 0L;
        long underRunsCnt = 0L;
        long ioErrors = 0L;
        int skypeSendMillis = 10;
        int minRxSize = 32 * skypeSendMillis;
        BufferedOutputStream skypeSockout = null;
        try {
            skypeSocket.setSoLinger(false, 500);
            skypeSocket.setTcpNoDelay(true);
            skypeSocket.setKeepAlive(false);
            skypeSockout = new BufferedOutputStream(skypeSocket.getOutputStream(), 2560);
            this.sipInputStream.clearBuffer();
        }
        catch (IOException e) {
            this.log.fatal("error", e);
            this.ua.hangup();
            this.stopnow = true;
        }
        if (this.ua.skype_profile.TcpTxBufferSize > 0) {
            try {
                skypeSocket.setSendBufferSize(this.ua.skype_profile.TcpTxBufferSize);
                int tstTx = skypeSocket.getSendBufferSize();
                if (tstTx != this.ua.skype_profile.TcpTxBufferSize) {
                    this.log.warn("error setting TCPSendBufferSize");
                }
            }
            catch (SocketException e) {
                this.log.warn("error setting TCPSendBufferSize", e);
            }
        }
        this.log.debug("+++ skypeAudioSender connected to port:" + this.ua.skypeInPort);
        while (!this.stopnow) {
            if (this.skypeClipStream != null) {
                int clipRead = -1;
                try {
                    clipRead = this.skypeClipStream.read(buffer, 0, 640);
                }
                catch (Exception e) {
                    this.log.error("error", e);
                }
                if (clipRead > 0) {
                    try {
                        skypeSockout.write(buffer, 0, clipRead);
                    }
                    catch (IOException e) {
                        this.log.error("error", e);
                    }
                    try {
                        SkypeAudioSenderServer.sleep(20L);
                    }
                    catch (Exception e) {}
                    continue;
                }
                this.log.debug("--- clip Closed");
                try {
                    this.skypeClipStream.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.skypeClipStream = null;
                if (this.skypeClipQueue.size() != 0 || !this.sipConnected) continue;
                try {
                    this.sipInputStream.clearBuffer();
                }
                catch (Exception e) {}
                continue;
            }
            if (this.skypeClipQueue.size() > 0) {
                this.skypeClipStream = this.getNextClipStream();
                continue;
            }
            if (this.sipConnected) {
                SkypeAudioSenderServer clipRead = this;
                synchronized (clipRead) {
                    try {
                        if (!this.sipSentData) {
                            this.wait(100L);
                        }
                        this.sipSentData = false;
                    }
                    catch (InterruptedException e) {
                        this.log.error("Interrupted", e);
                    }
                }
                try {
                    availBytes = this.sipInputStream.available();
                }
                catch (IOException e) {
                    this.log.error("pipe ioerror", e);
                }
                if (availBytes >= minRxSize) {
                    pcmBufferBytesReceived += (long)availBytes;
                    ++pcmPacketCounter;
                    if (availBytes >= 60536) {
                        try {
                            this.sipInputStream.chopBuffer(54482);
                            availBytes = this.sipInputStream.available();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        ++choppedCnt;
                    }
                    if (availBytes > bufferCeiling) {
                        bufferCeiling = availBytes;
                    }
                    try {
                        numRead = this.sipInputStream.read(buffer, 0, availBytes);
                        skypeSockout.write(buffer, 0, numRead);
                    }
                    catch (IOException e) {
                        ++ioErrors;
                    }
                    continue;
                }
                if (this.ua.onRemoteSipHold || pcmPacketCounter <= 5L || this.stopnow) continue;
                ++underRunsCnt;
                continue;
            }
            try {
                SkypeAudioSenderServer.sleep(20L);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.stopSkypeClips();
        try {
            skypeSockout.close();
            this.sipInputStream.clearBuffer();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (this.ua.skype_profile.audioPriorityIncrease > 0) {
            try {
                this.setPriority(5);
            }
            catch (Exception e) {
                this.log.warn("resetPriority Error. ", e);
            }
        }
        this.sipConnected = false;
        this.stopnow = false;
        int maxLatency = bufferCeiling / 32;
        if (maxLatency < 0) {
            maxLatency = 0;
        }
        int avgLatency = 0;
        if (pcmPacketCounter > 0L) {
            avgLatency = (int)(pcmBufferBytesReceived / pcmPacketCounter / 32L);
        }
        String msg = "SkypeAudioSender stats - packets:" + pcmPacketCounter;
        if (choppedCnt > 0L) {
            msg = String.valueOf(msg) + " chopCnt:" + choppedCnt;
        }
        if (underRunsCnt > 0L) {
            msg = String.valueOf(msg) + " underRuns:" + underRunsCnt;
        }
        if (ioErrors > 0L) {
            msg = String.valueOf(msg) + " IOErrors:" + ioErrors;
        }
        msg = String.valueOf(msg) + " maxLatency:" + maxLatency + "ms avgLatency:" + avgLatency + "ms";
        this.log.info(msg);
    }

    private AudioInputStream getNextClipStream() {
        AudioInputStream retvar = null;
        while (this.skypeClipQueue.size() > 0 && retvar == null) {
            String clipFile = this.skypeClipQueue.get(0);
            this.skypeClipQueue.remove(0);
            try {
                this.log.debug("clipFormat=" + AudioSystem.getAudioFileFormat(new File(clipFile)).toString());
                AudioFormat format = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 16000.0f, 16, 1, 2, 16000.0f, false);
                AudioInputStream srcStream = AudioSystem.getAudioInputStream(new File(clipFile));
                retvar = AudioSystem.getAudioInputStream(format, srcStream);
                this.log.debug("+++ clip " + clipFile + " Opened");
            }
            catch (Exception e) {
                this.log.error("File " + clipFile + " Error - Msg:", e);
            }
        }
        return retvar;
    }
}

