/*
 * Decompiled with CFR 0.152.
 */
package local.ua;

import java.io.IOException;
import java.io.PipedOutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import local.ua.RtpPacket;
import local.ua.SSInBandDtmfDetector;
import local.ua.SSInBandDtmfInterface;
import local.ua.SkypeAudioSenderServer;
import local.ua.SkypeUserAgent;
import local.ua.sscodecs.SSCodec;
import org.apache.log4j.Logger;

public class SkypeRtpReceiver
extends Thread
implements SSInBandDtmfInterface {
    private boolean doSkypeSend = false;
    private boolean stopnow = false;
    private Logger log = null;
    private static final int RTP_BUFFER_SIZE = 512;
    private SSCodec ssCodec = null;
    private static final int SO_TIMEOUT = 100;
    private DatagramSocket rtp_socket = null;
    private SkypeUserAgent ua = null;
    private boolean doRtpRedirect = false;
    SkypeAudioSenderServer skypeSender = null;
    private PipedOutputStream skypeOutStream = null;
    private int codec_payload_type;
    private int redirectCntReceived = 0;
    private boolean startMediaCalled = false;
    private boolean inbandDtmfActive = false;

    public SkypeRtpReceiver(SkypeUserAgent argUa) throws Exception {
        this.setName(String.valueOf(this.getClass().getName()) + ".T" + this.getName().replaceAll("Thread-", ""));
        this.log = Logger.getLogger(this.getName());
        this.ua = argUa;
    }

    public void initRtp(SSCodec argCodec, DatagramSocket socket) throws Exception {
        this.initCodec(argCodec);
        this.rtp_socket = socket;
    }

    public void initCodec(SSCodec argCodec) {
        this.ssCodec = argCodec;
        this.codec_payload_type = this.ssCodec.getPayloadType();
    }

    public synchronized void startMedia() {
        this.startMediaCalled = true;
        this.notify();
    }

    public void startSkypeMedia() throws Exception {
        this.doSkypeSend = true;
        if (!this.ua.skype_profile.inbandFullTimeDtmfDetection) {
            this.inbandDtmfActive = false;
        }
    }

    public void stopMedia() {
        this.stopnow = true;
        this.doSkypeSend = false;
        this.skypeSender.stopMedia();
    }

    public void gotDtmfDigit(int digit) {
        this.ua.onDtmfReceived(this.ua.call, digit);
    }

    void halt() {
        this.interrupt();
    }

    public void interrupt() {
        this.stopnow = true;
        super.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.skypeSender = new SkypeAudioSenderServer(this.ua);
            this.skypeSender.start();
            this.skypeOutStream = new PipedOutputStream(this.skypeSender.getPipedInPutStream());
            while (true) {
                this.inbandDtmfActive = this.ua.skype_profile.enableSIPInbandDtmfDetector;
                SkypeRtpReceiver skypeRtpReceiver = this;
                synchronized (skypeRtpReceiver) {
                    while (!this.startMediaCalled) {
                        this.wait();
                    }
                }
                this.startMediaCalled = false;
                this.rtpReceiver();
            }
        }
        catch (InterruptedException ie) {
            this.log.debug("interrupted");
            this.skypeSender.halt();
        }
        catch (Exception e) {
            this.log.error("error", e);
        }
    }

    public void resetRTPAllowRedirect() {
        if (this.ua.skype_profile.enableSendRTPtoReceivedAddress) {
            if (!this.doRtpRedirect) {
                this.log.info("RtpSender Address unLocked.");
                this.doRtpRedirect = true;
            }
            this.redirectCntReceived = 0;
        }
    }

    private void rtpReceiver() throws IOException {
        if (this.ua.skype_profile.audioPriorityIncrease > 0) {
            try {
                this.setPriority(5 + this.ua.skype_profile.audioPriorityIncrease);
            }
            catch (Exception e) {
                this.log.warn("setPriority Error. ", e);
            }
        }
        if (this.ua.skype_profile.enableSendRTPtoReceivedAddress) {
            this.doRtpRedirect = true;
        }
        byte[] buffer = new byte[512];
        RtpPacket rtp_packet = new RtpPacket(buffer, 0);
        DatagramPacket rtpDatagram = new DatagramPacket(buffer, 0, buffer.length);
        this.stopnow = false;
        byte[] outpcm = new byte[2048];
        int outpcmlen = 0;
        long rtpTimeoutCnt = 0L;
        long ioErrorCnt = 0L;
        long ukErrorCnt = 0L;
        int timeoutCnt = 0;
        int payLoadType = 0;
        int maxTimeoutCnt = this.ua.skype_profile.noRtpReceivedAutoHangupSeconds * 1000 / 110;
        boolean dtmfStartEvent = false;
        long rtpPacketCnt = 0L;
        long unKnownPayloadCnt = 0L;
        this.redirectCntReceived = 0;
        SSInBandDtmfDetector dtmfDetecter = null;
        PipedOutputStream sipDtmfDectorStream = null;
        if (this.ua.skype_profile.enableSIPInbandDtmfDetector) {
            dtmfDetecter = new SSInBandDtmfDetector(this, 16000, 2, this.ua.skype_profile.SipDtmfDetectorHitThreshold, this.ua.skype_profile.SipDtmfDetectorSilenceThreshold);
            sipDtmfDectorStream = new PipedOutputStream(dtmfDetecter.getPipedInputStream());
        }
        this.log.debug("+++ sipAudioReceiver - sip Port:" + this.rtp_socket.getLocalPort());
        this.skypeSender.stopSkypeClips();
        this.skypeSender.setSipConnected();
        this.clearRTPPackets();
        while (!this.stopnow) {
            enumRX rxStatus;
            try {
                this.rtp_socket.receive(rtpDatagram);
                rtp_packet.packet_len = rtpDatagram.getLength();
                rxStatus = enumRX.SUCCESS;
            }
            catch (SocketTimeoutException e) {
                rxStatus = enumRX.TIMEOUT;
            }
            catch (IOException e) {
                rxStatus = enumRX.IOERROR;
            }
            catch (Exception e) {
                this.log.error("receive RTP error", e);
                rxStatus = enumRX.FAIL;
            }
            if (rxStatus == enumRX.SUCCESS) {
                timeoutCnt = 0;
                payLoadType = rtp_packet.getPayloadType();
                int hdrSize = rtp_packet.getHeaderLength();
                if (payLoadType == this.codec_payload_type) {
                    int availBytes = rtp_packet.getPayloadLength();
                    ++rtpPacketCnt;
                    if (this.doRtpRedirect) {
                        ++this.redirectCntReceived;
                        this.ua.skypeRtpSender.redirectRTP(rtpDatagram.getAddress(), rtpDatagram.getPort());
                        if (this.redirectCntReceived >= this.ua.skype_profile.lockRtpSendAddressAfterPackets) {
                            this.log.info("RtpSender Address locked.");
                            this.doRtpRedirect = false;
                        }
                    }
                    outpcmlen = this.ssCodec.CodecToPcm(buffer, hdrSize, availBytes, outpcm);
                    if (this.inbandDtmfActive) {
                        sipDtmfDectorStream.write(outpcm, 0, outpcmlen);
                    }
                    if (!this.doSkypeSend || this.ua.skypeHoldingLocal || this.ua.skypeHoldingRemote) continue;
                    this.skypeOutStream.write(outpcm, 0, outpcmlen);
                    this.skypeSender.sipSentData();
                    continue;
                }
                if (payLoadType == this.ua.dtmf2833PayloadType_session) {
                    byte eventFlag = (byte)(buffer[hdrSize + 1] & 0x80);
                    if (eventFlag == 0) {
                        dtmfStartEvent = true;
                        continue;
                    }
                    if (!dtmfStartEvent) continue;
                    dtmfStartEvent = false;
                    byte eventId = buffer[hdrSize];
                    this.gotDtmfDigit(eventId);
                    continue;
                }
                ++unKnownPayloadCnt;
                continue;
            }
            if (rxStatus == enumRX.FAIL) {
                ++ukErrorCnt;
                continue;
            }
            if (rxStatus == enumRX.IOERROR) {
                ++ioErrorCnt;
                continue;
            }
            if (this.ua.onRemoteSipHold || this.stopnow || this.ua.call_state != "ONCALL") continue;
            ++rtpTimeoutCnt;
            if (++timeoutCnt < maxTimeoutCnt) continue;
            this.log.info("rtp Timeout: hanging up");
            this.ua.hangup();
            this.stopnow = true;
        }
        if (this.ua.skype_profile.enableSIPInbandDtmfDetector) {
            sipDtmfDectorStream.close();
        }
        this.rtp_socket = null;
        if (this.ua.skype_profile.audioPriorityIncrease > 0) {
            try {
                this.setPriority(5);
            }
            catch (Exception e) {
                this.log.warn("resetPriority Error. ", e);
            }
        }
        this.skypeSender.stopMedia();
        String msg = "RTPReceiver stats - packets:" + rtpPacketCnt;
        if (rtpTimeoutCnt > 0L) {
            msg = String.valueOf(msg) + " timeOuts:" + rtpTimeoutCnt;
        }
        if (ioErrorCnt > 0L) {
            msg = String.valueOf(msg) + " IOErrors:" + ioErrorCnt;
        }
        if (unKnownPayloadCnt > 0L) {
            msg = String.valueOf(msg) + " InvalidPayload Packets:" + unKnownPayloadCnt;
        }
        if (ukErrorCnt > 0L) {
            msg = String.valueOf(msg) + " Unknown Errors:" + ukErrorCnt;
        }
        this.log.info(msg);
    }

    private void clearRTPPackets() throws SocketException {
        DatagramPacket dgp = new DatagramPacket(new byte[1], 1);
        this.rtp_socket.setSoTimeout(5);
        int ioErrCnt = 0;
        while (true) {
            try {
                while (true) {
                    this.rtp_socket.receive(dgp);
                }
            }
            catch (SocketTimeoutException ce) {
            }
            catch (IOException ce) {
                if (++ioErrCnt <= 100) continue;
                this.log.warn("??? IO Errors during clearRTPPackets.");
            }
            break;
        }
        this.rtp_socket.setSoTimeout(100);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum enumRX {
        SUCCESS,
        IOERROR,
        TIMEOUT,
        FAIL;

    }
}

