/*
 * Decompiled with CFR 0.152.
 */
package local.ua;

import java.io.File;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Vector;
import java.util.concurrent.locks.LockSupport;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import local.ua.PipedInputStreamPCM;
import local.ua.RtpPacket;
import local.ua.SkypeAudioReceiverServer;
import local.ua.SkypeUserAgent;
import local.ua.sscodecs.FIRFilter;
import local.ua.sscodecs.FilterInterface;
import local.ua.sscodecs.FilterLowPassRc;
import local.ua.sscodecs.SSCodec;
import local.ua.sscodecs.SSCodecFactory;
import local.ua.sscodecs.SSCodecInfo;
import org.apache.log4j.Logger;

public class SkypeRtpSender
extends Thread {
    private static final long nanosPerMs = 1000000L;
    private boolean skypeConnected = false;
    private boolean stopnow = false;
    private Logger log = null;
    private Vector<String> sipClipQueue = new Vector();
    private AudioInputStream sipClipStream = null;
    private Vector<String> dtmfSipQueue = new Vector();
    private SkypeUserAgent ua = null;
    private DatagramSocket rtp_socket = null;
    private int frame_size = -1;
    private long frame_time = -1L;
    private long frame_time_nanos = -1L;
    private SSCodec ssCodec = null;
    private SSCodec ssClipCodec = null;
    private int codec_payload_type = -1;
    private byte[] codecBuf = new byte[512];
    private RtpPacket rtp_packet = new RtpPacket(this.codecBuf, 0);
    private byte[] blankbuf = new byte[512];
    private RtpPacket blankpacket = new RtpPacket(this.blankbuf, 0);
    private byte[] dtmfbuf = new byte[512];
    private RtpPacket dtmfpacket = new RtpPacket(this.dtmfbuf, 0);
    private int startPayloadPos = -1;
    private DatagramPacket sendDatagram = null;
    private int packetInteval = -1;
    private int packetCounter = 0;
    private Object redirectLock = new Object();
    private static final int pcmBytesPerMs = 32;
    private int dest_port = -1;
    private InetAddress dest_addr = null;
    private SkypeAudioReceiverServer skypeReceiver = null;
    private static final int PIPEBUFFER_SIZE = 65536;
    private static final int maxBehindBytes = 60536;
    private PipedInputStreamPCM skypeStream = null;
    private boolean skypeSentData = false;
    private boolean startMediaCalled = false;
    private long jittTargetNanos = 100000000L;
    private long jittMaxBehindNanos = 180000000L;
    private static long abs_maxdelay_nanos = 0L;
    private static long abs_mindelay_nanos = 0L;
    private static int pcmBytesPerRtpPacket = 0;
    private FilterInterface filter = null;
    private boolean useFilter = false;
    private long rtpDelay_frame_time_passed = 0L;
    private long rtpDelay_frame_starttime = System.nanoTime();
    private boolean resetRtpDelay = true;

    public SkypeRtpSender(SkypeUserAgent argUa) throws Exception {
        this.setName(String.valueOf(this.getClass().getName()) + ".T" + this.getName().replaceAll("Thread-", ""));
        this.log = Logger.getLogger(this.getName());
        this.ua = argUa;
        if (this.ua.skype_profile.jitterLevel == 1) {
            this.jittTargetNanos = 50000000L;
            this.jittMaxBehindNanos = 100000000L;
        } else if (this.ua.skype_profile.jitterLevel == 2) {
            this.jittTargetNanos = 75000000L;
            this.jittMaxBehindNanos = 150000000L;
        } else if (this.ua.skype_profile.jitterLevel == 3) {
            this.jittTargetNanos = 90000000L;
            this.jittMaxBehindNanos = 180000000L;
        } else if (this.ua.skype_profile.jitterLevel == 4) {
            this.jittTargetNanos = 110000000L;
            this.jittMaxBehindNanos = 220000000L;
        } else {
            this.jittTargetNanos = 140000000L;
            this.jittMaxBehindNanos = 280000000L;
        }
    }

    public void queueSipDtmfDigits(String argDigits) {
        int d = 0;
        while (d < argDigits.length()) {
            this.dtmfSipQueue.add(argDigits.substring(d, d + 1));
            ++d;
        }
    }

    public void queueSipClip(String argClipFile) {
        this.log.debug("Play Clip:" + argClipFile);
        this.sipClipQueue.add(argClipFile);
    }

    public boolean areClipsComplete() {
        return this.sipClipQueue.size() == 0 && this.sipClipStream == null;
    }

    private void stopSipClips() {
        this.sipClipQueue.removeAllElements();
        if (this.sipClipStream != null) {
            try {
                this.sipClipStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.sipClipStream = null;
        }
        this.ssClipCodec = null;
    }

    public void initRtp(SSCodec argCodec, DatagramSocket src_socket, String dest_addr, int arg_dest_port) throws Exception {
        this.initCodec(argCodec);
        this.dest_port = arg_dest_port;
        this.dest_addr = InetAddress.getByName(dest_addr);
        this.rtp_socket = src_socket;
    }

    public void initCodec(SSCodec argCodec) {
        this.ssCodec = argCodec;
        this.frame_size = this.ssCodec.getFrameSize();
        int frame_rate = this.ssCodec.getSampleRate() / this.frame_size;
        long byte_rate = frame_rate * this.frame_size;
        this.frame_time = (long)(this.frame_size * 1000) / byte_rate;
        this.frame_time_nanos = this.frame_time * 1000000L;
        pcmBytesPerRtpPacket = this.ssCodec.getPcmFrameSize();
        this.codec_payload_type = this.ssCodec.getPayloadType();
        this.rtp_packet.setPayloadType(this.codec_payload_type);
        this.startPayloadPos = this.rtp_packet.getHeaderLength();
        this.blankpacket.setPayloadType(this.codec_payload_type);
        this.blankpacket.setPayloadLength(this.ssCodec.getCodecBlankPacket(this.blankbuf, this.startPayloadPos));
        this.blankpacket.setSscr(this.rtp_packet.getSscr());
        this.dtmfpacket.setPayloadType(this.ua.dtmf2833PayloadType_session);
        this.dtmfpacket.setSscr(this.rtp_packet.getSscr());
        this.dtmfpacket.setPayloadLength(4);
        this.packetInteval = this.frame_size;
        abs_maxdelay_nanos = (this.frame_time + 40L) * 1000000L;
        this.filter = FilterType.valueOf(this.ua.skype_profile.filterParams[0].toUpperCase()) == FilterType.RC ? new FilterLowPassRc(Float.parseFloat(this.ua.skype_profile.filterParams[1]), Float.parseFloat(this.ua.skype_profile.filterParams[2]), pcmBytesPerRtpPacket) : (FilterType.valueOf(this.ua.skype_profile.filterParams[0].toUpperCase()) == FilterType.FIR ? new FIRFilter(Integer.parseInt(this.ua.skype_profile.filterParams[1]), FIRFilter.WINDOW.valueOf(this.ua.skype_profile.filterParams[2].toUpperCase()), FIRFilter.FILTTYPE.valueOf(this.ua.skype_profile.filterParams[3].toUpperCase()), Float.parseFloat(this.ua.skype_profile.filterParams[4]), Float.parseFloat(this.ua.skype_profile.filterParams[5]), 16000, pcmBytesPerRtpPacket) : null);
        this.useFilter = this.filter != null;
    }

    public synchronized void skypeSentData() {
        this.skypeSentData = true;
        this.notify();
    }

    public boolean redirectRTP(InetAddress arg_dest_addr, int arg_dest_port) {
        if (!this.dest_addr.equals(arg_dest_addr) || arg_dest_port != this.dest_port) {
            return this.redirectRTP(arg_dest_addr.getHostAddress(), arg_dest_port);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean redirectRTP(String arg_dest_addr, int arg_dest_port) {
        if (this.rtp_socket == null) {
            return false;
        }
        try {
            Object object = this.redirectLock;
            synchronized (object) {
                if (!this.dest_addr.getHostAddress().toString().equals(arg_dest_addr) || arg_dest_port != this.dest_port) {
                    this.log.info("updating RTP media destination to:" + arg_dest_addr + ":" + arg_dest_port + " from:" + this.dest_addr.getHostAddress() + ":" + this.dest_port);
                    this.dest_port = arg_dest_port;
                    this.dest_addr = InetAddress.getByName(arg_dest_addr);
                }
                this.clearSkypeAudio();
            }
            return true;
        }
        catch (Exception e) {
            this.log.error("redirectRTP:", e);
            return false;
        }
    }

    private void doRtpDelay() {
        long slpTime;
        long curNanoTime = System.nanoTime();
        if (this.resetRtpDelay) {
            this.resetRtpDelay = false;
            this.rtpDelay_frame_time_passed = 0L;
            this.rtpDelay_frame_starttime = curNanoTime;
        }
        if ((slpTime = this.frame_time_nanos - (curNanoTime - this.rtpDelay_frame_starttime - this.rtpDelay_frame_time_passed)) > this.frame_time_nanos) {
            LockSupport.parkNanos(this.frame_time_nanos);
        } else if (slpTime > 0L) {
            LockSupport.parkNanos(slpTime);
        } else if (slpTime < -this.frame_time_nanos && this.packetCounter > 5) {
            this.resetRtpDelay = true;
        }
        this.rtpDelay_frame_time_passed += this.frame_time_nanos;
    }

    public void startSkypeMedia() throws Exception {
        this.stopSipClips();
        this.skypeConnected = true;
        this.resetRtpDelay = true;
    }

    public synchronized void startMedia() {
        this.startMediaCalled = true;
        this.notify();
    }

    public void stopMedia() {
        this.skypeReceiver.stopMedia();
        this.stopnow = true;
        this.skypeConnected = false;
    }

    void halt() {
        this.interrupt();
    }

    public void interrupt() {
        this.stopnow = true;
        super.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.skypeReceiver = new SkypeAudioReceiverServer(this.ua);
            this.skypeReceiver.start();
            this.skypeStream = new PipedInputStreamPCM(this.skypeReceiver.getPipedOutputStream(), 65536);
            while (true) {
                SkypeRtpSender skypeRtpSender = this;
                synchronized (skypeRtpSender) {
                    while (!this.startMediaCalled) {
                        this.wait();
                    }
                }
                this.startMediaCalled = false;
                this.rtpSender();
            }
        }
        catch (InterruptedException ie) {
            this.log.debug("interrupted");
            this.skypeReceiver.halt();
        }
        catch (Exception e) {
            this.log.error("error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rtpSender() {
        int maxLatency;
        this.sendDatagram = new DatagramPacket(new byte[1], 0, 0, null, 0);
        if (this.ua.skype_profile.audioPriorityIncrease > 0) {
            try {
                this.setPriority(5 + this.ua.skype_profile.audioPriorityIncrease);
            }
            catch (Exception e) {
                this.log.warn("setPriority Error. ", e);
            }
        }
        this.stopnow = false;
        long time = 0L;
        byte[] inpcm = new byte[2048];
        this.log.debug("+++ sipAudioSender Connected - skypeframesize:" + pcmBytesPerRtpPacket + " framesize:" + this.frame_size + " frame_time:" + this.frame_time);
        this.log.info("RTP media target: " + this.dest_addr.getHostAddress() + ":" + this.dest_port);
        int availBytes = 0;
        long choppedCnt = 0L;
        long underRuns = 0L;
        int bufferCeiling = 0;
        long pcmPacketCounter = 0L;
        this.resetRtpDelay = true;
        long pcmBytesReceived = 0L;
        long pcmBytesSent = 0L;
        double jitDiffPcktCnt = 0.0;
        long jitMkupNanos = 0L;
        long jitTimeAdj = 0L;
        long jitRtpDelay = 0L;
        int dataMissed = 0;
        try {
            this.skypeStream.clearBuffer();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.skypeReceiver.setSipSending(true, pcmBytesPerRtpPacket);
        block31: while (!this.stopnow) {
            if (this.dtmfSipQueue.size() > 0) {
                char digit = this.getNextDtmfDigit();
                this.log.debug("Sending digit:" + digit);
                if (this.ua.user_profile.dtmfINFOType.length() > 0) {
                    String msg = null;
                    msg = this.ua.user_profile.dtmfINFOType.contains("-relay") ? "Signal=" + digit + "\r\nDuration=100\r\n" : String.valueOf(digit) + "\r\n";
                    this.ua.call.sendInfoMsg(msg, this.ua.user_profile.dtmfINFOType);
                }
                if (this.ua.user_profile.dtmf2833PayloadType > 0) {
                    this.dtmfbuf[this.startPayloadPos] = digit == '*' ? 10 : (digit == '#' ? 11 : (digit >= 'A' && digit <= 'D' ? (byte)(digit - 53) : (byte)(digit - 48)));
                    this.resetRtpDelay = true;
                    this.dtmfbuf[this.startPayloadPos + 1] = 0;
                    this.dtmfpacket.setDuration(0);
                    this.dtmfpacket.setSequenceNumber(this.packetCounter);
                    this.dtmfpacket.setTimestamp(time);
                    this.dtmfpacket.setMarker(true);
                    this.doRtpDelay();
                    int r = 0;
                    while (r < 3) {
                        this.send(this.dtmfpacket);
                        ++r;
                    }
                    this.blankpacket.setSequenceNumber(this.packetCounter);
                    this.blankpacket.setTimestamp(time);
                    this.send(this.blankpacket);
                    ++this.packetCounter;
                    time += (long)this.packetInteval;
                    this.dtmfpacket.setMarker(false);
                    r = 1;
                    while (r < 4) {
                        this.dtmfpacket.setDuration(this.packetInteval * r);
                        this.dtmfpacket.setSequenceNumber(this.packetCounter);
                        this.doRtpDelay();
                        this.send(this.dtmfpacket);
                        this.blankpacket.setSequenceNumber(this.packetCounter);
                        this.blankpacket.setTimestamp(time);
                        this.send(this.blankpacket);
                        ++this.packetCounter;
                        time += (long)this.packetInteval;
                        ++r;
                    }
                    this.dtmfbuf[this.startPayloadPos + 1] = -128;
                    this.dtmfpacket.setDuration(this.packetInteval * 4);
                    this.dtmfpacket.setSequenceNumber(this.packetCounter);
                    this.doRtpDelay();
                    r = 0;
                    while (r < 3) {
                        this.send(this.dtmfpacket);
                        ++r;
                    }
                    this.blankpacket.setSequenceNumber(this.packetCounter);
                    this.blankpacket.setTimestamp(time);
                    this.send(this.blankpacket);
                    ++this.packetCounter;
                    time += (long)this.packetInteval;
                }
                int r = 0;
                while ((long)r < 250L / this.frame_time) {
                    this.blankpacket.setSequenceNumber(this.packetCounter++);
                    this.blankpacket.setTimestamp(time += (long)this.packetInteval);
                    this.doRtpDelay();
                    this.send(this.blankpacket);
                    ++r;
                }
                this.clearSkypeAudio();
                continue;
            }
            if (this.sipClipStream != null) {
                int clipRead = -1;
                try {
                    clipRead = this.sipClipStream.read(inpcm, 0, pcmBytesPerRtpPacket);
                }
                catch (Exception e) {
                    this.log.error("error", e);
                }
                if (clipRead >= pcmBytesPerRtpPacket) {
                    if (this.useFilter) {
                        this.filter.filter(inpcm);
                    }
                    this.rtp_packet.packet_len = this.startPayloadPos + this.ssClipCodec.PcmToCodec(inpcm, pcmBytesPerRtpPacket, this.codecBuf, this.startPayloadPos);
                    this.rtp_packet.setSequenceNumber(this.packetCounter++);
                    this.rtp_packet.setTimestamp(time += (long)this.packetInteval);
                    this.doRtpDelay();
                    this.send(this.rtp_packet);
                    continue;
                }
                if (clipRead > 0) {
                    this.blankpacket.setSequenceNumber(this.packetCounter++);
                    this.blankpacket.setTimestamp(time += (long)this.packetInteval);
                    this.doRtpDelay();
                    this.send(this.blankpacket);
                    continue;
                }
                if (clipRead != -1) continue;
                this.log.debug("--- clip Closed");
                try {
                    this.sipClipStream.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.sipClipStream = null;
                if (this.sipClipQueue.size() != 0 || !this.skypeConnected) continue;
                this.clearSkypeAudio();
                continue;
            }
            if (this.sipClipQueue.size() > 0) {
                this.sipClipStream = this.getNextClipStream();
                this.resetRtpDelay = true;
                continue;
            }
            if (this.skypeConnected) {
                if (this.ua.skype_profile.jitterLevel == 0) {
                    SkypeRtpSender clipRead = this;
                    synchronized (clipRead) {
                        try {
                            if (!this.skypeSentData) {
                                this.wait(100L);
                            }
                            this.skypeSentData = false;
                        }
                        catch (InterruptedException e) {
                            this.log.error("Interrupted", e);
                        }
                    }
                }
                try {
                    availBytes = this.skypeStream.available();
                }
                catch (IOException e) {
                    this.log.error("pipe ioerror", e);
                }
                if (availBytes >= pcmBytesPerRtpPacket) {
                    dataMissed = 0;
                    if (availBytes > bufferCeiling) {
                        bufferCeiling = availBytes;
                    }
                    if (availBytes >= 60536) {
                        try {
                            this.skypeStream.chopBuffer(54482);
                            availBytes = this.skypeStream.available();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        ++choppedCnt;
                    }
                    if (availBytes > bufferCeiling) {
                        bufferCeiling = availBytes;
                    }
                    if (availBytes >= 60536) {
                        try {
                            this.skypeStream.chopBuffer(54482);
                            availBytes = this.skypeStream.available();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        ++choppedCnt;
                    }
                    if (this.ua.skype_profile.jitterLevel > 0) {
                        long jitTotalTimeDiffNanos = (long)(availBytes / 32) * 1000000L;
                        if (jitTotalTimeDiffNanos > this.jittMaxBehindNanos) {
                            jitRtpDelay = abs_mindelay_nanos;
                        } else if (jitTotalTimeDiffNanos <= this.jittTargetNanos) {
                            jitMkupNanos = this.jittTargetNanos - jitTotalTimeDiffNanos;
                            jitDiffPcktCnt = (double)availBytes / (double)pcmBytesPerRtpPacket + 1.0;
                            jitTimeAdj = (long)((double)jitMkupNanos / jitDiffPcktCnt);
                            jitRtpDelay = this.frame_time_nanos - jitTimeAdj;
                            if (jitRtpDelay > abs_maxdelay_nanos) {
                                jitRtpDelay = abs_maxdelay_nanos;
                            }
                        } else {
                            jitMkupNanos = jitTotalTimeDiffNanos - this.jittTargetNanos;
                            jitDiffPcktCnt = (double)availBytes / (double)pcmBytesPerRtpPacket - 1.0;
                            jitTimeAdj = (long)((double)jitMkupNanos / jitDiffPcktCnt);
                            jitRtpDelay = this.frame_time_nanos - jitTimeAdj;
                            if (jitRtpDelay < abs_mindelay_nanos) {
                                jitRtpDelay = abs_mindelay_nanos;
                            }
                        }
                    }
                    if (jitRtpDelay >= 0L) {
                        do {
                            pcmBytesReceived += (long)availBytes;
                            ++pcmPacketCounter;
                            try {
                                this.skypeStream.read(inpcm, 0, pcmBytesPerRtpPacket);
                            }
                            catch (IOException e) {
                                this.log.fatal(e);
                                this.stopnow = true;
                                continue block31;
                            }
                            if (this.useFilter) {
                                this.filter.filter(inpcm);
                            }
                            this.rtp_packet.packet_len = this.startPayloadPos + this.ssCodec.PcmToCodec(inpcm, pcmBytesPerRtpPacket, this.codecBuf, this.startPayloadPos);
                            this.rtp_packet.setSequenceNumber(this.packetCounter++);
                            this.rtp_packet.setTimestamp(time += (long)this.packetInteval);
                            if (jitRtpDelay > 0L) {
                                try {
                                    SkypeRtpSender.sleep(jitRtpDelay / 1000000L);
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                            }
                            this.send(this.rtp_packet);
                            pcmBytesSent += (long)pcmBytesPerRtpPacket;
                        } while ((availBytes -= pcmBytesPerRtpPacket) >= pcmBytesPerRtpPacket && (this.ua.skype_profile.jitterLevel == 0 || jitRtpDelay == 0L));
                        continue;
                    }
                    try {
                        SkypeRtpSender.sleep(20L);
                    }
                    catch (Exception e) {}
                    continue;
                }
                if (this.ua.skypeHoldingLocal || this.ua.skypeHoldingRemote) {
                    this.blankpacket.setSequenceNumber(this.packetCounter++);
                    this.blankpacket.setTimestamp(time += (long)this.packetInteval);
                    this.doRtpDelay();
                    this.send(this.blankpacket);
                } else if (this.packetCounter > 5) {
                    if (this.ua.skype_profile.jitterLevel > 0) {
                        if (++dataMissed > 2) {
                            ++underRuns;
                            dataMissed = 0;
                        }
                    } else {
                        ++underRuns;
                    }
                }
                if (this.ua.skype_profile.jitterLevel <= 0) continue;
                try {
                    SkypeRtpSender.sleep(20L);
                }
                catch (Exception e) {}
                continue;
            }
            this.blankpacket.setSequenceNumber(this.packetCounter++);
            this.blankpacket.setTimestamp(time += (long)this.packetInteval);
            this.doRtpDelay();
            this.send(this.blankpacket);
        }
        this.stopSipClips();
        this.skypeReceiver.setSipSending(false, pcmBytesPerRtpPacket);
        this.skypeReceiver.stopMedia();
        try {
            this.skypeStream.clearBuffer();
        }
        catch (IOException e) {
            this.log.error("Error", e);
        }
        this.rtp_socket = null;
        this.sendDatagram = null;
        this.filter = null;
        if (this.ua.skype_profile.audioPriorityIncrease > 0) {
            try {
                this.setPriority(5);
            }
            catch (Exception e) {
                this.log.warn("resetPriority Error. ", e);
            }
        }
        if ((maxLatency = bufferCeiling / 32) < 0) {
            maxLatency = 0;
        }
        int avgLatency = 0;
        if (pcmPacketCounter > 0L) {
            avgLatency = (int)(pcmBytesReceived / pcmPacketCounter / 32L);
        }
        String msg = "RTPSender stats - packets:" + this.packetCounter;
        if (choppedCnt > 0L) {
            msg = String.valueOf(msg) + " chopCnt:" + choppedCnt;
        }
        if (underRuns > 0L) {
            msg = String.valueOf(msg) + " underRuns:" + underRuns;
        }
        msg = String.valueOf(msg) + " maxLatency:" + maxLatency + "ms avgLatency:" + avgLatency + "ms";
        this.log.info(msg);
    }

    private AudioInputStream getNextClipStream() {
        AudioInputStream retvar = null;
        while (this.sipClipQueue.size() > 0 && retvar == null) {
            String clipFile = this.sipClipQueue.get(0);
            this.sipClipQueue.remove(0);
            try {
                AudioFormat format = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 16000.0f, 16, 1, 2, 16000.0f, false);
                AudioInputStream srcStream = AudioSystem.getAudioInputStream(new File(clipFile));
                retvar = AudioSystem.getAudioInputStream(format, srcStream);
                this.log.debug("+++ clip " + clipFile + " Opened");
                if (this.ssClipCodec != null) continue;
                SSCodecInfo codecInfo = this.ssCodec.getCodecInfo();
                codecInfo.inGain = 1.0;
                codecInfo.outGain = 1.0;
                this.ssClipCodec = SSCodecFactory.getCodec(codecInfo);
            }
            catch (Exception e) {
                this.log.error("File " + clipFile + " Error - Msg:", e);
                retvar = null;
            }
        }
        return retvar;
    }

    private char getNextDtmfDigit() {
        if (this.dtmfSipQueue.size() > 0) {
            String digit = this.dtmfSipQueue.get(0);
            this.dtmfSipQueue.remove(0);
            return digit.charAt(0);
        }
        return '\u0000';
    }

    private void clearSkypeAudio() {
        try {
            if (this.skypeConnected && this.skypeStream.available() > 0) {
                this.skypeStream.skip(this.skypeStream.available());
            }
        }
        catch (IOException e) {
            this.log.error("Error", e);
        }
    }

    private void send(RtpPacket rPacket) {
        this.sendDatagram.setData(rPacket.packet, 0, rPacket.packet_len);
        this.sendDatagram.setPort(this.dest_port);
        this.sendDatagram.setAddress(this.dest_addr);
        try {
            this.rtp_socket.send(this.sendDatagram);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg != null && msg.indexOf("Socket is closed") >= 0) {
                this.stopnow = true;
            }
            this.log.error("Rtp Send Error", e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum FilterType {
        NONE,
        RC,
        FIR;

    }
}

