/*
 * Decompiled with CFR 0.152.
 */
package local.ua;

import com.skype.Call;
import com.skype.CallListener;
import com.skype.CommandFailedException;
import com.skype.NotAttachedException;
import com.skype.Skype;
import com.skype.SkypeException;
import com.skype.connector.Connector;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Vector;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import local.server.LocationService;
import local.server.SSRegistrar;
import local.server.ServerProfile;
import local.ua.AuthMap;
import local.ua.BasicInstaller;
import local.ua.CallHistoryEntry;
import local.ua.CallHistoryHandler;
import local.ua.ConfigFileInfo;
import local.ua.ConfigWatchTimer;
import local.ua.ConfigWatchTimerInterface;
import local.ua.ConnectorDebugWriter;
import local.ua.ConnectorWatchDogTimer;
import local.ua.ConnectorWatchTimerInterface;
import local.ua.ControllerChannelInterface;
import local.ua.MailerThread;
import local.ua.RegisterAgent;
import local.ua.RegisterAgentListener;
import local.ua.SSCallChannel;
import local.ua.ShutdownTimer;
import local.ua.ShutdownTimerInterface;
import local.ua.SkypeProfile;
import local.ua.UserAgentProfile;
import local.ua.sscodecs.SSCodec;
import local.ua.sscodecs.SSCodecFactory;
import local.ua.test.SkypeConnectorReliabilityTest;
import local.ua.util;
import org.apache.log4j.Logger;
import org.zoolu.sip.address.NameAddress;
import org.zoolu.sip.address.SipURL;
import org.zoolu.sip.dialog.InviteDialog;
import org.zoolu.sip.provider.Identifier;
import org.zoolu.sip.provider.OptionHandler;
import org.zoolu.sip.provider.SipProvider;
import org.zoolu.sip.provider.SipStack;

public class SkypeUA
implements RegisterAgentListener,
CallListener,
ShutdownTimerInterface,
OptionHandler,
ControllerChannelInterface,
ConfigWatchTimerInterface,
ConnectorWatchTimerInterface {
    private Connector _instance = null;
    private static final String stsVersion = "v20090902";
    private Vector<SSCallChannel> callChannels = null;
    private SkypeProfile skype_profile;
    private String skypeUserId = null;
    private RegisterAgent ra;
    private UserAgentProfile user_profile;
    private Logger log = null;
    private CallHistoryHandler callHistoryHandler = null;
    private ShutdownTimer shutdownTimer = null;
    private int shutdownTimerIntervalSeconds = 300;
    private long shutdownTimerFiredCount = 0L;
    private ConfigWatchTimer configWatcher = null;
    private int configWatchTimerIntervalSeconds = 60;
    private long configWatchTimerFiredCount = 0L;
    private Vector<ConfigFileInfo> configFiles = null;
    private AuthMap authMaps = null;
    private SipProvider sip_provider = null;
    private String transferSkypeId = null;
    private String initFile = null;
    private SSRegistrar mjServer = null;
    private ServerProfile server_profile = null;
    private ConnectorWatchDogTimer connectorWatchDog = null;
    private boolean lowBalanceNotificationSent = false;

    public static void main(String[] args) throws Exception {
        String file = "siptosis.cfg";
        if (args.length > 0) {
            file = args[0];
        }
        if (args.length == 0) {
            BasicInstaller installer = new BasicInstaller(SkypeUA.getVMBitSize());
            installer = null;
        }
        try {
            new SkypeUA(file);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(ExitCode.STARTERROR.code());
        }
    }

    public SkypeUA(String file) throws Exception {
        this.initUA(file);
        this.run();
    }

    public void initUA(String file) throws Exception {
        int intMin;
        SecurityManager security;
        this.initFile = file;
        this.sip_provider = new SipProvider(file);
        this.user_profile = new UserAgentProfile(file);
        this.skype_profile = new SkypeProfile(file);
        this.server_profile = new ServerProfile(file);
        if (this.skype_profile.runConnectorReliabilityTest) {
            SkypeConnectorReliabilityTest srt = new SkypeConnectorReliabilityTest();
            System.exit(ExitCode.NORMAL.code);
        }
        this.log = Logger.getLogger(this.getClass().getName());
        int bits = SkypeUA.getVMBitSize();
        this.log.info("Starting SipToSis v20090902");
        this.log.info("os=" + System.getProperty("os.name") + " arch=" + System.getProperty("os.arch") + " ver=" + System.getProperty("os.version"));
        this.log.info("javaVer=" + System.getProperty("java.version") + " - " + System.getProperty("java.vendor") + " (" + bits + " bit)");
        this.log.debug("javaLibPath=" + System.getProperty("java.library.path"));
        this.log.debug("javaClassPath=" + System.getProperty("java.class.path"));
        if (bits == 64 && System.getProperty("os.name").toLowerCase().contains("windows") && (System.getenv("JAVAEXEPATH") == null || System.getenv("JAVAEXEPATH").length() == 0)) {
            this.log.warn("************************************************************");
            this.log.warn("* WARNING: JAVAEXEPATH not set - Recommended for 64 bit VM *");
            this.log.warn("***********************************************************");
        }
        if ((security = System.getSecurityManager()) != null) {
            this.log.warn("#### security manager installed, this will slow down RTP packets");
        }
        this.setupCodecs();
        if (this.skype_profile.connect) {
            this.skypeUserId = this.initSkype();
            if (this.skype_profile.SkypeInboundAllChannelsBusyAction.startsWith("transferto:")) {
                this.transferSkypeId = this.skype_profile.SkypeInboundAllChannelsBusyAction.replaceAll("transferto:", "");
                if (this.transferSkypeId.equalsIgnoreCase(this.skypeUserId)) {
                    this.log.fatal("Configuration error - Skype User ID and transferTo ID are the same");
                    System.exit(ExitCode.CONFIGERROR.code());
                }
            }
        } else {
            this.skypeUserId = "bogus";
            this.log.info("Skype disconnected mode");
        }
        if (this.skypeUserId == null) {
            this.log.info("not connected to skype.");
            return;
        }
        if (this.connectorWatchDog != null) {
            this.connectorWatchDog.stopTimer();
            this.connectorWatchDog = null;
        }
        if (this.shutdownTimer != null) {
            this.shutdownTimer.stopTimer();
            this.shutdownTimer = null;
        }
        if (this.skype_profile.autoShutdownMinutes > 0) {
            intMin = this.shutdownTimerIntervalSeconds / 60;
            this.skype_profile.autoShutdownMinutes = (this.skype_profile.autoShutdownMinutes + intMin - 1) / intMin * intMin;
            this.log.info("Auto Shutdown in " + this.skype_profile.autoShutdownMinutes + " minutes.");
            this.shutdownTimer = new ShutdownTimer(this.shutdownTimerIntervalSeconds, this);
        }
        if (this.configWatcher != null) {
            this.configWatcher.stopTimer();
            this.configWatcher = null;
        }
        if (this.skype_profile.configWatchInterval > 0) {
            this.configFiles = new Vector();
            this.configFiles.add(new ConfigFileInfo(file, true));
            this.configFiles.add(new ConfigFileInfo(this.skype_profile.SipOutDialingRulesFile, false));
            this.configFiles.add(new ConfigFileInfo(this.skype_profile.SipToSkypeAuthFile, false));
            this.configFiles.add(new ConfigFileInfo(this.skype_profile.SkypeOutDialingRulesFile, false));
            this.configFiles.add(new ConfigFileInfo(this.skype_profile.SkypeToSipAuthFile, false));
            intMin = this.configWatchTimerIntervalSeconds / 60;
            this.skype_profile.configWatchInterval = (this.skype_profile.configWatchInterval + intMin - 1) / intMin * intMin;
            this.log.info("configWatchInterval every " + this.skype_profile.configWatchInterval + " minutes.");
            this.configWatcher = new ConfigWatchTimer(this.configWatchTimerIntervalSeconds, this);
        }
        if (this.skype_profile.connectorWatchDogMinutes > 0) {
            this.connectorWatchDog = new ConnectorWatchDogTimer(this.skype_profile.connectorWatchDogMinutes, this);
        }
        this.ra = new RegisterAgent(this.sip_provider, this, this.user_profile);
        int rtpPort = this.user_profile.audio_port;
        int skypePort = this.skype_profile.SkypeAudioPortBase;
        this.log.info("Config - skypeClientSupportsMultiCalls:" + this.skype_profile.skypeClientSupportsMultiCalls + "  concurrentCallLimit:" + this.user_profile.concurrentCallLimit);
        this.log.info("SipToSis contact_url=" + this.ra.contact);
        String dspRealm = this.user_profile.realm;
        if (dspRealm == null) {
            dspRealm = "";
        }
        this.log.info("via_addr=" + this.sip_provider.getViaAddress() + "  realm=" + dspRealm);
        if (this.ra.contact.getAddress().getPort() != this.sip_provider.getPort()) {
            this.log.error("####### Config Error - host_port != contact_url port ########");
            System.exit(ExitCode.CONFIGERROR.code());
        }
        this.log.info("RTP Ports: " + rtpPort + "-" + (rtpPort + this.user_profile.concurrentCallLimit * 2 - 2) + "  Local Skype Ports: " + skypePort + "-" + (skypePort + this.user_profile.concurrentCallLimit * 2 - 1));
        if (this.user_profile.concurrentCallLimit < 1) {
            this.log.error("######### invalid concurrentCallLimit ##############");
        }
        this.initAuthMaps();
        this.callChannels = new Vector();
        if (!this.skype_profile.forceChannelBusy) {
            int c = 0;
            while (c < this.user_profile.concurrentCallLimit) {
                SSCallChannel ssChan = new SSCallChannel(this.sip_provider, this.user_profile, this.skype_profile, rtpPort, skypePort, this, c);
                this.callChannels.add(ssChan);
                skypePort += 2;
                rtpPort += 2;
                ++c;
            }
        } else {
            this.sip_provider.addSipProviderListener(new Identifier("FAKE"), new InviteDialog(null, null));
        }
        this.sip_provider.setOPTIONHandler(this);
        if (this.server_profile.is_registrar) {
            this.mjServer = new SSRegistrar(this.sip_provider, this.server_profile);
        }
        NameAddress tmpfrom = new NameAddress(this.user_profile.from_url);
        if (this.user_profile.do_register && tmpfrom.getAddress().getHost().equals(this.sip_provider.getViaAddress()) && tmpfrom.getAddress().getPort() == this.sip_provider.getPort()) {
            this.log.error("###### INVALID CONFIGURATION - Registering with self. #####");
        }
        String tmpMsg = "MaxCallTime: ";
        tmpMsg = this.skype_profile.maxCallTimeLimitMinutes > 0 ? String.valueOf(tmpMsg) + this.skype_profile.maxCallTimeLimitMinutes : String.valueOf(tmpMsg) + "not limited";
        tmpMsg = String.valueOf(tmpMsg) + " MaxPSTNCallTime: ";
        tmpMsg = this.skype_profile.MaxPstnCallTimeLimitMinutes > 0 ? String.valueOf(tmpMsg) + this.skype_profile.MaxPstnCallTimeLimitMinutes : String.valueOf(tmpMsg) + "not limited";
        this.log.info(tmpMsg);
        String tmpMsg2 = "MaxDailyPSTNUniqueNumberCount: ";
        tmpMsg2 = this.skype_profile.dailyPstnUniqueNumberLimit > 0 ? String.valueOf(tmpMsg2) + this.skype_profile.dailyPstnUniqueNumberLimit : String.valueOf(tmpMsg2) + "not limited";
        tmpMsg2 = String.valueOf(tmpMsg2) + " MaxDailyPSTNMinutes: ";
        tmpMsg2 = this.skype_profile.dailyPstnLimitMinutes > 0 ? String.valueOf(tmpMsg2) + this.skype_profile.dailyPstnLimitMinutes : String.valueOf(tmpMsg2) + "not limited";
        this.log.info(tmpMsg2);
        this.callHistoryHandler = new CallHistoryHandler(this.skypeUserId, this.skype_profile.callLogPath, this.skype_profile.tollFreeNumberPrefixes);
        if (this.skype_profile.loadSkypeClientCallHistory) {
            this.loadSkypeCallHistory();
        }
        this.log.info("PSTN counters reset at: " + this.callHistoryHandler.getResetTime());
        this.showCallHist();
        SipStack.init(file);
        if (this.skype_profile.emailRecipients == null || this.skype_profile.emailRecipients.length() < 1 || this.skype_profile.emailHost == null || this.skype_profile.emailHost.length() < 1 || this.skype_profile.emailWhenBalanceDropsTo < 0.0) {
            this.skype_profile.emailWhenBalanceDropsTo = -1.0;
        } else {
            this.log.info("Low balance notifier active.");
        }
        double curBal = util.getSkypeCreditBalance();
        this.log.info(util.formatSkypeCreditBalance(curBal));
        this.updateSkypeCreditBalance(curBal);
        if (this.skype_profile.emailTest) {
            new MailerThread("Skype Low Balance Alert Test", "It works!", this.skype_profile.emailHost, this.skype_profile.emailPort, this.skype_profile.emailUsername, this.skype_profile.emailPassword, this.skype_profile.emailRecipients, this.skype_profile.emailFrom);
        }
        this.startRA();
    }

    public void register(int expire_time) {
        if (this.ra.isRegistering()) {
            this.ra.halt();
        }
        this.ra.register(expire_time);
    }

    public void loopRegister(int expire_time, int renew_time, long keepalive_time) {
        if (this.ra.isRegistering()) {
            this.ra.halt();
        }
        this.ra.loopRegister(expire_time, renew_time, keepalive_time);
    }

    public void unregister() {
        if (this.ra.isRegistering()) {
            this.ra.halt();
        }
        this.ra.unregister();
    }

    public void unregisterall() {
        if (this.ra.isRegistering()) {
            this.ra.halt();
        }
        this.ra.unregisterall();
    }

    public void run() {
    }

    private void startRA() {
        if (this.user_profile.do_unregister_all) {
            this.log.info("UNREGISTER ALL contact URLs");
            this.unregisterall();
        }
        if (this.user_profile.do_unregister) {
            this.log.info("UNREGISTER the contact URL");
            this.unregister();
        }
        if (this.user_profile.do_register) {
            this.log.info("REGISTRATION");
            this.loopRegister(this.user_profile.expires, this.user_profile.expires / 2, this.user_profile.keepalive_time);
        }
    }

    public void exit() {
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.exit(ExitCode.NORMAL.code());
    }

    public void onUaRegistrationSuccess(RegisterAgent ra, NameAddress target, NameAddress contact, String result) {
        this.log.info("Registration success: " + result);
    }

    public void onUaRegistrationFailure(RegisterAgent ra, NameAddress target, NameAddress contact, String result) {
        this.log.info("Registration failure: " + result);
    }

    private String initSkype() throws Exception {
        String skypeUserId = null;
        if (this.skype_profile.skypeUserId != null) {
            this.log.info("Connecting to Skype Client with User: " + this.skype_profile.skypeUserId);
        }
        this.log.info("initSkype - If stuck, check Skype online & API auth");
        this.setupSkype();
        skypeUserId = Skype.getProfile().getId();
        this.log.info("Attached SkypeUserId:" + skypeUserId);
        return skypeUserId;
    }

    private void cleanupUA() {
        if (this.callChannels != null) {
            int c = 0;
            while (c < this.callChannels.size()) {
                SSCallChannel cc = this.callChannels.get(c);
                cc.halt();
                ++c;
            }
            this.callChannels = null;
        }
        if (this.ra != null) {
            this.ra.haltRA();
            this.ra = null;
        }
        if (this.mjServer != null) {
            this.mjServer = null;
        }
        if (this.sip_provider != null) {
            this.sip_provider.halt();
            this.sip_provider = null;
        }
        Skype.removeCallListener(this);
    }

    private void setupSkype() throws SkypeException {
        int retrycnt = 0;
        while (true) {
            try {
                if (this.skype_profile.skypeUserId != null && System.getProperty("os.name").toLowerCase().indexOf("windows") >= 0) {
                    Class<?> connectorClass = Class.forName("com.skype.connector.Connector");
                    Object[] argVals = new Object[]{this.skype_profile.skypeUserId};
                    Class[] argClasses = new Class[]{Class.forName("java.lang.String")};
                    Method getInstance = connectorClass.getMethod("getInstance", argClasses);
                    try {
                        this._instance = (Connector)getInstance.invoke(connectorClass, argVals);
                    }
                    catch (Exception e) {
                        this.log.error("Connector error", e);
                        System.exit(ExitCode.CONFIGERROR.code());
                    }
                }
                if (this.skype_profile.skypeAPITrace) {
                    Connector.getInstance().setDebugOut(new ConnectorDebugWriter());
                    Skype.setDebug(true);
                } else {
                    Skype.setDebug(false);
                }
                Connector.getInstance().setCommandTimeout(10000);
                this.log.info("SkypeVer:" + Skype.getVersion());
                Connector.getInstance().setCommandTimeout(2000);
            }
            catch (NotAttachedException e) {
                if (++retrycnt > 15) {
                    this.log.error("Connect attempt limit reached - exiting.", e);
                    System.exit(ExitCode.STARTERROR.code());
                }
                String sStatus = Connector.getInstance().getStatus().name();
                this.log.info("Skype Status: " + sStatus + " - retrying every 5 seconds");
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception exception) {}
                continue;
            }
            catch (Throwable e) {
                this.testLoadLibrary();
                this.log.fatal("skype4java connect error: ", e);
                System.exit(ExitCode.SKYPE4JAVACONNECTERROR.code());
                continue;
            }
            break;
        }
        Skype.addCallListener(this);
    }

    public void callReceived(Call call) throws SkypeException {
        this.log.info("callReceived - incoming Skype Call from:" + call.getPartnerDisplayName() + " [" + call.getPartnerId() + "] status:" + (Object)((Object)call.getStatus()));
        SSCallChannel callChannel = this.getFreeChannel(true);
        if (callChannel == null) {
            this.log.info("All Channels in Use.");
            if (this.skype_profile.SkypeInboundAllChannelsBusyAction.equals("refuse")) {
                this.log.info("Rejected Skype Call");
                call.cancel();
                return;
            }
            if (this.skype_profile.SkypeInboundAllChannelsBusyAction.equals("voicemail")) {
                this.log.info("Redirecting to VoiceMail");
                call.redirectToVoiceMail();
                return;
            }
            if (this.skype_profile.SkypeInboundAllChannelsBusyAction.startsWith("transferto:")) {
                this.log.info("Redirecting Skype Call to " + this.transferSkypeId);
                call.transferTo(this.transferSkypeId);
                return;
            }
            this.log.info("Skype call ignored.");
            return;
        }
        callChannel.setCurrentSkypeCall(call);
        String sipDest = callChannel.getSipDest();
        if (sipDest == null || sipDest.length() == 0) {
            this.log.info("callReceived - rejected call");
            callChannel.cancelSkypeCall();
            callChannel.unLock();
            return;
        }
        callChannel.skypeCallMaked();
        if (this.isSkypeCallClosed(call.getStatus())) {
            this.log.info("callReceived - call cancelled");
            callChannel.cancelSkypeCall();
            callChannel.unLock();
            return;
        }
        if (sipDest.toLowerCase().indexOf("sip:") >= 0) {
            NameAddress tmpfrom;
            sipDest = this.getSipUserContact(sipDest);
            String skypeid = callChannel.getCurrentSkypeCall().getPartnerId();
            if (this.skype_profile.replaceFromWithSkypeId) {
                SipURL tmpurl = new SipURL(callChannel.ua.user_profile.contact_url);
                tmpfrom = new NameAddress(skypeid, new SipURL(skypeid, tmpurl.getHost(), tmpurl.getPort()));
            } else {
                tmpfrom = new NameAddress(skypeid, new SipURL(callChannel.ua.user_profile.contact_url));
            }
            callChannel.ua.user_profile.from_url = tmpfrom.toString();
            this.log.info("callReceived - Direct Sip Dial to:" + sipDest.replaceAll(";.*", "") + " from:" + callChannel.ua.user_profile.from_url);
            callChannel.call(sipDest);
        } else {
            this.log.info("callReceived - Command List:" + sipDest);
            if (!callChannel.answerSkypeCall(sipDest)) {
                this.log.error("Skype Answer failed");
                callChannel.listen();
            }
        }
    }

    public void callMaked(Call call) throws SkypeException {
        this.log.debug("callMaked: Skype " + (Object)((Object)call.getStatus()) + " id=" + call.getId());
        int chkCount = 0;
        SSCallChannel callChannel = null;
        while (chkCount++ < 30) {
            callChannel = this.locateSkypeChannel(call);
            if (callChannel != null) break;
            try {
                Thread.sleep(5L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (callChannel == null) {
            block16: {
                boolean cancelUnknown = this.isLastSipCallRecent(5);
                boolean runAway = this.isPossibleRunaway(call.getId());
                if (!cancelUnknown && !runAway) {
                    if (this.skype_profile.JoinManualSkypeOutboundCallToSip) {
                        this.log.error("Manual SIP<-->Skype Link mode 1.");
                        String calledUserId = call.getPartnerId();
                        call.cancel();
                        SSCallChannel sipChan = this.getFreeChannel(true);
                        if (sipChan != null) {
                            sipChan.doSkypeSIPJoin(calledUserId);
                        } else {
                            this.log.error("No SIP channels available.");
                        }
                    } else {
                        this.log.info("Manual Outbound Skype Call.");
                    }
                } else {
                    this.log.error("Could not locate CallChannel for this Skype Call! id=" + call.getId() + " ActiveSkypeCallIds=" + this.getActiveSkypeCallIds());
                    if ((cancelUnknown || runAway) && (call.getType() == Call.Type.OUTGOING_P2P || call.getType() == Call.Type.OUTGOING_PSTN)) {
                        if (!runAway) {
                            this.log.error("Sip call within 5 second window, Forced hangup.");
                        } else {
                            this.log.error("Stopping runaway call.");
                        }
                        try {
                            call.cancel();
                        }
                        catch (CommandFailedException e) {
                            String msg = e.getLocalizedMessage();
                            if (msg == null) {
                                this.log.debug("Cancel skype call error", e);
                            }
                            if (msg.contains("Cannot hangup inactive call")) break block16;
                            this.log.debug("Cancel skype call error", e);
                        }
                    }
                }
            }
            return;
        }
        callChannel.skypeCallMaked();
    }

    public boolean isLastSipCallRecent(int seconds) {
        long curTime = System.currentTimeMillis();
        int c = 0;
        while (c < this.callChannels.size()) {
            SSCallChannel callChannel = this.callChannels.get(c);
            if (Math.abs(curTime - callChannel.getLastSipCallTime()) <= (long)(1000 * seconds)) {
                return true;
            }
            ++c;
        }
        return false;
    }

    public boolean isPossibleRunaway(String skypecallid) {
        int c = 0;
        while (c < this.callChannels.size()) {
            SSCallChannel callChannel = this.callChannels.get(c);
            String lastId = callChannel.getPossibleRunawaySkypeCallid();
            if (lastId != null && skypecallid.equals(lastId)) {
                return true;
            }
            ++c;
        }
        return false;
    }

    public void onShutdownTimerTimeout() {
        ++this.shutdownTimerFiredCount;
        if (this.allIdle() && this.shutdownTimerFiredCount >= (long)(this.skype_profile.autoShutdownMinutes * 60 / this.shutdownTimerIntervalSeconds)) {
            this.shutdownTimer.stopTimer();
            this.log.info("Auto shutting down.");
            this.cleanupUA();
            System.exit(ExitCode.NORMAL.code);
        }
    }

    private synchronized SSCallChannel getFreeChannel(boolean lockChannel) {
        int c = 0;
        while (c < this.callChannels.size()) {
            SSCallChannel callChannel = this.callChannels.get(c);
            if (callChannel.isIdle()) {
                if (lockChannel) {
                    callChannel.lock();
                }
                return callChannel;
            }
            ++c;
        }
        return null;
    }

    private SSCallChannel locateSkypeChannel(Call skypeCall) {
        int c = 0;
        while (c < this.callChannels.size()) {
            SSCallChannel callChannel = this.callChannels.get(c);
            if (callChannel.getCurrentSkypeCall() != null && callChannel.getCurrentSkypeCall().getId() == skypeCall.getId()) {
                return callChannel;
            }
            ++c;
        }
        return null;
    }

    private String getActiveSkypeCallIds() {
        String retvar = "";
        int c = 0;
        while (c < this.callChannels.size()) {
            SSCallChannel callChannel = this.callChannels.get(c);
            if (callChannel.getCurrentSkypeCall() != null) {
                if (retvar.length() > 0) {
                    retvar = String.valueOf(retvar) + ",";
                }
                retvar = String.valueOf(retvar) + callChannel.getCurrentSkypeCall().getId();
            }
            ++c;
        }
        return retvar;
    }

    public String onOptionMsgReceived() {
        SSCallChannel callChannel = this.getFreeChannel(false);
        if (callChannel != null) {
            return callChannel.ua.getCapabilities();
        }
        return null;
    }

    public void holdOtherSkypeCalls(Call excludedSkypeCall) throws Exception {
        int c = 0;
        while (c < this.callChannels.size()) {
            SSCallChannel callChannel = this.callChannels.get(c);
            if (!(callChannel.isIdle() || callChannel.getCurrentSkypeCall() == null || excludedSkypeCall != null && callChannel.getCurrentSkypeCall() == excludedSkypeCall)) {
                try {
                    callChannel.holdSkypeCall();
                }
                catch (Exception e) {
                    this.log.error("Skype Hold Failed! ", e);
                    throw new Exception(e);
                }
            }
            ++c;
        }
        int timerCnt = 0;
        int cntLimit = 10;
        while (timerCnt < cntLimit) {
            Thread.sleep(1000L);
            if (!this.allSkypeCallsHolding(excludedSkypeCall)) continue;
            return;
        }
        throw new TimeoutException("Hold Failed.");
    }

    private boolean allSkypeCallsHolding(Call excludedSkypeCall) {
        int c = 0;
        while (c < this.callChannels.size()) {
            SSCallChannel callChannel = this.callChannels.get(c);
            if (!(callChannel.isIdle() || callChannel.getCurrentSkypeCall() == null || excludedSkypeCall != null && callChannel.getCurrentSkypeCall() == excludedSkypeCall || callChannel.ua.skypeHoldingLocal)) {
                return false;
            }
            ++c;
        }
        return true;
    }

    private void testLoadLibrary() {
        String libName = "skype";
        this.log.info("###testLoadLibrary###");
        this.log.info("javaLibPath:" + System.getProperty("java.library.path"));
        this.log.info("libName=" + libName + " platform libname=" + System.mapLibraryName(libName));
        try {
            System.loadLibrary(libName);
            this.log.info("Load library worked??? Why are we here then?");
        }
        catch (UnsatisfiedLinkError err) {
            this.log.error("Load Library failed", err);
        }
        catch (Throwable e) {
            this.log.error("Load Library failed", e);
        }
    }

    private void setupCodecs() {
        if (this.user_profile.audio_frame_size.length != this.user_profile.audio_codec.length) {
            this.log.fatal("Codec Configuration Incorrect (You must specify audio_frame_size for each codec.");
            System.exit(ExitCode.CONFIGERROR.code());
        }
        boolean userDefinedTypes = false;
        if (this.user_profile.audio_avp.length > 0) {
            userDefinedTypes = true;
        }
        SSCodecFactory.init();
        Vector<String> codecsOK = new Vector<String>();
        Vector<Integer> codecsRates = new Vector<Integer>();
        Vector<Integer> codecsPayTypes = new Vector<Integer>();
        Vector<Integer> codecsFrameRates = new Vector<Integer>();
        Vector<Double> codecsAudionInGains = new Vector<Double>();
        Vector<Double> codecsAudionOutGains = new Vector<Double>();
        int cc = 0;
        while (cc < this.user_profile.audio_codec.length) {
            SSCodec sscodec;
            double inGain = this.skype_profile.SkypeAudioInGain[0];
            if (cc < this.skype_profile.SkypeAudioInGain.length) {
                inGain = this.skype_profile.SkypeAudioInGain[cc];
            }
            double outGain = this.skype_profile.SkypeAudioOutGain[0];
            if (cc < this.skype_profile.SkypeAudioOutGain.length) {
                outGain = this.skype_profile.SkypeAudioOutGain[cc];
            }
            if ((sscodec = SSCodecFactory.configureCodec(this.user_profile.audio_codec[cc], this.user_profile.audio_frame_size[cc], inGain, outGain)) != null) {
                codecsOK.add(sscodec.getCodecName());
                codecsRates.add(sscodec.getSampleRate());
                codecsFrameRates.add(sscodec.getFrameSize());
                int ptype = sscodec.getPayloadType();
                if (userDefinedTypes && this.user_profile.audio_avp[cc] >= 0) {
                    try {
                        SSCodecFactory.modifyCodecMap(ptype, this.user_profile.audio_avp[cc]);
                        ptype = this.user_profile.audio_avp[cc];
                    }
                    catch (Exception e) {
                        this.log.error("Codec: " + this.user_profile.audio_codec[cc] + " error: " + e.getLocalizedMessage());
                        System.exit(ExitCode.INITFAIL.code());
                    }
                }
                if (ptype < 0) {
                    this.log.error("Codec: " + this.user_profile.audio_codec[cc] + " is a dynamic payload type - you must set the RTP payload type in the config file");
                    System.exit(ExitCode.CONFIGERROR.code());
                }
                codecsPayTypes.add(ptype);
                codecsAudionInGains.add(inGain);
                codecsAudionOutGains.add(outGain);
            } else {
                this.log.error("Codec: " + this.user_profile.audio_codec[cc] + " not loaded.");
            }
            ++cc;
        }
        String codecList = "";
        this.user_profile.audio_codec = new String[codecsOK.size()];
        this.user_profile.audio_sample_rate = new int[codecsRates.size()];
        this.user_profile.audio_avp = new int[codecsPayTypes.size()];
        this.user_profile.audio_frame_size = new int[codecsPayTypes.size()];
        this.skype_profile.SkypeAudioInGain = new double[codecsAudionInGains.size()];
        this.skype_profile.SkypeAudioOutGain = new double[codecsAudionOutGains.size()];
        int cc2 = 0;
        while (cc2 < codecsOK.size()) {
            this.user_profile.audio_codec[cc2] = (String)codecsOK.get(cc2);
            this.user_profile.audio_sample_rate[cc2] = (Integer)codecsRates.get(cc2);
            this.user_profile.audio_avp[cc2] = (Integer)codecsPayTypes.get(cc2);
            this.user_profile.audio_frame_size[cc2] = (Integer)codecsFrameRates.get(cc2);
            this.skype_profile.SkypeAudioInGain[cc2] = (Double)codecsAudionInGains.get(cc2);
            this.skype_profile.SkypeAudioOutGain[cc2] = (Double)codecsAudionOutGains.get(cc2);
            if (codecList.length() > 0) {
                codecList = String.valueOf(codecList) + ",";
            }
            codecList = String.valueOf(codecList) + this.user_profile.audio_codec[cc2];
            if (this.user_profile.audio_sample_rate[cc2] != 8000) {
                codecList = String.valueOf(codecList) + "/" + this.user_profile.audio_sample_rate[cc2] / 1000 + "k";
            }
            codecList = String.valueOf(codecList) + "(" + this.user_profile.audio_avp[cc2] + ")";
            ++cc2;
        }
        if (this.user_profile.audio_codec.length == 0) {
            this.log.fatal("No Codecs available. Exiting.");
            System.exit(ExitCode.CONFIGERROR.code());
        }
        this.log.info("Available Codecs: " + codecList);
        if (this.user_profile.dtmf2833PayloadType >= 0) {
            this.log.info("DTMF rfc2833(" + this.user_profile.dtmf2833PayloadType + ")");
        }
        this.log.debug("Codec Config:\r\n" + SSCodecFactory.getConfiguredCodecs());
    }

    public void onConfigWatcherTimeout() {
        ++this.configWatchTimerFiredCount;
        if (this.configWatchTimerFiredCount >= (long)(this.skype_profile.configWatchInterval * 60 / this.configWatchTimerIntervalSeconds)) {
            boolean secondaryChanged = false;
            boolean primaryChanged = false;
            String priFile = null;
            int x = 0;
            while (x < this.configFiles.size()) {
                ConfigFileInfo cfi = this.configFiles.get(x);
                File tmpFile = new File(cfi.filename);
                if (cfi.lastModified != tmpFile.lastModified()) {
                    this.log.debug("Config File: " + cfi.filename + " changed");
                    if (cfi.primaryFile) {
                        primaryChanged = true;
                        priFile = cfi.filename;
                        break;
                    }
                    secondaryChanged = true;
                    cfi.lastModified = tmpFile.lastModified();
                }
                Thread.yield();
                ++x;
            }
            if (primaryChanged) {
                if (!this.allIdle()) {
                    return;
                }
                this.log.info("Primary Configuration changed - Restarting.");
                try {
                    this.cleanupUA();
                    this.initUA(priFile);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.exit(ExitCode.REINITERROR.code());
                }
            } else if (secondaryChanged) {
                this.log.info("Configuration changed - Reloading maps/rules.");
                this.resetChannelAuthMaps();
            }
            this.configWatchTimerFiredCount = 0L;
        }
    }

    private boolean allIdle() {
        int c = 0;
        while (c < this.callChannels.size()) {
            SSCallChannel callChannel = this.callChannels.get(c);
            if (!callChannel.isIdle()) {
                return false;
            }
            ++c;
        }
        return true;
    }

    private void initAuthMaps() {
        this.authMaps = new AuthMap(this.skype_profile.SipToSkypeAuthFile, this.skype_profile.SkypeToSipAuthFile, this.skype_profile.SkypeOutDialingRulesFile, this.skype_profile.SipOutDialingRulesFile);
    }

    private void resetChannelAuthMaps() {
        this.initAuthMaps();
    }

    public AuthMap getAuthMap() {
        return this.authMaps;
    }

    /*
     * Unable to fully structure code
     */
    public boolean lostSkypeConnection() {
        this.log.error("Lost Skype client connection - reconnecting.");
        retries = 0;
        while (retries++ < 5) {
            try {
                this.skypeUserId = Skype.getProfile().getId();
                this.log.info("Reconnected to Skype client.");
                return true;
            }
            catch (NotAttachedException e) {
                try {
                    Thread.sleep(3000L);
                }
                catch (Exception var3_4) {}
            }
            ** finally { 
lbl13:
            // 1 sources

        }
        return false;
    }

    public void restart() {
        this.log.error("Performing full restart.");
        try {
            Thread.sleep(2000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.cleanupUA();
            this.initUA(this.initFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(ExitCode.REINITERROR.code());
        }
    }

    public String getSipUserContact(String sipDest) {
        if (this.mjServer == null) {
            return sipDest;
        }
        Pattern sipidPat = Pattern.compile("sip:<?([^@<]+)@", 2);
        Matcher cuidMat = sipidPat.matcher(sipDest);
        String callUID = null;
        if (!cuidMat.find()) {
            return sipDest;
        }
        callUID = cuidMat.group(1);
        LocationService ls = this.mjServer.getLocationService();
        String[] testDomains = this.server_profile.domain_names;
        if (testDomains.length == 0) {
            testDomains = new String[]{new String(this.sip_provider.getViaAddress())};
        }
        int d = 0;
        while (d < testDomains.length) {
            String searchUser = String.valueOf(callUID) + "@" + testDomains[d];
            Enumeration c = ls.getUserContactURLs(searchUser);
            if (c != null) {
                while (c.hasMoreElements()) {
                    String contact = (String)c.nextElement();
                    if (ls.isUserContactExpired(searchUser, contact)) continue;
                    sipDest = contact.replaceAll(";.*", "");
                    this.log.info("Route to registered target:" + sipDest);
                    return sipDest;
                }
            }
            ++d;
        }
        return sipDest;
    }

    public void onConnectorWatcherTimeout() {
        boolean reconnect = false;
        try {
            Skype.getVersion();
        }
        catch (Throwable e) {
            reconnect = true;
            this.log.error("Watcher: Lost Skype client connection - attempting reconnect.");
        }
        if (reconnect) {
            int retries = 0;
            while (retries++ < 3) {
                try {
                    this.skypeUserId = Skype.getProfile().getId();
                    this.log.info("Watcher: Skype client reconnected to: " + this.skypeUserId);
                    return;
                }
                catch (Throwable e) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            this.log.error("Watcher: Reconnect to Skype client failed.");
        }
    }

    public void showCallHist() {
        this.log.info("Qualified PSTN calls today: " + this.callHistoryHandler.getPstnTodayCountQualified() + " Time: " + this.callHistoryHandler.getPstnTodayTimeQualified() + " minutes");
    }

    public CallHistoryHandler getCallHistoryHandler() {
        return this.callHistoryHandler;
    }

    private void loadSkypeCallHistory() {
        this.log.info("Loading Skype PSTN Call History");
        String callsResp = util.parseSkypeResponse("SEARCH CALLS", "CALLS");
        this.log.debug("CallsList:" + callsResp);
        if (callsResp.trim().length() == 0) {
            this.log.info("0 possible calls to import.");
            return;
        }
        String[] calls = callsResp.split(",");
        this.log.info(String.valueOf(calls.length) + " possible calls to import.");
        Calendar cutOffDate = Calendar.getInstance();
        cutOffDate.set(11, 0);
        cutOffDate.set(12, 0);
        cutOffDate.set(13, 0);
        cutOffDate.add(5, -1);
        int impCount = 0;
        int x = 0;
        while (x < calls.length) {
            CallHistoryEntry ce = new CallHistoryEntry();
            String curId = calls[x].trim();
            if (curId.length() > 0) {
                long unixStamp = -1L;
                try {
                    ce.callId = util.parseSkypeResponse("GET CALL " + curId + " TIMESTAMP", "CALL " + curId + " TIMESTAMP").trim();
                    unixStamp = Long.parseLong(ce.callId);
                }
                catch (Exception e) {
                    this.log.error("History Load Error: Skype CallId=" + curId, e);
                }
                if (unixStamp > 0L) {
                    Calendar callStamp = Calendar.getInstance();
                    callStamp.setTimeInMillis(unixStamp * 1000L);
                    ce.startTime = callStamp.getTime();
                    if (!cutOffDate.before(callStamp)) break;
                    ce.callType = Call.Type.valueOf(util.parseSkypeResponse("GET CALL " + curId + " TYPE", "CALL " + curId + " TYPE"));
                    if (ce.callType == Call.Type.OUTGOING_PSTN) {
                        ce.durationSeconds = Long.parseLong(util.parseSkypeResponse("GET CALL " + curId + " DURATION", "CALL " + curId + " DURATION"));
                        ce.callFrom = this.skypeUserId;
                        ce.callTo = util.parseSkypeResponse("GET CALL " + curId + " PARTNER_HANDLE", "CALL " + curId + " PARTNER_HANDLE");
                        ce.callCost = "Imported Call";
                        if (this.callHistoryHandler.addCall(ce)) {
                            ++impCount;
                        }
                    }
                }
            }
            ++x;
        }
        this.log.info(String.valueOf(impCount) + " PSTN calls imported");
    }

    private boolean isSkypeCallClosed(Call.Status status) {
        return status == Call.Status.MISSED || status == Call.Status.CANCELLED || status == Call.Status.FAILED || status == Call.Status.FINISHED || status == Call.Status.BUSY || status == Call.Status.REFUSED || status == Call.Status.UNPLACED;
    }

    private static int getVMBitSize() {
        String dmBits = System.getProperty("sun.arch.data.model", "novalue");
        if (dmBits.equals("32")) {
            return 32;
        }
        if (dmBits.equals("64")) {
            return 64;
        }
        if (dmBits.equals("novalue") && System.getProperty("java.vm.name").indexOf("64") >= 0) {
            return 64;
        }
        return 32;
    }

    public void updateSkypeCreditBalance(double bal) {
        if (this.skype_profile.emailWhenBalanceDropsTo < 0.0) {
            return;
        }
        if (bal > this.skype_profile.emailWhenBalanceDropsTo) {
            if (this.lowBalanceNotificationSent) {
                this.log.info("Low balance condition has been reset.");
                this.lowBalanceNotificationSent = false;
            }
        } else if (!this.lowBalanceNotificationSent) {
            this.log.info("Sending low balance notification.");
            String msg = "Skype Account: \"" + this.skypeUserId + "\" balance is now: " + util.formatAmount(bal, 2);
            new MailerThread("Skype Low Balance Alert", msg, this.skype_profile.emailHost, this.skype_profile.emailPort, this.skype_profile.emailUsername, this.skype_profile.emailPassword, this.skype_profile.emailRecipients, this.skype_profile.emailFrom);
            this.lowBalanceNotificationSent = true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ExitCode {
        NORMAL(0),
        INITFAIL(1),
        FATALERROR(2),
        STARTERROR(9),
        SKYPE4JAVACONNECTERROR(7),
        REINITERROR(11),
        CONFIGERROR(16);

        private final int code;

        private ExitCode(int code) {
            this.code = code;
        }

        public int code() {
            return this.code;
        }
    }
}

