/*
 * Decompiled with CFR 0.152.
 */
package local.ua;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.util.Vector;
import local.ua.JSkypeAudioLauncher;
import local.ua.SkypeProfile;
import local.ua.SkypeRtpReceiver;
import local.ua.SkypeRtpSender;
import local.ua.UserAgent;
import local.ua.UserAgentListener;
import local.ua.UserAgentProfile;
import local.ua.sscodecs.SSCodec;
import local.ua.sscodecs.SSCodecFactory;
import org.apache.log4j.Logger;
import org.zoolu.sdp.AttributeField;
import org.zoolu.sdp.MediaDescriptor;
import org.zoolu.sdp.SessionDescriptor;
import org.zoolu.sip.provider.SipProvider;
import org.zoolu.tools.Parser;

public class SkypeUserAgent
extends UserAgent {
    SkypeRtpReceiver skypeRtpReceiver = null;
    SkypeRtpSender skypeRtpSender = null;
    private String skypeDtmfBuffer = "";
    protected SkypeProfile skype_profile = null;
    protected int skypeInPort;
    protected int skypeOutPort;
    protected boolean skypeHoldingLocal = false;
    protected boolean skypeHoldingRemote = false;
    private SSCodec sscodec = null;
    DatagramSocket rtpSocket = null;

    public SkypeUserAgent(SipProvider sip_provider, UserAgentProfile user_profile, UserAgentListener listener, SkypeProfile skype_profile, int argRtpPort, int argSkypePort, int chanId) throws Exception {
        super(sip_provider, user_profile, listener, argRtpPort);
        this.log = Logger.getLogger(String.valueOf(this.getClass().getName()) + ".#C" + chanId);
        this.skypeInPort = argSkypePort;
        this.skypeOutPort = argSkypePort + 1;
        this.skype_profile = skype_profile;
        if (!this.openRtpSocket()) {
            throw new IOException("RTP Socket create error.");
        }
        this.skypeRtpSender = new SkypeRtpSender(this);
        this.skypeRtpReceiver = new SkypeRtpReceiver(this);
        this.skypeRtpSender.start();
        this.skypeRtpReceiver.start();
        this.clip_on = null;
        this.clip_off = null;
        this.clip_ring = null;
    }

    public void listen() {
        this.skypeHoldingLocal = false;
        this.skypeHoldingRemote = false;
        this.clearSkypeDtmfBuffer();
        super.listen();
    }

    public void stopMedia() {
        this.skypeRtpSender.stopMedia();
        this.skypeRtpReceiver.stopMedia();
    }

    public void startSkypeMedia(boolean sendSkypeOverSipSessionProgress) throws Exception {
        if (!sendSkypeOverSipSessionProgress) {
            this.skypeRtpReceiver.startSkypeMedia();
        }
        this.skypeRtpSender.startSkypeMedia();
        if (sendSkypeOverSipSessionProgress) {
            this.log.info("Sending Skype Early Media to SIP device");
            this.launchMediaApplication();
        }
    }

    public void queueSipClip(String clipFile) {
        this.skypeRtpSender.queueSipClip(clipFile);
    }

    boolean getSipClipQueueComplete() {
        return this.skypeRtpSender.areClipsComplete();
    }

    public void queueSipDtmfDigits(String digits) {
        this.skypeRtpSender.queueSipDtmfDigits(digits);
    }

    public void queueSkypeClip(String clipFile) {
        this.skypeRtpReceiver.skypeSender.queueSkypeClip(clipFile);
    }

    public void clearSkypeDtmfBuffer() {
        this.skypeDtmfBuffer = "";
    }

    public boolean getSkypeClipQueueComplete() {
        return this.skypeRtpReceiver.skypeSender.areClipsComplete();
    }

    public void chopSkypeDtmfBuffer(int bytes) {
        this.skypeDtmfBuffer = bytes < this.skypeDtmfBuffer.length() ? this.skypeDtmfBuffer.substring(bytes) : "";
    }

    public void gotSkypeDtmfDigit(int digit) {
        this.skypeDtmfBuffer = String.valueOf(this.skypeDtmfBuffer) + this.dtmfConvertToString(digit);
        this.listener.onDtmfReceived(this, digit, true);
    }

    public String dtmfConvertToString(int digit) {
        String retvar = "";
        if (digit < 10) {
            retvar = String.valueOf(digit);
        } else if (digit == 10) {
            retvar = "*";
        } else if (digit == 11) {
            retvar = "#";
        } else if (digit > 11 && digit < 16) {
            retvar = String.valueOf((char)(digit + 53));
        }
        return retvar;
    }

    public String getSkypeDtmfBuffer() {
        return this.skypeDtmfBuffer;
    }

    protected void launchMediaApplication() {
        String localDesc = this.call.getLocalSessionDescriptor();
        if (localDesc == null) {
            this.log.debug("Local SIP call cancelled. callUsed=" + this.call.callUsed());
            if (this.call.callUsed()) {
                this.listener.onUaCallFailed(this);
            }
            return;
        }
        SessionDescriptor local_sdp = new SessionDescriptor(localDesc);
        int local_audio_port = 0;
        int local_avp = 0;
        String codecParms = "";
        MediaDescriptor md = local_sdp.getMediaDescriptor("audio");
        if (md != null) {
            local_audio_port = md.getMedia().getPort();
            Vector af = md.getAttributes("rtpmap");
            boolean codecMatched = false;
            int c = 0;
            while (c < af.size()) {
                AttributeField ca = (AttributeField)af.get(c);
                String[] locAttr = ca.getAttributeValues();
                if (locAttr[1].toLowerCase().contains("telephone-event")) {
                    this.dtmf2833PayloadType_session = Integer.parseInt(locAttr[0]);
                } else if (!codecMatched) {
                    codecParms = locAttr[1];
                    local_avp = Integer.parseInt(locAttr[0]);
                    codecMatched = true;
                }
                ++c;
            }
            if (!codecMatched) {
                this.log.error("error matching codec local_sdp:" + local_sdp);
                this.listener.onUaCallFailed(this);
                return;
            }
        } else {
            this.log.error("Error - no audio descriptor in local session??? local_sdp:" + local_sdp);
            this.listener.onUaCallFailed(this);
            return;
        }
        if (this.dtmf2833PayloadType_session == local_avp) {
            this.log.error("Error - rfc2833 type same as codec type - disabling rfc2833 for this session");
            this.dtmf2833PayloadType_session = -1;
        }
        SessionDescriptor remote_sdp = new SessionDescriptor(this.call.getRemoteSessionDescriptor());
        String remote_media_address = new Parser(remote_sdp.getConnection().toString()).skipString().skipString().getString();
        int remote_audio_port = 0;
        MediaDescriptor remmd = remote_sdp.getMediaDescriptor("audio");
        if (remmd != null) {
            remote_audio_port = remmd.getMedia().getPort();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("launchMediaApplication\r\nremote media IP:" + remote_media_address + "\r\nlocalSdp:" + local_sdp.toString() + "\r\n\r\nremoteSdp:" + remote_sdp.toString());
            this.log.debug("RTP audio ports: local_audio_port=" + local_audio_port + " remote_audio_port=" + remote_audio_port);
        }
        int dir = 0;
        if (this.user_profile.recv_only) {
            dir = -1;
        } else if (this.user_profile.send_only) {
            dir = 1;
        }
        if (this.audio_app != null || this.video_app != null) {
            if (dir >= 0 && this.audio_app != null && !remote_media_address.equals("0.0.0.0")) {
                this.skypeRtpSender.redirectRTP(remote_media_address, remote_audio_port);
                this.skypeRtpReceiver.resetRTPAllowRedirect();
            } else {
                this.log.debug("media application is already running");
            }
            if (!this.sscodec.getCodecName().equals(codecParms.split("/")[0])) {
                String dmsg = "Switching codec to: " + codecParms + "(" + local_avp + ")";
                if (this.dtmf2833PayloadType_session >= 0) {
                    dmsg = String.valueOf(dmsg) + " rfc2833Type(" + this.dtmf2833PayloadType_session + ")";
                }
                this.log.info(dmsg);
                SSCodec newCodec = null;
                try {
                    newCodec = local_avp < 96 || local_avp > 127 ? SSCodecFactory.getCodecByNumber(local_avp) : SSCodecFactory.getDynamicCodec(local_avp, codecParms);
                }
                catch (Exception e) {
                    this.log.fatal("Failed to load codec.", e);
                    this.listener.onUaCallFailed(this);
                    return;
                }
                if (newCodec == null) {
                    this.log.fatal("Failed to load codec. (null)");
                    this.listener.onUaCallFailed(this);
                    return;
                }
                this.sscodec = newCodec;
                this.skypeRtpSender.initCodec(this.sscodec);
                this.skypeRtpReceiver.initCodec(this.sscodec);
            }
            return;
        }
        if (this.user_profile.audio) {
            if (local_audio_port != 0 && remote_audio_port != 0) {
                String dmsg = "Starting codec: " + codecParms + "(" + local_avp + ")";
                if (this.dtmf2833PayloadType_session >= 0) {
                    dmsg = String.valueOf(dmsg) + " rfc2833Type(" + this.dtmf2833PayloadType_session + ")";
                }
                this.log.info(dmsg);
                try {
                    this.sscodec = local_avp < 96 || local_avp > 127 ? SSCodecFactory.getCodecByNumber(local_avp) : SSCodecFactory.getDynamicCodec(local_avp, codecParms);
                }
                catch (Exception e) {
                    this.log.fatal("Failed to load codec.", e);
                    this.listener.onUaCallFailed(this);
                    return;
                }
                this.audio_app = new JSkypeAudioLauncher(this.rtpSocket, this.sscodec, remote_media_address, remote_audio_port, dir, this.skypeRtpReceiver, this.skypeRtpSender);
                this.audio_app.startMedia();
            } else {
                this.log.error("AudioPorts not found in descriptors??? local:" + local_audio_port + " remote:" + remote_audio_port);
                this.listener.onUaCallFailed(this);
            }
        }
    }

    protected synchronized void closeMediaApplication() {
        super.closeMediaApplication();
        this.sscodec = null;
        this.openRtpSocket();
    }

    private void closeRtpSocket() {
        if (this.rtpSocket != null) {
            try {
                this.rtpSocket.disconnect();
                this.rtpSocket.close();
            }
            catch (Exception e) {
                this.log.error("error disconnecting rtp socket", e);
            }
        }
        this.rtpSocket = null;
    }

    private synchronized boolean openRtpSocket() {
        boolean retvar = false;
        this.closeRtpSocket();
        try {
            this.rtpSocket = this.sip_provider.getInterfaceAddress() == null ? new DatagramSocket(this.rtpPort) : new DatagramSocket(this.rtpPort, this.sip_provider.getInterfaceAddress().getInetAddress());
            retvar = true;
        }
        catch (Exception e) {
            this.log.fatal("error creating rtp socket", e);
        }
        try {
            this.rtpSocket.setTrafficClass(24);
        }
        catch (Exception e) {
            this.log.debug("setTrafficClass failed.", e);
        }
        if (this.skype_profile.RtpRxBufferSize > 0) {
            try {
                this.rtpSocket.setReceiveBufferSize(this.skype_profile.RtpRxBufferSize);
                int tstRx = this.rtpSocket.getReceiveBufferSize();
                if (tstRx != this.skype_profile.RtpRxBufferSize) {
                    this.log.warn("error setting RtpReceiveBufferSize");
                }
            }
            catch (SocketException e) {
                this.log.warn("error setting RtpReceiveBufferSize", e);
            }
        }
        if (this.skype_profile.RtpTxBufferSize > 0) {
            try {
                this.rtpSocket.setSendBufferSize(this.skype_profile.RtpTxBufferSize);
                int tstTx = this.rtpSocket.getSendBufferSize();
                if (tstTx != this.skype_profile.RtpTxBufferSize) {
                    this.log.warn("error setting RTPSendBufferSize");
                }
            }
            catch (SocketException e) {
                this.log.warn("error setting RTPSendBufferSize", e);
            }
        }
        return retvar;
    }

    void halt() {
        this.stopMedia();
        this.skypeRtpSender.halt();
        this.skypeRtpReceiver.halt();
        this.closeRtpSocket();
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

