/*
 * Decompiled with CFR 0.152.
 */
package local.ua;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.RandomAccessFile;
import local.ua.sscodecs.SSCodecFactory;

public class UlawWriter {
    private BufferedOutputStream writer;
    private int bytesWritten = 0;
    private String fileName = null;

    public UlawWriter(String fileName) {
        this.fileName = fileName;
        try {
            this.writer = new BufferedOutputStream(new FileOutputStream(fileName), 8192);
        }
        catch (Exception e) {
            System.err.println(e.getLocalizedMessage());
        }
        byte[] auHeader = new byte[]{46, 115, 110, 100, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63};
        this.write(auHeader, 0, auHeader.length);
        this.bytesWritten = 0;
    }

    public void write(byte[] data, int offset, int len) {
        try {
            this.writer.write(data, offset, len);
            this.bytesWritten += len;
        }
        catch (Exception e) {
            System.err.println(e.getLocalizedMessage());
        }
    }

    public void writeValues(byte[] data, int offset, int len) {
        StringBuffer tmp = new StringBuffer();
        int x = offset;
        while (x < offset + len) {
            tmp.append(" " + Byte.toString(data[x]));
            ++x;
        }
        tmp.append("\n");
        try {
            this.writer.write(tmp.toString().getBytes());
            this.bytesWritten += len;
        }
        catch (Exception e) {
            System.err.println(e.getLocalizedMessage());
        }
    }

    public void close() {
        try {
            this.writer.close();
            RandomAccessFile headWriter = new RandomAccessFile(new File(this.fileName), "rw");
            byte[] tmpbuf = new byte[4];
            SSCodecFactory.intToBytes32(24, tmpbuf, 0, true);
            headWriter.seek(4L);
            headWriter.write(tmpbuf);
            SSCodecFactory.intToBytes32(this.bytesWritten, tmpbuf, 0, true);
            headWriter.seek(8L);
            headWriter.write(tmpbuf);
            SSCodecFactory.intToBytes32(1, tmpbuf, 0, true);
            headWriter.seek(12L);
            headWriter.write(tmpbuf);
            SSCodecFactory.intToBytes32(8000, tmpbuf, 0, true);
            headWriter.seek(16L);
            headWriter.write(tmpbuf);
            SSCodecFactory.intToBytes32(1, tmpbuf, 0, true);
            headWriter.seek(20L);
            headWriter.write(tmpbuf);
            headWriter.close();
        }
        catch (Exception e) {
            System.err.println(e.getLocalizedMessage());
        }
    }
}

