/*
 * Decompiled with CFR 0.152.
 */
package local.ua;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.RandomAccessFile;
import local.ua.sscodecs.SSCodecFactory;

public class WavWriter {
    private BufferedOutputStream writer;
    private int bytesWritten = 0;
    private String fileName = null;

    public WavWriter(String fileName) {
        this.fileName = fileName;
        try {
            this.writer = new BufferedOutputStream(new FileOutputStream(fileName), 8192);
        }
        catch (Exception e) {
            System.err.println(e.getLocalizedMessage());
        }
        byte[] byArray = new byte[44];
        byArray[0] = 82;
        byArray[1] = 73;
        byArray[2] = 70;
        byArray[3] = 70;
        byArray[4] = 63;
        byArray[5] = 63;
        byArray[6] = 63;
        byArray[7] = 63;
        byArray[8] = 87;
        byArray[9] = 65;
        byArray[10] = 86;
        byArray[11] = 69;
        byArray[12] = 102;
        byArray[13] = 109;
        byArray[14] = 116;
        byArray[15] = 32;
        byArray[16] = 16;
        byArray[20] = 1;
        byArray[22] = 1;
        byArray[24] = -128;
        byArray[25] = 62;
        byArray[29] = 125;
        byArray[32] = 2;
        byArray[34] = 16;
        byArray[36] = 100;
        byArray[37] = 97;
        byArray[38] = 116;
        byArray[39] = 97;
        byArray[40] = 63;
        byArray[41] = 63;
        byArray[42] = 63;
        byArray[43] = 63;
        byte[] wavHeader = byArray;
        this.write(wavHeader, wavHeader.length);
        this.bytesWritten = 0;
    }

    public void write(byte[] data, int len) {
        try {
            this.writer.write(data, 0, len);
            this.bytesWritten += len;
        }
        catch (Exception e) {
            System.err.println(e.getLocalizedMessage());
        }
    }

    public void close() {
        try {
            this.writer.close();
            RandomAccessFile headWriter = new RandomAccessFile(new File(this.fileName), "rw");
            byte[] tmpbuf = new byte[4];
            SSCodecFactory.intToBytes32(this.bytesWritten + 36, tmpbuf, 0, false);
            headWriter.seek(4L);
            headWriter.write(tmpbuf);
            SSCodecFactory.intToBytes32(this.bytesWritten, tmpbuf, 0, false);
            headWriter.seek(40L);
            headWriter.write(tmpbuf);
            headWriter.close();
        }
        catch (Exception e) {
            System.err.println(e.getLocalizedMessage());
        }
    }
}

