/*
 * Decompiled with CFR 0.152.
 */
package local.ua.sscodecs;

import local.ua.sscodecs.FilterInterface;

public class FIRFilter
implements FilterInterface {
    private int sampleRate;
    private float freqMax;
    private float freqMin;
    private int filterOrder;
    private WINDOW windowType;
    private FILTTYPE filterType;
    private float[] windowCoef = null;
    private int chunkByteSize;
    private int chunkShortSize;
    private float sampleSum;
    private int outPos;
    private float fN;
    private short[] sampleBuffer;

    public FIRFilter(int order, WINDOW winType, FILTTYPE filtType, float minFreq, float maxFreq, int argSampleRate, int argChunkSize) {
        this.windowType = winType;
        this.filterType = filtType;
        this.sampleRate = argSampleRate;
        this.fN = (float)((double)this.sampleRate * 0.5);
        this.filterOrder = order;
        this.freqMax = maxFreq;
        this.freqMin = minFreq;
        this.chunkByteSize = argChunkSize;
        this.chunkShortSize = this.chunkByteSize / 2;
        this.windowCoef = this.design();
        this.windowCoef = this.gainCompCoef(this.windowCoef, 1.0f);
        this.sampleBuffer = new short[this.chunkShortSize + this.filterOrder];
    }

    private float trBand() {
        switch (this.windowType) {
            case RECTANGULAR: {
                return 1.84f * this.fN / (float)this.filterOrder;
            }
            case HANNING: {
                return 6.22f * this.fN / (float)this.filterOrder;
            }
            case HAMMING: {
                return 6.64f * this.fN / (float)this.filterOrder;
            }
            case BLACKMAN: {
                return 11.13f * this.fN / (float)this.filterOrder;
            }
        }
        return 999.0f;
    }

    private float[] design() {
        int m = this.filterOrder / 2;
        float[] win = new float[m + 1];
        switch (this.windowType) {
            case RECTANGULAR: {
                int n = 1;
                while (n <= m) {
                    win[n] = 1.0f;
                    ++n;
                }
                break;
            }
            case HANNING: {
                float r = (float)Math.PI / (float)(m + 1);
                int n = 1;
                while (n <= m) {
                    win[n] = 0.5f + 0.5f * (float)Math.cos((float)n * r);
                    ++n;
                }
                break;
            }
            case HAMMING: {
                float r = (float)Math.PI / (float)m;
                int n = 1;
                while (n <= m) {
                    win[n] = 0.54f + 0.46f * (float)Math.cos((float)n * r);
                    ++n;
                }
                break;
            }
            case BLACKMAN: {
                float r = (float)Math.PI / (float)m;
                int n = 1;
                while (n <= m) {
                    win[n] = 0.42f + 0.5f * (float)Math.cos((float)n * r) + 0.08f * (float)Math.cos((float)(2 * n) * r);
                    ++n;
                }
                break;
            }
            default: {
                int n = 1;
                while (n <= m) {
                    win[n] = 1.0f;
                    ++n;
                }
                break block0;
            }
        }
        float w0 = 0.0f;
        float w1 = 0.0f;
        switch (this.filterType) {
            case LP: {
                w0 = 0.0f;
                w1 = (float)Math.PI * (this.freqMax + 0.5f * this.trBand()) / this.fN;
                break;
            }
            case HP: {
                w0 = (float)Math.PI;
                w1 = (float)Math.PI * (1.0f - (this.freqMin - 0.5f * this.trBand()) / this.fN);
                break;
            }
            case BP: {
                w0 = 1.5707964f * (this.freqMin + this.freqMax) / this.fN;
                w1 = 1.5707964f * (this.freqMax - this.freqMin + this.trBand()) / this.fN;
            }
        }
        float[] a = new float[this.filterOrder + 1];
        a[0] = w1 / (float)Math.PI;
        int n = 1;
        while (n <= m) {
            a[n] = (float)Math.sin((float)n * w1) * (float)Math.cos((float)n * w0) * win[n] / ((float)n * (float)Math.PI);
            ++n;
        }
        n = m + 1;
        while (n <= this.filterOrder) {
            a[n] = a[n - m];
            ++n;
        }
        n = 0;
        while (n <= m - 1) {
            a[n] = a[this.filterOrder - n];
            ++n;
        }
        a[m] = w1 / (float)Math.PI;
        return a;
    }

    private float[] gainCompCoef(float[] coef, float gainComp) {
        int c = 0;
        while (c < coef.length) {
            int n = c++;
            coef[n] = coef[n] * gainComp;
        }
        return coef;
    }

    public void filter(byte[] srcBuf) {
        int spos = this.filterOrder;
        int b = 0;
        while (b < this.chunkByteSize) {
            this.sampleBuffer[spos++] = (short)(srcBuf[b + 1] << 8 | srcBuf[b] & 0xFF);
            b += 2;
        }
        this.outPos = 0;
        int sampIndex = 0;
        while (sampIndex < this.chunkShortSize) {
            this.sampleSum = 0.0f;
            int r = 0;
            while (r <= this.filterOrder) {
                this.sampleSum += this.windowCoef[r] * (float)this.sampleBuffer[sampIndex + r];
                ++r;
            }
            srcBuf[this.outPos++] = (byte)this.sampleSum;
            srcBuf[this.outPos++] = (byte)((short)this.sampleSum >> 8);
            ++sampIndex;
        }
        System.arraycopy(this.sampleBuffer, this.sampleBuffer.length - this.filterOrder, this.sampleBuffer, 0, this.filterOrder);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FILTTYPE {
        LP,
        HP,
        BP;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WINDOW {
        RECTANGULAR,
        HANNING,
        HAMMING,
        BLACKMAN;

    }
}

