/*
 * Decompiled with CFR 0.152.
 */
package local.ua.sscodecs;

import java.util.Enumeration;
import java.util.Hashtable;
import local.ua.sscodecs.SSCodec;
import local.ua.sscodecs.SSCodecInfo;
import org.apache.log4j.Logger;

public class SSCodecFactory {
    private static Logger log = null;
    private static final String[] officialNames = new String[]{"PCMU", "GSM", "G723", "DVI4", "LPC", "PCMA", "G722", "L16", "QCELP", "CN", "MPA", "G728", "G729", "G726-16", "G726-24", "G726-32", "G726-40", "speex", "iLBC"};
    private static Hashtable<Integer, SSCodecInfo> codecNumberMap = null;
    private static Hashtable<String, SSCodecInfo> codecClassNameMap = null;
    private static Hashtable<String, SSCodecInfo> codecDynamicMap = null;

    public static void init() {
        codecNumberMap = new Hashtable();
        codecClassNameMap = new Hashtable();
        codecDynamicMap = new Hashtable();
        log = Logger.getLogger(SSCodecFactory.class);
    }

    public static SSCodec configureCodec(String codecClassName, int frameSize, double inGain, double outGain) {
        SSCodecInfo codecInfo = new SSCodecInfo(codecClassName, "N/A", frameSize, inGain, outGain);
        SSCodec sscodec = null;
        try {
            sscodec = SSCodecFactory.getCodec(codecInfo);
        }
        catch (Exception e) {
            log.error("Codec Error: " + codecClassName + " - " + e.getLocalizedMessage());
            return null;
        }
        if (codecNumberMap.containsKey(sscodec.getPayloadType())) {
            log.error("Error: payload Type " + sscodec.getPayloadType() + " already configured.");
            return null;
        }
        codecInfo.codecOfficialName = sscodec.getCodecName();
        boolean matched = false;
        int o = 0;
        while (o < officialNames.length) {
            if (officialNames[o].equals(sscodec.getCodecName())) {
                matched = true;
                break;
            }
            ++o;
        }
        if (!matched) {
            log.warn("Codec: " + codecClassName + " - internal Codec name:" + sscodec.getCodecName() + " is not official name");
        }
        codecNumberMap.put(sscodec.getPayloadType(), codecInfo);
        codecClassNameMap.put(codecClassName, codecInfo);
        if (sscodec.getPayloadType() < 0 || sscodec.getPayloadType() >= 96 && sscodec.getPayloadType() <= 127) {
            codecDynamicMap.put(String.valueOf(sscodec.getCodecName().toUpperCase()) + "/" + sscodec.getSampleRate(), codecInfo);
        }
        return sscodec;
    }

    public static void modifyCodecMap(int oldPayType, int newPayloadType) throws IllegalArgumentException {
        if (codecNumberMap.containsKey(newPayloadType)) {
            throw new IllegalArgumentException("payload type number: " + newPayloadType + " already in use");
        }
        SSCodecInfo codecInfo = codecNumberMap.get(oldPayType);
        codecNumberMap.remove(oldPayType);
        codecNumberMap.put(newPayloadType, codecInfo);
    }

    public static String getConfiguredCodecs() {
        String info = "";
        Enumeration<SSCodecInfo> e = codecClassNameMap.elements();
        while (e.hasMoreElements()) {
            SSCodecInfo ci = e.nextElement();
            info = String.valueOf(info) + "CodecClassSuffix:" + ci.codecClassName + " internalName:" + ci.codecOfficialName + " frameSize:" + ci.frameSize + " inGain:" + ci.inGain + " outGain:" + ci.outGain + "\r\n";
        }
        return info;
    }

    public static SSCodec getCodec(SSCodecInfo codecInfo) throws Exception {
        String codecClassName = "local.ua.sscodecs.SSCodec_" + codecInfo.codecClassName;
        Class<?> codecClass = null;
        SSCodec sscodec = null;
        try {
            codecClass = Class.forName(codecClassName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Codec not found - " + codecClassName);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        try {
            sscodec = (SSCodec)codecClass.newInstance();
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Codec won't instantiate - " + codecClassName);
        }
        boolean frameOK = false;
        int[] vfs = sscodec.getValidFrameSizes();
        String frameSizeList = "";
        int t = 0;
        while (t < vfs.length) {
            if (vfs[t] == codecInfo.frameSize) {
                frameOK = true;
                break;
            }
            if (frameSizeList.length() > 0) {
                frameSizeList = String.valueOf(frameSizeList) + ",";
            }
            frameSizeList = String.valueOf(frameSizeList) + vfs[t];
            ++t;
        }
        if (!frameOK) {
            throw new IllegalArgumentException("Invalid frameSize: " + codecInfo.frameSize + " - supported sizes are: " + frameSizeList);
        }
        try {
            sscodec.init(codecInfo.frameSize, codecInfo.inGain, codecInfo.outGain);
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Codec failed init - " + codecClassName);
        }
        return sscodec;
    }

    public static SSCodec getCodecByNumber(int codecNum) throws Exception {
        SSCodecInfo codecInfo = codecNumberMap.get(codecNum);
        SSCodec newCodec = SSCodecFactory.getCodec(codecInfo);
        if (newCodec != null) {
            newCodec.setPayloadType(codecNum);
        }
        return newCodec;
    }

    public static SSCodec getDynamicCodec(int dynamicNum, String codecParms) throws Exception {
        String fixParms = codecParms.replaceAll("/1$", "").toUpperCase();
        SSCodecInfo codecInfo = codecDynamicMap.get(fixParms);
        if (codecInfo == null) {
            throw new Exception("Error locating codec: " + fixParms);
        }
        SSCodec newCodec = SSCodecFactory.getCodec(codecInfo);
        if (newCodec != null) {
            newCodec.setPayloadType(dynamicNum);
        }
        return newCodec;
    }

    public static void intToBytes32(int sample, byte[] buffer, int byteOffset, boolean bigEndian) {
        if (bigEndian) {
            buffer[byteOffset++] = (byte)(sample >> 24);
            buffer[byteOffset++] = (byte)(sample >>> 16 & 0xFF);
            buffer[byteOffset++] = (byte)(sample >>> 8 & 0xFF);
            buffer[byteOffset] = (byte)(sample & 0xFF);
        } else {
            buffer[byteOffset++] = (byte)(sample & 0xFF);
            buffer[byteOffset++] = (byte)(sample >>> 8 & 0xFF);
            buffer[byteOffset++] = (byte)(sample >>> 16 & 0xFF);
            buffer[byteOffset] = (byte)(sample >> 24);
        }
    }
}

