/*
 * Decompiled with CFR 0.152.
 */
package local.ua.sscodecs;

public class SSCodecUtil {
    private int usCurSample;
    private int uslastPcmSample;
    private int usInterpol;
    private int uspos;
    private int usR;
    private int dnCurSample1;
    private int dnCurSample2;
    private int dnSample;
    private int dnpos;
    private int dnR;

    public int upSample2x(byte[] srcbuf, int len, byte[] outbuf, double gain) {
        this.uspos = 0;
        this.usR = 0;
        while (this.usR < len) {
            this.usCurSample = (int)((double)(srcbuf[this.usR + 1] << 8 | srcbuf[this.usR] & 0xFF) * gain);
            if (this.usCurSample > Short.MAX_VALUE) {
                this.usCurSample = Short.MAX_VALUE;
            } else if (this.usCurSample < Short.MIN_VALUE) {
                this.usCurSample = Short.MIN_VALUE;
            }
            this.usInterpol = (this.uslastPcmSample + this.usCurSample) / 2;
            outbuf[this.uspos++] = (byte)this.usInterpol;
            outbuf[this.uspos++] = (byte)(this.usInterpol >> 8);
            outbuf[this.uspos++] = (byte)this.usCurSample;
            outbuf[this.uspos++] = (byte)(this.usCurSample >> 8);
            this.uslastPcmSample = this.usCurSample;
            this.usR += 2;
        }
        return this.uspos;
    }

    public int upSample2x(short[] srcbuf, int len, byte[] outbuf, double gain) {
        this.uspos = 0;
        this.usR = 0;
        while (this.usR < len) {
            this.usCurSample = (int)((double)srcbuf[this.usR] * gain);
            if (this.usCurSample > Short.MAX_VALUE) {
                this.usCurSample = Short.MAX_VALUE;
            } else if (this.usCurSample < Short.MIN_VALUE) {
                this.usCurSample = Short.MIN_VALUE;
            }
            this.usInterpol = (this.uslastPcmSample + this.usCurSample) / 2;
            outbuf[this.uspos++] = (byte)this.usInterpol;
            outbuf[this.uspos++] = (byte)(this.usInterpol >> 8);
            outbuf[this.uspos++] = (byte)this.usCurSample;
            outbuf[this.uspos++] = (byte)(this.usCurSample >> 8);
            this.uslastPcmSample = this.usCurSample;
            ++this.usR;
        }
        return this.uspos;
    }

    public int downSample2x(byte[] srcbuf, int len, short[] outbuf, double gain) {
        this.dnpos = 0;
        this.dnR = 0;
        while (this.dnR < len) {
            this.dnCurSample1 = srcbuf[this.dnR + 1] << 8 | srcbuf[this.dnR] & 0xFF;
            this.dnCurSample2 = srcbuf[this.dnR + 3] << 8 | srcbuf[this.dnR + 2] & 0xFF;
            this.dnSample = (int)((double)((this.dnCurSample1 + this.dnCurSample2) / 2) * gain);
            if (this.dnSample > Short.MAX_VALUE) {
                this.dnSample = Short.MAX_VALUE;
            } else if (this.dnSample < Short.MIN_VALUE) {
                this.dnSample = Short.MIN_VALUE;
            }
            outbuf[this.dnpos++] = (short)this.dnSample;
            this.dnR += 4;
        }
        return this.dnpos;
    }

    public int downSample2x(byte[] srcbuf, int len, byte[] outbuf, double gain) {
        this.dnpos = 0;
        this.dnR = 0;
        while (this.dnR < len) {
            this.dnCurSample1 = srcbuf[this.dnR + 1] << 8 | srcbuf[this.dnR] & 0xFF;
            this.dnCurSample2 = srcbuf[this.dnR + 3] << 8 | srcbuf[this.dnR + 2] & 0xFF;
            this.dnSample = (int)((double)((this.dnCurSample1 + this.dnCurSample2) / 2) * gain);
            if (this.dnSample > Short.MAX_VALUE) {
                this.dnSample = Short.MAX_VALUE;
            } else if (this.dnSample < Short.MIN_VALUE) {
                this.dnSample = Short.MIN_VALUE;
            }
            outbuf[this.dnpos++] = (byte)this.dnSample;
            outbuf[this.dnpos++] = (byte)(this.dnSample >> 8);
            this.dnR += 4;
        }
        return this.dnpos;
    }

    public int convertBytesToShortsLE(byte[] srcbuf, int offset, int len, short[] outbuf) {
        int convbspos = 0;
        int convbsR = offset;
        while (convbsR < len + offset) {
            outbuf[convbspos++] = (short)(srcbuf[convbsR + 1] << 8 | srcbuf[convbsR] & 0xFF);
            convbsR += 2;
        }
        return convbspos;
    }

    public int convertShortsToBytesLE(short[] srcbuf, int len, byte[] outbuf, int offset) {
        int convsbpos = offset;
        int convsbR = 0;
        while (convsbR < len) {
            outbuf[convsbpos++] = (byte)srcbuf[convsbR];
            outbuf[convsbpos++] = (byte)(srcbuf[convsbR] >> 8);
            ++convsbR;
        }
        return convsbpos - offset;
    }

    public int convertBytesToShortsBE(byte[] srcbuf, int offset, int len, short[] outbuf) {
        int convbspos = 0;
        int convbsR = offset;
        while (convbsR < len + offset) {
            outbuf[convbspos++] = (short)(srcbuf[convbsR] << 8 | srcbuf[convbsR + 1] & 0xFF);
            convbsR += 2;
        }
        return convbspos;
    }

    public int convertShortsToBytesBE(short[] srcbuf, int len, byte[] outbuf, int offset) {
        int convsbpos = offset;
        int convsbR = 0;
        while (convsbR < len) {
            outbuf[convsbpos++] = (byte)(srcbuf[convsbR] >> 8);
            outbuf[convsbpos++] = (byte)srcbuf[convsbR];
            ++convsbR;
        }
        return convsbpos - offset;
    }

    public int changeAmplitude(byte[] srcbuf, int len, short[] outbuf, double gain) {
        this.dnpos = 0;
        this.dnR = 0;
        while (this.dnR < len) {
            this.dnCurSample1 = srcbuf[this.dnR + 1] << 8 | srcbuf[this.dnR] & 0xFF;
            this.dnSample = (int)((double)this.dnCurSample1 * gain);
            if (this.dnSample > Short.MAX_VALUE) {
                this.dnSample = Short.MAX_VALUE;
            } else if (this.dnSample < Short.MIN_VALUE) {
                this.dnSample = Short.MIN_VALUE;
            }
            outbuf[this.dnpos++] = (short)this.dnSample;
            this.dnR += 2;
        }
        return this.dnpos;
    }

    public int changeAmplitude(byte[] srcbuf, int len, byte[] outbuf, double gain) {
        this.uspos = 0;
        this.usR = 0;
        while (this.usR < len) {
            this.usCurSample = (int)((double)(srcbuf[this.usR + 1] << 8 | srcbuf[this.usR] & 0xFF) * gain);
            if (this.usCurSample > Short.MAX_VALUE) {
                this.usCurSample = Short.MAX_VALUE;
            } else if (this.usCurSample < Short.MIN_VALUE) {
                this.usCurSample = Short.MIN_VALUE;
            }
            outbuf[this.uspos++] = (byte)this.usCurSample;
            outbuf[this.uspos++] = (byte)(this.usCurSample >> 8);
            this.usR += 2;
        }
        return this.uspos;
    }
}

