/*
 * Decompiled with CFR 0.152.
 */
package local.ua.sscodecs;

import local.ua.sscodecs.SSCodec;
import local.ua.sscodecs.SSCodecInfo;
import local.ua.sscodecs.SSCodecUtil;
import org.apache.log4j.Logger;
import org.tritonus.lowlevel.gsm.Encoder;
import org.tritonus.lowlevel.gsm.GSMDecoder;
import org.tritonus.share.sampled.TConversionTool;

public class SSCodec_GSMTRI
implements SSCodec {
    private Logger log = Logger.getLogger(this.getClass());
    private String codecName = "GSM";
    private int payLoadType = 3;
    private int sample_rate = 8000;
    private int sample_size = 1;
    private int frame_size = 0;
    private static final int gsmPacketSize = 33;
    private static final int gsmInputSize = 320;
    private double encodeGain = 0.0;
    private double decodeGain = 0.0;
    SSCodecUtil codecUtil = new SSCodecUtil();
    private int pcmFrameSize;
    private Class tcl = TConversionTool.class;
    private Encoder encoder = new Encoder();
    private short[] encPcmBuf = null;
    private byte[] encGsmBuf = null;
    GSMDecoder decoder = new GSMDecoder();
    private byte[] decPcmBuf = new byte[1280];
    private int decReadPtr;
    private int decWritePtr;

    public void init(int frame_size, double argEncodeGain, double argDecodeGain) {
        this.frame_size = frame_size;
        this.pcmFrameSize = frame_size * 4;
        this.encodeGain = argEncodeGain;
        this.decodeGain = argDecodeGain;
        this.encPcmBuf = new short[this.frame_size];
        this.encGsmBuf = new byte[33];
    }

    public SSCodecInfo getCodecInfo() {
        return new SSCodecInfo(this.getClass().getSimpleName().replaceAll("^[^_]+_", ""), this.codecName, this.frame_size, this.encodeGain, this.decodeGain);
    }

    public int[] getValidFrameSizes() {
        return new int[]{160};
    }

    public int getFrameSize() {
        return this.frame_size;
    }

    public int getPcmFrameSize() {
        return this.pcmFrameSize;
    }

    public int getSampleRate() {
        return this.sample_rate;
    }

    public void setSampleRate(int rate) {
        this.sample_rate = rate;
    }

    public void setPayloadType(int type) {
        this.payLoadType = type;
    }

    public int getPayloadType() {
        return this.payLoadType;
    }

    public String getCodecName() {
        return this.codecName;
    }

    public int PcmToCodec(byte[] inpcm, int len, byte[] outgsm, int offset) {
        this.codecUtil.downSample2x(inpcm, len, this.encPcmBuf, this.encodeGain);
        this.encoder.encode(this.encPcmBuf, this.encGsmBuf);
        System.arraycopy(this.encGsmBuf, 0, outgsm, offset, 33);
        return 33;
    }

    public int CodecToPcm(byte[] gsmBuf, int offset, int len, byte[] outpcm) {
        this.decReadPtr = offset;
        this.decWritePtr = 0;
        while (this.decReadPtr < len) {
            try {
                this.decoder.decode(gsmBuf, this.decReadPtr, this.decPcmBuf, this.decWritePtr, false);
            }
            catch (Exception e) {
                this.log.error("decoder Error", e);
            }
            this.decWritePtr += 320;
            this.decReadPtr += 33;
        }
        this.codecUtil.upSample2x(this.decPcmBuf, this.decWritePtr, outpcm, this.decodeGain);
        return this.decWritePtr * 2;
    }

    public int getCodecBlankPacket(byte[] buf, int offset) {
        byte[] blankBuf = new byte[this.getPcmFrameSize()];
        return this.PcmToCodec(blankBuf, blankBuf.length, buf, offset);
    }
}

