/*
 * Decompiled with CFR 0.152.
 */
package local.ua.sscodecs;

import local.ua.sscodecs.SSCodec;
import local.ua.sscodecs.SSCodecInfo;
import local.ua.sscodecs.SSCodecUtil;
import local.ua.sscodecs.ilbc.ilbc_decoder;
import local.ua.sscodecs.ilbc.ilbc_encoder;
import org.apache.log4j.Logger;

public class SSCodec_ILBC
implements SSCodec {
    private Logger log = Logger.getLogger(this.getClass());
    private String codecName = "iLBC";
    private int payLoadType = -1;
    private int sample_rate = 8000;
    private int sample_size = 1;
    private int frame_size = 0;
    private double encodeGain = 0.0;
    private double decodeGain = 0.0;
    SSCodecUtil codecUtil = new SSCodecUtil();
    private int pcmFrameSize;
    private short[] encPcmBuf = null;
    private ilbc_encoder encoder = null;
    private int encOutBytes;
    private short[] encIlbcBuf = null;
    private ilbc_decoder decoder = null;
    private short[] decIlbcBuf = null;
    private short[] decTargetPcmBuf = null;

    public void init(int frame_size, double argEncodeGain, double argDecodeGain) {
        this.frame_size = frame_size;
        this.pcmFrameSize = frame_size * 4;
        this.encodeGain = argEncodeGain;
        this.decodeGain = argDecodeGain;
        this.encPcmBuf = new short[this.frame_size];
        this.encOutBytes = frame_size == 160 ? 38 : 50;
        this.encIlbcBuf = new short[this.encOutBytes / 2];
        this.decIlbcBuf = new short[this.encOutBytes / 2];
        this.decTargetPcmBuf = new short[frame_size];
        this.encoder = new ilbc_encoder(frame_size / 8);
        this.decoder = new ilbc_decoder(frame_size / 8, 1);
    }

    public SSCodecInfo getCodecInfo() {
        return new SSCodecInfo(this.getClass().getSimpleName().replaceAll("^[^_]+_", ""), this.codecName, this.frame_size, this.encodeGain, this.decodeGain);
    }

    public int[] getValidFrameSizes() {
        return new int[]{240};
    }

    public int getFrameSize() {
        return this.frame_size;
    }

    public int getPcmFrameSize() {
        return this.pcmFrameSize;
    }

    public int getSampleRate() {
        return this.sample_rate;
    }

    public void setSampleRate(int rate) {
        this.sample_rate = rate;
    }

    public void setPayloadType(int type) {
        this.payLoadType = type;
    }

    public int getPayloadType() {
        return this.payLoadType;
    }

    public String getCodecName() {
        return this.codecName;
    }

    public int PcmToCodec(byte[] inpcm, int len, byte[] outIlbc, int offset) {
        this.codecUtil.downSample2x(inpcm, len, this.encPcmBuf, this.encodeGain);
        this.encoder.encode(this.encIlbcBuf, this.encPcmBuf);
        this.codecUtil.convertShortsToBytesBE(this.encIlbcBuf, this.encOutBytes / 2, outIlbc, offset);
        return this.encOutBytes;
    }

    public int CodecToPcm(byte[] inIlbc, int offset, int len, byte[] outpcm) {
        this.codecUtil.convertBytesToShortsBE(inIlbc, offset, len, this.decIlbcBuf);
        this.decoder.decode(this.decTargetPcmBuf, this.decIlbcBuf, (short)1);
        this.codecUtil.upSample2x(this.decTargetPcmBuf, this.frame_size, outpcm, this.decodeGain);
        return this.pcmFrameSize;
    }

    public int getCodecBlankPacket(byte[] buf, int offset) {
        byte[] blankBuf = new byte[this.getPcmFrameSize()];
        return this.PcmToCodec(blankBuf, blankBuf.length, buf, offset);
    }
}

