/*
 * Decompiled with CFR 0.152.
 */
package local.ua.sscodecs;

import java.util.Arrays;
import local.media.G711;
import local.ua.sscodecs.SSCodec;
import local.ua.sscodecs.SSCodecInfo;

public class SSCodec_PCMU
implements SSCodec {
    private String codecName = "PCMU";
    private int payLoadType = 0;
    private int sample_rate = 8000;
    private int sample_size = 1;
    private int frame_size = 0;
    private int pcmFrameSize;
    private double encodeGain = 0.0;
    private double decodeGain = 0.0;
    private int encCurSample1;
    private int encCurSample2;
    private int encInterpol;
    private int outulawpos = 0;
    private int encR = 0;
    private int outpcmpos = 0;
    private int pcmout;
    private int decInterpol;
    private int lastPcmSample = 0;
    private int decR = 0;
    static byte[] ulawEncodeTable = null;
    static short[] ulawDecodeTable = null;

    public void init(int frame_size, double argEncodeGain, double argDecodeGain) {
        this.frame_size = frame_size;
        this.pcmFrameSize = frame_size * 4;
        this.encodeGain = argEncodeGain;
        this.decodeGain = argDecodeGain;
        ulawEncodeTable = SSCodec_PCMU.getUlawEncodeTable(this.encodeGain);
        ulawDecodeTable = SSCodec_PCMU.getUlawDecodeTable(this.decodeGain);
    }

    public SSCodecInfo getCodecInfo() {
        return new SSCodecInfo(this.getClass().getSimpleName().replaceAll("^[^_]+_", ""), this.codecName, this.frame_size, this.encodeGain, this.decodeGain);
    }

    public int[] getValidFrameSizes() {
        return new int[]{160, 240, 320};
    }

    public int getFrameSize() {
        return this.frame_size;
    }

    public int getPcmFrameSize() {
        return this.pcmFrameSize;
    }

    public int getSampleRate() {
        return this.sample_rate;
    }

    public void setSampleRate(int rate) {
        this.sample_rate = rate;
    }

    public void setPayloadType(int type) {
        this.payLoadType = type;
    }

    public int getPayloadType() {
        return this.payLoadType;
    }

    public String getCodecName() {
        return this.codecName;
    }

    public int PcmToCodec(byte[] inpcm, int len, byte[] outulaw, int offset) {
        this.outulawpos = offset;
        this.encR = 0;
        while (this.encR < len) {
            this.encCurSample1 = inpcm[this.encR + 1] << 8 | inpcm[this.encR] & 0xFF;
            this.encCurSample2 = inpcm[this.encR + 3] << 8 | inpcm[this.encR + 2] & 0xFF;
            this.encInterpol = (this.encCurSample1 + this.encCurSample2) / 2;
            outulaw[this.outulawpos++] = ulawEncodeTable[this.encInterpol + 32768];
            this.encR += 4;
        }
        return len / 4;
    }

    public int CodecToPcm(byte[] ulawbuf, int offset, int len, byte[] outpcm) {
        this.outpcmpos = 0;
        this.decR = 0;
        while (this.decR < len) {
            this.pcmout = ulawDecodeTable[ulawbuf[this.decR + offset] + 128];
            this.decInterpol = (this.lastPcmSample + this.pcmout) / 2;
            outpcm[this.outpcmpos++] = (byte)this.decInterpol;
            outpcm[this.outpcmpos++] = (byte)(this.decInterpol >> 8);
            outpcm[this.outpcmpos++] = (byte)this.pcmout;
            outpcm[this.outpcmpos++] = (byte)(this.pcmout >> 8);
            this.lastPcmSample = this.pcmout;
            ++this.decR;
        }
        return len * 4;
    }

    public int getCodecBlankPacket(byte[] buf, int offset) {
        Arrays.fill(buf, offset, offset + this.frame_size, ulawEncodeTable[32768]);
        return this.frame_size;
    }

    private static byte[] getUlawEncodeTable(double gain) {
        byte[] table = new byte[65536];
        int v = Short.MIN_VALUE;
        while (v < 32768) {
            int s = v;
            if (gain < 1.6 || Math.abs(s) > 60) {
                s = (int)((double)s * gain);
            }
            if (s > Short.MAX_VALUE) {
                s = Short.MAX_VALUE;
            } else if (s < Short.MIN_VALUE) {
                s = Short.MIN_VALUE;
            }
            table[v + 32768] = (byte)G711.linear2ulaw(s);
            if (table[v + 32768] == 0) {
                table[v + 32768] = 2;
            }
            ++v;
        }
        return table;
    }

    private static short[] getUlawDecodeTable(double gain) {
        short[] table = new short[256];
        int v = -128;
        while (v < 128) {
            int s = G711.ulaw2linear((byte)v);
            if (gain < 1.6 || Math.abs(s) > 60) {
                s = (int)((double)s * gain);
            }
            if (s > Short.MAX_VALUE) {
                s = Short.MAX_VALUE;
            } else if (s < Short.MIN_VALUE) {
                s = Short.MIN_VALUE;
            }
            table[v + 128] = (short)s;
            ++v;
        }
        return table;
    }
}

