/*
 * Decompiled with CFR 0.152.
 */
package local.ua.sscodecs;

import local.ua.sscodecs.SSCodec;
import local.ua.sscodecs.SSCodecInfo;
import local.ua.sscodecs.SSCodecUtil;
import org.apache.log4j.Logger;
import org.xiph.speex.SpeexDecoder;
import org.xiph.speex.SpeexEncoder;

public class SSCodec_SPEEX16K
implements SSCodec {
    private Logger log = Logger.getLogger(this.getClass());
    private String codecName = "speex";
    private int payLoadType = -1;
    private int sample_rate = 16000;
    private int speexMode = 1;
    private int sample_size = 1;
    private int speexChannels = 1;
    private int frame_size = 0;
    private double encodeGain = 0.0;
    private double decodeGain = 0.0;
    SSCodecUtil codecUtil = new SSCodecUtil();
    private int pcmFrameSize;
    private SpeexEncoder encoder = new SpeexEncoder();
    private short[] encPcmBuf = null;
    private int speexQuality = 3;
    private SpeexDecoder decoder = new SpeexDecoder();
    private byte[] decPcmBuf = new byte[2560];
    private int decWritePtr;
    private boolean speexEnhanced = false;

    public void init(int frame_size, double argEncodeGain, double argDecodeGain) {
        this.frame_size = frame_size;
        this.pcmFrameSize = frame_size;
        this.encodeGain = argEncodeGain;
        this.decodeGain = argDecodeGain;
        this.encPcmBuf = new short[this.frame_size];
        this.encoder.init(this.speexMode, this.speexQuality, this.sample_rate, this.speexChannels);
        this.encoder.getEncoder().setComplexity(2);
        this.encoder.getEncoder().setVbrQuality(4.0f);
        this.encoder.getEncoder().setVbr(false);
        this.encoder.getEncoder().setAbr(0);
        this.encoder.getEncoder().setVad(false);
        this.encoder.getEncoder().setDtx(false);
        this.decoder.init(this.speexMode, this.sample_rate, this.speexChannels, this.speexEnhanced);
    }

    public SSCodecInfo getCodecInfo() {
        return new SSCodecInfo(this.getClass().getSimpleName().replaceAll("^[^_]+_", ""), this.codecName, this.frame_size, this.encodeGain, this.decodeGain);
    }

    public int[] getValidFrameSizes() {
        return new int[]{320};
    }

    public int getFrameSize() {
        return this.frame_size;
    }

    public int getPcmFrameSize() {
        return this.pcmFrameSize;
    }

    public int getSampleRate() {
        return this.sample_rate;
    }

    public void setSampleRate(int rate) {
        this.sample_rate = rate;
    }

    public void setPayloadType(int type) {
        this.payLoadType = type;
    }

    public int getPayloadType() {
        return this.payLoadType;
    }

    public String getCodecName() {
        return this.codecName;
    }

    public int PcmToCodec(byte[] inpcm, int len, byte[] outSpeex, int offset) {
        this.codecUtil.changeAmplitude(inpcm, len, this.encPcmBuf, this.encodeGain);
        this.encoder.processData(this.encPcmBuf, 0, len);
        return this.encoder.getProcessedData(outSpeex, offset);
    }

    public int CodecToPcm(byte[] speexBuf, int offset, int len, byte[] outpcm) {
        try {
            this.decoder.processData(speexBuf, offset, len);
        }
        catch (Exception e) {
            this.log.error("Speex Decoder Error", e);
            return 0;
        }
        this.decWritePtr = this.decoder.getProcessedData(this.decPcmBuf, 0);
        this.codecUtil.changeAmplitude(this.decPcmBuf, this.decWritePtr, outpcm, this.decodeGain);
        return this.decWritePtr;
    }

    public int getCodecBlankPacket(byte[] buf, int offset) {
        byte[] blankBuf = new byte[this.getPcmFrameSize()];
        return this.PcmToCodec(blankBuf, blankBuf.length, buf, offset);
    }
}

