/*
 * Decompiled with CFR 0.152.
 */
package local.ua.sscodecs.ilbc;

import local.ua.sscodecs.ilbc.bitpack;

class bitstream {
    int bitcount;
    int pos = 0;
    char[] buffer;
    int buffer_len;
    int buffer_pos;

    public bitstream(int size) {
        this.buffer_len = size;
        this.buffer_pos = 0;
        this.buffer = new char[size];
        this.bitcount = 0;
    }

    public bitstream() {
        this.buffer_len = 128;
        this.buffer_pos = 0;
        this.buffer = new char[128];
    }

    public bitpack packsplit(int index, int bitno_firstpart, int bitno_total) {
        int bitno_rest = bitno_total - bitno_firstpart;
        bitpack rval = new bitpack();
        int fp = index >>> bitno_rest;
        rval.set_firstpart(fp);
        rval.set_rest(index - (rval.get_firstpart() << bitno_rest));
        return rval;
    }

    int packcombine(int index, int rest, int bitno_rest) {
        index <<= bitno_rest;
        return index += rest;
    }

    void dopack(int index, int bitno) {
        this.bitcount += bitno;
        if (this.pos == 0) {
            this.buffer[this.buffer_pos] = '\u0000';
        }
        while (bitno > 0) {
            int posLeft;
            if (this.pos == 8) {
                this.pos = 0;
                ++this.buffer_pos;
                this.buffer[this.buffer_pos] = '\u0000';
            }
            if (bitno <= (posLeft = 8 - this.pos)) {
                int n = this.buffer_pos;
                this.buffer[n] = (char)(this.buffer[n] | (char)(index << posLeft - bitno));
                this.pos += bitno;
                bitno = 0;
                continue;
            }
            int n = this.buffer_pos;
            this.buffer[n] = (char)(this.buffer[n] | (char)(index >>> bitno - posLeft));
            this.pos = 8;
            index -= index >>> bitno - posLeft << bitno - posLeft;
            bitno -= posLeft;
        }
    }

    public int unpack(int bitno) {
        int index = 0;
        while (bitno > 0) {
            int BitsLeft;
            if (this.pos == 8) {
                this.pos = 0;
                ++this.buffer_pos;
            }
            if ((BitsLeft = 8 - this.pos) >= bitno) {
                index += (this.buffer[this.buffer_pos] << this.pos & 0xFF) >>> 8 - bitno;
                this.pos += bitno;
                bitno = 0;
                continue;
            }
            if (8 - bitno > 0) {
                index += (this.buffer[this.buffer_pos] << this.pos & 0xFF) >>> 8 - bitno;
                this.pos = 8;
            } else {
                index += (this.buffer[this.buffer_pos] << this.pos & 0xFF) << bitno - 8;
                this.pos = 8;
            }
            bitno -= BitsLeft;
        }
        return index;
    }
}

