/*
 * Decompiled with CFR 0.152.
 */
package local.ua.sscodecs.ilbc;

import local.ua.sscodecs.ilbc.ilbc_constants;

class ilbc_common {
    ilbc_common() {
    }

    public static int LSF_check(float[] lsf, int dim, int NoAn) {
        int Nit = 2;
        int change = 0;
        float eps = 0.039f;
        float eps2 = 0.0195f;
        float maxlsf = 3.14f;
        float minlsf = 0.01f;
        int n = 0;
        while (n < Nit) {
            int m = 0;
            while (m < NoAn) {
                int k = 0;
                while (k < dim - 1) {
                    int pos = m * dim + k;
                    if (lsf[pos + 1] - lsf[pos] < eps) {
                        if (lsf[pos + 1] < lsf[pos]) {
                            float tmp = lsf[pos + 1];
                            lsf[pos + 1] = lsf[pos] + eps2;
                            lsf[pos] = lsf[pos + 1] - eps2;
                        } else {
                            int n2 = pos;
                            lsf[n2] = lsf[n2] - eps2;
                            int n3 = pos + 1;
                            lsf[n3] = lsf[n3] + eps2;
                        }
                        change = 1;
                    }
                    if (lsf[pos] < minlsf) {
                        lsf[pos] = minlsf;
                        change = 1;
                    }
                    if (lsf[pos] > maxlsf) {
                        lsf[pos] = maxlsf;
                        change = 1;
                    }
                    ++k;
                }
                ++m;
            }
            ++n;
        }
        return change;
    }

    public static void StateConstructW(int idxForMax, int[] idxVec, float[] syntDenum, int syntDenum_idx, float[] out, int out_idx, int len) {
        float[] tmpbuf = new float[ilbc_constants.LPC_FILTERORDER + 2 * ilbc_constants.STATE_LEN];
        float[] numerator = new float[ilbc_constants.LPC_FILTERORDER + 1];
        float[] foutbuf = new float[ilbc_constants.LPC_FILTERORDER + 2 * ilbc_constants.STATE_LEN];
        float maxVal = ilbc_constants.state_frgqTbl[idxForMax];
        maxVal = (float)Math.pow(10.0, maxVal) / 4.5f;
        int li = 0;
        while (li < ilbc_constants.LPC_FILTERORDER) {
            tmpbuf[li] = 0.0f;
            foutbuf[li] = 0.0f;
            ++li;
        }
        int k = 0;
        while (k < ilbc_constants.LPC_FILTERORDER) {
            numerator[k] = syntDenum[syntDenum_idx + ilbc_constants.LPC_FILTERORDER - k];
            ++k;
        }
        numerator[ilbc_constants.LPC_FILTERORDER] = syntDenum[syntDenum_idx];
        int tmp = ilbc_constants.LPC_FILTERORDER;
        int fout = ilbc_constants.LPC_FILTERORDER;
        k = 0;
        while (k < len) {
            int tmpi = len - 1 - k;
            tmpbuf[tmp + k] = maxVal * ilbc_constants.state_sq3Tbl[idxVec[tmpi]];
            ++k;
        }
        li = 0;
        while (li < len) {
            tmpbuf[tmp + len + li] = 0.0f;
            ++li;
        }
        ilbc_common.ZeroPoleFilter(tmpbuf, tmp, numerator, syntDenum, syntDenum_idx, 2 * len, ilbc_constants.LPC_FILTERORDER, foutbuf, fout);
        k = 0;
        while (k < len) {
            out[out_idx + k] = foutbuf[fout + len - 1 - k] + foutbuf[fout + 2 * len - 1 - k];
            ++k;
        }
    }

    public static void AllPoleFilter(float[] InOut, int InOut_idx, float[] Coef, int Coef_idx, int lengthInOut, int orderCoef) {
        int n = 0;
        while (n < lengthInOut) {
            int k = 1;
            while (k <= orderCoef) {
                int n2 = n + InOut_idx;
                InOut[n2] = InOut[n2] - Coef[Coef_idx + k] * InOut[n - k + InOut_idx];
                ++k;
            }
            ++n;
        }
    }

    public static void AllZeroFilter(float[] In, int In_idx, float[] Coef, int lengthInOut, int orderCoef, float[] Out, int Out_idx) {
        int n = 0;
        while (n < lengthInOut) {
            Out[Out_idx] = Coef[0] * In[In_idx];
            int k = 1;
            while (k <= orderCoef) {
                int n2 = Out_idx;
                Out[n2] = Out[n2] + Coef[k] * In[In_idx - k];
                ++k;
            }
            ++Out_idx;
            ++In_idx;
            ++n;
        }
    }

    public static void ZeroPoleFilter(float[] In, int In_idx, float[] ZeroCoef, float[] PoleCoef, int PoleCoef_idx, int lengthInOut, int orderCoef, float[] Out, int Out_idx) {
        ilbc_common.AllZeroFilter(In, In_idx, ZeroCoef, lengthInOut, orderCoef, Out, Out_idx);
        ilbc_common.AllPoleFilter(Out, Out_idx, PoleCoef, PoleCoef_idx, lengthInOut, orderCoef);
    }

    public static void lsf2a(float[] a_coef, float[] freq) {
        float[] p = new float[ilbc_constants.LPC_HALFORDER];
        float[] q = new float[ilbc_constants.LPC_HALFORDER];
        float[] a = new float[ilbc_constants.LPC_HALFORDER + 1];
        float[] a1 = new float[ilbc_constants.LPC_HALFORDER];
        float[] a2 = new float[ilbc_constants.LPC_HALFORDER];
        float[] b = new float[ilbc_constants.LPC_HALFORDER + 1];
        float[] b1 = new float[ilbc_constants.LPC_HALFORDER];
        float[] b2 = new float[ilbc_constants.LPC_HALFORDER];
        int i = 0;
        while (i < ilbc_constants.LPC_FILTERORDER) {
            freq[i] = freq[i] * ilbc_constants.PI2;
            ++i;
        }
        if (freq[0] <= 0.0f || (double)freq[ilbc_constants.LPC_FILTERORDER - 1] >= 0.5) {
            if (freq[0] <= 0.0f) {
                freq[0] = 0.022f;
            }
            if ((double)freq[ilbc_constants.LPC_FILTERORDER - 1] >= 0.5) {
                freq[ilbc_constants.LPC_FILTERORDER - 1] = 0.499f;
            }
            float hlp = (freq[ilbc_constants.LPC_FILTERORDER - 1] - freq[0]) / (float)(ilbc_constants.LPC_FILTERORDER - 1);
            i = 1;
            while (i < ilbc_constants.LPC_FILTERORDER) {
                freq[i] = freq[i - 1] + hlp;
                ++i;
            }
        }
        int li = 0;
        while (li < ilbc_constants.LPC_HALFORDER) {
            a1[li] = 0.0f;
            a2[li] = 0.0f;
            b1[li] = 0.0f;
            b2[li] = 0.0f;
            ++li;
        }
        li = 0;
        while (li < ilbc_constants.LPC_HALFORDER + 1) {
            a[li] = 0.0f;
            b[li] = 0.0f;
            ++li;
        }
        i = 0;
        while (i < ilbc_constants.LPC_HALFORDER) {
            p[i] = (float)Math.cos(ilbc_constants.TWO_PI * freq[2 * i]);
            q[i] = (float)Math.cos(ilbc_constants.TWO_PI * freq[2 * i + 1]);
            ++i;
        }
        a[0] = 0.25f;
        b[0] = 0.25f;
        i = 0;
        while (i < ilbc_constants.LPC_HALFORDER) {
            a[i + 1] = a[i] - 2.0f * p[i] * a1[i] + a2[i];
            b[i + 1] = b[i] - 2.0f * q[i] * b1[i] + b2[i];
            a2[i] = a1[i];
            a1[i] = a[i];
            b2[i] = b1[i];
            b1[i] = b[i];
            ++i;
        }
        int j = 0;
        while (j < ilbc_constants.LPC_FILTERORDER) {
            if (j == 0) {
                a[0] = 0.25f;
                b[0] = -0.25f;
            } else {
                b[0] = 0.0f;
                a[0] = 0.0f;
            }
            i = 0;
            while (i < ilbc_constants.LPC_HALFORDER) {
                a[i + 1] = a[i] - 2.0f * p[i] * a1[i] + a2[i];
                b[i + 1] = b[i] - 2.0f * q[i] * b1[i] + b2[i];
                a2[i] = a1[i];
                a1[i] = a[i];
                b2[i] = b1[i];
                b1[i] = b[i];
                ++i;
            }
            a_coef[j + 1] = 2.0f * (a[ilbc_constants.LPC_HALFORDER] + b[ilbc_constants.LPC_HALFORDER]);
            ++j;
        }
        a_coef[0] = 1.0f;
    }

    public static void interpolate(float[] out, float[] in1, float[] in2, int in2_idx, float coef, int length) {
        float invcoef = 1.0f - coef;
        int i = 0;
        while (i < length) {
            out[i] = coef * in1[i] + invcoef * in2[i + in2_idx];
            ++i;
        }
    }

    public static void bwexpand(float[] out, int out_idx, float[] in, float coef, int length) {
        float chirp = coef;
        out[out_idx] = in[0];
        int i = 1;
        while (i < length) {
            out[i + out_idx] = chirp * in[i];
            chirp *= coef;
            ++i;
        }
    }

    public static void getCBvec(float[] cbvec, float[] mem, int mem_idx, int index, int lMem, int cbveclen) {
        float[] tmpbuf = new float[ilbc_constants.CB_MEML];
        int base_size = lMem - cbveclen + 1;
        if (cbveclen == ilbc_constants.SUBL) {
            base_size += cbveclen / 2;
        }
        if (index < lMem - cbveclen + 1) {
            int k = index + cbveclen;
            System.arraycopy(mem, mem_idx + lMem - k, cbvec, 0, cbveclen);
        } else if (index < base_size) {
            int k = 2 * (index - (lMem - cbveclen + 1)) + cbveclen;
            int ihigh = k / 2;
            int ilow = ihigh - 5;
            System.arraycopy(mem, mem_idx + lMem - k / 2, cbvec, 0, ilow);
            float alfa1 = 0.2f;
            float alfa = 0.0f;
            int j = ilow;
            while (j < ihigh) {
                cbvec[j] = (1.0f - alfa) * mem[mem_idx + lMem - k / 2 + j] + alfa * mem[mem_idx + lMem - k + j];
                alfa += alfa1;
                ++j;
            }
            System.arraycopy(mem, mem_idx + lMem - k + ihigh, cbvec, ihigh, cbveclen - ihigh);
        } else if (index - base_size < lMem - cbveclen + 1) {
            float[] tempbuff2 = new float[ilbc_constants.CB_MEML + ilbc_constants.CB_FILTERLEN + 1];
            int li = 0;
            while (li < ilbc_constants.CB_HALFFILTERLEN) {
                tempbuff2[li] = 0.0f;
                ++li;
            }
            System.arraycopy(mem, mem_idx, tempbuff2, ilbc_constants.CB_HALFFILTERLEN, lMem);
            li = 0;
            while (li < ilbc_constants.CB_HALFFILTERLEN + 1) {
                tempbuff2[lMem + ilbc_constants.CB_HALFFILTERLEN + li] = 0.0f;
                ++li;
            }
            int k = index - base_size + cbveclen;
            int sFilt = lMem - k;
            int memInd = sFilt + 1 - ilbc_constants.CB_HALFFILTERLEN;
            int pos = 0;
            li = 0;
            while (li < cbveclen) {
                cbvec[li] = 0.0f;
                ++li;
            }
            int n = 0;
            while (n < cbveclen) {
                int pp = memInd + n + ilbc_constants.CB_HALFFILTERLEN;
                int pp1 = ilbc_constants.CB_FILTERLEN - 1;
                int j = 0;
                while (j < ilbc_constants.CB_FILTERLEN) {
                    int n2 = pos;
                    cbvec[n2] = cbvec[n2] + tempbuff2[pp] * ilbc_constants.cbfiltersTbl[pp1];
                    ++pp;
                    --pp1;
                    ++j;
                }
                ++pos;
                ++n;
            }
        } else {
            int j;
            float[] tempbuff2 = new float[ilbc_constants.CB_MEML + ilbc_constants.CB_FILTERLEN + 1];
            int li = 0;
            while (li < ilbc_constants.CB_HALFFILTERLEN) {
                tempbuff2[li] = 0.0f;
                ++li;
            }
            System.arraycopy(mem, mem_idx, tempbuff2, ilbc_constants.CB_HALFFILTERLEN, lMem);
            li = 0;
            while (li < ilbc_constants.CB_HALFFILTERLEN) {
                tempbuff2[lMem + ilbc_constants.CB_HALFFILTERLEN + li] = 0.0f;
                ++li;
            }
            int k = 2 * (index - base_size - (lMem - cbveclen + 1)) + cbveclen;
            int sFilt = lMem - k;
            int memInd = sFilt + 1 - ilbc_constants.CB_HALFFILTERLEN;
            int pos = sFilt;
            li = 0;
            while (li < k) {
                tmpbuf[pos + li] = 0.0f;
                ++li;
            }
            int i = 0;
            while (i < k) {
                int pp = memInd + i + ilbc_constants.CB_HALFFILTERLEN;
                int pp1 = ilbc_constants.CB_FILTERLEN - 1;
                j = 0;
                while (j < ilbc_constants.CB_FILTERLEN) {
                    int n = pos;
                    tmpbuf[n] = tmpbuf[n] + tempbuff2[pp] * ilbc_constants.cbfiltersTbl[pp1];
                    ++pp;
                    --pp1;
                    ++j;
                }
                ++pos;
                ++i;
            }
            int ihigh = k / 2;
            int ilow = ihigh - 5;
            System.arraycopy(tmpbuf, lMem - k / 2, cbvec, 0, ilow);
            float alfa1 = 0.2f;
            float alfa = 0.0f;
            j = ilow;
            while (j < ihigh) {
                cbvec[j] = (1.0f - alfa) * tmpbuf[lMem - k / 2 + j] + alfa * tmpbuf[lMem - k + j];
                alfa += alfa1;
                ++j;
            }
            System.arraycopy(tmpbuf, lMem - k + ihigh, cbvec, ihigh, cbveclen - ihigh);
        }
    }

    public static float gainquant(float in, float maxIn, int cblen, int[] index, int index_idx) {
        float scale = maxIn;
        if ((double)scale < 0.1) {
            scale = 0.1f;
        }
        float[] cb = cblen == 8 ? ilbc_constants.gain_sq3Tbl : (cblen == 16 ? ilbc_constants.gain_sq4Tbl : ilbc_constants.gain_sq5Tbl);
        float minmeasure = 1.0E7f;
        int tindex = 0;
        int i = 0;
        while (i < cblen) {
            float measure = (in - scale * cb[i]) * (in - scale * cb[i]);
            if (measure < minmeasure) {
                tindex = i;
                minmeasure = measure;
            }
            ++i;
        }
        index[index_idx] = tindex;
        return scale * cb[tindex];
    }

    public static float gaindequant(int index, float maxIn, int cblen) {
        float scale = Math.abs(maxIn);
        if ((double)scale < 0.1) {
            scale = 0.1f;
        }
        if (cblen == 8) {
            return scale * ilbc_constants.gain_sq3Tbl[index];
        }
        if (cblen == 16) {
            return scale * ilbc_constants.gain_sq4Tbl[index];
        }
        if (cblen == 32) {
            return scale * ilbc_constants.gain_sq5Tbl[index];
        }
        return 0.0f;
    }

    public static void iCBConstruct(float[] decvector, int decvector_idx, int[] index, int index_idx, int[] gain_index, int gain_index_idx, float[] mem, int mem_idx, int lMem, int veclen, int nStages) {
        float[] gain = new float[ilbc_constants.CB_NSTAGES];
        float[] cbvec = new float[ilbc_constants.SUBL];
        gain[0] = ilbc_common.gaindequant(gain_index[gain_index_idx + 0], 1.0f, 32);
        if (nStages > 1) {
            gain[1] = ilbc_common.gaindequant(gain_index[gain_index_idx + 1], Math.abs(gain[0]), 16);
        }
        if (nStages > 2) {
            gain[2] = ilbc_common.gaindequant(gain_index[gain_index_idx + 2], Math.abs(gain[1]), 8);
        }
        ilbc_common.getCBvec(cbvec, mem, mem_idx, index[index_idx + 0], lMem, veclen);
        int j = 0;
        while (j < veclen) {
            decvector[decvector_idx + j] = gain[0] * cbvec[j];
            ++j;
        }
        if (nStages > 1) {
            int k = 1;
            while (k < nStages) {
                ilbc_common.getCBvec(cbvec, mem, mem_idx, index[index_idx + k], lMem, veclen);
                j = 0;
                while (j < veclen) {
                    int n = decvector_idx + j;
                    decvector[n] = decvector[n] + gain[k] * cbvec[j];
                    ++j;
                }
                ++k;
            }
        }
    }
}

