/*
 * Decompiled with CFR 0.152.
 */
package local.ua.sscodecs.ilbc;

import local.ua.sscodecs.ilbc.bitstream;
import local.ua.sscodecs.ilbc.ilbc_common;
import local.ua.sscodecs.ilbc.ilbc_constants;
import local.ua.sscodecs.ilbc.ilbc_ulp;

public class ilbc_decoder {
    int consPLICount;
    int prevPLI;
    int prevLag;
    int last_lag;
    int prev_enh_pl;
    float per;
    float[] prevResidual;
    long seed;
    float[] prevLpc;
    ilbc_ulp ULP_inst = null;
    float[] syntMem;
    float[] lsfdeqold;
    float[] old_syntdenum;
    float[] hpomem;
    int use_enhancer;
    float[] enh_buf;
    float[] enh_period;

    void syntFilter(float[] Out, int Out_idx, float[] a, int a_idx, int len, float[] mem) {
        int j;
        int pa;
        int pi;
        int po = Out_idx;
        int i = 0;
        while (i < ilbc_constants.LPC_FILTERORDER) {
            pi = Out_idx + i - 1;
            pa = a_idx + 1;
            int pm = ilbc_constants.LPC_FILTERORDER - 1;
            j = 1;
            while (j <= i) {
                int n = po;
                Out[n] = Out[n] - a[pa] * Out[pi];
                ++pa;
                --pi;
                ++j;
            }
            j = i + 1;
            while (j < ilbc_constants.LPC_FILTERORDER + 1) {
                int n = po;
                Out[n] = Out[n] - a[pa] * mem[pm];
                ++pa;
                --pm;
                ++j;
            }
            ++po;
            ++i;
        }
        i = ilbc_constants.LPC_FILTERORDER;
        while (i < len) {
            pi = Out_idx + i - 1;
            pa = a_idx + 1;
            j = 1;
            while (j < ilbc_constants.LPC_FILTERORDER + 1) {
                int n = po;
                Out[n] = Out[n] - a[pa] * Out[pi];
                ++pa;
                --pi;
                ++j;
            }
            ++po;
            ++i;
        }
        System.arraycopy(Out, Out_idx + len - ilbc_constants.LPC_FILTERORDER, mem, 0, ilbc_constants.LPC_FILTERORDER);
    }

    public void LSFinterpolate2a_dec(float[] a, float[] lsf1, float[] lsf2, int lsf2_idx, float coef, int length) {
        float[] lsftmp = new float[ilbc_constants.LPC_FILTERORDER];
        ilbc_common.interpolate(lsftmp, lsf1, lsf2, lsf2_idx, coef, length);
        ilbc_common.lsf2a(a, lsftmp);
    }

    void SimplelsfDEQ(float[] lsfdeq, int[] index, int lpc_n) {
        int j;
        int pos = 0;
        int cb_pos = 0;
        int i = 0;
        while (i < ilbc_constants.LSF_NSPLIT) {
            j = 0;
            while (j < ilbc_constants.dim_lsfCbTbl[i]) {
                lsfdeq[pos + j] = ilbc_constants.lsfCbTbl[cb_pos + (int)((long)index[i] * (long)ilbc_constants.dim_lsfCbTbl[i] + (long)j)];
                ++j;
            }
            pos += ilbc_constants.dim_lsfCbTbl[i];
            cb_pos += ilbc_constants.size_lsfCbTbl[i] * ilbc_constants.dim_lsfCbTbl[i];
            ++i;
        }
        if (lpc_n > 1) {
            pos = 0;
            cb_pos = 0;
            i = 0;
            while (i < ilbc_constants.LSF_NSPLIT) {
                j = 0;
                while (j < ilbc_constants.dim_lsfCbTbl[i]) {
                    lsfdeq[ilbc_constants.LPC_FILTERORDER + pos + j] = ilbc_constants.lsfCbTbl[cb_pos + (int)((long)index[ilbc_constants.LSF_NSPLIT + i] * (long)ilbc_constants.dim_lsfCbTbl[i]) + j];
                    ++j;
                }
                pos += ilbc_constants.dim_lsfCbTbl[i];
                cb_pos += ilbc_constants.size_lsfCbTbl[i] * ilbc_constants.dim_lsfCbTbl[i];
                ++i;
            }
        }
    }

    void DecoderInterpolateLSF(float[] syntdenum, float[] weightdenum, float[] lsfdeq, int length) {
        float[] lp = new float[ilbc_constants.LPC_FILTERORDER + 1];
        int lsfdeq2 = length;
        int lp_length = length + 1;
        if (this.ULP_inst.mode == 30) {
            this.LSFinterpolate2a_dec(lp, this.lsfdeqold, lsfdeq, 0, ilbc_constants.lsf_weightTbl_30ms[0], length);
            System.arraycopy(lp, 0, syntdenum, 0, lp_length);
            ilbc_common.bwexpand(weightdenum, 0, lp, ilbc_constants.LPC_CHIRP_WEIGHTDENUM, lp_length);
            int pos = lp_length;
            int i = 1;
            while (i < 6) {
                this.LSFinterpolate2a_dec(lp, lsfdeq, lsfdeq, lsfdeq2, ilbc_constants.lsf_weightTbl_30ms[i], length);
                System.arraycopy(lp, 0, syntdenum, pos, lp_length);
                ilbc_common.bwexpand(weightdenum, pos, lp, ilbc_constants.LPC_CHIRP_WEIGHTDENUM, lp_length);
                pos += lp_length;
                ++i;
            }
        } else {
            int pos = 0;
            int i = 0;
            while (i < this.ULP_inst.nsub) {
                this.LSFinterpolate2a_dec(lp, this.lsfdeqold, lsfdeq, 0, ilbc_constants.lsf_weightTbl_20ms[i], length);
                System.arraycopy(lp, 0, syntdenum, pos, lp_length);
                ilbc_common.bwexpand(weightdenum, pos, lp, ilbc_constants.LPC_CHIRP_WEIGHTDENUM, lp_length);
                pos += lp_length;
                ++i;
            }
        }
        if (this.ULP_inst.mode == 30) {
            System.arraycopy(lsfdeq, lsfdeq2, this.lsfdeqold, 0, length);
        } else {
            System.arraycopy(lsfdeq, 0, this.lsfdeqold, 0, length);
        }
    }

    public void index_conv_dec(int[] index) {
        int k = 1;
        while (k < ilbc_constants.CB_NSTAGES) {
            if (index[k] >= 44 && index[k] < 108) {
                int n = k;
                index[n] = index[n] + 64;
            } else if (index[k] >= 108 && index[k] < 128) {
                int n = k;
                index[n] = index[n] + 128;
            }
            ++k;
        }
    }

    public void hpOutput(float[] In, int len, float[] Out, float[] mem) {
        int pi = 0;
        int po = 0;
        int i = 0;
        while (i < len) {
            Out[po] = ilbc_constants.hpo_zero_coefsTbl[0] * In[pi];
            int n = po;
            Out[n] = Out[n] + ilbc_constants.hpo_zero_coefsTbl[1] * mem[0];
            int n2 = po++;
            Out[n2] = Out[n2] + ilbc_constants.hpo_zero_coefsTbl[2] * mem[1];
            mem[1] = mem[0];
            mem[0] = In[pi];
            ++pi;
            ++i;
        }
        po = 0;
        i = 0;
        while (i < len) {
            int n = po;
            Out[n] = Out[n] - ilbc_constants.hpo_pole_coefsTbl[1] * mem[2];
            int n3 = po;
            Out[n3] = Out[n3] - ilbc_constants.hpo_pole_coefsTbl[2] * mem[3];
            mem[3] = mem[2];
            mem[2] = Out[po];
            ++po;
            ++i;
        }
    }

    void DownSample(float[] In, int in_idx, float[] Coef, int lengthIn, float[] state, float[] Out) {
        int j;
        float o;
        int out_ptr = 0;
        int coef_ptr = 0;
        int in_ptr = in_idx;
        int state_ptr = 0;
        int i = ilbc_constants.DELAY_DS;
        while (i < lengthIn) {
            coef_ptr = 0;
            in_ptr = in_idx + i;
            state_ptr = ilbc_constants.FILTERORDER_DS - 2;
            o = 0.0f;
            int stop = i < ilbc_constants.FILTERORDER_DS ? i + 1 : ilbc_constants.FILTERORDER_DS;
            j = 0;
            while (j < stop) {
                o += Coef[coef_ptr] * In[in_ptr];
                ++coef_ptr;
                --in_ptr;
                ++j;
            }
            j = i + 1;
            while (j < ilbc_constants.FILTERORDER_DS) {
                o += Coef[coef_ptr] * state[state_ptr];
                ++coef_ptr;
                --state_ptr;
                ++j;
            }
            Out[out_ptr] = o;
            ++out_ptr;
            i += ilbc_constants.FACTOR_DS;
        }
        i = lengthIn + ilbc_constants.FACTOR_DS;
        while (i < lengthIn + ilbc_constants.DELAY_DS) {
            o = 0.0f;
            if (i < lengthIn) {
                coef_ptr = 0;
                in_ptr = in_idx + i;
                j = 0;
                while (j < ilbc_constants.FILTERORDER_DS) {
                    o += Coef[coef_ptr] * Out[out_ptr];
                    ++coef_ptr;
                    --out_ptr;
                    ++j;
                }
            } else {
                coef_ptr = i - lengthIn;
                in_ptr = in_idx + lengthIn - 1;
                j = 0;
                while (j < ilbc_constants.FILTERORDER_DS - (i - lengthIn)) {
                    o += Coef[coef_ptr] * In[in_ptr];
                    ++coef_ptr;
                    --in_ptr;
                    ++j;
                }
            }
            Out[out_ptr] = o;
            ++out_ptr;
            i += ilbc_constants.FACTOR_DS;
        }
    }

    public int NearestNeighbor(float[] array, float value, int arlength) {
        float crit = array[0] - value;
        float bestcrit = crit * crit;
        int index = 0;
        int i = 1;
        while (i < arlength) {
            crit = array[i] - value;
            if ((crit *= crit) < bestcrit) {
                bestcrit = crit;
                index = i;
            }
            ++i;
        }
        return index;
    }

    public void mycorr1(float[] corr, int corr_idx, float[] seq1, int seq1_idx, int dim1, float[] seq2, int seq2_idx, int dim2) {
        int i = 0;
        while (i <= dim1 - dim2) {
            if (corr_idx + i < corr.length) {
                corr[corr_idx + i] = 0.0f;
            }
            int j = 0;
            while (j < dim2) {
                int n = corr_idx + i;
                corr[n] = corr[n] + seq1[seq1_idx + i + j] * seq2[seq2_idx + j];
                ++j;
            }
            ++i;
        }
    }

    public void enh_upsample(float[] useq1, float[] seq1, int dim1, int hfl) {
        int k;
        int ps;
        int pp;
        int j;
        int[] polyp = new int[ilbc_constants.ENH_UPS0];
        int filterlength = 2 * hfl + 1;
        if (filterlength > dim1) {
            int hfl2 = dim1 / 2;
            j = 0;
            while (j < ilbc_constants.ENH_UPS0) {
                polyp[j] = j * filterlength + hfl - hfl2;
                ++j;
            }
            hfl = hfl2;
            filterlength = 2 * hfl + 1;
        } else {
            j = 0;
            while (j < ilbc_constants.ENH_UPS0) {
                polyp[j] = j * filterlength;
                ++j;
            }
        }
        int pu = 0;
        int i = hfl;
        while (i < filterlength) {
            j = 0;
            while (j < ilbc_constants.ENH_UPS0) {
                useq1[pu] = 0.0f;
                pp = polyp[j];
                ps = i;
                k = 0;
                while (k <= i) {
                    int n = pu;
                    useq1[n] = useq1[n] + seq1[ps] * ilbc_constants.polyphaserTbl[pp];
                    --ps;
                    ++pp;
                    ++k;
                }
                ++pu;
                ++j;
            }
            ++i;
        }
        i = filterlength;
        while (i < dim1) {
            j = 0;
            while (j < ilbc_constants.ENH_UPS0) {
                useq1[pu] = 0.0f;
                pp = polyp[j];
                ps = i;
                k = 0;
                while (k < filterlength) {
                    int n = pu;
                    useq1[n] = useq1[n] + seq1[ps] * ilbc_constants.polyphaserTbl[pp];
                    --ps;
                    ++pp;
                    ++k;
                }
                ++pu;
                ++j;
            }
            ++i;
        }
        int q = 1;
        while (q <= hfl) {
            j = 0;
            while (j < ilbc_constants.ENH_UPS0) {
                useq1[pu] = 0.0f;
                pp = polyp[j] + q;
                ps = dim1 - 1;
                k = 0;
                while (k < filterlength - q) {
                    int n = pu;
                    useq1[n] = useq1[n] + seq1[ps] * ilbc_constants.polyphaserTbl[pp];
                    --ps;
                    ++pp;
                    ++k;
                }
                ++pu;
                ++j;
            }
            ++q;
        }
    }

    public float refiner(float[] seg, int seg_idx, float[] idata, int idatal, int centerStartPos, float estSegPos, float period) {
        int st;
        int searchSegEndPos;
        float[] vect = new float[ilbc_constants.ENH_VECTL];
        float[] corrVec = new float[ilbc_constants.ENH_CORRDIM];
        float[] corrVecUps = new float[ilbc_constants.ENH_CORRDIM * ilbc_constants.ENH_UPS0];
        float updStartPos = 0.0f;
        int estSegPosRounded = (int)((double)estSegPos - 0.5);
        int searchSegStartPos = estSegPosRounded - ilbc_constants.ENH_SLOP;
        if (searchSegStartPos < 0) {
            searchSegStartPos = 0;
        }
        if ((searchSegEndPos = estSegPosRounded + ilbc_constants.ENH_SLOP) + ilbc_constants.ENH_BLOCKL >= idatal) {
            searchSegEndPos = idatal - ilbc_constants.ENH_BLOCKL - 1;
        }
        int corrdim = searchSegEndPos - searchSegStartPos + 1;
        this.mycorr1(corrVec, 0, idata, searchSegStartPos, corrdim + ilbc_constants.ENH_BLOCKL - 1, idata, centerStartPos, ilbc_constants.ENH_BLOCKL);
        this.enh_upsample(corrVecUps, corrVec, corrdim, ilbc_constants.ENH_FL0);
        int tloc = 0;
        float maxv = corrVecUps[0];
        int i = 1;
        while (i < ilbc_constants.ENH_UPS0 * corrdim) {
            if (corrVecUps[i] > maxv) {
                tloc = i;
                maxv = corrVecUps[i];
            }
            ++i;
        }
        updStartPos = (float)searchSegStartPos + (float)tloc / (float)ilbc_constants.ENH_UPS0 + 1.0f;
        int tloc2 = tloc / ilbc_constants.ENH_UPS0;
        if (tloc > tloc2 * ilbc_constants.ENH_UPS0) {
            ++tloc2;
        }
        if ((st = searchSegStartPos + tloc2 - ilbc_constants.ENH_FL0) < 0) {
            int li = 0;
            while (li < -st) {
                vect[li] = 0.0f;
                ++li;
            }
            System.arraycopy(idata, 0, vect, -st, ilbc_constants.ENH_VECTL + st);
        } else {
            int en = st + ilbc_constants.ENH_VECTL;
            if (en > idatal) {
                System.arraycopy(idata, st, vect, 0, ilbc_constants.ENH_VECTL - (en - idatal));
                int li = 0;
                while (li < en - idatal) {
                    vect[ilbc_constants.ENH_VECTL - (en - idatal) + li] = 0.0f;
                    ++li;
                }
            } else {
                System.arraycopy(idata, st, vect, 0, ilbc_constants.ENH_VECTL);
            }
        }
        int fraction = tloc2 * ilbc_constants.ENH_UPS0 - tloc;
        this.mycorr1(seg, seg_idx, vect, 0, ilbc_constants.ENH_VECTL, ilbc_constants.polyphaserTbl, (2 * ilbc_constants.ENH_FL0 + 1) * fraction, 2 * ilbc_constants.ENH_FL0 + 1);
        return updStartPos;
    }

    public void smath(float[] odata, int odata_idx, float[] sseq, int hl, float alpha0) {
        int psseq;
        float[] surround = new float[ilbc_constants.BLOCKL_MAX];
        float[] wt = new float[2 * ilbc_constants.ENH_HL + 1];
        int i = 1;
        while (i <= 2 * hl + 1) {
            wt[i - 1] = 0.5f * (1.0f - (float)Math.cos(2.0f * ilbc_constants.PI * (float)i / (float)(2 * hl + 2)));
            ++i;
        }
        wt[hl] = 0.0f;
        i = 0;
        while (i < ilbc_constants.ENH_BLOCKL) {
            surround[i] = sseq[i] * wt[0];
            ++i;
        }
        int k = 1;
        while (k < hl) {
            psseq = k * ilbc_constants.ENH_BLOCKL;
            i = 0;
            while (i < ilbc_constants.ENH_BLOCKL) {
                int n = i;
                surround[n] = surround[n] + sseq[psseq + i] * wt[k];
                ++i;
            }
            ++k;
        }
        k = hl + 1;
        while (k <= 2 * hl) {
            psseq = k * ilbc_constants.ENH_BLOCKL;
            i = 0;
            while (i < ilbc_constants.ENH_BLOCKL) {
                int n = i;
                surround[n] = surround[n] + sseq[psseq + i] * wt[k];
                ++i;
            }
            ++k;
        }
        float w11 = 0.0f;
        float w10 = 0.0f;
        float w00 = 0.0f;
        psseq = hl * ilbc_constants.ENH_BLOCKL;
        i = 0;
        while (i < ilbc_constants.ENH_BLOCKL) {
            w00 += sseq[psseq + i] * sseq[psseq + i];
            w11 += surround[i] * surround[i];
            w10 += surround[i] * sseq[psseq + i];
            ++i;
        }
        if (Math.abs(w11) < 1.0f) {
            w11 = 1.0f;
        }
        float C = (float)Math.sqrt(w00 / w11);
        float errs = 0.0f;
        psseq = hl * ilbc_constants.ENH_BLOCKL;
        i = 0;
        while (i < ilbc_constants.ENH_BLOCKL) {
            odata[odata_idx + i] = C * surround[i];
            float err = sseq[psseq + i] - odata[odata_idx + i];
            errs += err * err;
            ++i;
        }
        if (errs > alpha0 * w00) {
            float B;
            float A;
            float denom;
            if (w00 < 1.0f) {
                w00 = 1.0f;
            }
            if ((denom = (w11 * w00 - w10 * w10) / (w00 * w00)) > 1.0E-4f) {
                A = (float)Math.sqrt((alpha0 - alpha0 * alpha0 / 4.0f) / denom);
                B = -alpha0 / 2.0f - A * w10 / w00;
                B += 1.0f;
            } else {
                A = 0.0f;
                B = 1.0f;
            }
            psseq = hl * ilbc_constants.ENH_BLOCKL;
            i = 0;
            while (i < ilbc_constants.ENH_BLOCKL) {
                odata[odata_idx + i] = A * surround[i] + B * sseq[psseq + i];
                ++i;
            }
        }
    }

    public void getsseq(float[] sseq, float[] idata, int idatal, int centerStartPos, float[] period, float[] plocs, int periodl, int hl) {
        int li;
        float[] blockStartPos = new float[2 * ilbc_constants.ENH_HL + 1];
        int[] lagBlock = new int[2 * ilbc_constants.ENH_HL + 1];
        float[] plocs2 = new float[ilbc_constants.ENH_PLOCSL];
        int centerEndPos = centerStartPos + ilbc_constants.ENH_BLOCKL - 1;
        lagBlock[hl] = this.NearestNeighbor(plocs, 0.5f * (float)(centerStartPos + centerEndPos), periodl);
        blockStartPos[hl] = centerStartPos;
        int psseq = ilbc_constants.ENH_BLOCKL * hl;
        System.arraycopy(idata, centerStartPos, sseq, psseq, ilbc_constants.ENH_BLOCKL);
        int q = hl - 1;
        while (q >= 0) {
            blockStartPos[q] = blockStartPos[q + 1] - period[lagBlock[q + 1]];
            lagBlock[q] = this.NearestNeighbor(plocs, blockStartPos[q] + (float)ilbc_constants.ENH_BLOCKL_HALF - period[lagBlock[q + 1]], periodl);
            if (blockStartPos[q] - (float)ilbc_constants.ENH_OVERHANG >= 0.0f) {
                blockStartPos[q] = this.refiner(sseq, q * ilbc_constants.ENH_BLOCKL, idata, idatal, centerStartPos, blockStartPos[q], period[lagBlock[q + 1]]);
            } else {
                psseq = q * ilbc_constants.ENH_BLOCKL;
                li = 0;
                while (li < ilbc_constants.ENH_BLOCKL) {
                    sseq[psseq + li] = 0.0f;
                    ++li;
                }
            }
            --q;
        }
        int i = 0;
        while (i < periodl) {
            plocs2[i] = plocs[i] - period[i];
            ++i;
        }
        q = hl + 1;
        while (q <= 2 * hl) {
            lagBlock[q] = this.NearestNeighbor(plocs2, blockStartPos[q - 1] + (float)ilbc_constants.ENH_BLOCKL_HALF, periodl);
            blockStartPos[q] = blockStartPos[q - 1] + period[lagBlock[q]];
            if (blockStartPos[q] + (float)ilbc_constants.ENH_BLOCKL + (float)ilbc_constants.ENH_OVERHANG < (float)idatal) {
                blockStartPos[q] = this.refiner(sseq, q * ilbc_constants.ENH_BLOCKL, idata, idatal, centerStartPos, blockStartPos[q], period[lagBlock[q]]);
            } else {
                psseq = q * ilbc_constants.ENH_BLOCKL;
                li = 0;
                while (li < ilbc_constants.ENH_BLOCKL) {
                    sseq[psseq + li] = 0.0f;
                    ++li;
                }
            }
            ++q;
        }
    }

    public void enhancer(float[] odata, int odata_idx, float[] idata, int idatal, int centerStartPos, float alpha0, float[] period, float[] plocs, int periodl) {
        float[] sseq = new float[(2 * ilbc_constants.ENH_HL + 1) * ilbc_constants.ENH_BLOCKL];
        this.getsseq(sseq, idata, idatal, centerStartPos, period, plocs, periodl, ilbc_constants.ENH_HL);
        this.smath(odata, odata_idx, sseq, ilbc_constants.ENH_HL, alpha0);
    }

    public float xCorrCoef(float[] target, int t_idx, float[] regressor, int r_idx, int subl) {
        float ftmp1 = 0.0f;
        float ftmp2 = 0.0f;
        int i = 0;
        while (i < subl) {
            ftmp1 += target[t_idx + i] * regressor[r_idx + i];
            ftmp2 += regressor[r_idx + i] * regressor[r_idx + i];
            ++i;
        }
        if (ftmp1 > 0.0f) {
            return ftmp1 * ftmp1 / ftmp2;
        }
        return 0.0f;
    }

    int enhancerInterface(float[] out, float[] in) {
        int lag;
        block17: {
            int iblock;
            block16: {
                float cc;
                int ilag;
                float maxcc;
                lag = 0;
                float[] plc_pred = new float[ilbc_constants.ENH_BLOCKL];
                float[] lpState = new float[6];
                float[] downsampled = new float[(ilbc_constants.ENH_NBLOCKS * ilbc_constants.ENH_BLOCKL + 120) / 2];
                int inLen = ilbc_constants.ENH_NBLOCKS * ilbc_constants.ENH_BLOCKL + 120;
                System.arraycopy(this.enh_buf, this.ULP_inst.blockl, this.enh_buf, 0, ilbc_constants.ENH_BUFL - this.ULP_inst.blockl);
                System.arraycopy(in, 0, this.enh_buf, ilbc_constants.ENH_BUFL - this.ULP_inst.blockl, this.ULP_inst.blockl);
                int plc_blockl = this.ULP_inst.mode == 30 ? ilbc_constants.ENH_BLOCKL : 40;
                int ioffset = 0;
                if (this.ULP_inst.mode == 20) {
                    ioffset = 1;
                }
                int i = 3 - ioffset;
                System.arraycopy(this.enh_period, i, this.enh_period, 0, ilbc_constants.ENH_NBLOCKS_TOT - i);
                System.arraycopy(this.enh_buf, (ilbc_constants.ENH_NBLOCKS_EXTRA + ioffset) * ilbc_constants.ENH_BLOCKL - 126, lpState, 0, 6);
                this.DownSample(this.enh_buf, (ilbc_constants.ENH_NBLOCKS_EXTRA + ioffset) * ilbc_constants.ENH_BLOCKL - 120, ilbc_constants.lpFilt_coefsTbl, inLen - ioffset * ilbc_constants.ENH_BLOCKL, lpState, downsampled);
                iblock = 0;
                while (iblock < ilbc_constants.ENH_NBLOCKS - ioffset) {
                    lag = 10;
                    maxcc = this.xCorrCoef(downsampled, 60 + iblock * ilbc_constants.ENH_BLOCKL_HALF, downsampled, 60 + iblock * ilbc_constants.ENH_BLOCKL_HALF - lag, ilbc_constants.ENH_BLOCKL_HALF);
                    ilag = 11;
                    while (ilag < 60) {
                        cc = this.xCorrCoef(downsampled, 60 + iblock * ilbc_constants.ENH_BLOCKL_HALF, downsampled, 60 + iblock * ilbc_constants.ENH_BLOCKL_HALF - ilag, ilbc_constants.ENH_BLOCKL_HALF);
                        if (cc > maxcc) {
                            maxcc = cc;
                            lag = ilag;
                        }
                        ++ilag;
                    }
                    this.enh_period[iblock + ilbc_constants.ENH_NBLOCKS_EXTRA + ioffset] = (float)lag * 2.0f;
                    ++iblock;
                }
                if (this.prev_enh_pl == 1) {
                    int inlag = (int)this.enh_period[ilbc_constants.ENH_NBLOCKS_EXTRA + ioffset];
                    lag = inlag - 1;
                    maxcc = this.xCorrCoef(in, 0, in, lag, plc_blockl);
                    ilag = inlag;
                    while (ilag <= inlag + 1) {
                        cc = this.xCorrCoef(in, 0, in, ilag, plc_blockl);
                        if (cc > maxcc) {
                            maxcc = cc;
                            lag = ilag;
                        }
                        ++ilag;
                    }
                    this.enh_period[ilbc_constants.ENH_NBLOCKS_EXTRA + ioffset - 1] = lag;
                    int inPtr = lag - 1;
                    int enh_bufPtr1 = plc_blockl - 1;
                    int start = lag > plc_blockl ? plc_blockl : lag;
                    int isample = start;
                    while (isample > 0) {
                        plc_pred[enh_bufPtr1] = in[inPtr];
                        --enh_bufPtr1;
                        --inPtr;
                        --isample;
                    }
                    int enh_bufPtr2 = ilbc_constants.ENH_BUFL - 1 - this.ULP_inst.blockl;
                    isample = plc_blockl - 1 - lag;
                    while (isample >= 0) {
                        plc_pred[enh_bufPtr1] = this.enh_buf[enh_bufPtr2];
                        --enh_bufPtr1;
                        --enh_bufPtr2;
                        --isample;
                    }
                    float ftmp2 = 0.0f;
                    float ftmp1 = 0.0f;
                    i = 0;
                    while (i < plc_blockl) {
                        ftmp2 += this.enh_buf[ilbc_constants.ENH_BUFL - 1 - this.ULP_inst.blockl - i] * this.enh_buf[ilbc_constants.ENH_BUFL - 1 - this.ULP_inst.blockl - i];
                        ftmp1 += plc_pred[i] * plc_pred[i];
                        ++i;
                    }
                    if ((ftmp1 = (float)Math.sqrt(ftmp1 / (float)plc_blockl)) > 2.0f * (ftmp2 = (float)Math.sqrt(ftmp2 / (float)plc_blockl)) && (double)ftmp1 > 0.0) {
                        i = 0;
                        while (i < plc_blockl - 10) {
                            int n = i++;
                            plc_pred[n] = plc_pred[n] * (2.0f * ftmp2 / ftmp1);
                        }
                        i = plc_blockl - 10;
                        while (i < plc_blockl) {
                            int n = i;
                            plc_pred[n] = plc_pred[n] * ((float)(i - plc_blockl + 10) * (1.0f - 2.0f * ftmp2 / ftmp1) / 10.0f + 2.0f * ftmp2 / ftmp1);
                            ++i;
                        }
                    }
                    enh_bufPtr1 = ilbc_constants.ENH_BUFL - 1 - this.ULP_inst.blockl;
                    i = 0;
                    while (i < plc_blockl) {
                        ftmp1 = (float)(i + 1) / (float)(plc_blockl + 1);
                        int n = enh_bufPtr1;
                        this.enh_buf[n] = this.enh_buf[n] * ftmp1;
                        int n2 = enh_bufPtr1--;
                        this.enh_buf[n2] = this.enh_buf[n2] + (1.0f - ftmp1) * plc_pred[plc_blockl - 1 - i];
                        ++i;
                    }
                }
                if (this.ULP_inst.mode != 20) break block16;
                iblock = 0;
                while (iblock < 2) {
                    this.enhancer(out, iblock * ilbc_constants.ENH_BLOCKL, this.enh_buf, ilbc_constants.ENH_BUFL, (5 + iblock) * ilbc_constants.ENH_BLOCKL + 40, ilbc_constants.ENH_ALPHA0, this.enh_period, ilbc_constants.enh_plocsTbl, ilbc_constants.ENH_NBLOCKS_TOT);
                    ++iblock;
                }
                break block17;
            }
            if (this.ULP_inst.mode != 30) break block17;
            iblock = 0;
            while (iblock < 3) {
                this.enhancer(out, iblock * ilbc_constants.ENH_BLOCKL, this.enh_buf, ilbc_constants.ENH_BUFL, (4 + iblock) * ilbc_constants.ENH_BLOCKL, ilbc_constants.ENH_ALPHA0, this.enh_period, ilbc_constants.enh_plocsTbl, ilbc_constants.ENH_NBLOCKS_TOT);
                ++iblock;
            }
        }
        return lag * 2;
    }

    public void compCorr(float[] cc, float[] gc, float[] pm, float[] buffer, int lag, int bLen, int sRange) {
        if (bLen - sRange - lag < 0) {
            sRange = bLen - lag;
        }
        float ftmp1 = 0.0f;
        float ftmp2 = 0.0f;
        float ftmp3 = 0.0f;
        int i = 0;
        while (i < sRange) {
            ftmp1 += buffer[bLen - sRange + i] * buffer[bLen - sRange + i - lag];
            ftmp2 += buffer[bLen - sRange + i - lag] * buffer[bLen - sRange + i - lag];
            ftmp3 += buffer[bLen - sRange + i] * buffer[bLen - sRange + i];
            ++i;
        }
        if (ftmp2 > 0.0f) {
            cc[0] = ftmp1 * ftmp1 / ftmp2;
            gc[0] = Math.abs(ftmp1 / ftmp2);
            pm[0] = Math.abs(ftmp1) / ((float)Math.sqrt(ftmp2) * (float)Math.sqrt(ftmp3));
        } else {
            cc[0] = 0.0f;
            gc[0] = 0.0f;
            pm[0] = 0.0f;
        }
    }

    public void doThePLC(float[] PLCresidual, float[] PLClpc, int PLI, float[] decresidual, float[] lpc, int lpc_idx, int inlag) {
        int lag = 20;
        int randlag = 0;
        float gain = 0.0f;
        float maxcc = 0.0f;
        float use_gain = 0.0f;
        float gain_comp = 0.0f;
        float maxcc_comp = 0.0f;
        float per = 0.0f;
        float max_per = 0.0f;
        float[] randvec = new float[ilbc_constants.BLOCKL_MAX];
        float[] a_gain = new float[1];
        float[] a_comp = new float[1];
        float[] a_per = new float[1];
        if (PLI == 1) {
            int i;
            ++this.consPLICount;
            if (this.prevPLI != 1) {
                lag = inlag - 3;
                a_comp[0] = maxcc;
                a_gain[0] = gain;
                a_per[0] = max_per;
                this.compCorr(a_comp, a_gain, a_per, this.prevResidual, lag, this.ULP_inst.blockl, 60);
                maxcc = a_comp[0];
                gain = a_gain[0];
                max_per = a_per[0];
                i = inlag - 2;
                while (i <= inlag + 3) {
                    a_comp[0] = maxcc_comp;
                    a_gain[0] = gain_comp;
                    a_per[0] = per;
                    this.compCorr(a_comp, a_gain, a_per, this.prevResidual, i, this.ULP_inst.blockl, 60);
                    maxcc_comp = a_comp[0];
                    gain_comp = a_gain[0];
                    per = a_per[0];
                    if (maxcc_comp > maxcc) {
                        maxcc = maxcc_comp;
                        gain = gain_comp;
                        lag = i;
                        max_per = per;
                    }
                    ++i;
                }
            } else {
                lag = this.prevLag;
                max_per = this.per;
            }
            use_gain = 1.0f;
            if (this.consPLICount * this.ULP_inst.blockl > 320) {
                use_gain = 0.9f;
            } else if (this.consPLICount * this.ULP_inst.blockl > 640) {
                use_gain = 0.7f;
            } else if (this.consPLICount * this.ULP_inst.blockl > 960) {
                use_gain = 0.5f;
            } else if (this.consPLICount * this.ULP_inst.blockl > 1280) {
                use_gain = 0.0f;
            }
            float ftmp = (float)Math.sqrt(max_per);
            float pitchfact = ftmp > 0.7f ? 1.0f : (ftmp > 0.4f ? (ftmp - 0.4f) / 0.29999998f : 0.0f);
            int use_lag = lag;
            if (lag < 80) {
                use_lag = 2 * lag;
            }
            float energy = 0.0f;
            i = 0;
            while (i < this.ULP_inst.blockl) {
                this.seed = this.seed * 69069L + 1L & Integer.MAX_VALUE;
                randlag = 50 + (int)(this.seed % 70L);
                int pick = i - randlag;
                randvec[i] = pick < 0 ? this.prevResidual[this.ULP_inst.blockl + pick] : randvec[pick];
                pick = i - use_lag;
                PLCresidual[i] = pick < 0 ? this.prevResidual[this.ULP_inst.blockl + pick] : PLCresidual[pick];
                PLCresidual[i] = i < 80 ? use_gain * (pitchfact * PLCresidual[i] + (1.0f - pitchfact) * randvec[i]) : (i < 160 ? 0.95f * use_gain * (pitchfact * PLCresidual[i] + (1.0f - pitchfact) * randvec[i]) : 0.9f * use_gain * (pitchfact * PLCresidual[i] + (1.0f - pitchfact) * randvec[i]));
                energy += PLCresidual[i] * PLCresidual[i];
                ++i;
            }
            if ((float)Math.sqrt(energy / (float)this.ULP_inst.blockl) < 30.0f) {
                gain = 0.0f;
                i = 0;
                while (i < this.ULP_inst.blockl) {
                    PLCresidual[i] = randvec[i];
                    ++i;
                }
            }
            System.arraycopy(this.prevLpc, 0, PLClpc, 0, ilbc_constants.LPC_FILTERORDER + 1);
        } else {
            System.arraycopy(decresidual, 0, PLCresidual, 0, this.ULP_inst.blockl);
            System.arraycopy(lpc, lpc_idx, PLClpc, 0, ilbc_constants.LPC_FILTERORDER + 1);
            this.consPLICount = 0;
        }
        if (PLI != 0) {
            this.prevLag = lag;
            this.per = max_per;
        }
        this.prevPLI = PLI;
        System.arraycopy(PLClpc, 0, this.prevLpc, 0, ilbc_constants.LPC_FILTERORDER + 1);
        System.arraycopy(PLCresidual, 0, this.prevResidual, 0, this.ULP_inst.blockl);
    }

    public short decode(short[] decoded_data, short[] encoded_data, short mode) {
        float[] decblock = new float[ilbc_constants.BLOCKL_MAX];
        bitstream en_data = new bitstream(this.ULP_inst.no_of_bytes);
        if (mode < 0 || mode > 1) {
            System.out.println("\nERROR - Wrong mode - 0, 1 allowed\n");
        }
        int k = 0;
        while (k < encoded_data.length) {
            en_data.buffer[2 * k + 1] = (char)(encoded_data[k] & 0xFF);
            en_data.buffer[2 * k] = (char)(encoded_data[k] >> 8 & 0xFF);
            ++k;
        }
        this.iLBC_decode(decblock, en_data, mode);
        k = 0;
        while (k < this.ULP_inst.blockl) {
            float dtmp = decblock[k];
            if (dtmp < (float)ilbc_constants.MIN_SAMPLE) {
                dtmp = ilbc_constants.MIN_SAMPLE;
            } else if (dtmp > (float)ilbc_constants.MAX_SAMPLE) {
                dtmp = ilbc_constants.MAX_SAMPLE;
            }
            decoded_data[k] = (short)dtmp;
            ++k;
        }
        return (short)this.ULP_inst.blockl;
    }

    public void Decode(float[] decresidual, int start, int idxForMax, int[] idxVec, float[] syntdenum, int[] cb_index, int[] gain_index, int[] extra_cb_index, int[] extra_gain_index, int state_first) {
        int Nback;
        int subframe;
        int meml_gotten;
        int k;
        int li;
        float[] reverseDecresidual = new float[ilbc_constants.BLOCKL_MAX];
        float[] mem = new float[ilbc_constants.CB_MEML];
        int diff = ilbc_constants.STATE_LEN - this.ULP_inst.state_short_len;
        int start_pos = state_first == 1 ? (start - 1) * ilbc_constants.SUBL : (start - 1) * ilbc_constants.SUBL + diff;
        ilbc_common.StateConstructW(idxForMax, idxVec, syntdenum, (start - 1) * (ilbc_constants.LPC_FILTERORDER + 1), decresidual, start_pos, this.ULP_inst.state_short_len);
        if (state_first != 0) {
            li = 0;
            while (li < ilbc_constants.CB_MEML - this.ULP_inst.state_short_len) {
                mem[li] = 0.0f;
                ++li;
            }
            System.arraycopy(decresidual, start_pos, mem, ilbc_constants.CB_MEML - this.ULP_inst.state_short_len, this.ULP_inst.state_short_len);
            ilbc_common.iCBConstruct(decresidual, start_pos + this.ULP_inst.state_short_len, extra_cb_index, 0, extra_gain_index, 0, mem, ilbc_constants.CB_MEML - ilbc_constants.stMemLTbl, ilbc_constants.stMemLTbl, diff, ilbc_constants.CB_NSTAGES);
        } else {
            k = 0;
            while (k < diff) {
                reverseDecresidual[k] = decresidual[(start + 1) * ilbc_constants.SUBL - 1 - (k + this.ULP_inst.state_short_len)];
                ++k;
            }
            meml_gotten = this.ULP_inst.state_short_len;
            k = 0;
            while (k < meml_gotten) {
                mem[ilbc_constants.CB_MEML - 1 - k] = decresidual[start_pos + k];
                ++k;
            }
            li = 0;
            while (li < ilbc_constants.CB_MEML - k) {
                mem[li] = 0.0f;
                ++li;
            }
            ilbc_common.iCBConstruct(reverseDecresidual, 0, extra_cb_index, 0, extra_gain_index, 0, mem, ilbc_constants.CB_MEML - ilbc_constants.stMemLTbl, ilbc_constants.stMemLTbl, diff, ilbc_constants.CB_NSTAGES);
            k = 0;
            while (k < diff) {
                decresidual[start_pos - 1 - k] = reverseDecresidual[k];
                ++k;
            }
        }
        int subcount = 0;
        int Nfor = this.ULP_inst.nsub - start - 1;
        if (Nfor > 0) {
            li = 0;
            while (li < ilbc_constants.CB_MEML - ilbc_constants.STATE_LEN) {
                mem[li] = 0.0f;
                ++li;
            }
            System.arraycopy(decresidual, (start - 1) * ilbc_constants.SUBL, mem, ilbc_constants.CB_MEML - ilbc_constants.STATE_LEN, ilbc_constants.STATE_LEN);
            subframe = 0;
            while (subframe < Nfor) {
                ilbc_common.iCBConstruct(decresidual, (start + 1 + subframe) * ilbc_constants.SUBL, cb_index, subcount * ilbc_constants.CB_NSTAGES, gain_index, subcount * ilbc_constants.CB_NSTAGES, mem, ilbc_constants.CB_MEML - ilbc_constants.memLfTbl[subcount], ilbc_constants.memLfTbl[subcount], ilbc_constants.SUBL, ilbc_constants.CB_NSTAGES);
                System.arraycopy(mem, ilbc_constants.SUBL, mem, 0, ilbc_constants.CB_MEML - ilbc_constants.SUBL);
                System.arraycopy(decresidual, (start + 1 + subframe) * ilbc_constants.SUBL, mem, ilbc_constants.CB_MEML - ilbc_constants.SUBL, ilbc_constants.SUBL);
                ++subcount;
                ++subframe;
            }
        }
        if ((Nback = start - 1) > 0) {
            meml_gotten = ilbc_constants.SUBL * (this.ULP_inst.nsub + 1 - start);
            if (meml_gotten > ilbc_constants.CB_MEML) {
                meml_gotten = ilbc_constants.CB_MEML;
            }
            k = 0;
            while (k < meml_gotten) {
                mem[ilbc_constants.CB_MEML - 1 - k] = decresidual[(start - 1) * ilbc_constants.SUBL + k];
                ++k;
            }
            li = 0;
            while (li < ilbc_constants.CB_MEML - k) {
                mem[li] = 0.0f;
                ++li;
            }
            subframe = 0;
            while (subframe < Nback) {
                ilbc_common.iCBConstruct(reverseDecresidual, subframe * ilbc_constants.SUBL, cb_index, subcount * ilbc_constants.CB_NSTAGES, gain_index, subcount * ilbc_constants.CB_NSTAGES, mem, ilbc_constants.CB_MEML - ilbc_constants.memLfTbl[subcount], ilbc_constants.memLfTbl[subcount], ilbc_constants.SUBL, ilbc_constants.CB_NSTAGES);
                System.arraycopy(mem, ilbc_constants.SUBL, mem, 0, ilbc_constants.CB_MEML - ilbc_constants.SUBL);
                System.arraycopy(reverseDecresidual, subframe * ilbc_constants.SUBL, mem, ilbc_constants.CB_MEML - ilbc_constants.SUBL, ilbc_constants.SUBL);
                ++subcount;
                ++subframe;
            }
            int i = 0;
            while (i < ilbc_constants.SUBL * Nback) {
                decresidual[ilbc_constants.SUBL * Nback - i - 1] = reverseDecresidual[i];
                ++i;
            }
        }
    }

    void iLBC_decode(float[] decblock, bitstream bytes, int mode) {
        int i;
        int start;
        float[] data = new float[ilbc_constants.BLOCKL_MAX];
        float[] lsfdeq = new float[ilbc_constants.LPC_FILTERORDER * ilbc_constants.LPC_N_MAX];
        float[] PLCresidual = new float[ilbc_constants.BLOCKL_MAX];
        float[] PLClpc = new float[ilbc_constants.LPC_FILTERORDER + 1];
        float[] zeros = new float[ilbc_constants.BLOCKL_MAX];
        float[] one = new float[ilbc_constants.LPC_FILTERORDER + 1];
        int[] idxVec = new int[ilbc_constants.STATE_LEN];
        int[] gain_index = new int[ilbc_constants.NASUB_MAX * ilbc_constants.CB_NSTAGES];
        int[] extra_gain_index = new int[ilbc_constants.CB_NSTAGES];
        int[] cb_index = new int[ilbc_constants.CB_NSTAGES * ilbc_constants.NASUB_MAX];
        int[] extra_cb_index = new int[ilbc_constants.CB_NSTAGES];
        int[] lsf_i = new int[ilbc_constants.LSF_NSPLIT * ilbc_constants.LPC_N_MAX];
        float[] weightdenum = new float[(ilbc_constants.LPC_FILTERORDER + 1) * ilbc_constants.NSUB_MAX];
        float[] syntdenum = new float[ilbc_constants.NSUB_MAX * (ilbc_constants.LPC_FILTERORDER + 1)];
        float[] decresidual = new float[ilbc_constants.BLOCKL_MAX];
        if (mode > 0) {
            boolean pos = false;
            int k = 0;
            while (k < ilbc_constants.LSF_NSPLIT * ilbc_constants.LPC_N_MAX) {
                lsf_i[k] = 0;
                ++k;
            }
            start = 0;
            int state_first = 0;
            int idxForMax = 0;
            k = 0;
            while (k < this.ULP_inst.state_short_len) {
                idxVec[k] = 0;
                ++k;
            }
            k = 0;
            while (k < ilbc_constants.CB_NSTAGES) {
                extra_cb_index[k] = 0;
                ++k;
            }
            k = 0;
            while (k < ilbc_constants.CB_NSTAGES) {
                extra_gain_index[k] = 0;
                ++k;
            }
            i = 0;
            while (i < this.ULP_inst.nasub) {
                k = 0;
                while (k < ilbc_constants.CB_NSTAGES) {
                    cb_index[i * ilbc_constants.CB_NSTAGES + k] = 0;
                    ++k;
                }
                ++i;
            }
            i = 0;
            while (i < this.ULP_inst.nasub) {
                k = 0;
                while (k < ilbc_constants.CB_NSTAGES) {
                    gain_index[i * ilbc_constants.CB_NSTAGES + k] = 0;
                    ++k;
                }
                ++i;
            }
            int ulp = 0;
            while (ulp < 3) {
                int lastpart;
                k = 0;
                while (k < ilbc_constants.LSF_NSPLIT * this.ULP_inst.lpc_n) {
                    lastpart = bytes.unpack(this.ULP_inst.lsf_bits[k][ulp]);
                    lsf_i[k] = bytes.packcombine(lsf_i[k], lastpart, this.ULP_inst.lsf_bits[k][ulp]);
                    ++k;
                }
                lastpart = bytes.unpack(this.ULP_inst.start_bits[ulp]);
                start = bytes.packcombine(start, lastpart, this.ULP_inst.start_bits[ulp]);
                lastpart = bytes.unpack(this.ULP_inst.startfirst_bits[ulp]);
                state_first = bytes.packcombine(state_first, lastpart, this.ULP_inst.startfirst_bits[ulp]);
                lastpart = bytes.unpack(this.ULP_inst.scale_bits[ulp]);
                idxForMax = bytes.packcombine(idxForMax, lastpart, this.ULP_inst.scale_bits[ulp]);
                k = 0;
                while (k < this.ULP_inst.state_short_len) {
                    lastpart = bytes.unpack(this.ULP_inst.state_bits[ulp]);
                    idxVec[k] = bytes.packcombine(idxVec[k], lastpart, this.ULP_inst.state_bits[ulp]);
                    ++k;
                }
                k = 0;
                while (k < ilbc_constants.CB_NSTAGES) {
                    lastpart = bytes.unpack(this.ULP_inst.extra_cb_index[k][ulp]);
                    extra_cb_index[k] = bytes.packcombine(extra_cb_index[k], lastpart, this.ULP_inst.extra_cb_index[k][ulp]);
                    ++k;
                }
                k = 0;
                while (k < ilbc_constants.CB_NSTAGES) {
                    lastpart = bytes.unpack(this.ULP_inst.extra_cb_gain[k][ulp]);
                    extra_gain_index[k] = bytes.packcombine(extra_gain_index[k], lastpart, this.ULP_inst.extra_cb_gain[k][ulp]);
                    ++k;
                }
                i = 0;
                while (i < this.ULP_inst.nasub) {
                    k = 0;
                    while (k < ilbc_constants.CB_NSTAGES) {
                        lastpart = bytes.unpack(this.ULP_inst.cb_index[i][k][ulp]);
                        cb_index[i * ilbc_constants.CB_NSTAGES + k] = bytes.packcombine(cb_index[i * ilbc_constants.CB_NSTAGES + k], lastpart, this.ULP_inst.cb_index[i][k][ulp]);
                        ++k;
                    }
                    ++i;
                }
                i = 0;
                while (i < this.ULP_inst.nasub) {
                    k = 0;
                    while (k < ilbc_constants.CB_NSTAGES) {
                        lastpart = bytes.unpack(this.ULP_inst.cb_gain[i][k][ulp]);
                        gain_index[i * ilbc_constants.CB_NSTAGES + k] = bytes.packcombine(gain_index[i * ilbc_constants.CB_NSTAGES + k], lastpart, this.ULP_inst.cb_gain[i][k][ulp]);
                        ++k;
                    }
                    ++i;
                }
                ++ulp;
            }
            int last_bit = bytes.unpack(1);
            if (start < 1) {
                mode = 0;
            }
            if (this.ULP_inst.mode == 20 && start > 3) {
                mode = 0;
            }
            if (this.ULP_inst.mode == 30 && start > 5) {
                mode = 0;
            }
            if (last_bit == 1) {
                mode = 0;
            }
            if (mode == 1) {
                this.index_conv_dec(cb_index);
                this.SimplelsfDEQ(lsfdeq, lsf_i, this.ULP_inst.lpc_n);
                int check = ilbc_common.LSF_check(lsfdeq, ilbc_constants.LPC_FILTERORDER, this.ULP_inst.lpc_n);
                this.DecoderInterpolateLSF(syntdenum, weightdenum, lsfdeq, ilbc_constants.LPC_FILTERORDER);
                this.Decode(decresidual, start, idxForMax, idxVec, syntdenum, cb_index, gain_index, extra_cb_index, extra_gain_index, state_first);
                this.doThePLC(PLCresidual, PLClpc, 0, decresidual, syntdenum, (ilbc_constants.LPC_FILTERORDER + 1) * (this.ULP_inst.nsub - 1), this.last_lag);
                System.arraycopy(PLCresidual, 0, decresidual, 0, this.ULP_inst.blockl);
            }
        }
        if (mode == 0) {
            int li = 0;
            while (li < ilbc_constants.BLOCKL_MAX) {
                zeros[li] = 0.0f;
                ++li;
            }
            one[0] = 1.0f;
            li = 0;
            while (li < ilbc_constants.LPC_FILTERORDER) {
                one[li + 1] = 0.0f;
                ++li;
            }
            start = 0;
            this.doThePLC(PLCresidual, PLClpc, 1, zeros, one, 0, this.last_lag);
            System.arraycopy(PLCresidual, 0, decresidual, 0, this.ULP_inst.blockl);
            int order_plus_one = ilbc_constants.LPC_FILTERORDER + 1;
            i = 0;
            while (i < this.ULP_inst.nsub) {
                System.arraycopy(PLClpc, 0, syntdenum, i * order_plus_one, order_plus_one);
                ++i;
            }
        }
        if (this.use_enhancer == 1) {
            this.last_lag = this.enhancerInterface(data, decresidual);
            if (this.ULP_inst.mode == 20) {
                i = 0;
                this.syntFilter(data, i * ilbc_constants.SUBL, this.old_syntdenum, (i + this.ULP_inst.nsub - 1) * (ilbc_constants.LPC_FILTERORDER + 1), ilbc_constants.SUBL, this.syntMem);
                i = 1;
                while (i < this.ULP_inst.nsub) {
                    this.syntFilter(data, i * ilbc_constants.SUBL, syntdenum, (i - 1) * (ilbc_constants.LPC_FILTERORDER + 1), ilbc_constants.SUBL, this.syntMem);
                    ++i;
                }
            } else if (this.ULP_inst.mode == 30) {
                i = 0;
                while (i < 2) {
                    this.syntFilter(data, i * ilbc_constants.SUBL, this.old_syntdenum, (i + this.ULP_inst.nsub - 2) * (ilbc_constants.LPC_FILTERORDER + 1), ilbc_constants.SUBL, this.syntMem);
                    ++i;
                }
                i = 2;
                while (i < this.ULP_inst.nsub) {
                    this.syntFilter(data, i * ilbc_constants.SUBL, syntdenum, (i - 2) * (ilbc_constants.LPC_FILTERORDER + 1), ilbc_constants.SUBL, this.syntMem);
                    ++i;
                }
            }
        } else {
            int lag = 20;
            float maxcc = this.xCorrCoef(decresidual, ilbc_constants.BLOCKL_MAX - ilbc_constants.ENH_BLOCKL, decresidual, ilbc_constants.BLOCKL_MAX - ilbc_constants.ENH_BLOCKL - lag, ilbc_constants.ENH_BLOCKL);
            int ilag = 21;
            while (ilag < 120) {
                float cc = this.xCorrCoef(decresidual, ilbc_constants.BLOCKL_MAX - ilbc_constants.ENH_BLOCKL, decresidual, ilbc_constants.BLOCKL_MAX - ilbc_constants.ENH_BLOCKL - ilag, ilbc_constants.ENH_BLOCKL);
                if (cc > maxcc) {
                    maxcc = cc;
                    lag = ilag;
                }
                ++ilag;
            }
            this.last_lag = lag;
            System.arraycopy(decresidual, 0, data, 0, this.ULP_inst.blockl);
            i = 0;
            while (i < this.ULP_inst.nsub) {
                this.syntFilter(data, i * ilbc_constants.SUBL, syntdenum, i * (ilbc_constants.LPC_FILTERORDER + 1), ilbc_constants.SUBL, this.syntMem);
                ++i;
            }
        }
        this.hpOutput(data, this.ULP_inst.blockl, decblock, this.hpomem);
        System.arraycopy(syntdenum, 0, this.old_syntdenum, 0, this.ULP_inst.nsub * (ilbc_constants.LPC_FILTERORDER + 1));
        this.prev_enh_pl = 0;
        if (mode == 0) {
            this.prev_enh_pl = 1;
        }
    }

    public ilbc_decoder(int init_mode, int init_enhancer) {
        this.ULP_inst = new ilbc_ulp(init_mode);
        this.syntMem = new float[ilbc_constants.LPC_FILTERORDER];
        this.prevLpc = new float[ilbc_constants.LPC_FILTERORDER + 1];
        this.prevResidual = new float[ilbc_constants.NSUB_MAX * ilbc_constants.SUBL];
        this.old_syntdenum = new float[(ilbc_constants.LPC_FILTERORDER + 1) * ilbc_constants.NSUB_MAX];
        this.hpomem = new float[4];
        this.enh_buf = new float[ilbc_constants.ENH_BUFL];
        this.enh_period = new float[ilbc_constants.ENH_NBLOCKS_TOT];
        this.lsfdeqold = new float[ilbc_constants.LPC_FILTERORDER];
        int li = 0;
        while (li < this.syntMem.length) {
            this.syntMem[li] = 0.0f;
            ++li;
        }
        System.arraycopy(ilbc_constants.lsfmeanTbl, 0, this.lsfdeqold, 0, ilbc_constants.LPC_FILTERORDER);
        li = 0;
        while (li < this.old_syntdenum.length) {
            this.old_syntdenum[li] = 0.0f;
            ++li;
        }
        li = 0;
        while (li < ilbc_constants.NSUB_MAX) {
            this.old_syntdenum[li * (ilbc_constants.LPC_FILTERORDER + 1)] = 1.0f;
            ++li;
        }
        this.last_lag = 20;
        this.prevLag = 120;
        this.per = 0.0f;
        this.consPLICount = 0;
        this.prevPLI = 0;
        this.prevLpc[0] = 1.0f;
        li = 1;
        while (li < this.prevLpc.length) {
            this.prevLpc[li] = 0.0f;
            ++li;
        }
        li = 0;
        while (li < this.prevResidual.length) {
            this.prevResidual[li] = 0.0f;
            ++li;
        }
        this.seed = 777L;
        li = 0;
        while (li < this.hpomem.length) {
            this.hpomem[li] = 0.0f;
            ++li;
        }
        this.use_enhancer = init_enhancer;
        li = 0;
        while (li < this.enh_buf.length) {
            this.enh_buf[li] = 0.0f;
            ++li;
        }
        li = 0;
        while (li < ilbc_constants.ENH_NBLOCKS_TOT) {
            this.enh_period[li] = 40.0f;
            ++li;
        }
        this.prev_enh_pl = 0;
    }
}

