/*
 * Decompiled with CFR 0.152.
 */
package local.ua.test;

import com.skype.Call;
import com.skype.CallListener;
import com.skype.CallStatusChangedListener;
import com.skype.NotAttachedException;
import com.skype.Skype;
import com.skype.SkypeException;
import com.skype.connector.Connector;
import local.ua.ConnectorDebugWriter;
import local.ua.SkypeUA;
import local.ua.test.Pinger;
import local.ua.util;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class SkypeConnectorReliabilityTest
implements CallListener,
CallStatusChangedListener {
    private Logger log = null;
    private String skypeUserId = null;
    private Call currentSkypeCall = null;
    private Call.Status curCallStatus = null;
    private long failcnt = 0L;

    public static void main(String[] args) {
        PropertyConfigurator.configure("log.properties");
        new SkypeConnectorReliabilityTest();
    }

    public SkypeConnectorReliabilityTest() {
        if (this.init()) {
            this.doTest();
        }
        this.cleanup();
        System.exit(0);
    }

    public boolean init() {
        this.log = Logger.getLogger(this.getClass().getName());
        int bits = SkypeConnectorReliabilityTest.getVMBitSize();
        this.log.info("Starting Connector Reliability Test ");
        this.log.info("os=" + System.getProperty("os.name") + " arch=" + System.getProperty("os.arch") + " ver=" + System.getProperty("os.version"));
        this.log.info("javaVer=" + System.getProperty("java.version") + " - " + System.getProperty("java.vendor") + " (" + bits + " bit)");
        this.log.debug("javaLibPath=" + System.getProperty("java.library.path"));
        this.log.debug("javaClassPath=" + System.getProperty("java.class.path"));
        if (bits == 64 && System.getProperty("os.name").toLowerCase().contains("windows") && (System.getenv("JAVAEXEPATH") == null || System.getenv("JAVAEXEPATH").length() == 0)) {
            this.log.warn("*********************************************************");
            this.log.warn("* WARNING: JAVAEXEPATH not set - Required for 64 bit VM *");
            this.log.warn("*********************************************************");
        }
        try {
            this.skypeUserId = this.initSkype();
            return true;
        }
        catch (Exception e) {
            this.log.error("initSkype failed", e);
            return false;
        }
    }

    private String initSkype() throws Exception {
        this.log.info("initSkype - If stuck, check Skype online & API auth");
        this.setupSkype();
        this.skypeUserId = Skype.getProfile().getId();
        this.log.info("Attached SkypeUserId:" + this.skypeUserId);
        return this.skypeUserId;
    }

    private void cleanup() {
        Skype.removeCallListener(this);
    }

    private void setupSkype() throws SkypeException {
        int retrycnt = 0;
        while (true) {
            try {
                Connector.getInstance().setDebugOut(new ConnectorDebugWriter());
                Connector.getInstance().setCommandTimeout(2000);
                Skype.setDebug(true);
                this.log.info("SkypeVer:" + Skype.getVersion());
            }
            catch (NotAttachedException e) {
                if (++retrycnt > 15) {
                    this.log.error("Connect attempt limit reached - exiting.", e);
                    System.exit(SkypeUA.ExitCode.STARTERROR.code());
                }
                String sStatus = Connector.getInstance().getStatus().name();
                this.log.info("Skype Status: " + sStatus + " - retrying every 5 seconds");
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception exception) {}
                continue;
            }
            catch (Throwable e) {
                this.log.fatal("skype4java connect error: ", e);
                System.exit(SkypeUA.ExitCode.SKYPE4JAVACONNECTERROR.code());
                continue;
            }
            break;
        }
        Skype.addCallListener(this);
    }

    public void callReceived(Call call) throws SkypeException {
        this.log.info("callReceived - incoming Skype Call from:" + call.getPartnerDisplayName() + " [" + call.getPartnerId() + "] status:" + (Object)((Object)call.getStatus()));
    }

    public void callMaked(Call call) throws SkypeException {
        this.log.info("callMaked: Skype " + (Object)((Object)call.getStatus()) + " id=" + call.getId());
        this.currentSkypeCall.addCallStatusChangedListener(this);
    }

    /*
     * Unable to fully structure code
     */
    public boolean lostSkypeConnection() {
        this.log.error("Lost Skype client connection - reconnecting.");
        retries = 0;
        while (retries++ < 5) {
            try {
                this.skypeUserId = Skype.getProfile().getId();
                this.log.info("Reconnected to Skype client.");
                return true;
            }
            catch (NotAttachedException e) {
                try {
                    Thread.sleep(3000L);
                }
                catch (Exception var3_4) {}
            }
            ** finally { 
lbl13:
            // 1 sources

        }
        return false;
    }

    private static int getVMBitSize() {
        String dmBits = System.getProperty("sun.arch.data.model", "novalue");
        if (dmBits.equals("32")) {
            return 32;
        }
        if (dmBits.equals("64")) {
            return 64;
        }
        if (dmBits.equals("novalue") && System.getProperty("java.vm.name").indexOf("64") >= 0) {
            return 64;
        }
        return 32;
    }

    public void statusChanged(Call.Status status) throws SkypeException {
        this.curCallStatus = status;
        if (status == Call.Status.FINISHED || status == Call.Status.CANCELLED || status == Call.Status.MISSED || status == Call.Status.REFUSED || status == Call.Status.FAILED || status == Call.Status.UNPLACED || status == Call.Status.BUSY) {
            this.log.info("skypeCallStatus - Complete: " + (Object)((Object)status));
            this.currentSkypeCall.removeCallStatusChangedListener(this);
            this.currentSkypeCall = null;
        } else if (status == Call.Status.EARLYMEDIA) {
            this.log.info("skypeCallStatus - " + (Object)((Object)status));
        } else if (status == Call.Status.INPROGRESS) {
            this.log.info("skypeCallStatus - " + (Object)((Object)status));
        } else if (status == Call.Status.LOCALHOLD) {
            this.log.info("skypeCallStatus - " + (Object)((Object)status));
        } else if (status == Call.Status.REMOTEHOLD) {
            this.log.info("skypeCallStatus - " + (Object)((Object)status));
        } else if (status == Call.Status.ROUTING || status == Call.Status.RINGING) {
            this.log.info("skypeCallStatus - " + (Object)((Object)status));
        } else {
            this.log.info("skypeCallStatus - " + (Object)((Object)status));
        }
    }

    private boolean loadSkypeCallHistory() {
        this.log.info("Loading Skype PSTN Call History");
        String callsResp = util.parseSkypeResponse("SEARCH CALLS", "CALLS");
        this.log.debug("CallsList:" + callsResp);
        if (callsResp.trim().length() == 0) {
            this.log.info("0 possible calls in history.");
            return true;
        }
        String[] calls = callsResp.split(",");
        this.log.info(String.valueOf(calls.length) + " calls in history.");
        int x = 0;
        while (x < calls.length) {
            String curId = calls[x].trim();
            if (curId.length() > 0) {
                long unixStamp = -1L;
                try {
                    Call.Type callType;
                    String callId = util.parseSkypeResponse("GET CALL " + curId + " TIMESTAMP", "CALL " + curId + " TIMESTAMP").trim();
                    unixStamp = Long.parseLong(callId);
                    if (unixStamp > 0L && (callType = Call.Type.valueOf(util.parseSkypeResponse("GET CALL " + curId + " TYPE", "CALL " + curId + " TYPE"))) == Call.Type.OUTGOING_PSTN) {
                        long durationSeconds = Long.parseLong(util.parseSkypeResponse("GET CALL " + curId + " DURATION", "CALL " + curId + " DURATION"));
                        String string = util.parseSkypeResponse("GET CALL " + curId + " PARTNER_HANDLE", "CALL " + curId + " PARTNER_HANDLE");
                    }
                }
                catch (Exception e) {
                    this.log.error("History Load Error: Skype CallId=" + curId, e);
                    return false;
                }
            }
            ++x;
        }
        return true;
    }

    private boolean isSkypeCallClosed(Call.Status status) {
        return status == Call.Status.MISSED || status == Call.Status.CANCELLED || status == Call.Status.FAILED || status == Call.Status.FINISHED || status == Call.Status.BUSY || status == Call.Status.REFUSED || status == Call.Status.UNPLACED;
    }

    private void doTest() {
        int maxTests = 999999999;
        int testcnt = 0;
        this.log.info("Testing - press a key to exit");
        while (!this.keyPressed() || testcnt >= maxTests) {
            ++testcnt;
            Pinger pinger = new Pinger();
            pinger.start();
            int x = 0;
            while (x < 5) {
                if (!this.loadSkypeCallHistory()) {
                    this.log.error("FAILED HISTORY LOAD TEST");
                    ++this.failcnt;
                }
                try {
                    this.log.info("ver:" + Skype.getVersion());
                }
                catch (Exception e) {
                    this.log.error("FAILED", e);
                    ++this.failcnt;
                }
                ++x;
            }
            pinger.halt();
            this.log.info("Complete Pass: " + testcnt + " failcnt=" + this.failcnt);
            try {
                Thread.sleep(5000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean makeTestCall(String dest) {
        boolean retvar = false;
        this.curCallStatus = null;
        this.log.info("Calling: " + dest);
        try {
            this.currentSkypeCall = Skype.call(dest);
        }
        catch (Exception e) {
            this.log.error("FAIL:", e);
        }
        if (this.currentSkypeCall != null) {
            try {
                this.curCallStatus = this.currentSkypeCall.getStatus();
                int wait = 0;
                int connectLimit = 15;
                while (wait++ < connectLimit) {
                    if (this.curCallStatus == Call.Status.INPROGRESS) {
                        this.log.info("OnCall with:" + this.currentSkypeCall.getPartnerId());
                        int connwait = 0;
                        while (this.curCallStatus == Call.Status.INPROGRESS && connwait++ < 10) {
                            Thread.sleep(2000L);
                        }
                        if (this.curCallStatus == Call.Status.INPROGRESS) {
                            this.currentSkypeCall.cancel();
                            int cancelcnt = 0;
                            while (this.curCallStatus == Call.Status.INPROGRESS && cancelcnt++ < 2) {
                                Thread.sleep(2000L);
                            }
                            if (cancelcnt >= 2) {
                                this.log.info("Call did not end within time limit");
                                break;
                            }
                            this.log.info("CallEnded");
                            this.currentSkypeCall = null;
                            retvar = true;
                            break;
                        }
                        this.log.info("Call was cut off prematurely");
                        continue;
                    }
                    Thread.sleep(2000L);
                }
                if (this.currentSkypeCall != null) {
                    this.currentSkypeCall.cancel();
                }
                if (wait >= connectLimit) {
                    this.log.info("Call did not connect within time limit");
                }
            }
            catch (Exception e) {
                this.log.error("Error", e);
            }
        }
        return retvar;
    }

    private boolean keyPressed() {
        boolean retvar = false;
        try {
            if (System.in.available() > 0) {
                retvar = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retvar;
    }
}

