/*
 * Decompiled with CFR 0.152.
 */
package org.zoolu.net;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;

public class IpAddress {
    String address;
    InetAddress inet_address;

    IpAddress(InetAddress iaddress) {
        this.init(null, iaddress);
    }

    private void init(String address, InetAddress iaddress) {
        this.address = address;
        this.inet_address = iaddress;
    }

    public InetAddress getInetAddress() {
        if (this.inet_address == null) {
            try {
                this.inet_address = InetAddress.getByName(this.address);
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return this.inet_address;
    }

    public IpAddress(String address) {
        this.init(address, null);
    }

    public IpAddress(IpAddress ipaddr) {
        this.init(ipaddr.address, ipaddr.inet_address);
    }

    public Object clone() {
        return new IpAddress(this);
    }

    public boolean equals(Object obj) {
        try {
            IpAddress ipaddr = (IpAddress)obj;
            return this.toString().equals(ipaddr.toString());
        }
        catch (Exception e) {
            return false;
        }
    }

    public String toString() {
        if (this.address == null && this.inet_address != null) {
            this.address = this.inet_address.getHostAddress();
        }
        return this.address;
    }

    public static IpAddress getByName(String host_addr) throws UnknownHostException {
        InetAddress iaddr = InetAddress.getByName(host_addr);
        return new IpAddress(iaddr);
    }

    public static IpAddress getLocalHostAddress() {
        String localIP = "127.0.0.1";
        try {
            localIP = InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Enumeration<NetworkInterface> nis = null;
        try {
            nis = NetworkInterface.getNetworkInterfaces();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (nis != null) {
            boolean gotit = false;
            while (nis.hasMoreElements() && !gotit) {
                NetworkInterface ni = nis.nextElement();
                Enumeration<InetAddress> ias = ni.getInetAddresses();
                while (ias.hasMoreElements() && !gotit) {
                    InetAddress ia = ias.nextElement();
                    String ha = ia.getHostAddress();
                    if (ha.startsWith("127.") || !ha.matches("\\d+\\.\\d+\\.\\d+\\.\\d+")) continue;
                    localIP = ha;
                    if (ha.startsWith("169.254.")) continue;
                    gotit = true;
                }
            }
        }
        return new IpAddress(localIP);
    }
}

