/*
 * Decompiled with CFR 0.152.
 */
package org.zoolu.net;

import org.zoolu.net.IpAddress;

public class SocketAddress {
    IpAddress ipaddr;
    int port;

    public SocketAddress(IpAddress ipaddr, int port) {
        this.init(ipaddr, port);
    }

    public SocketAddress(String addr, int port) {
        this.init(new IpAddress(addr), port);
    }

    public SocketAddress(String soaddr) {
        String addr = null;
        int port = -1;
        int colon = soaddr.indexOf(58);
        if (colon < 0) {
            addr = soaddr;
        } else {
            addr = soaddr.substring(0, colon);
            try {
                port = Integer.parseInt(soaddr.substring(colon + 1));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.init(new IpAddress(addr), port);
    }

    public SocketAddress(SocketAddress soaddr) {
        this.init(soaddr.ipaddr, soaddr.port);
    }

    private void init(IpAddress ipaddr, int port) {
        this.ipaddr = ipaddr;
        this.port = port;
    }

    public IpAddress getAddress() {
        return this.ipaddr;
    }

    public int getPort() {
        return this.port;
    }

    public Object clone() {
        return new SocketAddress(this);
    }

    public boolean equals(Object obj) {
        SocketAddress saddr;
        block3: {
            try {
                saddr = (SocketAddress)obj;
                if (this.port == saddr.port) break block3;
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        return this.ipaddr.equals(saddr.ipaddr);
    }

    public String toString() {
        return String.valueOf(this.ipaddr.toString()) + ":" + this.port;
    }
}

