/*
 * Decompiled with CFR 0.152.
 */
package org.zoolu.net;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import org.zoolu.net.IpAddress;
import org.zoolu.net.TcpConnectionListener;
import org.zoolu.net.TcpSocket;

public class TcpConnection
extends Thread {
    static final int BUFFER_SIZE = 65535;
    public static final int DEFAULT_SOCKET_TIMEOUT = 2000;
    TcpSocket socket;
    int socket_timeout;
    long alive_time;
    InputStream istream;
    OutputStream ostream;
    Exception error;
    boolean stop;
    boolean is_running;
    TcpConnectionListener listener;

    public TcpConnection(TcpSocket socket, TcpConnectionListener listener) {
        this.init(socket, 0L, listener);
        this.start();
    }

    public TcpConnection(TcpSocket socket, long alive_time, TcpConnectionListener listener) {
        this.init(socket, alive_time, listener);
        this.start();
    }

    private void init(TcpSocket socket, long alive_time, TcpConnectionListener listener) {
        this.setName(String.valueOf(this.getClass().getName()) + ".T" + this.getName().replaceAll("Thread-", ""));
        this.listener = listener;
        this.socket = socket;
        this.socket_timeout = 2000;
        this.alive_time = alive_time;
        this.stop = false;
        this.is_running = true;
        this.istream = null;
        this.ostream = null;
        this.error = null;
        try {
            this.istream = new BufferedInputStream(socket.getInputStream());
            this.ostream = new BufferedOutputStream(socket.getOutputStream());
        }
        catch (Exception e) {
            this.error = e;
        }
    }

    public boolean isRunning() {
        return this.is_running;
    }

    public TcpSocket getSocket() {
        return this.socket;
    }

    public IpAddress getRemoteAddress() {
        return this.socket.getAddress();
    }

    public int getRemotePort() {
        return this.socket.getPort();
    }

    public void halt() {
        this.stop = true;
    }

    public void send(byte[] buff, int offset, int len) throws IOException {
        if (!this.stop && this.ostream != null) {
            this.ostream.write(buff, offset, len);
            this.ostream.flush();
        }
    }

    public void send(byte[] buff) throws IOException {
        this.send(buff, 0, buff.length);
    }

    public void run() {
        byte[] buff = new byte[65535];
        long expire = 0L;
        if (this.alive_time > 0L) {
            expire = System.currentTimeMillis() + this.alive_time;
        }
        try {
            if (this.error != null) {
                throw this.error;
            }
            this.socket.setSoTimeout(this.socket_timeout);
            while (!this.stop) {
                int len = 0;
                if (this.istream != null) {
                    try {
                        len = this.istream.read(buff);
                    }
                    catch (InterruptedIOException ie) {
                        if (this.alive_time <= 0L || System.currentTimeMillis() <= expire) continue;
                        this.halt();
                        continue;
                    }
                }
                if (len < 0) {
                    this.stop = true;
                    continue;
                }
                if (len <= 0) continue;
                if (this.listener != null) {
                    this.listener.onReceivedData(this, buff, len);
                }
                if (this.alive_time <= 0L) continue;
                expire = System.currentTimeMillis() + this.alive_time;
            }
        }
        catch (Exception e) {
            this.error = e;
            this.stop = true;
        }
        this.is_running = false;
        if (this.istream != null) {
            try {
                this.istream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.ostream != null) {
            try {
                this.ostream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.listener != null) {
            this.listener.onConnectionTerminated(this, this.error);
        }
        this.listener = null;
    }

    public String toString() {
        return "tcp:" + this.socket.getLocalAddress() + ":" + this.socket.getLocalPort() + "<->" + this.socket.getAddress() + ":" + this.socket.getPort();
    }
}

