/*
 * Decompiled with CFR 0.152.
 */
package org.zoolu.net;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import org.zoolu.net.IpAddress;
import org.zoolu.net.TcpServerListener;
import org.zoolu.net.TcpSocket;

public class TcpServer
extends Thread {
    public static final int DEFAULT_SOCKET_TIMEOUT = 5000;
    static int socket_backlog = 50;
    ServerSocket server_socket;
    int socket_timeout;
    long alive_time;
    boolean stop;
    boolean is_running;
    TcpServerListener listener;

    public TcpServer(int port, TcpServerListener listener) throws IOException {
        this.init(port, null, 0L, listener);
        this.start();
    }

    public TcpServer(int port, IpAddress bind_ipaddr, TcpServerListener listener) throws IOException {
        this.init(port, bind_ipaddr, 0L, listener);
        this.start();
    }

    public TcpServer(int port, IpAddress bind_ipaddr, long alive_time, TcpServerListener listener) throws IOException {
        this.init(port, bind_ipaddr, alive_time, listener);
        this.start();
    }

    private void init(int port, IpAddress bind_ipaddr, long alive_time, TcpServerListener listener) throws IOException {
        this.setName(String.valueOf(this.getClass().getName()) + ".T" + this.getName().replaceAll("Thread-", ""));
        this.listener = listener;
        this.server_socket = bind_ipaddr == null ? new ServerSocket(port) : new ServerSocket(port, socket_backlog, bind_ipaddr.getInetAddress());
        this.socket_timeout = 5000;
        this.alive_time = alive_time;
        this.stop = false;
        this.is_running = true;
    }

    public boolean isRunning() {
        return this.is_running;
    }

    public void halt() {
        this.stop = true;
        int waitcnt = 0;
        while (this.is_running && waitcnt++ < this.socket_timeout / 500 + 4) {
            try {
                TcpServer.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.server_socket != null) {
            try {
                this.server_socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void run() {
        Exception error = null;
        try {
            this.server_socket.setSoTimeout(this.socket_timeout);
            long expire = 0L;
            if (this.alive_time > 0L) {
                expire = System.currentTimeMillis() + this.alive_time;
            }
            while (!this.stop) {
                TcpSocket socket = null;
                try {
                    socket = new TcpSocket(this.server_socket.accept());
                }
                catch (InterruptedIOException ie) {
                    if (this.alive_time <= 0L || System.currentTimeMillis() <= expire) continue;
                    this.halt();
                    continue;
                }
                if (this.listener != null) {
                    this.listener.onIncomingConnection(this, socket);
                }
                if (this.alive_time <= 0L) continue;
                expire = System.currentTimeMillis() + this.alive_time;
            }
        }
        catch (Exception e) {
            error = e;
            this.stop = true;
        }
        this.is_running = false;
        try {
            this.server_socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.server_socket = null;
        if (this.listener != null) {
            this.listener.onServerTerminated(this, error);
        }
        this.listener = null;
    }

    public String toString() {
        return "tcp:" + this.server_socket.getInetAddress() + ":" + this.server_socket.getLocalPort();
    }
}

