/*
 * Decompiled with CFR 0.152.
 */
package org.zoolu.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import org.zoolu.net.IpAddress;

public class TcpSocket {
    Socket socket;

    TcpSocket() {
        this.socket = null;
    }

    TcpSocket(Socket sock) {
        this.socket = sock;
    }

    public TcpSocket(String host, int port) throws IOException {
        this.socket = new Socket(host, port);
    }

    public TcpSocket(String host, int port, IpAddress local_ipaddr, int local_port) throws IOException {
        this.socket = new Socket(host, port, local_ipaddr.getInetAddress(), local_port);
    }

    public TcpSocket(IpAddress ipaddr, int port) throws IOException {
        this.socket = new Socket(ipaddr.getInetAddress(), port);
    }

    public TcpSocket(IpAddress ipaddr, int port, IpAddress local_ipaddr, int local_port) throws IOException {
        this.socket = new Socket(ipaddr.getInetAddress(), port, local_ipaddr.getInetAddress(), local_port);
    }

    public void close() throws IOException {
        this.socket.close();
    }

    public IpAddress getAddress() {
        return new IpAddress(this.socket.getInetAddress());
    }

    public InputStream getInputStream() throws IOException {
        return this.socket.getInputStream();
    }

    public IpAddress getLocalAddress() {
        return new IpAddress(this.socket.getLocalAddress());
    }

    public int getLocalPort() {
        return this.socket.getLocalPort();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.socket.getOutputStream();
    }

    public int getPort() {
        return this.socket.getPort();
    }

    public int getSoTimeout() throws SocketException {
        return this.socket.getSoTimeout();
    }

    public void setSoTimeout(int timeout) throws SocketException {
        this.socket.setSoTimeout(timeout);
    }

    public String toString() {
        return this.socket.toString();
    }
}

