/*
 * Decompiled with CFR 0.152.
 */
package org.zoolu.net;

import java.net.DatagramPacket;
import org.zoolu.net.IpAddress;

public class UdpPacket {
    DatagramPacket packet;

    UdpPacket(DatagramPacket packet) {
        this.packet = packet;
    }

    DatagramPacket getDatagramPacket() {
        return this.packet;
    }

    void setDatagramPacket(DatagramPacket packet) {
        this.packet = packet;
    }

    public UdpPacket(byte[] buf, int length) {
        this.packet = new DatagramPacket(buf, length);
    }

    public UdpPacket(byte[] buf, int length, IpAddress ipaddr, int port) {
        this.packet = new DatagramPacket(buf, length, ipaddr.getInetAddress(), port);
    }

    public UdpPacket(byte[] buf, int offset, int length) {
        this.packet = new DatagramPacket(buf, offset, length);
    }

    public UdpPacket(byte[] buf, int offset, int length, IpAddress ipaddr, int port) {
        this.packet = new DatagramPacket(buf, offset, length, ipaddr.getInetAddress(), port);
    }

    public IpAddress getIpAddress() {
        return new IpAddress(this.packet.getAddress());
    }

    public byte[] getData() {
        return this.packet.getData();
    }

    public int getLength() {
        return this.packet.getLength();
    }

    public int getOffset() {
        return this.packet.getOffset();
    }

    public int getPort() {
        return this.packet.getPort();
    }

    public void setIpAddress(IpAddress ipaddr) {
        this.packet.setAddress(ipaddr.getInetAddress());
    }

    public void setData(byte[] buf) {
        this.packet.setData(buf);
    }

    public void setData(byte[] buf, int offset, int length) {
        this.packet.setData(buf, offset, length);
    }

    public void setLength(int length) {
        this.packet.setLength(length);
    }

    public void setPort(int iport) {
        this.packet.setPort(iport);
    }
}

