/*
 * Decompiled with CFR 0.152.
 */
package org.zoolu.net;

import java.io.IOException;
import java.io.InterruptedIOException;
import org.zoolu.net.UdpPacket;
import org.zoolu.net.UdpProviderListener;
import org.zoolu.net.UdpSocket;

public class UdpProvider
extends Thread {
    public static final int BUFFER_SIZE = 65535;
    public static final int DEFAULT_SOCKET_TIMEOUT = 2000;
    UdpSocket socket;
    int socket_timeout;
    long alive_time;
    int minimum_length;
    boolean stop;
    boolean is_running;
    UdpProviderListener listener;

    public UdpProvider(UdpSocket socket, UdpProviderListener listener) {
        this.init(socket, 0L, listener);
        this.start();
    }

    public UdpProvider(UdpSocket socket, long alive_time, UdpProviderListener listener) {
        this.init(socket, alive_time, listener);
        this.start();
    }

    private void init(UdpSocket socket, long alive_time, UdpProviderListener listener) {
        this.setName(String.valueOf(this.getClass().getName()) + ".T" + this.getName().replaceAll("Thread-", ""));
        this.listener = listener;
        this.socket = socket;
        this.socket_timeout = 2000;
        this.alive_time = alive_time;
        this.minimum_length = 0;
        this.stop = false;
        this.is_running = true;
    }

    public UdpSocket getUdpSocket() {
        return this.socket;
    }

    public boolean isRunning() {
        return this.is_running;
    }

    public void setSoTimeout(int timeout) {
        this.socket_timeout = timeout;
    }

    public int getSoTimeout() {
        return this.socket_timeout;
    }

    public void setMinimumReceivedDataLength(int len) {
        this.minimum_length = len;
    }

    public int getMinimumReceivedDataLength() {
        return this.minimum_length;
    }

    public void send(UdpPacket packet) throws IOException {
        if (!this.stop) {
            this.socket.send(packet);
        }
    }

    public void halt() {
        this.stop = true;
        int waitcnt = 0;
        while (this.is_running && waitcnt++ < this.socket_timeout / 500 + 4) {
            try {
                UdpProvider.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.socket != null) {
            this.socket.close();
        }
    }

    public void run() {
        byte[] buf = new byte[65535];
        UdpPacket packet = new UdpPacket(buf, buf.length);
        Exception error = null;
        long expire = 0L;
        if (this.alive_time > 0L) {
            expire = System.currentTimeMillis() + this.alive_time;
        }
        try {
            this.socket.setSoTimeout(this.socket_timeout);
            while (!this.stop) {
                try {
                    this.socket.receive(packet);
                }
                catch (InterruptedIOException ie) {
                    if (this.alive_time <= 0L || System.currentTimeMillis() <= expire) continue;
                    this.halt();
                    continue;
                }
                if (packet.getLength() >= this.minimum_length) {
                    if (this.listener != null) {
                        this.listener.onReceivedPacket(this, packet);
                    }
                    if (this.alive_time > 0L) {
                        expire = System.currentTimeMillis() + this.alive_time;
                    }
                }
                packet = new UdpPacket(buf, buf.length);
            }
        }
        catch (Exception e) {
            error = e;
            this.stop = true;
        }
        this.is_running = false;
        if (this.listener != null) {
            this.listener.onServiceTerminated(this, error);
        }
        this.listener = null;
    }

    public String toString() {
        return "udp:" + this.socket.getLocalAddress() + ":" + this.socket.getLocalPort();
    }
}

