/*
 * Decompiled with CFR 0.152.
 */
package org.zoolu.net;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import org.zoolu.net.IpAddress;
import org.zoolu.net.UdpPacket;

public class UdpSocket {
    DatagramSocket socket;

    public UdpSocket() throws SocketException {
        this.socket = new DatagramSocket();
    }

    public UdpSocket(int port) throws SocketException {
        this.socket = new DatagramSocket(port);
    }

    UdpSocket(DatagramSocket sock) {
        this.socket = sock;
    }

    public UdpSocket(int port, IpAddress ipaddr) throws SocketException {
        this.socket = new DatagramSocket(port, ipaddr.getInetAddress());
    }

    public void close() {
        this.socket.close();
    }

    public IpAddress getLocalAddress() {
        return new IpAddress(this.socket.getInetAddress());
    }

    public int getLocalPort() {
        return this.socket.getLocalPort();
    }

    public int getSoTimeout() throws SocketException {
        return this.socket.getSoTimeout();
    }

    public void setSoTimeout(int timeout) throws SocketException {
        this.socket.setSoTimeout(timeout);
    }

    public void receive(UdpPacket pkt) throws IOException {
        DatagramPacket dgram = pkt.getDatagramPacket();
        this.socket.receive(dgram);
        pkt.setDatagramPacket(dgram);
    }

    public void send(UdpPacket pkt) throws IOException {
        this.socket.send(pkt.getDatagramPacket());
    }

    public String toString() {
        return this.socket.toString();
    }
}

