/*
 * Decompiled with CFR 0.152.
 */
package org.zoolu.sdp;

import org.zoolu.sdp.SdpField;
import org.zoolu.tools.Parser;

public class ConnectionField
extends SdpField {
    public ConnectionField(String connection_field) {
        super('c', connection_field);
    }

    public ConnectionField(String address_type, String address, int ttl, int num) {
        super('c', null);
        this.value = "IN " + address_type + " " + address;
        if (ttl > 0) {
            this.value = String.valueOf(this.value) + "/" + ttl;
        }
        if (num > 0) {
            this.value = String.valueOf(this.value) + "/" + num;
        }
    }

    public ConnectionField(String address_type, String address) {
        super('c', "IN " + address_type + " " + address);
    }

    public ConnectionField(SdpField sf) {
        super(sf);
    }

    public String getAddressType() {
        String type = new Parser(this.value).skipString().getString();
        return type;
    }

    public String getAddress() {
        String address = new Parser(this.value).skipString().skipString().getString();
        int i = address.indexOf("/");
        if (i < 0) {
            return address;
        }
        return address.substring(0, i);
    }

    public int getTTL() {
        String address = new Parser(this.value).skipString().skipString().getString();
        int i = address.indexOf("/");
        if (i < 0) {
            return 0;
        }
        int j = address.indexOf("/", i);
        if (j < 0) {
            return Integer.parseInt(address.substring(i));
        }
        return Integer.parseInt(address.substring(i, j));
    }

    public int getNum() {
        String address = new Parser(this.value).skipString().skipString().getString();
        int i = address.indexOf("/");
        if (i < 0) {
            return 0;
        }
        int j = address.indexOf("/", i);
        if (j < 0) {
            return 0;
        }
        return Integer.parseInt(address.substring(j));
    }
}

