/*
 * Decompiled with CFR 0.152.
 */
package org.zoolu.sdp;

import java.util.Vector;
import org.zoolu.sdp.AttributeField;
import org.zoolu.sdp.ConnectionField;
import org.zoolu.sdp.MediaField;

public class MediaDescriptor {
    MediaField m;
    ConnectionField c;
    Vector av;

    public MediaDescriptor(MediaDescriptor md) {
        this.m = new MediaField(md.m);
        this.c = md.c != null ? new ConnectionField(md.c) : null;
        this.av = new Vector();
        int i = 0;
        while (i < md.av.size()) {
            this.av.addElement(new AttributeField((AttributeField)md.av.elementAt(i)));
            ++i;
        }
    }

    public MediaDescriptor(MediaField media, ConnectionField connection) {
        this.m = media;
        this.c = connection;
        this.av = new Vector();
    }

    public MediaDescriptor(MediaField media, ConnectionField connection, AttributeField attribute) {
        this.m = media;
        this.c = connection;
        this.av = new Vector();
        if (attribute != null) {
            this.av.addElement(attribute);
        }
    }

    public MediaDescriptor(MediaField media, ConnectionField connection, Vector attributes) {
        this.m = media;
        this.c = connection;
        this.av = new Vector(attributes.size());
        this.av.setSize(attributes.size());
        int i = 0;
        while (i < attributes.size()) {
            this.av.setElementAt((AttributeField)attributes.elementAt(i), i);
            ++i;
        }
    }

    public MediaDescriptor(String media, String connection, String attribute) {
        this.m = new MediaField(media);
        if (connection != null) {
            this.c = new ConnectionField(connection);
        }
        this.av = new Vector();
        if (attribute != null) {
            this.av.addElement(new AttributeField(attribute));
        }
    }

    public MediaField getMedia() {
        return this.m;
    }

    public ConnectionField getConnection() {
        return this.c;
    }

    public Vector getAttributes() {
        Vector<AttributeField> v = new Vector<AttributeField>(this.av.size());
        int i = 0;
        while (i < this.av.size()) {
            v.addElement((AttributeField)this.av.elementAt(i));
            ++i;
        }
        return v;
    }

    public MediaDescriptor addAttribute(AttributeField attribute) {
        this.av.addElement(new AttributeField(attribute));
        return this;
    }

    public boolean hasAttribute(String a_name) {
        int i = 0;
        while (i < this.av.size()) {
            if (((AttributeField)this.av.elementAt(i)).getAttributeName().equals(a_name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public AttributeField getAttribute(String a_name) {
        int i = 0;
        while (i < this.av.size()) {
            AttributeField a = (AttributeField)this.av.elementAt(i);
            if (a.getAttributeName().equals(a_name)) {
                return a;
            }
            ++i;
        }
        return null;
    }

    public Vector getAttributes(String a_name) {
        Vector<AttributeField> v = new Vector<AttributeField>(this.av.size());
        int i = 0;
        while (i < this.av.size()) {
            AttributeField a = (AttributeField)this.av.elementAt(i);
            if (a.getAttributeName().equals(a_name)) {
                v.addElement(a);
            }
            ++i;
        }
        return v;
    }

    public boolean removeAttributeField(String a_name, String value) {
        int i = 0;
        while (i < this.av.size()) {
            AttributeField a = (AttributeField)this.av.elementAt(i);
            if (a.getAttributeName().equals(a_name) && a.getAttributeValue().equals(value)) {
                this.av.remove(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean removeAllAttributeFields() {
        this.av.clear();
        return true;
    }

    public String toString() {
        String str = "";
        str = String.valueOf(str) + this.m;
        if (this.c != null) {
            str = String.valueOf(str) + this.c;
        }
        int i = 0;
        while (i < this.av.size()) {
            str = String.valueOf(str) + (AttributeField)this.av.elementAt(i);
            ++i;
        }
        return str;
    }
}

