/*
 * Decompiled with CFR 0.152.
 */
package org.zoolu.sdp;

import java.util.Vector;
import org.zoolu.sdp.SdpField;
import org.zoolu.tools.Parser;

public class MediaField
extends SdpField {
    public MediaField(String media_field) {
        super('m', media_field);
    }

    public MediaField(String media, int port, int num, String transport, String formats) {
        super('m', null);
        this.value = String.valueOf(media) + " " + port;
        if (num > 0) {
            this.value = String.valueOf(this.value) + "/" + num;
        }
        this.value = String.valueOf(this.value) + " " + transport + " " + formats;
    }

    public MediaField(String media, int port, int num, String transport, Vector formatlist) {
        super('m', null);
        this.value = String.valueOf(media) + " " + port;
        if (num > 0) {
            this.value = String.valueOf(this.value) + "/" + num;
        }
        this.value = String.valueOf(this.value) + " " + transport;
        int i = 0;
        while (i < formatlist.size()) {
            this.value = String.valueOf(this.value) + " " + formatlist.elementAt(i);
            ++i;
        }
    }

    public MediaField(SdpField sf) {
        super(sf);
    }

    public String getMedia() {
        return new Parser(this.value).getString();
    }

    public int getPort() {
        String port = new Parser(this.value).skipString().getString();
        int i = port.indexOf(47);
        if (i < 0) {
            return Integer.parseInt(port);
        }
        return Integer.parseInt(port.substring(0, i));
    }

    public String getTransport() {
        return new Parser(this.value).skipString().skipString().getString();
    }

    public String getFormats() {
        return new Parser(this.value).skipString().skipString().skipString().skipWSP().getRemainingString();
    }

    public Vector getFormatList() {
        Vector<String> formatlist = new Vector<String>();
        Parser par = new Parser(this.value);
        par.skipString().skipString().skipString();
        while (par.hasMore()) {
            String fmt = par.getString();
            if (fmt == null || fmt.length() <= 0) continue;
            formatlist.addElement(fmt);
        }
        return formatlist;
    }

    public MediaField removeAllFormats() {
        String formats = this.getFormats();
        this.value = this.value.replaceAll(String.valueOf(formats) + "$", "").trim();
        return this;
    }

    public void removeFormat(String format) {
        String formats = this.getFormats();
        this.removeAllFormats();
        formats = formats.replaceAll("\\b" + format + "\\b", "").replace("  ", " ").trim();
        if (formats.length() > 0) {
            this.value = String.valueOf(this.value) + " " + formats;
        }
    }

    public MediaField appendFormat(String format) {
        this.value = String.valueOf(this.value) + " " + format;
        return this;
    }
}

