/*
 * Decompiled with CFR 0.152.
 */
package org.zoolu.sdp;

import java.util.Vector;
import org.zoolu.sdp.AttributeField;
import org.zoolu.sdp.ConnectionField;
import org.zoolu.sdp.MediaDescriptor;
import org.zoolu.sdp.MediaField;
import org.zoolu.sdp.OriginField;
import org.zoolu.sdp.SdpField;
import org.zoolu.sdp.SessionNameField;
import org.zoolu.sdp.TimeField;
import org.zoolu.tools.Parser;

class SdpParser
extends Parser {
    public SdpParser(String s) {
        super(s);
    }

    public SdpParser(String s, int i) {
        super(s, i);
    }

    public SdpField parseSdpField() {
        String value;
        int LF;
        int begin = this.index;
        while (begin >= 0 && begin < this.str.length() - 1 && this.str.charAt(begin + 1) != '=') {
            begin = this.str.indexOf("\n", begin);
        }
        if (begin < 0) {
            return null;
        }
        char type = this.str.charAt(begin);
        int end = this.str.length();
        int CR = this.str.indexOf(13, begin += 2);
        if (CR > 0 && CR < end) {
            end = CR;
        }
        if ((LF = this.str.indexOf(10, begin)) > 0 && LF < end) {
            end = LF;
        }
        if ((value = this.str.substring(begin, end).trim()) == null) {
            return null;
        }
        this.setPos(end);
        this.goToNextLine();
        return new SdpField(type, value);
    }

    public SdpField parseSdpField(char type) {
        int begin = 0;
        if (!this.str.startsWith(String.valueOf(type) + "=", this.index)) {
            begin = this.str.indexOf("\n" + type + "=", this.index);
            if (begin < 0) {
                return null;
            }
            this.index = begin + 1;
        }
        return this.parseSdpField();
    }

    public OriginField parseOriginField() {
        SdpField sf = this.parseSdpField('o');
        if (sf != null) {
            return new OriginField(sf);
        }
        return null;
    }

    public MediaField parseMediaField() {
        SdpField sf = this.parseSdpField('m');
        if (sf != null) {
            return new MediaField(sf);
        }
        return null;
    }

    public ConnectionField parseConnectionField() {
        SdpField sf = this.parseSdpField('c');
        if (sf != null) {
            return new ConnectionField(sf);
        }
        return null;
    }

    public SessionNameField parseSessionNameField() {
        SdpField sf = this.parseSdpField('s');
        if (sf != null) {
            return new SessionNameField(sf);
        }
        return null;
    }

    public TimeField parseTimeField() {
        SdpField sf = this.parseSdpField('t');
        if (sf != null) {
            return new TimeField(sf);
        }
        return null;
    }

    public AttributeField parseAttributeField() {
        SdpField sf = this.parseSdpField('a');
        if (sf != null) {
            return new AttributeField(sf);
        }
        return null;
    }

    public MediaDescriptor parseMediaDescriptor() {
        MediaField m = this.parseMediaField();
        if (m == null) {
            return null;
        }
        int begin = this.index;
        int end = this.str.indexOf("\nm", begin);
        end = end < 0 ? this.str.length() : ++end;
        this.index = end;
        SdpParser par = new SdpParser(this.str.substring(begin, end));
        ConnectionField c = par.parseConnectionField();
        Vector<AttributeField> av = new Vector<AttributeField>();
        AttributeField a = par.parseAttributeField();
        while (a != null) {
            av.addElement(a);
            a = par.parseAttributeField();
        }
        return new MediaDescriptor(m, c, av);
    }
}

