/*
 * Decompiled with CFR 0.152.
 */
package org.zoolu.sdp;

import java.util.Vector;
import org.zoolu.sdp.AttributeField;
import org.zoolu.sdp.ConnectionField;
import org.zoolu.sdp.MediaDescriptor;
import org.zoolu.sdp.MediaField;
import org.zoolu.sdp.OriginField;
import org.zoolu.sdp.SdpField;
import org.zoolu.sdp.SdpParser;
import org.zoolu.sdp.SessionNameField;
import org.zoolu.sdp.TimeField;

public class SessionDescriptor {
    SdpField v;
    OriginField o;
    SessionNameField s;
    ConnectionField c;
    TimeField t;
    Vector av;
    Vector media;

    private void init(OriginField origin, SessionNameField session, ConnectionField connection, TimeField time) {
        this.v = new SdpField('v', "0");
        this.o = origin;
        this.s = session;
        this.c = connection;
        this.t = time;
        this.av = new Vector();
        this.media = new Vector();
    }

    public SessionDescriptor(SessionDescriptor sd) {
        this.init(new OriginField(sd.o), new SessionNameField(sd.s), new ConnectionField(sd.c), new TimeField(sd.t));
        int i = 0;
        while (i < sd.media.size()) {
            this.media.addElement(new MediaDescriptor((MediaDescriptor)sd.media.elementAt(i)));
            ++i;
        }
    }

    public SessionDescriptor(OriginField origin, SessionNameField session, ConnectionField connection, TimeField time) {
        this.init(origin, session, connection, time);
    }

    public SessionDescriptor(String origin, String session, String connection, String time) {
        this.init(new OriginField(origin), new SessionNameField(session), new ConnectionField(connection), new TimeField(time));
    }

    public SessionDescriptor(String owner, String address) {
        if (address == null) {
            address = "127.0.0.1";
        }
        if (owner == null) {
            owner = "user@" + address;
        }
        this.init(new OriginField(owner, Long.toString(System.currentTimeMillis() / 1000L), "0", address), new SessionNameField("Session SIP/SDP"), new ConnectionField("IP4", address), new TimeField());
    }

    public SessionDescriptor() {
        String address = "127.0.0.1";
        String owner = "user@" + address;
        this.init(new OriginField(owner, Long.toString(System.currentTimeMillis()), "0", address), new SessionNameField("Session SIP/SDP"), new ConnectionField("IP4", address), new TimeField());
    }

    public SessionDescriptor(String sdp) {
        MediaDescriptor md;
        SdpParser par = new SdpParser(sdp);
        this.v = par.parseSdpField('v');
        if (this.v == null) {
            this.v = new SdpField('v', "0");
        }
        this.o = par.parseOriginField();
        if (this.o == null) {
            this.o = new OriginField("unknown");
        }
        this.s = par.parseSessionNameField();
        if (this.s == null) {
            this.s = new SessionNameField();
        }
        this.c = par.parseConnectionField();
        if (this.c == null) {
            this.c = new ConnectionField("IP4", "0.0.0.0");
        }
        this.t = par.parseTimeField();
        if (this.t == null) {
            this.t = new TimeField();
        }
        while (par.hasMore() && !par.startsWith("a=") && !par.startsWith("m=")) {
            par.goToNextLine();
        }
        this.av = new Vector();
        while (par.hasMore() && par.startsWith("a=")) {
            AttributeField attribute = par.parseAttributeField();
            this.av.addElement(attribute);
        }
        this.media = new Vector();
        par.setPos(0);
        while ((md = par.parseMediaDescriptor()) != null) {
            this.addMediaDescriptor(md);
        }
    }

    public SessionDescriptor setOrigin(OriginField origin) {
        this.o = origin;
        return this;
    }

    public OriginField getOrigin() {
        return this.o;
    }

    public SessionDescriptor setSessionName(SessionNameField session) {
        this.s = session;
        return this;
    }

    public SessionNameField getSessionName() {
        return this.s;
    }

    public SessionDescriptor setConnection(ConnectionField connection) {
        this.c = connection;
        return this;
    }

    public ConnectionField getConnection() {
        return this.c;
    }

    public SessionDescriptor setTime(TimeField time) {
        this.t = time;
        return this;
    }

    public TimeField getTime() {
        return this.t;
    }

    public SessionDescriptor addMedia(MediaField media, AttributeField attribute) {
        this.addMediaDescriptor(new MediaDescriptor(media, null, attribute));
        return this;
    }

    public SessionDescriptor addMedia(MediaField media, Vector attributes) {
        this.addMediaDescriptor(new MediaDescriptor(media, null, attributes));
        return this;
    }

    public SessionDescriptor addMediaDescriptor(MediaDescriptor media_desc) {
        this.media.addElement(media_desc);
        return this;
    }

    public SessionDescriptor addMediaDescriptors(Vector media_descs) {
        int i = 0;
        while (i < media_descs.size()) {
            this.media.addElement(media_descs.elementAt(i));
            ++i;
        }
        return this;
    }

    public Vector getMediaDescriptors() {
        return this.media;
    }

    public SessionDescriptor removeMediaDescriptor(String media_type) {
        int i = this.media.size() - 1;
        while (i >= 0) {
            if (((MediaDescriptor)this.media.elementAt(i)).getMedia().getMedia().equals(media_type)) {
                this.media.removeElementAt(i);
            }
            --i;
        }
        return this;
    }

    public SessionDescriptor removeMediaDescriptors() {
        this.media.setSize(0);
        return this;
    }

    public MediaDescriptor getMediaDescriptor(String media_type) {
        int i = 0;
        while (i < this.media.size()) {
            MediaDescriptor md = (MediaDescriptor)this.media.elementAt(i);
            if (md.getMedia().getMedia().equals(media_type)) {
                return md;
            }
            ++i;
        }
        return null;
    }

    public SessionDescriptor addAttributes(Vector attribute_fields) {
        int i = 0;
        while (i < attribute_fields.size()) {
            this.addAttribute((AttributeField)attribute_fields.elementAt(i));
            ++i;
        }
        return this;
    }

    public SessionDescriptor addAttribute(AttributeField attribute) {
        this.av.addElement(new AttributeField(attribute));
        return this;
    }

    public SessionDescriptor removeAttributes() {
        this.av.setSize(0);
        return this;
    }

    public Vector getAttributes() {
        Vector<AttributeField> v = new Vector<AttributeField>(this.av.size());
        int i = 0;
        while (i < this.av.size()) {
            v.addElement((AttributeField)this.av.elementAt(i));
            ++i;
        }
        return v;
    }

    public boolean hasAttribute(String attribute_name) {
        int i = 0;
        while (i < this.av.size()) {
            if (((AttributeField)this.av.elementAt(i)).getAttributeName().equals(attribute_name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public AttributeField getAttribute(String attribute_name) {
        int i = 0;
        while (i < this.media.size()) {
            AttributeField af = (AttributeField)this.av.elementAt(i);
            if (af.getAttributeName().equals(attribute_name)) {
                return af;
            }
            ++i;
        }
        return null;
    }

    public Vector getAttributes(String attribute_name) {
        Vector<AttributeField> v = new Vector<AttributeField>(this.av.size());
        int i = 0;
        while (i < this.av.size()) {
            AttributeField a = (AttributeField)this.av.elementAt(i);
            if (a.getAttributeName().equals(attribute_name)) {
                v.addElement(a);
            }
            ++i;
        }
        return v;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.v != null) {
            sb.append(this.v.toString());
        }
        if (this.o != null) {
            sb.append(this.o.toString());
        }
        if (this.s != null) {
            sb.append(this.s.toString());
        }
        if (this.c != null) {
            sb.append(this.c.toString());
        }
        if (this.t != null) {
            sb.append(this.t.toString());
        }
        int i = 0;
        while (i < this.av.size()) {
            sb.append(((AttributeField)this.av.elementAt(i)).toString());
            ++i;
        }
        i = 0;
        while (i < this.media.size()) {
            sb.append(((MediaDescriptor)this.media.elementAt(i)).toString());
            ++i;
        }
        return sb.toString();
    }
}

