/*
 * Decompiled with CFR 0.152.
 */
package org.zoolu.sip.address;

import org.zoolu.sip.address.SipURL;
import org.zoolu.sip.provider.SipParser;

public class NameAddress {
    String name;
    SipURL url;

    public NameAddress(String displayname, SipURL sipurl) {
        this.name = displayname;
        this.url = sipurl;
    }

    public NameAddress(SipURL sipurl) {
        this.name = null;
        this.url = sipurl;
    }

    public NameAddress(NameAddress name_address) {
        this.name = name_address.getDisplayName();
        this.url = name_address.getAddress();
    }

    public NameAddress(String naddr) {
        SipParser par = new SipParser(naddr);
        NameAddress na = par.getNameAddress();
        this.name = na.name;
        this.url = na.url;
    }

    public Object clone() {
        return new NameAddress(this);
    }

    public boolean equals(Object obj) {
        NameAddress naddr = (NameAddress)obj;
        return this.url.equals(naddr.getAddress());
    }

    public SipURL getAddress() {
        return this.url;
    }

    public String getDisplayName() {
        return this.name;
    }

    public boolean hasDisplayName() {
        return this.name != null;
    }

    public void removeDisplayName() {
        this.name = null;
    }

    public void setAddress(SipURL address) {
        this.url = address;
    }

    public void setDisplayName(String displayName) {
        this.name = displayName;
    }

    public boolean equals(NameAddress naddr) {
        return this.name == naddr.name && this.url == naddr.url;
    }

    public String toString() {
        String str = this.hasDisplayName() ? "\"" + this.name + "\" <" + this.url + ">" : "<" + this.url + ">";
        return str;
    }
}

