/*
 * Decompiled with CFR 0.152.
 */
package org.zoolu.sip.address;

import java.util.Vector;
import org.zoolu.sip.provider.SipParser;
import org.zoolu.tools.Parser;

public class SipURL {
    protected String url;
    protected static final String transport_param = "transport";
    protected static final String maddr_param = "maddr";
    protected static final String ttl_param = "ttl";
    protected static final String lr_param = "lr";

    public SipURL(String sipurl) {
        this.url = sipurl.startsWith("sip:") ? new String(sipurl) : "sip:" + sipurl;
    }

    public SipURL(String username, String hostname) {
        this.init(username, hostname, -1);
    }

    public SipURL(String hostname, int portnumber) {
        this.init(null, hostname, portnumber);
    }

    public SipURL(String username, String hostname, int portnumber) {
        this.init(username, hostname, portnumber);
    }

    private void init(String username, String hostname, int portnumber) {
        StringBuffer sb = new StringBuffer("sip:");
        if (username != null) {
            sb.append(username).append('@');
        }
        sb.append(hostname);
        if (portnumber > 0) {
            sb.append(":" + portnumber);
        }
        this.url = sb.toString();
    }

    public Object clone() {
        return new SipURL(this.url);
    }

    public boolean equals(Object obj) {
        SipURL newurl = (SipURL)obj;
        return this.url.toString().equals(newurl.toString());
    }

    public String getUserName() {
        int begin = 4;
        int end = this.url.indexOf(64, begin);
        if (end < 0) {
            return null;
        }
        return this.url.substring(begin, end);
    }

    public String getHost() {
        char[] host_terminators = new char[]{':', ';', '?'};
        Parser par = new Parser(this.url);
        int begin = par.indexOf('@');
        begin = begin < 0 ? 4 : ++begin;
        par.setPos(begin);
        int end = par.indexOf(host_terminators);
        if (end < 0) {
            return this.url.substring(begin);
        }
        return this.url.substring(begin, end);
    }

    public int getPort() {
        char[] port_terminators = new char[]{';', '?'};
        Parser par = new Parser(this.url, 4);
        int begin = par.indexOf(':');
        if (begin < 0) {
            return -1;
        }
        par.setPos(++begin);
        int end = par.indexOf(port_terminators);
        if (end < 0) {
            return Integer.parseInt(this.url.substring(begin));
        }
        return Integer.parseInt(this.url.substring(begin, end));
    }

    public boolean hasUserName() {
        return this.getUserName() != null;
    }

    public boolean hasPort() {
        return this.getPort() >= 0;
    }

    public boolean equals(SipURL sip_url) {
        return this.url == sip_url.url;
    }

    public String toString() {
        return this.url;
    }

    public String getParameter(String name) {
        SipParser par = new SipParser(this.url);
        return ((SipParser)par.goTo(';').skipChar()).getParameter(name);
    }

    public Vector getParameters() {
        SipParser par = new SipParser(this.url);
        return ((SipParser)par.goTo(';').skipChar()).getParameters();
    }

    public boolean hasParameter(String name) {
        SipParser par = new SipParser(this.url);
        return ((SipParser)par.goTo(';').skipChar()).hasParameter(name);
    }

    public boolean hasParameters() {
        return this.url != null && this.url.indexOf(59) >= 0;
    }

    public void addParameter(String name) {
        this.url = String.valueOf(this.url) + ";" + name;
    }

    public void addParameter(String name, String value) {
        this.url = value != null ? String.valueOf(this.url) + ";" + name + "=" + value : String.valueOf(this.url) + ";" + name;
    }

    public void removeParameters() {
        int index = this.url.indexOf(59);
        if (index >= 0) {
            this.url = this.url.substring(0, index);
        }
    }

    public void removeParameter(String name) {
        int index = this.url.indexOf(59);
        if (index < 0) {
            return;
        }
        Parser par = new Parser(this.url, index);
        while (par.hasMore()) {
            int begin_param = par.getPos();
            par.skipChar();
            if (par.getWord(SipParser.param_separators).equals(name)) {
                String top = this.url.substring(0, begin_param);
                par.goToSkippingQuoted(';');
                String bottom = "";
                if (par.hasMore()) {
                    bottom = this.url.substring(par.getPos());
                }
                this.url = top.concat(bottom);
                return;
            }
            par.goTo(';');
        }
    }

    public String getTransport() {
        return this.getParameter(transport_param);
    }

    public boolean hasTransport() {
        return this.hasParameter(transport_param);
    }

    public void addTransport(String proto) {
        this.addParameter(transport_param, proto.toLowerCase());
    }

    public String getMaddr() {
        return this.getParameter(maddr_param);
    }

    public boolean hasMaddr() {
        return this.hasParameter(maddr_param);
    }

    public void addMaddr(String maddr) {
        this.addParameter(maddr_param, maddr);
    }

    public int getTtl() {
        try {
            return Integer.parseInt(this.getParameter(ttl_param));
        }
        catch (Exception e) {
            return 1;
        }
    }

    public boolean hasTtl() {
        return this.hasParameter(ttl_param);
    }

    public void addTtl(int ttl) {
        this.addParameter(ttl_param, Integer.toString(ttl));
    }

    public boolean hasLr() {
        return this.hasParameter(lr_param);
    }

    public void addLr() {
        this.addParameter(lr_param);
    }
}

