/*
 * Decompiled with CFR 0.152.
 */
package org.zoolu.sip.authentication;

import org.zoolu.sip.header.AuthenticationHeader;
import org.zoolu.sip.header.AuthorizationHeader;
import org.zoolu.sip.header.ProxyAuthorizationHeader;
import org.zoolu.sip.header.WwwAuthenticateHeader;
import org.zoolu.tools.MD5;

public class DigestAuthentication {
    protected String method;
    protected String username;
    protected String passwd;
    protected String realm;
    protected String nonce;
    protected String opaque;
    protected String algorithm;
    protected String qop;
    protected String uri;
    protected String cnonce;
    protected String nc;
    protected String response;
    protected String body;

    protected DigestAuthentication() {
    }

    public DigestAuthentication(String method, AuthorizationHeader ah, String body, String passwd) {
        this.init(method, ah, body, passwd);
    }

    public DigestAuthentication(String method, String uri, WwwAuthenticateHeader ah, String qop, String body, String username, String passwd) {
        this.init(method, ah, body, passwd);
        this.uri = uri;
        this.qop = qop;
        this.username = username;
    }

    private void init(String method, AuthenticationHeader ah, String body, String passwd) {
        this.method = method;
        this.username = ah.getUsernameParam();
        this.passwd = passwd;
        this.realm = ah.getRealmParam();
        this.opaque = ah.getOpaqueParam();
        this.nonce = ah.getNonceParam();
        this.algorithm = ah.getAlgorithParam();
        this.qop = ah.getQopParam();
        this.uri = ah.getUriParam();
        this.cnonce = ah.getCnonceParam();
        this.nc = ah.getNcParam();
        this.response = ah.getResponseParam();
        this.body = body;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("method=").append(this.method).append("\n");
        sb.append("username=").append(this.username).append("\n");
        sb.append("passwd=").append(this.passwd).append("\n");
        sb.append("realm=").append(this.realm).append("\n");
        sb.append("nonce=").append(this.nonce).append("\n");
        sb.append("opaque=").append(this.opaque).append("\n");
        sb.append("algorithm=").append(this.algorithm).append("\n");
        sb.append("qop=").append(this.qop).append("\n");
        sb.append("uri=").append(this.uri).append("\n");
        sb.append("cnonce=").append(this.cnonce).append("\n");
        sb.append("nc=").append(this.nc).append("\n");
        sb.append("response=").append(this.response).append("\n");
        sb.append("body=").append(this.body).append("\n");
        return sb.toString();
    }

    public boolean checkResponse() {
        if (this.response == null) {
            return false;
        }
        return this.response.equals(this.getResponse());
    }

    public AuthorizationHeader getAuthorizationHeader() {
        AuthorizationHeader ah = new AuthorizationHeader("Digest");
        ah.addUsernameParam(this.username);
        ah.addRealmParam(this.realm);
        ah.addNonceParam(this.nonce);
        ah.addUriParam(this.uri);
        if (this.algorithm != null) {
            ah.addAlgorithParam(this.algorithm);
        }
        if (this.opaque != null) {
            ah.addOpaqueParam(this.opaque);
        }
        if (this.qop != null) {
            ah.addQopParam(this.qop);
            if (this.qop.equalsIgnoreCase("auth-int") || this.qop.equalsIgnoreCase("auth")) {
                this.cnonce = DigestAuthentication.HEX(DigestAuthentication.MD5(Long.toString(System.currentTimeMillis())));
                ah.addCnonceParam(this.cnonce);
                this.nc = "00000001";
                ah.addNcParam(this.nc);
            }
        }
        String response = this.getResponse();
        ah.addResponseParam(response);
        return ah;
    }

    public ProxyAuthorizationHeader getProxyAuthorizationHeader() {
        return new ProxyAuthorizationHeader(this.getAuthorizationHeader().getValue());
    }

    public String getResponse() {
        String secret = DigestAuthentication.HEX(DigestAuthentication.MD5(this.A1()));
        StringBuffer sb = new StringBuffer();
        if (this.nonce != null) {
            sb.append(this.nonce);
        }
        sb.append(":");
        if (this.qop != null) {
            if (this.nc != null) {
                sb.append(this.nc);
            }
            sb.append(":");
            if (this.cnonce != null) {
                sb.append(this.cnonce);
            }
            sb.append(":");
            sb.append(this.qop);
            sb.append(":");
        }
        sb.append(DigestAuthentication.HEX(DigestAuthentication.MD5(this.A2())));
        String data = sb.toString();
        return DigestAuthentication.HEX(this.KD(secret, data));
    }

    private byte[] KD(String secret, String data) {
        StringBuffer sb = new StringBuffer();
        sb.append(secret).append(":").append(data);
        return DigestAuthentication.MD5(sb.toString());
    }

    private byte[] A1() {
        StringBuffer sb = new StringBuffer();
        if (this.username != null) {
            sb.append(this.username);
        }
        sb.append(":");
        if (this.realm != null) {
            sb.append(this.realm);
        }
        sb.append(":");
        if (this.passwd != null) {
            sb.append(this.passwd);
        }
        if (this.algorithm == null || !this.algorithm.equalsIgnoreCase("MD5-sess")) {
            return sb.toString().getBytes();
        }
        StringBuffer sb2 = new StringBuffer();
        sb2.append(":");
        if (this.nonce != null) {
            sb2.append(this.nonce);
        }
        sb2.append(":");
        if (this.cnonce != null) {
            sb2.append(this.cnonce);
        }
        return DigestAuthentication.cat(DigestAuthentication.MD5(sb.toString()), sb2.toString().getBytes());
    }

    private String A2() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.method);
        sb.append(":");
        if (this.uri != null) {
            sb.append(this.uri);
        }
        if (this.qop != null && this.qop.equalsIgnoreCase("auth-int")) {
            sb.append(":");
            if (this.body == null) {
                sb.append(DigestAuthentication.HEX(DigestAuthentication.MD5("")));
            } else {
                sb.append(DigestAuthentication.HEX(DigestAuthentication.MD5(this.body)));
            }
        }
        return sb.toString();
    }

    private static byte[] cat(byte[] a, byte[] b) {
        int len = a.length + b.length;
        byte[] c = new byte[len];
        int i = 0;
        while (i < a.length) {
            c[i] = a[i];
            ++i;
        }
        i = 0;
        while (i < b.length) {
            c[i + a.length] = b[i];
            ++i;
        }
        return c;
    }

    private static byte[] MD5(String str) {
        return MD5.digest(str);
    }

    private static byte[] MD5(byte[] bb) {
        return MD5.digest(bb);
    }

    private static String HEX(byte[] bb) {
        return MD5.asHex(bb);
    }

    public static void main(String[] args) {
        DigestAuthentication a = new DigestAuthentication();
        a.method = "GET";
        a.passwd = "Circle Of Life";
        a.realm = "testrealm@host.com";
        a.nonce = "dcd98b7102dd2f0e8b11d0f600bfb0c093";
        a.uri = "/dir/index.html";
        a.qop = "auth";
        a.nc = "00000001";
        a.cnonce = "0a4f113b";
        a.username = "Mufasa";
        String response1 = a.getResponse();
        String response2 = "6629fae49393a05397450978507c4ef1";
        System.out.println(response1);
        System.out.println(response2);
        System.out.println(" ");
        String ah_str = "Digest username=\"Mufasa\", realm=\"testrealm@host.com\", nonce=\"dcd98b7102dd2f0e8b11d0f600bfb0c093\", uri=\"/dir/index.html\", qop=auth, nc=00000001, cnonce=\"0a4f113b\", response=\"6629fae49393a05397450978507c4ef1\", opaque=\"5ccc069c403ebaf9f0171e9517f40e41\"\n";
        AuthorizationHeader ah = new AuthorizationHeader(ah_str);
        a = new DigestAuthentication("GET", ah, null, "Circle Of Life");
        response1 = a.getResponse();
        response2 = "6629fae49393a05397450978507c4ef1";
        System.out.println(response1);
        System.out.println(response2);
        System.out.println(a.checkResponse());
    }
}

