/*
 * Decompiled with CFR 0.152.
 */
package org.zoolu.sip.call;

import org.apache.log4j.Logger;
import org.zoolu.sip.address.NameAddress;
import org.zoolu.sip.call.CallListener;
import org.zoolu.sip.dialog.InviteDialog;
import org.zoolu.sip.dialog.InviteDialogListener;
import org.zoolu.sip.header.MultipleHeader;
import org.zoolu.sip.message.Message;
import org.zoolu.sip.message.SipResponses;
import org.zoolu.sip.provider.SipProvider;

public class Call
implements InviteDialogListener {
    Logger log = Logger.getLogger(this.getClass());
    protected SipProvider sip_provider;
    protected InviteDialog dialog;
    protected String from_url;
    protected String contact_url;
    protected String local_sdp;
    protected String remote_sdp;
    CallListener listener;
    private boolean callWasUsed = false;

    public Call(SipProvider sip_provider, String from_url, String contact_url, CallListener call_listener) {
        this.sip_provider = sip_provider;
        this.listener = call_listener;
        this.from_url = from_url;
        this.contact_url = contact_url;
        this.dialog = null;
        this.local_sdp = null;
        this.remote_sdp = null;
    }

    public String getLocalSessionDescriptor() {
        return this.local_sdp;
    }

    public void setLocalSessionDescriptor(String sdp) {
        this.local_sdp = sdp;
    }

    public String getRemoteSessionDescriptor() {
        return this.remote_sdp;
    }

    public boolean isOnCall() {
        return this.dialog.isSessionActive();
    }

    public void listen() {
        this.dialog = new InviteDialog(this.sip_provider, this);
        this.dialog.listen();
    }

    public void call(String callee) {
        this.call(callee, null, null, null);
    }

    public void call(String callee, String sdp) {
        this.call(callee, null, null, sdp);
    }

    public void call(String callee, String from, String contact, String sdp) {
        this.log.info((Object)("calling " + callee));
        this.callWasUsed = true;
        if (from == null) {
            from = this.from_url;
        }
        if (contact == null) {
            contact = this.contact_url;
        }
        if (sdp != null) {
            this.local_sdp = sdp;
        }
        this.dialog = new InviteDialog(this.sip_provider, this);
        if (this.local_sdp != null) {
            this.dialog.invite(callee, from, contact, this.local_sdp);
        } else {
            this.dialog.inviteWithoutOffer(callee, from, contact);
        }
    }

    public void call(Message invite) {
        this.dialog = new InviteDialog(this.sip_provider, this);
        this.callWasUsed = true;
        this.local_sdp = invite.getBody();
        if (this.local_sdp != null) {
            this.dialog.invite(invite);
        } else {
            this.dialog.inviteWithoutOffer(invite);
        }
    }

    public void ackWithAnswer(String sdp) {
        this.local_sdp = sdp;
        this.dialog.ackWithAnswer(this.contact_url, sdp);
    }

    public void ring() {
        if (this.dialog != null) {
            this.dialog.ring(this.contact_url);
        }
    }

    public void respond(Message resp) {
        if (this.dialog != null) {
            this.dialog.respond(resp);
        }
    }

    public void accept(String sdp) {
        this.local_sdp = sdp;
        this.callWasUsed = true;
        if (this.dialog != null) {
            this.dialog.accept(this.contact_url, this.local_sdp);
        }
    }

    public void sendEarlyMedia(String sdp) {
        this.local_sdp = sdp;
        this.callWasUsed = true;
        if (this.dialog != null) {
            this.dialog.sendEarlyMedia(this.contact_url, this.local_sdp);
        }
    }

    public void redirect(String redirect_url) {
        if (this.dialog != null) {
            this.dialog.redirect(302, "Moved Temporarily", redirect_url);
        }
    }

    public void refuse() {
        if (this.dialog != null) {
            this.dialog.refuse();
        }
    }

    public void cancel() {
        if (this.dialog != null) {
            this.dialog.cancel();
        }
    }

    public void bye() {
        if (this.dialog != null) {
            this.dialog.bye();
        }
    }

    public void modify(String contact, String sdp) {
        this.local_sdp = sdp;
        if (this.dialog != null) {
            this.dialog.reInvite(contact, this.local_sdp);
        }
    }

    public void hangup() {
        this.hangup(403);
    }

    public void hangup(int status) {
        if (this.dialog != null && !this.dialog.isWaiting() && !this.dialog.isTerminated()) {
            this.callWasUsed = true;
            this.dialog.refuse(status, SipResponses.reasonOf(status));
            this.dialog.cancel();
            this.dialog.bye();
        }
    }

    public void onDlgInvite(InviteDialog d, NameAddress callee, NameAddress caller, String sdp, Message msg) {
        if (d != this.dialog) {
            this.log.info((Object)"NOT the current dialog");
            return;
        }
        if (sdp != null && sdp.length() != 0) {
            this.remote_sdp = sdp;
        }
        this.callWasUsed = true;
        if (this.listener != null) {
            this.listener.onCallIncoming(this, callee, caller, sdp, msg);
        }
    }

    public void onDlgReInvite(InviteDialog d, String sdp, Message msg) {
        if (d != this.dialog) {
            this.log.info((Object)"NOT the current dialog");
            return;
        }
        if (sdp != null && sdp.length() != 0) {
            this.remote_sdp = sdp;
        }
        if (this.listener != null) {
            this.listener.onCallModifying(this, sdp, msg);
        }
    }

    public void onDlgInviteProvisionalResponse(InviteDialog d, int code, String reason, String sdp, Message msg) {
        if (d != this.dialog) {
            this.log.info((Object)"NOT the current dialog");
            return;
        }
        if (sdp != null && sdp.length() != 0) {
            this.remote_sdp = sdp;
        }
        if (code == 180 && this.listener != null) {
            this.listener.onCallRinging(this, msg);
        }
    }

    public void onDlgInviteSuccessResponse(InviteDialog d, int code, String reason, String sdp, Message msg) {
        if (d != this.dialog) {
            this.log.info((Object)"NOT the current dialog");
            return;
        }
        if (sdp != null && sdp.length() != 0) {
            this.remote_sdp = sdp;
        }
        if (this.listener != null) {
            this.listener.onCallAccepted(this, sdp, msg);
        }
    }

    public void onDlgInviteRedirectResponse(InviteDialog d, int code, String reason, MultipleHeader contacts, Message msg) {
        if (d != this.dialog) {
            this.log.info((Object)"NOT the current dialog");
            return;
        }
        if (this.listener != null) {
            this.listener.onCallRedirection(this, reason, contacts.getValues(), msg);
        }
    }

    public void onDlgInviteFailureResponse(InviteDialog d, int code, String reason, Message msg) {
        if (d != this.dialog) {
            this.log.info((Object)"NOT the current dialog");
            return;
        }
        if (this.listener != null) {
            this.listener.onCallRefused(this, reason, msg);
        }
    }

    public void onDlgTimeout(InviteDialog d) {
        if (d != this.dialog) {
            this.log.info((Object)"NOT the current dialog");
            return;
        }
        if (this.listener != null) {
            this.listener.onCallTimeout(this);
        }
    }

    public void onDlgReInviteProvisionalResponse(InviteDialog d, int code, String reason, String sdp, Message msg) {
        if (d != this.dialog) {
            this.log.info((Object)"NOT the current dialog");
            return;
        }
        if (sdp != null && sdp.length() != 0) {
            this.remote_sdp = sdp;
        }
    }

    public void onDlgReInviteSuccessResponse(InviteDialog d, int code, String reason, String sdp, Message msg) {
        if (d != this.dialog) {
            this.log.info((Object)"NOT the current dialog");
            return;
        }
        if (sdp != null && sdp.length() != 0) {
            this.remote_sdp = sdp;
        }
        if (this.listener != null) {
            this.listener.onCallReInviteAccepted(this, sdp, msg);
        }
    }

    public void onDlgReInviteFailureResponse(InviteDialog d, int code, String reason, Message msg) {
        if (d != this.dialog) {
            this.log.info((Object)"NOT the current dialog");
            return;
        }
        if (this.listener != null) {
            this.listener.onCallReInviteRefused(this, reason, msg);
        }
    }

    public void onDlgReInviteTimeout(InviteDialog d) {
        if (d != this.dialog) {
            this.log.info((Object)"NOT the current dialog");
            return;
        }
        if (this.listener != null) {
            this.listener.onCallReInviteTimeout(this);
        }
    }

    public void onDlgAck(InviteDialog d, String sdp, Message msg) {
        if (d != this.dialog) {
            this.log.info((Object)"NOT the current dialog");
            return;
        }
        if (sdp != null && sdp.length() != 0) {
            this.remote_sdp = sdp;
        }
        if (this.listener != null) {
            this.listener.onCallConfirmed(this, sdp, msg);
        }
    }

    public void onDlgCancel(InviteDialog d, Message msg) {
        if (d != this.dialog) {
            this.log.info((Object)"NOT the current dialog");
            return;
        }
        if (this.listener != null) {
            this.listener.onCallCanceling(this, msg);
        }
    }

    public void onDlgBye(InviteDialog d, Message msg) {
        if (d != this.dialog) {
            this.log.info((Object)"NOT the current dialog");
            return;
        }
        if (this.listener != null) {
            this.listener.onCallClosing(this, msg);
        }
    }

    public void onDlgByeFailureResponse(InviteDialog d, int code, String reason, Message msg) {
        if (d != this.dialog) {
            this.log.info((Object)"NOT the current dialog");
            return;
        }
        if (this.listener != null) {
            this.listener.onCallClosed(this, msg);
        }
    }

    public void onDlgByeSuccessResponse(InviteDialog d, int code, String reason, Message msg) {
        if (d != this.dialog) {
            this.log.info((Object)"NOT the current dialog");
            return;
        }
        if (this.listener != null) {
            this.listener.onCallClosed(this, msg);
        }
    }

    public void onDlgCall(InviteDialog dialog) {
    }

    public void onDlgClose(InviteDialog d) {
        if (d == this.dialog) {
            this.callWasUsed = true;
        }
        if (this.listener != null) {
            this.listener.onCallClosed(this, null);
        }
    }

    public void onDlgInfo(InviteDialog dialog, Message msg) {
        if (this.listener != null) {
            this.listener.onInfoMsg(this, msg);
        }
    }

    public void sendInfoMsg(String msg, String content_type) {
        this.dialog.sendInfoMsg(msg, content_type);
    }

    public boolean callUsed() {
        return this.callWasUsed;
    }

    public void removeInviteListener() {
        this.dialog.removeInviteListener();
    }
}

