/*
 * Decompiled with CFR 0.152.
 */
package org.zoolu.sip.call;

import java.util.Vector;
import org.zoolu.sdp.SessionDescriptor;
import org.zoolu.sip.address.NameAddress;
import org.zoolu.sip.call.Call;
import org.zoolu.sip.call.ExtendedCall;
import org.zoolu.sip.call.ExtendedCallListener;
import org.zoolu.sip.call.SdpTools;
import org.zoolu.sip.message.Message;

public abstract class CallListenerAdapter
implements ExtendedCallListener {
    protected CallListenerAdapter() {
    }

    public void onCallIncoming(Call call, NameAddress callee, NameAddress caller, String sdp, Message invite) {
        String local_session;
        call.ring();
        if (sdp != null && sdp.length() > 0) {
            SessionDescriptor remote_sdp = new SessionDescriptor(sdp);
            SessionDescriptor local_sdp = new SessionDescriptor(call.getLocalSessionDescriptor());
            SessionDescriptor new_sdp = new SessionDescriptor(remote_sdp.getOrigin(), remote_sdp.getSessionName(), local_sdp.getConnection(), local_sdp.getTime());
            new_sdp.addMediaDescriptors(local_sdp.getMediaDescriptors());
            new_sdp = SdpTools.sdpMediaProduct(new_sdp, remote_sdp.getMediaDescriptors());
            new_sdp = SdpTools.sdpAttirbuteSelection(new_sdp, "rtpmap");
            local_session = new_sdp.toString();
        } else {
            local_session = call.getLocalSessionDescriptor();
        }
        call.accept(local_session);
    }

    public void onCallModifying(Call call, String sdp, Message invite, int[] avpList) {
        String local_session;
        if (sdp != null && sdp.length() > 0) {
            SessionDescriptor remote_sdp = new SessionDescriptor(sdp);
            SessionDescriptor local_sdp = new SessionDescriptor(call.getLocalSessionDescriptor());
            SessionDescriptor new_sdp = new SessionDescriptor(remote_sdp.getOrigin(), remote_sdp.getSessionName(), local_sdp.getConnection(), local_sdp.getTime());
            new_sdp.addMediaDescriptors(local_sdp.getMediaDescriptors());
            new_sdp = SdpTools.sdpMediaProduct(new_sdp, remote_sdp.getMediaDescriptors());
            new_sdp = SdpTools.sdpAttirbuteSelection(new_sdp, "rtpmap");
            local_session = new_sdp.toString();
        } else {
            local_session = call.getLocalSessionDescriptor();
        }
        call.accept(local_session);
    }

    public void onCallRinging(Call call, Message resp) {
    }

    public void onCallAccepted(Call call, String sdp, Message resp) {
    }

    public void onCallRefused(Call call, String reason, Message resp) {
    }

    public void onCallRedirection(Call call, String reason, Vector contact_list, Message resp) {
        call.call((String)contact_list.elementAt(0));
    }

    public void onCallConfirmed(Call call, String sdp, Message ack) {
    }

    public void onCallTimeout(Call call) {
    }

    public void onCallReInviteAccepted(Call call, String sdp, Message resp) {
    }

    public void onCallReInviteRefused(Call call, String reason, Message resp) {
    }

    public void onCallReInviteTimeout(Call call) {
    }

    public void onCallCanceling(Call call, Message cancel) {
    }

    public void onCallClosing(Call call, Message bye) {
    }

    public void onCallClosed(Call call, Message resp) {
    }

    public void onCallTransfer(ExtendedCall call, NameAddress refer_to, NameAddress refered_by, Message refer) {
    }

    public void onCallTransferAccepted(ExtendedCall call, Message resp) {
    }

    public void onCallTransferRefused(ExtendedCall call, String reason, Message resp) {
    }

    public void onCallTransferSuccess(ExtendedCall call, Message notify) {
    }

    public void onCallTransferFailure(ExtendedCall call, String reason, Message notify) {
    }
}

