/*
 * Decompiled with CFR 0.152.
 */
package org.zoolu.sip.call;

import org.zoolu.sip.address.NameAddress;
import org.zoolu.sip.call.Call;
import org.zoolu.sip.call.ExtendedCallListener;
import org.zoolu.sip.dialog.ExtendedInviteDialog;
import org.zoolu.sip.dialog.ExtendedInviteDialogListener;
import org.zoolu.sip.dialog.InviteDialog;
import org.zoolu.sip.header.StatusLine;
import org.zoolu.sip.message.Message;
import org.zoolu.sip.provider.SipProvider;

public class ExtendedCall
extends Call
implements ExtendedInviteDialogListener {
    ExtendedCallListener xcall_listener;
    Message refer;
    String username;
    String realm;
    String passwd;
    String next_nonce;
    String qop;

    public ExtendedCall(SipProvider sip_provider, String from_url, String contact_url, ExtendedCallListener call_listener) {
        super(sip_provider, from_url, contact_url, call_listener);
        this.xcall_listener = call_listener;
        this.refer = null;
        this.username = null;
        this.realm = null;
        this.passwd = null;
        this.next_nonce = null;
        this.qop = null;
    }

    public ExtendedCall(SipProvider sip_provider, String from_url, String contact_url, String username, String realm, String passwd, ExtendedCallListener call_listener) {
        super(sip_provider, from_url, contact_url, call_listener);
        this.xcall_listener = call_listener;
        this.refer = null;
        this.username = username;
        this.realm = realm;
        this.passwd = passwd;
        this.next_nonce = null;
        this.qop = null;
    }

    public void listen() {
        this.dialog = this.username != null ? new ExtendedInviteDialog(this.sip_provider, this.username, this.realm, this.passwd, this) : new ExtendedInviteDialog(this.sip_provider, this);
        this.dialog.listen();
    }

    public void call(String r_user, String from, String contact, String sdp) {
        this.log.debug((Object)("calling " + r_user));
        this.dialog = this.username != null ? new ExtendedInviteDialog(this.sip_provider, this.username, this.realm, this.passwd, this) : new ExtendedInviteDialog(this.sip_provider, this);
        if (from == null) {
            from = this.from_url;
        }
        if (contact == null) {
            contact = this.contact_url;
        }
        if (sdp != null) {
            this.local_sdp = sdp;
        }
        if (this.local_sdp != null) {
            this.dialog.invite(r_user, from, contact, this.local_sdp);
        } else {
            this.dialog.inviteWithoutOffer(r_user, from, contact);
        }
    }

    public void call(Message invite) {
        this.dialog = new ExtendedInviteDialog(this.sip_provider, this);
        this.local_sdp = invite.getBody();
        if (this.local_sdp != null) {
            this.dialog.invite(invite);
        } else {
            this.dialog.inviteWithoutOffer(invite);
        }
    }

    public void transfer(String transfer_to) {
        ((ExtendedInviteDialog)this.dialog).refer(new NameAddress(transfer_to));
    }

    public void acceptTransfer() {
        ((ExtendedInviteDialog)this.dialog).acceptRefer(this.refer);
    }

    public void refuseTransfer() {
        ((ExtendedInviteDialog)this.dialog).refuseRefer(this.refer);
    }

    public void notify(int code, String reason) {
        ((ExtendedInviteDialog)this.dialog).notify(code, reason);
    }

    public void onDlgRefer(InviteDialog d, NameAddress refer_to, NameAddress referred_by, Message msg) {
        if (d != this.dialog) {
            this.log.info((Object)"NOT the current dialog");
            return;
        }
        this.log.debug((Object)("onDlgRefer(" + refer_to.toString() + ")"));
        this.refer = msg;
        if (this.xcall_listener != null) {
            this.xcall_listener.onCallTransfer(this, refer_to, referred_by, msg);
        }
    }

    public void onDlgReferResponse(InviteDialog d, int code, String reason, Message msg) {
        if (d != this.dialog) {
            this.log.info((Object)"NOT the current dialog");
            return;
        }
        this.log.debug((Object)("onDlgReferResponse(" + code + " " + reason + ")"));
        if (code >= 200 && code < 300) {
            if (this.xcall_listener != null) {
                this.xcall_listener.onCallTransferAccepted(this, msg);
            }
        } else if (code >= 300 && this.xcall_listener != null) {
            this.xcall_listener.onCallTransferRefused(this, reason, msg);
        }
    }

    public void onDlgNotify(InviteDialog d, String event, String sipfragment, Message msg) {
        if (d != this.dialog) {
            this.log.info((Object)"NOT the current dialog");
            return;
        }
        this.log.debug((Object)"onDlgNotify()");
        if (event.equals("refer")) {
            Message fragment = new Message(sipfragment);
            this.log.info((Object)("Notify: " + sipfragment));
            if (fragment.isResponse()) {
                StatusLine status_line = fragment.getStatusLine();
                int code = status_line.getCode();
                String reason = status_line.getReason();
                if (code >= 200 && code < 300) {
                    this.log.debug((Object)"Call successfully transferred");
                    if (this.xcall_listener != null) {
                        this.xcall_listener.onCallTransferSuccess(this, msg);
                    }
                } else if (code >= 300) {
                    this.log.debug((Object)"Call NOT transferred");
                    if (this.xcall_listener != null) {
                        this.xcall_listener.onCallTransferFailure(this, reason, msg);
                    }
                }
            }
        }
    }

    public void onDlgAltRequest(InviteDialog d, String method, String body, Message msg) {
    }

    public void onDlgAltResponse(InviteDialog d, String method, int code, String reason, String body, Message msg) {
    }
}

