/*
 * Decompiled with CFR 0.152.
 */
package org.zoolu.sip.call;

import java.util.Enumeration;
import java.util.Vector;
import org.zoolu.sdp.AttributeField;
import org.zoolu.sdp.MediaDescriptor;
import org.zoolu.sdp.MediaField;
import org.zoolu.sdp.SessionDescriptor;

public class SdpTools {
    public static SessionDescriptor sdpMediaProduct(SessionDescriptor sdp, Vector m_descs) {
        Vector<MediaDescriptor> new_media = new Vector<MediaDescriptor>();
        if (m_descs != null) {
            Enumeration e = m_descs.elements();
            while (e.hasMoreElements()) {
                MediaDescriptor spec_md = (MediaDescriptor)e.nextElement();
                MediaDescriptor prev_md = sdp.getMediaDescriptor(spec_md.getMedia().getMedia());
                if (prev_md == null) continue;
                Vector spec_attributes = spec_md.getAttributes();
                Vector prev_attributes = prev_md.getAttributes();
                if (spec_attributes.size() == 0 || prev_attributes.size() == 0) {
                    new_media.addElement(prev_md);
                    continue;
                }
                Vector<AttributeField> new_attributes = new Vector<AttributeField>();
                Enumeration i = spec_attributes.elements();
                block1: while (i.hasMoreElements()) {
                    AttributeField spec_attr = (AttributeField)i.nextElement();
                    String spec_name = spec_attr.getAttributeName();
                    String spec_value = spec_attr.getAttributeValue();
                    Enumeration k = prev_attributes.elements();
                    while (k.hasMoreElements()) {
                        AttributeField prev_attr = (AttributeField)k.nextElement();
                        String prev_name = prev_attr.getAttributeName();
                        String prev_value = prev_attr.getAttributeValue();
                        if (!prev_name.equals(spec_name) || !prev_value.equalsIgnoreCase(spec_value)) continue;
                        new_attributes.addElement(prev_attr);
                        continue block1;
                    }
                }
                if (new_attributes.size() <= 0) continue;
                new_media.addElement(new MediaDescriptor(prev_md.getMedia(), prev_md.getConnection(), new_attributes));
            }
        }
        SessionDescriptor new_sdp = new SessionDescriptor(sdp);
        new_sdp.removeMediaDescriptors();
        new_sdp.addMediaDescriptors(new_media);
        return new_sdp;
    }

    public static SessionDescriptor sdpAttirbuteSelection(SessionDescriptor sdp, String a_name) {
        Vector<MediaDescriptor> new_media = new Vector<MediaDescriptor>();
        Enumeration e = sdp.getMediaDescriptors().elements();
        while (e.hasMoreElements()) {
            MediaDescriptor md = (MediaDescriptor)e.nextElement();
            AttributeField attr = md.getAttribute(a_name);
            if (attr == null) continue;
            new_media.addElement(new MediaDescriptor(md.getMedia(), md.getConnection(), attr));
        }
        SessionDescriptor new_sdp = new SessionDescriptor(sdp);
        new_sdp.removeMediaDescriptors();
        new_sdp.addMediaDescriptors(new_media);
        return new_sdp;
    }

    public static SessionDescriptor selectMedia(SessionDescriptor sdp, SessionDescriptor priSdp, SessionDescriptor secSdp) {
        Vector priDescs = priSdp.getMediaDescriptors();
        SessionDescriptor new_sdp = new SessionDescriptor(sdp);
        new_sdp.removeMediaDescriptors();
        Enumeration e = priDescs.elements();
        while (e.hasMoreElements()) {
            MediaDescriptor pri_md = (MediaDescriptor)e.nextElement();
            String priMediaType = pri_md.getMedia().getMedia();
            MediaDescriptor new_md = sdp.getMediaDescriptor(priMediaType);
            MediaDescriptor sec_md = secSdp.getMediaDescriptor(priMediaType);
            if (sec_md == null) continue;
            MediaDescriptor new_cur_media = new MediaDescriptor(new MediaField(sdp.getMediaDescriptor(priMediaType).getMedia()), new_md.getConnection(), null);
            new_cur_media.getMedia().removeAllFormats();
            Vector priFormats = pri_md.getMedia().getFormatList();
            Vector secFormats = sec_md.getMedia().getFormatList();
            boolean matched = false;
            int ca = 0;
            while (ca < priFormats.size()) {
                String priFormat = (String)priFormats.get(ca);
                int numPriFormat = Integer.parseInt(priFormat);
                AttributeField priAttr = SdpTools.getRtpMapForFormat(pri_md, priFormat);
                if (priAttr != null) {
                    int sa = 0;
                    while (sa < secFormats.size()) {
                        String secFormat = (String)secFormats.get(sa);
                        int numSecFormat = Integer.parseInt(secFormat);
                        AttributeField secAttr = SdpTools.getRtpMapForFormat(sec_md, secFormat);
                        if (secAttr != null) {
                            if (numPriFormat < 96 || numPriFormat > 127) {
                                if (numSecFormat == numPriFormat && !matched) {
                                    new_cur_media.getMedia().appendFormat(secFormat);
                                    new_cur_media.addAttribute(secAttr);
                                    matched = true;
                                    break;
                                }
                            } else {
                                String[] priCodecInfo = priAttr.getAttributeValues();
                                String priCodecFix = priCodecInfo[1].replaceAll("/1$", "");
                                String[] secCodecInfo = secAttr.getAttributeValues();
                                String secCodecFix = secCodecInfo[1].replaceAll("/1$", "");
                                if (secCodecFix.toUpperCase().equals(priCodecFix.toUpperCase())) {
                                    if (secCodecInfo[1].toLowerCase().contains("telephone-event")) {
                                        new_cur_media.getMedia().appendFormat(secFormat);
                                        new_cur_media.addAttribute(secAttr);
                                        new_cur_media.addAttribute(new AttributeField("fmtp", String.valueOf(secFormat) + " 0-15"));
                                        break;
                                    }
                                    if (!matched) {
                                        new_cur_media.getMedia().appendFormat(secFormat);
                                        new_cur_media.addAttribute(secAttr);
                                        matched = true;
                                        break;
                                    }
                                }
                            }
                        }
                        ++sa;
                    }
                }
                ++ca;
            }
            if (new_cur_media.getMedia().getFormatList().size() <= 0) continue;
            new_sdp.addMediaDescriptor(new_cur_media);
        }
        return new_sdp;
    }

    private static AttributeField getRtpMapForFormat(MediaDescriptor md, String format) {
        Vector rtpmap = md.getAttributes("rtpmap");
        int m = 0;
        while (m < rtpmap.size()) {
            AttributeField cf = (AttributeField)rtpmap.get(m);
            if (cf.getAttributeValues()[0].equals(format)) {
                return cf;
            }
            ++m;
        }
        if (format.equals("0")) {
            return new AttributeField("rtpmap", "0 PCMU/8000");
        }
        if (format.equals("8")) {
            return new AttributeField("rtpmap", "8 PCMA/8000");
        }
        if (format.equals("3")) {
            return new AttributeField("rtpmap", "3 GSM/8000");
        }
        return null;
    }
}

