/*
 * Decompiled with CFR 0.152.
 */
package org.zoolu.sip.dialog;

import java.util.Vector;
import org.apache.log4j.Logger;
import org.zoolu.sip.dialog.DialogInfo;
import org.zoolu.sip.header.FromHeader;
import org.zoolu.sip.header.Header;
import org.zoolu.sip.header.RecordRouteHeader;
import org.zoolu.sip.header.ToHeader;
import org.zoolu.sip.message.Message;
import org.zoolu.sip.provider.DialogIdentifier;
import org.zoolu.sip.provider.SipProvider;
import org.zoolu.sip.provider.SipProviderListener;

public abstract class Dialog
extends DialogInfo
implements SipProviderListener {
    private static int dialog_counter = 0;
    public static final int UAC = 0;
    public static final int UAS = 1;
    protected int dialog_sqn;
    protected Logger log = Logger.getLogger(this.getClass());
    protected SipProvider sip_provider;
    protected int status;
    protected DialogIdentifier dialog_id;

    protected abstract String getStatus();

    public abstract boolean isEarly();

    public abstract boolean isConfirmed();

    public abstract boolean isTerminated();

    public abstract void onReceivedMessage(SipProvider var1, Message var2);

    protected Dialog(SipProvider provider) {
        this.sip_provider = provider;
        this.dialog_sqn = dialog_counter++;
        this.status = 0;
        this.dialog_id = null;
    }

    protected void changeStatus(int newstatus) {
        this.status = newstatus;
        this.log.debug((Object)("changed dialog state: " + this.getStatus()));
        if (this.isTerminated()) {
            if (this.dialog_id != null && this.sip_provider.getListeners().containsKey(this.dialog_id)) {
                this.sip_provider.removeSipProviderListener(this.dialog_id);
            }
        } else if ((this.isEarly() || this.isConfirmed()) && this.dialog_id != null && !this.sip_provider.getListeners().containsKey(this.dialog_id)) {
            this.sip_provider.addSipProviderListener(this.dialog_id, this);
        }
    }

    protected boolean statusIs(int st) {
        return this.status == st;
    }

    public SipProvider getSipProvider() {
        return this.sip_provider;
    }

    public DialogIdentifier getDialogID() {
        return this.dialog_id;
    }

    public void update(int side, Message msg) {
        Vector rr;
        FromHeader from;
        ToHeader to;
        if (this.isTerminated()) {
            this.log.warn((Object)"trying to update a terminated dialog: do nothing.");
            return;
        }
        if (this.call_id == null) {
            this.call_id = msg.getCallIdHeader().getCallId();
        }
        if (side == 0) {
            if (this.remote_name == null || this.remote_tag == null) {
                to = msg.getToHeader();
                if (this.remote_name == null) {
                    this.remote_name = to.getNameAddress();
                }
                if (this.remote_tag == null) {
                    this.remote_tag = to.getTag();
                }
            }
            if (this.local_name == null || this.local_tag == null) {
                from = msg.getFromHeader();
                if (this.local_name == null) {
                    this.local_name = from.getNameAddress();
                }
                if (this.local_tag == null) {
                    this.local_tag = from.getTag();
                }
            }
            this.local_cseq = msg.getCSeqHeader().getSequenceNumber();
        } else {
            if (this.local_name == null || this.local_tag == null) {
                to = msg.getToHeader();
                if (this.local_name == null) {
                    this.local_name = to.getNameAddress();
                }
                if (this.local_tag == null) {
                    this.local_tag = to.getTag();
                }
            }
            if (this.remote_name == null || this.remote_tag == null) {
                from = msg.getFromHeader();
                if (this.remote_name == null) {
                    this.remote_name = from.getNameAddress();
                }
                if (this.remote_tag == null) {
                    this.remote_tag = from.getTag();
                }
            }
            this.remote_cseq = msg.getCSeqHeader().getSequenceNumber();
            if (this.local_cseq == -1L) {
                this.local_cseq = SipProvider.pickInitialCSeq() - 1;
            }
        }
        if (msg.hasContactHeader()) {
            if (side == 0 && msg.isRequest() || side == 1 && msg.isResponse()) {
                this.local_contact = msg.getContactHeader().getNameAddress();
            } else {
                this.remote_contact = msg.getContactHeader().getNameAddress();
            }
        }
        if (side == 0) {
            if (msg.isRequest() && msg.hasRouteHeader() && this.route == null) {
                this.route = msg.getRoutes().getValues();
            }
            if (side == 0 && msg.isResponse() && msg.hasRecordRouteHeader()) {
                rr = msg.getRecordRoutes().getHeaders();
                int size = rr.size();
                this.route = new Vector(size);
                int i = 0;
                while (i < size) {
                    this.route.insertElementAt(new RecordRouteHeader((Header)rr.elementAt(size - 1 - i)).getNameAddress(), i);
                    ++i;
                }
            }
        } else {
            int i;
            int size;
            if (msg.isRequest() && msg.hasRouteHeader() && this.route == null) {
                Vector reverse_route = msg.getRoutes().getValues();
                size = reverse_route.size();
                this.route = new Vector(size);
                i = 0;
                while (i < size) {
                    this.route.insertElementAt(reverse_route.elementAt(size - 1 - i), i);
                    ++i;
                }
            }
            if (msg.isRequest() && msg.hasRecordRouteHeader()) {
                rr = msg.getRecordRoutes().getHeaders();
                size = rr.size();
                this.route = new Vector(size);
                i = 0;
                while (i < size) {
                    this.route.insertElementAt(new RecordRouteHeader((Header)rr.elementAt(i)).getNameAddress(), i);
                    ++i;
                }
            }
        }
        DialogIdentifier new_id = new DialogIdentifier(this.call_id, this.local_tag, this.remote_tag);
        if (this.dialog_id == null || !this.dialog_id.equals(new_id)) {
            if (this.dialog_id != null && this.sip_provider != null && this.sip_provider.getListeners().containsKey(this.dialog_id)) {
                this.sip_provider.removeSipProviderListener(this.dialog_id);
            }
            this.dialog_id = new_id;
            this.log.debug((Object)("new dialog id: " + this.dialog_id));
            if (this.sip_provider != null) {
                this.sip_provider.addSipProviderListener(this.dialog_id, this);
            }
        }
    }

    protected final boolean verifyStatus(boolean expression) {
        return this.verifyThat(expression, "dialog state mismatching");
    }

    protected final boolean verifyThat(boolean expression, String str) {
        if (!expression) {
            if (str == null || str.length() == 0) {
                this.log.warn((Object)"expression check failed. ");
            } else {
                this.log.debug((Object)str);
            }
        }
        return expression;
    }
}

