/*
 * Decompiled with CFR 0.152.
 */
package org.zoolu.sip.dialog;

import java.util.Hashtable;
import org.zoolu.sip.address.NameAddress;
import org.zoolu.sip.authentication.DigestAuthentication;
import org.zoolu.sip.dialog.ExtendedInviteDialogListener;
import org.zoolu.sip.dialog.InviteDialog;
import org.zoolu.sip.header.AuthorizationHeader;
import org.zoolu.sip.header.RequestLine;
import org.zoolu.sip.header.StatusLine;
import org.zoolu.sip.header.ToHeader;
import org.zoolu.sip.header.ViaHeader;
import org.zoolu.sip.header.WwwAuthenticateHeader;
import org.zoolu.sip.message.Message;
import org.zoolu.sip.message.MessageFactory;
import org.zoolu.sip.message.SipResponses;
import org.zoolu.sip.provider.SipProvider;
import org.zoolu.sip.provider.TransactionIdentifier;
import org.zoolu.sip.transaction.InviteTransactionClient;
import org.zoolu.sip.transaction.TransactionClient;
import org.zoolu.sip.transaction.TransactionServer;
import org.zoolu.sip.transaction.TransactionServerListener;

public class ExtendedInviteDialog
extends InviteDialog {
    static final int MAX_ATTEMPTS = 3;
    ExtendedInviteDialogListener dialog_listener;
    Hashtable transactions;
    String username;
    String realm;
    String passwd;
    String next_nonce;
    String qop;
    int attempts;

    public ExtendedInviteDialog(SipProvider provider, ExtendedInviteDialogListener listener) {
        super(provider, listener);
        this.init(listener);
    }

    public ExtendedInviteDialog(SipProvider provider, String username, String realm, String passwd, ExtendedInviteDialogListener listener) {
        super(provider, listener);
        this.init(listener);
        this.username = username;
        this.realm = realm;
        this.passwd = passwd;
    }

    private void init(ExtendedInviteDialogListener listener) {
        this.dialog_listener = listener;
        this.transactions = new Hashtable();
        this.username = null;
        this.realm = null;
        this.passwd = null;
        this.next_nonce = null;
        this.qop = null;
        this.attempts = 0;
    }

    public void request(Message req) {
        TransactionClient t = new TransactionClient(this.sip_provider, req, this);
        this.transactions.put(t.getTransactionId(), t);
        t.request();
    }

    public void refer(NameAddress refer_to) {
        this.refer(refer_to, null);
    }

    public void refer(NameAddress refer_to, NameAddress referred_by) {
        Message req = MessageFactory.createReferRequest(this, refer_to, referred_by);
        this.request(req);
    }

    public void notify(int code, String reason) {
        this.notify(new StatusLine(code, reason).toString());
    }

    public void notify(String sipfragment) {
        Message req = MessageFactory.createNotifyRequest(this, "refer", null, sipfragment);
        this.request(req);
    }

    public void respond(Message resp) {
        this.log.debug((Object)"inside respond(resp)");
        String method = resp.getCSeqHeader().getMethod();
        if (method.equals("INVITE") || method.equals("CANCEL") || method.equals("BYE")) {
            super.respond(resp);
        } else {
            TransactionIdentifier transaction_id = resp.getTransactionId();
            this.log.debug((Object)("transaction-id=" + transaction_id));
            if (this.transactions.containsKey(transaction_id)) {
                this.log.debug((Object)"responding");
                TransactionServer t = (TransactionServer)this.transactions.get(transaction_id);
                t.respondWith(resp);
            } else {
                this.log.debug((Object)"transaction server not found; message discarded");
            }
        }
    }

    public void acceptRefer(Message req) {
        this.log.debug((Object)"inside acceptRefer(refer)");
        Message resp = MessageFactory.createResponse(req, 202, SipResponses.reasonOf(200), null);
        this.respond(resp);
    }

    public void refuseRefer(Message req) {
        this.log.debug((Object)"inside refuseRefer(refer)");
        Message resp = MessageFactory.createResponse(req, 603, SipResponses.reasonOf(603), null);
        this.respond(resp);
    }

    public void onReceivedMessage(SipProvider provider, Message msg) {
        this.log.debug((Object)("Message received: " + msg.getFirstLine().substring(0, msg.toString().indexOf(13))));
        if (msg.isResponse()) {
            super.onReceivedMessage(provider, msg);
        } else if (msg.isInvite() || msg.isAck() || msg.isCancel() || msg.isBye() || msg.isInfo()) {
            super.onReceivedMessage(provider, msg);
        } else {
            TransactionServer t = new TransactionServer(this.sip_provider, msg, (TransactionServerListener)this);
            this.transactions.put(t.getTransactionId(), t);
            if (msg.isRefer()) {
                NameAddress refer_to = msg.getReferToHeader().getNameAddress();
                NameAddress referred_by = null;
                if (msg.hasReferredByHeader()) {
                    referred_by = msg.getReferredByHeader().getNameAddress();
                }
                this.dialog_listener.onDlgRefer(this, refer_to, referred_by, msg);
            } else if (msg.isNotify()) {
                Message resp = MessageFactory.createResponse(msg, 200, SipResponses.reasonOf(200), null);
                this.respond(resp);
                String event = msg.getEventHeader().getValue();
                String sipfragment = msg.getBody();
                this.dialog_listener.onDlgNotify(this, event, sipfragment, msg);
            } else {
                this.log.debug((Object)("Received alternative request " + msg.getRequestLine().getMethod()));
                this.dialog_listener.onDlgAltRequest(this, msg.getRequestLine().getMethod(), msg.getBody(), msg);
            }
        }
    }

    public void onTransFailureResponse(TransactionClient tc, Message msg) {
        this.log.debug((Object)("inside onTransFailureResponse(" + tc.getTransactionId() + ",msg)"));
        String method = tc.getTransactionMethod();
        StatusLine status_line = msg.getStatusLine();
        int code = status_line.getCode();
        String reason = status_line.getReason();
        if (code == 401 && this.attempts < 3 && msg.hasWwwAuthenticateHeader() && msg.getWwwAuthenticateHeader().getRealmParam().equalsIgnoreCase(this.realm) || code == 407 && this.attempts < 3 && msg.hasProxyAuthenticateHeader() && msg.getProxyAuthenticateHeader().getRealmParam().equalsIgnoreCase(this.realm)) {
            ++this.attempts;
            Message req = tc.getRequestMessage();
            ViaHeader via = req.getViaHeader();
            req.removeViaHeader();
            via.setBranch(SipProvider.pickBranch());
            req.addViaHeader(via);
            req.setCSeqHeader(req.getCSeqHeader().incSequenceNumber());
            WwwAuthenticateHeader wah = code == 401 ? msg.getWwwAuthenticateHeader() : msg.getProxyAuthenticateHeader();
            String qop_options = wah.getQopOptionsParam();
            this.qop = qop_options != null ? "auth" : null;
            RequestLine rl = req.getRequestLine();
            DigestAuthentication digest = new DigestAuthentication(rl.getMethod(), rl.getAddress().toString(), wah, this.qop, null, this.username, this.passwd);
            AuthorizationHeader ah = code == 401 ? digest.getAuthorizationHeader() : digest.getProxyAuthorizationHeader();
            req.setAuthorizationHeader(ah);
            if (req.isInvite()) {
                this.invite_req = req;
            }
            this.log.info((Object)(String.valueOf(code) + " Authentication"));
            this.transactions.remove(tc.getTransactionId());
            tc = new InviteTransactionClient(this.sip_provider, req, this);
            this.transactions.put(tc.getTransactionId(), tc);
            tc.request();
        } else if ((code == 302 || code == 301) && method.equals("INVITE")) {
            NameAddress redirect_to = new NameAddress(msg.getContactHeader().getNameAddress());
            this.log.info((Object)("Received " + code + " Moved - Calling: " + redirect_to));
            Message req = tc.getRequestMessage();
            ViaHeader via = req.getViaHeader();
            req.removeViaHeader();
            via.setBranch(SipProvider.pickBranch());
            req.addViaHeader(via);
            req.removeToHeader();
            req.setToHeader(new ToHeader(redirect_to));
            req.removeRoutes();
            req.setRequestLine(new RequestLine("INVITE", redirect_to.getAddress()));
            req.setCSeqHeader(req.getCSeqHeader().incSequenceNumber());
            this.invite_req = req;
            this.transactions.remove(tc.getTransactionId());
            tc = new InviteTransactionClient(this.sip_provider, req, this);
            this.transactions.put(tc.getTransactionId(), tc);
            tc.request();
        } else if (method.equals("INVITE") || method.equals("CANCEL") || method.equals("BYE")) {
            super.onTransFailureResponse(tc, msg);
        } else if (tc.getTransactionMethod().equals("REFER")) {
            this.transactions.remove(tc.getTransactionId());
            this.dialog_listener.onDlgReferResponse(this, code, reason, msg);
        } else {
            String body = msg.getBody();
            this.transactions.remove(tc.getTransactionId());
            this.dialog_listener.onDlgAltResponse(this, method, code, reason, body, msg);
        }
    }

    public void onTransSuccessResponse(TransactionClient t, Message msg) {
        this.log.debug((Object)("inside onTransSuccessResponse(" + t.getTransactionId() + ",msg)"));
        this.attempts = 0;
        String method = t.getTransactionMethod();
        StatusLine status_line = msg.getStatusLine();
        int code = status_line.getCode();
        String reason = status_line.getReason();
        if (method.equals("INVITE") || method.equals("CANCEL") || method.equals("BYE")) {
            super.onTransSuccessResponse(t, msg);
        } else if (t.getTransactionMethod().equals("REFER")) {
            this.transactions.remove(t.getTransactionId());
            this.dialog_listener.onDlgReferResponse(this, code, reason, msg);
        } else {
            String body = msg.getBody();
            this.transactions.remove(t.getTransactionId());
            this.dialog_listener.onDlgAltResponse(this, method, code, reason, body, msg);
        }
    }

    public void onTransTimeout(TransactionClient t) {
        this.log.debug((Object)("inside onTransTimeout(" + t.getTransactionId() + ",msg)"));
        String method = t.getTransactionMethod();
        if (method.equals("INVITE") || method.equals("BYE")) {
            super.onTransTimeout(t);
        } else {
            this.transactions.remove(t.getTransactionId());
        }
    }
}

