/*
 * Decompiled with CFR 0.152.
 */
package org.zoolu.sip.dialog;

import org.zoolu.sip.address.NameAddress;
import org.zoolu.sip.address.SipURL;
import org.zoolu.sip.dialog.Dialog;
import org.zoolu.sip.dialog.InviteDialogListener;
import org.zoolu.sip.header.ContactHeader;
import org.zoolu.sip.header.StatusLine;
import org.zoolu.sip.message.Message;
import org.zoolu.sip.message.MessageFactory;
import org.zoolu.sip.message.SipResponses;
import org.zoolu.sip.provider.ConnectionIdentifier;
import org.zoolu.sip.provider.Identifier;
import org.zoolu.sip.provider.SipProvider;
import org.zoolu.sip.provider.SipProviderListener;
import org.zoolu.sip.transaction.AckTransactionClient;
import org.zoolu.sip.transaction.AckTransactionServer;
import org.zoolu.sip.transaction.AckTransactionServerListener;
import org.zoolu.sip.transaction.InviteTransactionClient;
import org.zoolu.sip.transaction.InviteTransactionServer;
import org.zoolu.sip.transaction.InviteTransactionServerListener;
import org.zoolu.sip.transaction.TransactionClient;
import org.zoolu.sip.transaction.TransactionClientListener;
import org.zoolu.sip.transaction.TransactionServer;
import org.zoolu.sip.transaction.TransactionServerListener;

public class InviteDialog
extends Dialog
implements TransactionClientListener,
InviteTransactionServerListener,
AckTransactionServerListener,
SipProviderListener {
    Message invite_req;
    Message ack_req;
    InviteTransactionServer invite_ts;
    AckTransactionServer ack_ts;
    TransactionServer bye_ts;
    InviteDialogListener listener;
    boolean invite_offer;
    protected static final int D_INIT = 0;
    protected static final int D_WAITING = 1;
    protected static final int D_INVITING = 2;
    protected static final int D_INVITED = 3;
    protected static final int D_REFUSED = 4;
    protected static final int D_ACCEPTED = 5;
    protected static final int D_CALL = 6;
    protected static final int D_ReWAITING = 11;
    protected static final int D_ReINVITING = 12;
    protected static final int D_ReINVITED = 13;
    protected static final int D_ReREFUSED = 14;
    protected static final int D_ReACCEPTED = 15;
    protected static final int D_BYEING = 7;
    protected static final int D_BYED = 8;
    protected static final int D_CLOSE = 9;

    protected String getStatus() {
        switch (this.status) {
            case 0: {
                return "D_INIT";
            }
            case 1: {
                return "D_WAITING";
            }
            case 2: {
                return "D_INVITING";
            }
            case 3: {
                return "D_INVITED";
            }
            case 4: {
                return "D_REFUSED";
            }
            case 5: {
                return "D_ACCEPTED";
            }
            case 6: {
                return "D_CALL";
            }
            case 11: {
                return "D_ReWAITING";
            }
            case 12: {
                return "D_ReINVITING";
            }
            case 13: {
                return "D_ReINVITED";
            }
            case 14: {
                return "D_ReREFUSED";
            }
            case 15: {
                return "D_ReACCEPTED";
            }
            case 7: {
                return "D_BYEING";
            }
            case 8: {
                return "D_BYED";
            }
            case 9: {
                return "D_CLOSE";
            }
        }
        return null;
    }

    public boolean isEarly() {
        return this.status < 5;
    }

    public boolean isConfirmed() {
        return this.status >= 5 && this.status < 9;
    }

    public boolean isTerminated() {
        this.log.debug((Object)("isTerminated - callState=" + this.status));
        return this.status == 9;
    }

    public boolean isSessionActive() {
        return this.status == 6;
    }

    public boolean isWaiting() {
        this.log.debug((Object)("isWaiting - callState=" + this.status));
        return this.status == 1;
    }

    public Message getInviteMessage() {
        return this.invite_req;
    }

    public InviteDialog(SipProvider sip_provider, InviteDialogListener listener) {
        super(sip_provider);
        this.init(listener);
    }

    public InviteDialog(SipProvider sip_provider, Message invite, InviteDialogListener listener) {
        super(sip_provider);
        this.init(listener);
        this.changeStatus(3);
        this.invite_req = invite;
        this.invite_ts = new InviteTransactionServer(sip_provider, this.invite_req, this);
        this.update(1, this.invite_req);
    }

    private void init(InviteDialogListener listener) {
        this.listener = listener;
        this.invite_req = null;
        this.ack_req = null;
        this.invite_offer = true;
        this.changeStatus(0);
    }

    public void listen() {
        if (!this.statusIs(0)) {
            return;
        }
        this.changeStatus(1);
        this.invite_ts = new InviteTransactionServer(this.sip_provider, this);
        this.invite_ts.listen();
    }

    public void invite(String callee, String caller, String contact, String session_descriptor) {
        this.log.debug((Object)"inside invite(callee,caller,contact,sdp)");
        if (!this.statusIs(0)) {
            return;
        }
        NameAddress to_url = new NameAddress(callee);
        NameAddress from_url = new NameAddress(caller);
        SipURL request_uri = to_url.getAddress();
        NameAddress contact_url = null;
        contact_url = contact != null ? (contact.indexOf("sip:") >= 0 ? new NameAddress(contact) : new NameAddress(new SipURL(contact, this.sip_provider.getViaAddress(), this.sip_provider.getPort()))) : from_url;
        Message invite = MessageFactory.createInviteRequest(this.sip_provider, request_uri, to_url, from_url, contact_url, session_descriptor);
        this.invite(invite);
    }

    public void invite(Message invite) {
        this.log.debug((Object)"inside invite(invite)");
        if (!this.statusIs(0)) {
            return;
        }
        this.changeStatus(2);
        this.invite_req = invite;
        this.update(0, this.invite_req);
        InviteTransactionClient invite_tc = new InviteTransactionClient(this.sip_provider, this.invite_req, this);
        invite_tc.request();
    }

    public void inviteWithoutOffer(String callee, String caller, String contact) {
        this.invite_offer = false;
        this.invite(callee, caller, contact, null);
    }

    public void inviteWithoutOffer(Message invite) {
        this.invite_offer = false;
        this.invite(invite);
    }

    public void reInvite(String contact, String session_descriptor) {
        this.log.debug((Object)"inside reInvite(contact,sdp)");
        if (!this.statusIs(6)) {
            return;
        }
        Message invite = MessageFactory.createInviteRequest(this, session_descriptor);
        if (contact != null) {
            NameAddress contact_url = contact.indexOf("sip:") >= 0 ? new NameAddress(contact) : new NameAddress(new SipURL(contact, this.sip_provider.getViaAddress(), this.sip_provider.getPort()));
            invite.setContactHeader(new ContactHeader(contact_url));
        }
        this.reInvite(invite);
    }

    public void reInvite(Message invite) {
        this.log.debug((Object)"inside reInvite(invite)");
        if (!this.statusIs(6)) {
            return;
        }
        this.changeStatus(12);
        this.invite_req = invite;
        this.update(0, this.invite_req);
        InviteTransactionClient invite_tc = new InviteTransactionClient(this.sip_provider, this.invite_req, this);
        invite_tc.request();
    }

    public void reInviteWithoutOffer(Message invite) {
        this.invite_offer = false;
        this.reInvite(invite);
    }

    public void reInviteWithoutOffer(String contact, String session_descriptor) {
        this.invite_offer = false;
        this.reInvite(contact, session_descriptor);
    }

    public void ackWithAnswer(String contact, String session_descriptor) {
        if (contact != null) {
            this.setLocalContact(new NameAddress(contact));
        }
        Message ack = MessageFactory.create2xxAckRequest(this, session_descriptor);
        this.ackWithAnswer(ack);
    }

    public void ackWithAnswer(Message ack) {
        this.ack_req = ack;
        this.invite_offer = true;
        AckTransactionClient ack_tc = new AckTransactionClient(this.sip_provider, ack, null);
        ack_tc.request();
    }

    public void respond(Message resp) {
        this.log.debug((Object)"inside respond(resp)");
        String method = resp.getCSeqHeader().getMethod();
        if (method.equals("INVITE")) {
            if (!this.verifyStatus(this.statusIs(3) || this.statusIs(13))) {
                this.log.debug((Object)"respond(): InviteDialog not in (re)invited state: No response now");
                return;
            }
            int code = resp.getStatusLine().getCode();
            if (code >= 100 && code < 200) {
                this.invite_ts.respondWith(resp);
                return;
            }
            if (code >= 200) {
                this.update(1, resp);
            }
            if (code >= 200 && code < 300) {
                if (this.statusIs(3)) {
                    this.changeStatus(5);
                } else {
                    this.changeStatus(15);
                }
                this.invite_ts.terminate();
                ConnectionIdentifier conn_id = this.invite_ts.getConnectionId();
                this.ack_ts = new AckTransactionServer(this.sip_provider, conn_id, resp, this);
                this.ack_ts.respond();
                return;
            }
            if (this.statusIs(3)) {
                this.changeStatus(4);
            } else {
                this.changeStatus(14);
            }
            this.invite_ts.respondWith(resp);
            return;
        }
        if (method.equals("BYE")) {
            if (!this.verifyStatus(this.statusIs(8))) {
                return;
            }
            this.bye_ts.respondWith(resp);
        }
    }

    public void respond(int code, String reason, String contact, String sdp) {
        this.log.debug((Object)("inside respond(" + code + "," + reason + ")"));
        if (this.statusIs(3) || this.statusIs(13)) {
            NameAddress contact_address = null;
            if (contact != null) {
                contact_address = new NameAddress(contact);
            }
            Message resp = MessageFactory.createResponse(this.invite_req, code, reason, contact_address);
            resp.setBody(sdp);
            this.respond(resp);
        } else {
            this.log.debug((Object)("Dialog isn't in \"invited\" state: cannot respond (" + code + "/" + this.getStatus() + "/" + this.getDialogID() + ")"));
        }
    }

    public void ring(String contact) {
        this.log.debug((Object)"inside ring()");
        this.respond(180, SipResponses.reasonOf(180), contact, null);
    }

    public void accept(String contact, String sdp) {
        this.log.debug((Object)"inside accept(sdp)");
        this.respond(200, SipResponses.reasonOf(200), contact, sdp);
    }

    public void sendEarlyMedia(String contact, String sdp) {
        this.log.debug((Object)"inside sendEarlyMedia(sdp)");
        this.respond(183, SipResponses.reasonOf(183), contact, sdp);
    }

    public void refuse(int code, String reason) {
        this.log.debug((Object)("inside refuse(" + code + "," + reason + ")"));
        this.respond(code, reason, null, null);
    }

    public void refuse() {
        this.log.debug((Object)"inside refuse()");
        this.refuse(403, SipResponses.reasonOf(403));
    }

    public void bye() {
        this.log.debug((Object)"inside bye()");
        if (this.statusIs(6)) {
            Message bye = MessageFactory.createByeRequest(this);
            this.bye(bye);
        }
    }

    public void bye(Message bye) {
        this.log.debug((Object)"inside bye(bye)");
        if (this.statusIs(6)) {
            this.changeStatus(7);
            TransactionClient tc = new TransactionClient(this.sip_provider, bye, this);
            tc.request();
        }
    }

    public void cancel() {
        this.log.debug((Object)("inside cancel() status=" + this.getStatus()));
        if (this.statusIs(2) || this.statusIs(12)) {
            Message cancel = MessageFactory.createCancelRequest(this.invite_req);
            this.cancel(cancel);
        } else if (this.statusIs(1) || this.statusIs(11)) {
            this.invite_ts.terminate();
        }
    }

    public void cancel(Message cancel) {
        this.log.debug((Object)"inside cancel(cancel)");
        if (this.statusIs(2) || this.statusIs(12)) {
            TransactionClient tc = new TransactionClient(this.sip_provider, cancel, null);
            tc.request();
        } else if (this.statusIs(1) || this.statusIs(11)) {
            this.invite_ts.terminate();
        }
    }

    public void redirect(int code, String reason, String contact) {
        this.log.debug((Object)("inside redirect(" + code + "," + reason + "," + contact + ")"));
        this.respond(code, reason, contact, null);
    }

    public void onReceivedMessage(SipProvider sip_provider, Message msg) {
        this.log.debug((Object)"inside onReceivedMessage(sip_provider,message)");
        if (msg.isRequest() && !msg.isAck() && !msg.isCancel() && msg.getCSeqHeader().getSequenceNumber() <= this.getRemoteCSeq()) {
            this.log.debug((Object)"Request message is too late (CSeq too small): Message discarded");
            return;
        }
        if (msg.isRequest() && msg.isInvite()) {
            this.verifyStatus(this.statusIs(0) || this.statusIs(6));
            if (this.statusIs(0)) {
                this.changeStatus(3);
            } else {
                this.changeStatus(13);
            }
            this.invite_req = msg;
            this.invite_ts = new InviteTransactionServer(sip_provider, this.invite_req, this);
            this.update(1, this.invite_req);
            if (this.statusIs(3)) {
                this.listener.onDlgInvite(this, this.invite_req.getToHeader().getNameAddress(), this.invite_req.getFromHeader().getNameAddress(), this.invite_req.getBody(), this.invite_req);
            } else {
                this.listener.onDlgReInvite(this, this.invite_req.getBody(), this.invite_req);
            }
        } else if (msg.isRequest() && msg.isAck()) {
            if (!this.verifyStatus(this.statusIs(5) || this.statusIs(15))) {
                return;
            }
            this.changeStatus(6);
            this.ack_ts.terminate();
            this.listener.onDlgAck(this, msg.getBody(), msg);
            this.listener.onDlgCall(this);
        } else if (msg.isResponse()) {
            if (!this.verifyStatus(this.statusIs(6))) {
                return;
            }
            int code = msg.getStatusLine().getCode();
            this.verifyThat(code >= 200 && code < 300, "code 2xx was expected");
            if (this.ack_req != null) {
                AckTransactionClient ack_tc = new AckTransactionClient(sip_provider, this.ack_req, null);
                ack_tc.request();
            }
        } else if (msg.isRequest() && msg.isBye()) {
            if (!this.verifyStatus(this.statusIs(6) || this.statusIs(7) || this.statusIs(15))) {
                this.log.debug((Object)("### status=" + this.getStatus()));
                return;
            }
            if (this.statusIs(15) && this.ack_ts != null) {
                this.ack_ts.terminate();
            }
            this.changeStatus(8);
            this.bye_ts = new TransactionServer(sip_provider, msg, (TransactionServerListener)this);
            Message resp = MessageFactory.createResponse(msg, 200, SipResponses.reasonOf(200), null);
            this.respond(resp);
            this.listener.onDlgBye(this, msg);
            this.changeStatus(9);
            this.listener.onDlgClose(this);
        } else if (msg.isRequest() && msg.isCancel()) {
            if (!this.verifyStatus(this.statusIs(3) || this.statusIs(13))) {
                return;
            }
            TransactionServer ts = new TransactionServer(sip_provider, msg, null);
            ts.respondWith(MessageFactory.createResponse(msg, 200, SipResponses.reasonOf(200), null));
            Message resp = MessageFactory.createResponse(this.invite_req, 487, SipResponses.reasonOf(487), null);
            this.respond(resp);
            this.listener.onDlgCancel(this, msg);
        } else if (msg.isRequest() && msg.isInfo()) {
            TransactionServer ts = new TransactionServer(sip_provider, msg, null);
            ts.respondWith(MessageFactory.createResponse(msg, 200, SipResponses.reasonOf(200), null));
            this.listener.onDlgInfo(this, msg);
        } else if (msg.isRequest()) {
            TransactionServer ts = new TransactionServer(sip_provider, msg, null);
            ts.respondWith(MessageFactory.createResponse(msg, 405, SipResponses.reasonOf(405), null));
        }
    }

    public void onTransProvisionalResponse(TransactionClient tc, Message msg) {
        this.log.debug((Object)"inside onTransProvisionalResponse(tc,mdg)");
        if (tc.getTransactionMethod().equals("INVITE")) {
            StatusLine statusline = msg.getStatusLine();
            this.listener.onDlgInviteProvisionalResponse(this, statusline.getCode(), statusline.getReason(), msg.getBody(), msg);
        }
    }

    public void onTransFailureResponse(TransactionClient tc, Message msg) {
        this.log.debug((Object)("inside onTransFailureResponse(" + tc.getTransactionId() + ",msg)"));
        if (tc.getTransactionMethod().equals("INVITE")) {
            if (!this.verifyStatus(this.statusIs(2) || this.statusIs(12))) {
                return;
            }
            StatusLine statusline = msg.getStatusLine();
            int code = statusline.getCode();
            this.verifyThat(code >= 300 && code < 700, "error code was expected");
            if (this.statusIs(12)) {
                this.changeStatus(6);
                this.listener.onDlgReInviteFailureResponse(this, code, statusline.getReason(), msg);
            } else {
                this.changeStatus(9);
                if (code >= 300 && code < 400) {
                    this.listener.onDlgInviteRedirectResponse(this, code, statusline.getReason(), msg.getContacts(), msg);
                } else {
                    this.listener.onDlgInviteFailureResponse(this, code, statusline.getReason(), msg);
                }
                this.listener.onDlgClose(this);
            }
        } else if (tc.getTransactionMethod().equals("BYE")) {
            if (!this.verifyStatus(this.statusIs(7))) {
                return;
            }
            StatusLine statusline = msg.getStatusLine();
            int code = statusline.getCode();
            this.verifyThat(code >= 300 && code < 700, "error code was expected");
            this.changeStatus(6);
            this.listener.onDlgByeFailureResponse(this, code, statusline.getReason(), msg);
        }
    }

    public void onTransSuccessResponse(TransactionClient tc, Message msg) {
        this.log.debug((Object)"inside onTransSuccessResponse(tc,msg)");
        if (tc.getTransactionMethod().equals("INVITE")) {
            if (!this.verifyStatus(this.statusIs(2) || this.statusIs(12))) {
                return;
            }
            StatusLine statusline = msg.getStatusLine();
            int code = statusline.getCode();
            if (!this.verifyThat(code >= 200 && code < 300 && msg.getTransactionMethod().equals("INVITE"), "2xx for invite was expected")) {
                return;
            }
            boolean re_inviting = this.statusIs(12);
            this.changeStatus(6);
            this.update(0, msg);
            if (this.invite_offer) {
                this.ack_req = MessageFactory.create2xxAckRequest(this, null);
                AckTransactionClient ack_tc = new AckTransactionClient(this.sip_provider, this.ack_req, null);
                ack_tc.request();
            }
            if (!re_inviting) {
                this.listener.onDlgInviteSuccessResponse(this, code, statusline.getReason(), msg.getBody(), msg);
                this.listener.onDlgCall(this);
            } else {
                this.listener.onDlgReInviteSuccessResponse(this, code, statusline.getReason(), msg.getBody(), msg);
            }
        } else if (tc.getTransactionMethod().equals("BYE")) {
            if (!this.verifyStatus(this.statusIs(7))) {
                return;
            }
            StatusLine statusline = msg.getStatusLine();
            int code = statusline.getCode();
            this.verifyThat(code >= 200 && code < 300, "2xx for bye was expected");
            this.changeStatus(9);
            this.listener.onDlgByeSuccessResponse(this, code, statusline.getReason(), msg);
            this.listener.onDlgClose(this);
        }
    }

    public void onTransTimeout(TransactionClient tc) {
        this.log.debug((Object)"inside onTransTimeout(tc,msg)");
        if (tc.getTransactionMethod().equals("INVITE")) {
            if (!this.verifyStatus(this.statusIs(2) || this.statusIs(12))) {
                return;
            }
            this.changeStatus(9);
            this.listener.onDlgTimeout(this);
            this.listener.onDlgClose(this);
        } else if (tc.getTransactionMethod().equals("BYE")) {
            if (!this.verifyStatus(this.statusIs(7))) {
                return;
            }
            this.changeStatus(9);
            this.listener.onDlgClose(this);
        }
    }

    public void onTransRequest(TransactionServer ts, Message req) {
        this.log.debug((Object)"inside onTransRequest(ts,msg)");
        if (ts.getTransactionMethod().equals("INVITE")) {
            if (!this.verifyStatus(this.statusIs(1))) {
                return;
            }
            this.changeStatus(3);
            this.invite_req = req;
            this.update(1, this.invite_req);
            this.listener.onDlgInvite(this, this.invite_req.getToHeader().getNameAddress(), this.invite_req.getFromHeader().getNameAddress(), this.invite_req.getBody(), this.invite_req);
        }
    }

    public void onTransFailureAck(InviteTransactionServer ts, Message msg) {
        this.log.debug((Object)"inside onTransFailureAck(ts,msg)");
        if (!this.verifyStatus(this.statusIs(4) || this.statusIs(14))) {
            return;
        }
        if (this.statusIs(14)) {
            this.changeStatus(6);
        } else {
            this.changeStatus(9);
            this.listener.onDlgClose(this);
        }
    }

    public void onTransAckTimeout(AckTransactionServer ts) {
        this.log.debug((Object)"inside onAckSrvTimeout(ts)");
        if (!this.verifyStatus(this.statusIs(5) || this.statusIs(15) || this.statusIs(4) || this.statusIs(14))) {
            return;
        }
        this.log.info((Object)"No ACK received..");
        this.changeStatus(9);
        this.listener.onDlgClose(this);
    }

    public void sendInfoMsg(String msg, String content_type) {
        Message info = MessageFactory.createInfoRequest(this, content_type, msg);
        TransactionClient tc = new TransactionClient(this.sip_provider, info, this);
        tc.request();
    }

    public void removeInviteListener() {
        if (this.invite_ts != null) {
            this.sip_provider.removeSipProviderListener(new Identifier("INVITE"), this.invite_ts);
        }
    }
}

