/*
 * Decompiled with CFR 0.152.
 */
package org.zoolu.sip.dialog;

import org.zoolu.sip.address.NameAddress;
import org.zoolu.sip.dialog.Dialog;
import org.zoolu.sip.dialog.NotifierDialogListener;
import org.zoolu.sip.header.EventHeader;
import org.zoolu.sip.header.ExpiresHeader;
import org.zoolu.sip.header.StatusLine;
import org.zoolu.sip.header.SubscriptionStateHeader;
import org.zoolu.sip.message.Message;
import org.zoolu.sip.message.MessageFactory;
import org.zoolu.sip.message.SipResponses;
import org.zoolu.sip.provider.MethodIdentifier;
import org.zoolu.sip.provider.SipProvider;
import org.zoolu.sip.provider.SipStack;
import org.zoolu.sip.transaction.TransactionClient;
import org.zoolu.sip.transaction.TransactionClientListener;
import org.zoolu.sip.transaction.TransactionServer;

public class NotifierDialog
extends Dialog
implements TransactionClientListener {
    protected static final String ACTIVE = "active";
    protected static final String PENDING = "pending";
    protected static final String TERMINATED = "terminated";
    NotifierDialogListener listener;
    Message subscribe_req;
    TransactionServer subscribe_transaction;
    TransactionClient notify_transaction;
    String event;
    String id;
    protected static final int D_INIT = 0;
    protected static final int D_WAITING = 1;
    protected static final int D_SUBSCRIBED = 2;
    protected static final int D_PENDING = 3;
    protected static final int D_ACTIVE = 4;
    protected static final int D_TERMINATED = 9;

    protected String getStatus() {
        switch (this.status) {
            case 0: {
                return "D_INIT";
            }
            case 1: {
                return "D_WAITING";
            }
            case 2: {
                return "D_SUBSCRIBED";
            }
            case 3: {
                return "D_PENDING";
            }
            case 4: {
                return "D_ACTIVE";
            }
            case 9: {
                return "D_TERMINATED";
            }
        }
        return null;
    }

    public boolean isEarly() {
        return this.status < 3;
    }

    public boolean isConfirmed() {
        return this.status >= 3 && this.status < 9;
    }

    public boolean isTerminated() {
        return this.status == 9;
    }

    public boolean isSubscriptionPending() {
        return this.status >= 2 && this.status < 4;
    }

    public boolean isSubscriptionActive() {
        return this.status == 4;
    }

    public boolean isSubscriptionTerminated() {
        return this.status == 9;
    }

    public String getEvent() {
        return this.event;
    }

    public String getId() {
        return this.id;
    }

    public NotifierDialog(SipProvider sip_provider, NotifierDialogListener listener) {
        super(sip_provider);
        this.init(listener);
    }

    public NotifierDialog(SipProvider sip_provider, Message subscribe, NotifierDialogListener listener) {
        super(sip_provider);
        this.init(listener);
        this.changeStatus(2);
        this.subscribe_req = subscribe;
        this.subscribe_transaction = new TransactionServer(sip_provider, subscribe, null);
        this.update(1, subscribe);
        EventHeader eh = subscribe.getEventHeader();
        if (eh != null) {
            this.event = eh.getEvent();
            this.id = eh.getId();
        }
    }

    private void init(NotifierDialogListener listener) {
        this.listener = listener;
        this.subscribe_transaction = null;
        this.notify_transaction = null;
        this.subscribe_req = null;
        this.event = null;
        this.id = null;
        this.changeStatus(0);
    }

    public void listen() {
        this.log.debug((Object)"inside method listen()");
        if (!this.statusIs(0)) {
            this.log.debug((Object)"first subscription already received");
            return;
        }
        this.changeStatus(1);
        this.sip_provider.addSipProviderListener(new MethodIdentifier("SUBSCRIBE"), this);
    }

    public void accept(int expires, String contact) {
        this.log.debug((Object)"inside accept()");
        this.respond(202, SipResponses.reasonOf(202), expires, contact, null, null);
    }

    public void refuse() {
        this.log.debug((Object)"inside refuse()");
        this.respond(403, SipResponses.reasonOf(403), -1, null, null, null);
    }

    public void respond(int code, String reason, int expires, String contact, String content_type, String body) {
        this.log.debug((Object)("inside respond(" + code + "," + reason + ")"));
        NameAddress contact_url = null;
        if (contact != null) {
            contact_url = new NameAddress(contact);
        }
        Message resp = MessageFactory.createResponse(this.subscribe_req, code, SipResponses.reasonOf(code), contact_url);
        if (expires >= 0) {
            resp.setExpiresHeader(new ExpiresHeader(expires));
        }
        if (body != null) {
            resp.setBody(content_type, body);
        }
        this.respond(resp);
    }

    public void respond(Message resp) {
        this.log.debug((Object)"inside respond(resp)");
        if (resp.getStatusLine().getCode() >= 200) {
            this.update(1, resp);
        }
        this.subscribe_transaction.respondWith(resp);
    }

    public void activate() {
        this.activate(SipStack.default_expires);
    }

    public void activate(int expires) {
        this.notify(ACTIVE, expires, null, null);
    }

    public void pending() {
        this.pending(SipStack.default_expires);
    }

    public void pending(int expires) {
        this.notify(PENDING, expires, null, null);
    }

    public void terminate() {
        this.terminate(null);
    }

    public void terminate(String reason) {
        Message req = MessageFactory.createNotifyRequest(this, this.event, this.id, null, null);
        SubscriptionStateHeader sh = new SubscriptionStateHeader(TERMINATED);
        if (reason != null) {
            sh.setReason(reason);
        }
        req.setSubscriptionStateHeader(sh);
        this.notify(req);
    }

    public void notify(String state, int expires, String content_type, String body) {
        Message req = MessageFactory.createNotifyRequest(this, this.event, this.id, content_type, body);
        if (state != null) {
            SubscriptionStateHeader sh = new SubscriptionStateHeader(state);
            if (expires >= 0) {
                sh.setExpires(expires);
            }
            req.setSubscriptionStateHeader(sh);
        }
        this.notify(req);
    }

    public void notify(Message req) {
        String subscription_state = req.getSubscriptionStateHeader().getState();
        if (subscription_state.equalsIgnoreCase(ACTIVE) && (this.statusIs(2) || this.statusIs(3))) {
            this.changeStatus(4);
        } else if (subscription_state.equalsIgnoreCase(PENDING) && this.statusIs(2)) {
            this.changeStatus(3);
        } else if (subscription_state.equalsIgnoreCase(TERMINATED) && !this.statusIs(9)) {
            this.changeStatus(9);
        }
        TransactionClient notify_transaction = new TransactionClient(this.sip_provider, req, this);
        notify_transaction.request();
    }

    public void onTransProvisionalResponse(TransactionClient tc, Message resp) {
        this.log.debug((Object)"onTransProvisionalResponse()");
    }

    public void onTransSuccessResponse(TransactionClient tc, Message resp) {
        this.log.debug((Object)"onTransSuccessResponse()");
        StatusLine status_line = resp.getStatusLine();
        if (this.listener != null) {
            this.listener.onDlgNotificationSuccess(this, status_line.getCode(), status_line.getReason(), resp);
        }
    }

    public void onTransFailureResponse(TransactionClient tc, Message resp) {
        this.log.debug((Object)"onTransFailureResponse()");
        StatusLine status_line = resp.getStatusLine();
        if (this.listener != null) {
            this.listener.onDlgNotificationFailure(this, status_line.getCode(), status_line.getReason(), resp);
        }
    }

    public void onTransTimeout(TransactionClient tc) {
        this.log.debug((Object)"onTransTimeout()");
        if (!this.statusIs(9)) {
            this.changeStatus(9);
            if (this.listener != null) {
                this.listener.onDlgNotifyTimeout(this);
            }
        }
    }

    public void onReceivedMessage(SipProvider provider, Message msg) {
        this.log.debug((Object)"onReceivedMessage()");
        if (this.statusIs(9)) {
            this.log.debug((Object)"subscription already terminated: message discarded");
            return;
        }
        if (msg.isRequest() && msg.isSubscribe()) {
            if (this.statusIs(1)) {
                this.changeStatus(2);
                this.sip_provider.removeSipProviderListener(new MethodIdentifier("SUBSCRIBE"));
            }
            this.subscribe_req = msg;
            NameAddress target = msg.getToHeader().getNameAddress();
            NameAddress subscriber = msg.getFromHeader().getNameAddress();
            EventHeader eh = msg.getEventHeader();
            if (eh != null) {
                this.event = eh.getEvent();
                this.id = eh.getId();
            }
            this.update(1, msg);
            this.subscribe_transaction = new TransactionServer(this.sip_provider, msg, null);
            if (this.listener != null) {
                this.listener.onDlgSubscribe(this, target, subscriber, this.event, this.id, msg);
            }
        } else {
            this.log.info((Object)"message is not a SUBSCRIBE: message discarded");
        }
    }
}

